/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.verification;

import java.util.ArrayList;
import java.util.Collection;
import org.netbeans.editor.BaseDocument;
import org.netbeans.jmi.javamodel.AnnotableElement;
import org.netbeans.jmi.javamodel.Annotation;
import org.netbeans.jmi.javamodel.ClassMember;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.j2ee.verification.JEEVerificationAnnotationProvider;
import org.netbeans.modules.j2ee.verification.JEEVerificationProblemMark;
import org.netbeans.modules.j2ee.verification.ProblemFinderContext;
import org.netbeans.modules.j2ee.verification.ProblemFindingUtils;
import org.netbeans.modules.j2ee.verification.persistence.BeanAccessType;
import org.openide.ErrorManager;
import org.openide.text.Annotatable;
import org.openide.text.Line;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ProblemFinder {
    private final Collection<JEEVerificationProblemMark> problemMarks = new ArrayList<JEEVerificationProblemMark>();
    private ProblemFinderContext context;

    public abstract void parseDocument();

    protected void addProblemMark(JEEVerificationProblemMark problem) {
        this.getProblemMarks().add(problem);
    }

    protected void attachProblemMarkToElement(JEEVerificationProblemMark problemMark, Element element) {
        Line.Part linePart = ProblemFindingUtils.getLinePartForElement(this.getLineSet(), this.getDocument(), element);
        problemMark.attach((Annotatable)linePart);
        JEEVerificationAnnotationProvider.tmpDbg("problemMark attached: " + problemMark);
    }

    protected void attachProblemMarkToModifier(JEEVerificationProblemMark problemMark, ClassMember element, int modifier) {
        if ((element.getModifiers() & modifier) == 0) {
            throw new IllegalArgumentException("Specified element does not contain specified modifier");
        }
        Line.Part linePart = ProblemFindingUtils.getLinePartForModifier(this.getLineSet(), this.getDocument(), (Element)element, modifier);
        if (linePart != null) {
            problemMark.attach((Annotatable)linePart);
        } else {
            ErrorManager.getDefault().log(65536, "failed to attach the problem mark to the modifier");
            this.attachProblemMarkToElement(problemMark, (Element)element);
        }
    }

    public ProblemFinderContext getContext() {
        return this.context;
    }

    public final Collection<JEEVerificationProblemMark> getProblemMarks() {
        return this.problemMarks;
    }

    public final void reset() {
        this.problemMarks.clear();
    }

    public Line.Set getLineSet() {
        return this.context.getLineSet();
    }

    public Resource getResource() {
        return this.context.getResource();
    }

    public BaseDocument getDocument() {
        return this.context.getDocument();
    }

    public JavaClass getMainJavaClass() {
        return this.context.getMainJavaClass();
    }

    public BeanAccessType getBeanAccessType() {
        return this.context.getBeanAccessType();
    }

    public boolean getIsEntityClass() {
        return this.context.isIsEntityClass();
    }

    void setContext(ProblemFinderContext context) {
        this.context = context;
    }

    protected static Element getAnnotationOrAnnotableElement(AnnotableElement elem, String annotationName) {
        Annotation ann = ProblemFindingUtils.findAnnotation(elem, annotationName);
        if (ann != null) {
            return ann;
        }
        return elem;
    }
}

