/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.xdm.visitor;

import java.util.List;
import org.netbeans.modules.xml.xdm.nodes.Attribute;
import org.netbeans.modules.xml.xdm.nodes.Document;
import org.netbeans.modules.xml.xdm.nodes.Element;
import org.netbeans.modules.xml.xdm.nodes.Node;
import org.netbeans.modules.xml.xdm.nodes.Text;
import org.netbeans.modules.xml.xdm.nodes.Token;
import org.netbeans.modules.xml.xdm.visitor.XMLNodeVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompareVisitor
implements XMLNodeVisitor {
    private Node target;
    boolean result = false;

    public boolean compare(Node n1, Node n2) {
        this.target = n2;
        n1.accept(this);
        return this.result;
    }

    @Override
    public void visit(Attribute attr) {
        this.result = false;
        if (this.target instanceof Attribute) {
            if (attr.getName().equals(((Attribute)this.target).getName()) && attr.getValue().equals(((Attribute)this.target).getValue())) {
                this.result = true;
            }
            if (this.result) {
                this.tokenCompare(attr.getTokens(), ((Attribute)this.target).getTokens());
            }
        }
    }

    @Override
    public void visit(Document doc) {
        if (this.target instanceof Document) {
            this.result = true;
        }
    }

    @Override
    public void visit(Element e) {
        this.result = false;
        if (this.target instanceof Element && e.getLocalName().equals(((Element)this.target).getLocalName())) {
            this.result = true;
        }
        if (this.result) {
            this.tokenCompare(e.getTokens(), ((Element)this.target).getTokens());
        }
    }

    @Override
    public void visit(Text txt) {
        this.result = false;
        if (this.target instanceof Text && txt.getText().equals(((Text)this.target).getText())) {
            this.result = true;
        }
        if (this.result) {
            this.tokenCompare(txt.getTokens(), ((Text)this.target).getTokens());
        }
    }

    private void tokenCompare(List<Token> oldtokens, List<Token> newtokens) {
        assert (oldtokens != null && newtokens != null);
        if (oldtokens.size() != newtokens.size()) {
            this.result = false;
        } else {
            int i = 0;
            for (Token t : oldtokens) {
                if (t.getType() != newtokens.get(i).getType() || !t.getValue().equals(newtokens.get(i).getValue())) {
                    this.result = false;
                }
                ++i;
            }
        }
    }
}

