/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.deployment.impl.query;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.queries.JavadocForBinaryQuery;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.impl.ServerInstance;
import org.netbeans.modules.j2ee.deployment.impl.ServerRegistry;
import org.netbeans.modules.j2ee.deployment.plugins.api.J2eePlatformImpl;
import org.netbeans.spi.java.queries.JavadocForBinaryQueryImplementation;
import org.netbeans.spi.project.libraries.LibraryImplementation;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.WeakListeners;

public class J2eePlatformJavadocForBinaryQuery
implements JavadocForBinaryQueryImplementation {
    private static int MAX_DEPTH = 3;
    private final Map normalizedURLCache = new HashMap();

    public JavadocForBinaryQuery.Result findJavadoc(URL b) {
        boolean isNormalizedURL = J2eePlatformJavadocForBinaryQuery.isNormalizedURL(b);
        String[] serverInstanceIDs = Deployment.getDefault().getServerInstanceIDs();
        ServerRegistry servReg = ServerRegistry.getInstance();
        for (int i = 0; i < serverInstanceIDs.length; ++i) {
            ServerInstance serInst = servReg.getServerInstance(serverInstanceIDs[i]);
            J2eePlatformImpl platformImpl = serInst.getJ2eePlatformImpl();
            if (platformImpl == null) continue;
            LibraryImplementation[] libs = platformImpl.getLibraries();
            for (int j = 0; j < libs.length; ++j) {
                List jars = libs[j].getContent("classpath");
                for (URL entry : jars) {
                    URL normalizedEntry = isNormalizedURL ? this.getNormalizedURL(entry) : entry;
                    if (normalizedEntry == null || !normalizedEntry.equals(b)) continue;
                    class R
                    implements JavadocForBinaryQuery.Result,
                    PropertyChangeListener {
                        private LibraryImplementation lib;
                        private ArrayList listeners;
                        private URL[] cachedRoots;

                        public R(LibraryImplementation lib) {
                            this.lib = lib;
                            this.lib.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.lib));
                        }

                        public synchronized URL[] getRoots() {
                            if (this.cachedRoots == null) {
                                List l = this.lib.getContent("javadoc");
                                ArrayList<URL> result = new ArrayList<URL>();
                                for (URL u : l) {
                                    result.add(J2eePlatformJavadocForBinaryQuery.getIndexFolder(u));
                                }
                                this.cachedRoots = result.toArray(new URL[result.size()]);
                            }
                            return this.cachedRoots;
                        }

                        public synchronized void addChangeListener(ChangeListener l) {
                            assert (l != null) : "Listener can not be null";
                            if (this.listeners == null) {
                                this.listeners = new ArrayList();
                            }
                            this.listeners.add(l);
                        }

                        public synchronized void removeChangeListener(ChangeListener l) {
                            assert (l != null) : "Listener can not be null";
                            if (this.listeners == null) {
                                return;
                            }
                            this.listeners.remove(l);
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void propertyChange(PropertyChangeEvent event) {
                            if ("content".equals(event.getPropertyName())) {
                                R r = this;
                                synchronized (r) {
                                    this.cachedRoots = null;
                                }
                                this.fireChange();
                            }
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        private void fireChange() {
                            Iterator it = null;
                            R r = this;
                            synchronized (r) {
                                if (this.listeners == null) {
                                    return;
                                }
                                it = ((ArrayList)this.listeners.clone()).iterator();
                            }
                            ChangeEvent event = new ChangeEvent(this);
                            while (it.hasNext()) {
                                ((ChangeListener)it.next()).stateChanged(event);
                            }
                        }
                    }
                    return new R(libs[j]);
                }
            }
        }
        return null;
    }

    private URL getNormalizedURL(URL url) {
        FileObject fo;
        if (J2eePlatformJavadocForBinaryQuery.isNormalizedURL(url)) {
            return url;
        }
        URL normalizedURL = (URL)this.normalizedURLCache.get(url);
        if (normalizedURL == null && (fo = URLMapper.findFileObject((URL)url)) != null) {
            try {
                normalizedURL = fo.getURL();
                this.normalizedURLCache.put(url, normalizedURL);
            }
            catch (FileStateInvalidException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
        }
        return normalizedURL;
    }

    private static boolean isNormalizedURL(URL url) {
        if ("jar".equals(url.getProtocol())) {
            url = FileUtil.getArchiveFile((URL)url);
        }
        return "file".equals(url.getProtocol());
    }

    private static URL getIndexFolder(URL rootURL) {
        if (rootURL == null) {
            return null;
        }
        FileObject root = URLMapper.findFileObject((URL)rootURL);
        if (root == null) {
            return rootURL;
        }
        FileObject result = J2eePlatformJavadocForBinaryQuery.findIndexFolder(root, 1);
        try {
            return result == null ? rootURL : result.getURL();
        }
        catch (FileStateInvalidException e) {
            ErrorManager.getDefault().notify((Throwable)e);
            return rootURL;
        }
    }

    private static FileObject findIndexFolder(FileObject fo, int depth) {
        if (depth > MAX_DEPTH) {
            return null;
        }
        if (fo.getFileObject("index-files", null) != null || fo.getFileObject("index-all.html", null) != null) {
            return fo;
        }
        FileObject[] children = fo.getChildren();
        for (int i = 0; i < children.length; ++i) {
            FileObject result;
            if (!children[i].isFolder() || (result = J2eePlatformJavadocForBinaryQuery.findIndexFolder(children[i], depth + 1)) == null) continue;
            return result;
        }
        return null;
    }
}

