/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.deployment.impl.projects;

import java.io.File;
import java.io.IOException;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.TargetModuleID;
import org.netbeans.modules.j2ee.deployment.config.ConfigSupportImpl;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModuleContainer;
import org.netbeans.modules.j2ee.deployment.devmodules.api.ModuleChangeReporter;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeAppProvider;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.deployment.execution.DeploymentConfigurationProvider;
import org.netbeans.modules.j2ee.deployment.execution.DeploymentTarget;
import org.netbeans.modules.j2ee.deployment.impl.ServerInstance;
import org.netbeans.modules.j2ee.deployment.impl.ServerRegistry;
import org.netbeans.modules.j2ee.deployment.impl.ServerString;
import org.netbeans.modules.j2ee.deployment.impl.TargetModule;
import org.netbeans.modules.j2ee.deployment.plugins.api.IncrementalDeployment;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public final class DeploymentTargetImpl
implements DeploymentTarget {
    J2eeModuleProvider moduleProvider;
    String clientName;
    ServerString server;
    TargetModule[] targetModules;

    public DeploymentTargetImpl(J2eeModuleProvider moduleProvider, String clientName) {
        this.moduleProvider = moduleProvider;
        this.clientName = clientName;
    }

    public J2eeModule getModule() {
        return this.moduleProvider.getJ2eeModule();
    }

    public ModuleChangeReporter getModuleChangeReporter() {
        return this.moduleProvider.getModuleChangeReporter();
    }

    public String getClientUrl(String partUrl) {
        J2eeModule clientModule = null;
        String url = null;
        if (this.moduleProvider instanceof J2eeAppProvider) {
            J2eeAppProvider ear = (J2eeAppProvider)this.moduleProvider;
            J2eeModuleProvider clientProvider = this.getChildModuleProvider(ear, this.clientName);
            if (clientProvider != null) {
                clientModule = clientProvider.getJ2eeModule();
            } else {
                J2eeModuleContainer jmc = (J2eeModuleContainer)ear.getJ2eeModule();
                J2eeModule[] modules = jmc.getModules(null);
                for (int i = 0; i < modules.length; ++i) {
                    if (!J2eeModule.WAR.equals(modules[i].getModuleType())) continue;
                    clientModule = modules[i];
                    break;
                }
            }
        } else {
            clientModule = this.moduleProvider.getJ2eeModule();
        }
        if ((url = this.findWebUrl(clientModule)) != null) {
            if (partUrl.startsWith("/")) {
                return url + partUrl;
            }
            return url + "/" + partUrl;
        }
        return null;
    }

    private J2eeModuleProvider getChildModuleProvider(J2eeModuleProvider jmp, String uri) {
        J2eeAppProvider jap;
        if (uri == null) {
            return null;
        }
        J2eeModuleProvider child = null;
        if (jmp instanceof J2eeAppProvider && (child = (jap = (J2eeAppProvider)jmp).getChildModuleProvider(uri)) == null) {
            String root = "/";
            uri = uri.startsWith(root) ? uri.substring(1) : root + uri;
            child = jap.getChildModuleProvider(uri);
        }
        return child;
    }

    private TargetModule getTargetModule() {
        TargetModule[] mods = this.getTargetModules();
        if (mods == null || mods.length == 0) {
            return null;
        }
        if (mods[0].delegate() != null) {
            return mods[0];
        }
        ServerString defaultTarget = ServerRegistry.getInstance().getDefaultInstance();
        TargetModule execMod = null;
        if (defaultTarget != null) {
            for (int i = 0; i < mods.length; ++i) {
                if (!mods[i].getInstanceUrl().equals(defaultTarget.getUrl()) || !mods[i].getTargetName().equals(defaultTarget.getTargets(true)[0])) continue;
                execMod = mods[i];
                break;
            }
        }
        if (execMod == null) {
            execMod = mods[0];
        }
        execMod.initDelegate((ModuleType)this.getModule().getModuleType());
        return execMod;
    }

    private String findWebUrl(J2eeModule client) {
        String clientModuleUri;
        TargetModule module = this.getTargetModule();
        if (module == null) {
            return null;
        }
        if (this.getModule() == client) {
            return module.getWebURL();
        }
        ServerInstance instance = ServerRegistry.getInstance().getServerInstance(module.getInstanceUrl());
        IncrementalDeployment mur = instance.getIncrementalDeployment();
        String string = clientModuleUri = client == null ? "" : client.getUrl();
        if (clientModuleUri.startsWith("/")) {
            clientModuleUri = clientModuleUri.substring(1);
        }
        TargetModuleID[] children = module.getChildTargetModuleID();
        String urlString = null;
        TargetModuleID tmid = null;
        for (int i = 0; children != null && i < children.length; ++i) {
            if (urlString == null || urlString.trim().equals("")) {
                urlString = children[i].getWebURL();
            }
            String uri = children[i].getModuleID();
            if (mur != null) {
                uri = mur.getModuleUrl(children[i]);
            } else {
                int j = uri.indexOf(35);
                if (j > -1) {
                    uri = uri.substring(j + 1);
                }
            }
            if (mur == null || !clientModuleUri.equalsIgnoreCase(uri)) continue;
            tmid = children[i];
            break;
        }
        if (tmid != null) {
            urlString = tmid.getWebURL();
        }
        return urlString;
    }

    private ConfigSupportImpl getConfigSupportImpl() {
        return (ConfigSupportImpl)this.moduleProvider.getConfigSupport();
    }

    public File getConfigurationFile() {
        return this.getConfigSupportImpl().getConfigurationFile();
    }

    public ServerString getServer() {
        if (this.server == null) {
            String instanceID = this.moduleProvider.getServerInstanceID();
            ServerInstance inst = ServerRegistry.getInstance().getServerInstance(instanceID);
            if (inst == null) {
                throw new RuntimeException(NbBundle.getMessage(DeploymentTargetImpl.class, (String)"MSG_TargetServerNotFound", (Object)instanceID));
            }
            this.server = new ServerString(inst);
        }
        return this.server;
    }

    public TargetModule[] getTargetModules() {
        if (this.targetModules == null || this.targetModules.length == 0) {
            String fname = this.getTargetModuleFileName();
            if (fname == null) {
                return null;
            }
            this.targetModules = TargetModule.load(this.getServer(), fname);
        }
        return this.targetModules;
    }

    public void setTargetModules(TargetModule[] targetModules) {
        this.targetModules = targetModules;
        for (int i = 0; i < targetModules.length; ++i) {
            targetModules[i].save(this.getTargetModuleFileName());
        }
    }

    public DeploymentConfigurationProvider getDeploymentConfigurationProvider() {
        return this.getConfigSupportImpl();
    }

    public J2eeModuleProvider.ConfigSupport getConfigSupport() {
        return this.moduleProvider.getConfigSupport();
    }

    private String getTargetModuleFileName() {
        String fileName = this.getDeploymentName();
        if (fileName != null) {
            return fileName;
        }
        File f = null;
        try {
            if (this.getModule().getContentDirectory() != null) {
                f = FileUtil.toFile((FileObject)this.getModule().getContentDirectory());
            }
        }
        catch (IOException ioe) {
            ErrorManager.getDefault().notify(1, (Throwable)ioe);
        }
        if (f == null) {
            fileName = this.getConfigSupportImpl().getDeploymentName();
        } else {
            String pathName = f.getAbsolutePath();
            fileName = TargetModule.shortNameFromPath(pathName);
        }
        return fileName;
    }

    public String getDeploymentName() {
        return this.moduleProvider.getDeploymentName();
    }
}

