/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.deployment.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.spi.DeploymentManager;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.InstanceListener;
import org.netbeans.modules.j2ee.deployment.impl.Server;
import org.netbeans.modules.j2ee.deployment.impl.ServerInstance;
import org.netbeans.modules.j2ee.deployment.impl.ServerString;
import org.netbeans.modules.j2ee.deployment.impl.ServerStringConverter;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceCreationException;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.j2ee.deployment.profiler.spi.Profiler;
import org.openide.ErrorManager;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public final class ServerRegistry
implements Serializable {
    public static final String DIR_INSTALLED_SERVERS = "/J2EE/InstalledServers";
    public static final String DIR_JSR88_PLUGINS = "/J2EE/DeploymentPlugins";
    public static final String URL_ATTR = "url";
    public static final String USERNAME_ATTR = "username";
    public static final String PASSWORD_ATTR = "password";
    public static final String FILE_DEFAULT_INSTANCE = "DefaultInstance.settings";
    public static final String J2EE_DEFAULT_SERVER = "j2ee.defaultServer";
    public static final String TARGETNAME_ATTR = "targetName";
    public static final String SERVER_NAME = "serverName";
    private static ServerRegistry instance = null;
    private transient Map servers = null;
    private transient Map instances = null;
    private transient Collection pluginListeners = new HashSet();
    private transient Collection instanceListeners = new ArrayList();
    private transient InstanceListener[] instanceListenersArray;
    private ServerString defaultInstance;
    private static HashMap configNamesByType = null;
    private static final Object[] allTypes = new Object[]{J2eeModule.EAR, J2eeModule.CLIENT, J2eeModule.CONN, J2eeModule.EJB, J2eeModule.WAR};

    public static synchronized ServerRegistry getInstance() {
        if (instance == null) {
            instance = new ServerRegistry();
        }
        return instance;
    }

    public static synchronized boolean wasInitialized() {
        return instance != null && ServerRegistry.instance.servers != null && ServerRegistry.instance.instances != null;
    }

    private synchronized void init() {
        int i;
        if (this.servers != null && this.instances != null) {
            return;
        }
        this.servers = new HashMap();
        this.instances = new HashMap();
        Repository rep = (Repository)Lookup.getDefault().lookup(Repository.class);
        FileObject dir = rep.getDefaultFileSystem().findResource(DIR_JSR88_PLUGINS);
        dir.addFileChangeListener((FileChangeListener)new PluginInstallListener());
        FileObject[] ch = dir.getChildren();
        for (i = 0; i < ch.length; ++i) {
            this.addPlugin(ch[i]);
        }
        dir = rep.getDefaultFileSystem().findResource(DIR_INSTALLED_SERVERS);
        dir.addFileChangeListener((FileChangeListener)new InstanceInstallListener());
        ch = dir.getChildren();
        for (i = 0; i < ch.length; ++i) {
            this.addInstance(ch[i]);
        }
    }

    private Map serversMap() {
        this.init();
        return this.servers;
    }

    private Map instancesMap() {
        this.init();
        return this.instances;
    }

    private synchronized void addPlugin(FileObject fo) {
        String name = "";
        try {
            if (fo.isFolder()) {
                name = fo.getName();
                if (this.serversMap().containsKey(name)) {
                    return;
                }
                Server server = new Server(fo);
                this.serversMap().put(name, server);
                this.firePluginListeners(server, true);
            }
        }
        catch (Exception e) {
            ErrorManager.getDefault().log(16, "Plugin " + name + " installation failed");
            ErrorManager.getDefault().notify(1, (Throwable)e);
        }
    }

    synchronized void removePlugin(FileObject fo) {
        String name = fo.getName();
        if (this.serversMap().containsKey(name)) {
            Server server = (Server)this.serversMap().get(name);
            if (server != null) {
                ServerInstance[] instances = this.getServerInstances();
                for (int i = 0; i < instances.length; ++i) {
                    ServerInstance si = instances[i];
                    if (!server.equals(si.getServer())) continue;
                    this.removeServerInstance(si.getUrl());
                }
            }
            this.serversMap().remove(name);
            this.firePluginListeners(server, false);
        }
    }

    public Collection getServers() {
        return this.serversMap().values();
    }

    public Collection getInstances() {
        return this.instancesMap().values();
    }

    public String[] getInstanceURLs() {
        return this.instancesMap().keySet().toArray(new String[this.instancesMap().size()]);
    }

    public void checkInstanceAlreadyExists(String url) throws InstanceCreationException {
        if (this.getServerInstance(url) != null) {
            String msg = NbBundle.getMessage(ServerRegistry.class, (String)"MSG_InstanceAlreadyExists", (Object)url);
            throw new InstanceCreationException(msg);
        }
    }

    public void checkInstanceExists(String url) {
        if (this.getServerInstance(url) == null) {
            String msg = NbBundle.getMessage(ServerRegistry.class, (String)"MSG_InstanceNotExists", (Object)url);
            throw new IllegalArgumentException(msg);
        }
    }

    public Server getServer(String name) {
        return (Server)this.serversMap().get(name);
    }

    public void addPluginListener(PluginListener pl) {
        this.pluginListeners.add(pl);
    }

    public ServerInstance getServerInstance(String url) {
        return (ServerInstance)this.instancesMap().get(url);
    }

    public void removeServerInstance(String url) {
        ServerInstance instance;
        if (url == null) {
            return;
        }
        ServerString def = this.getDefaultInstance();
        if (url.equals(def.getUrl())) {
            this.defaultInstance = null;
        }
        if ((instance = (ServerInstance)this.instancesMap().remove(url)) != null) {
            this.fireInstanceListeners(url, false);
            this.removeInstanceFromFile(url);
        }
        ServerString newinst = this.getDefaultInstance(false);
        this.fireDefaultInstance(def != null ? def.getUrl() : null, newinst != null ? newinst.getUrl() : null);
    }

    public ServerInstance[] getServerInstances() {
        ServerInstance[] ret = new ServerInstance[this.instancesMap().size()];
        this.instancesMap().values().toArray(ret);
        return ret;
    }

    public static FileObject getInstanceFileObject(String url) {
        Repository rep = (Repository)Lookup.getDefault().lookup(Repository.class);
        FileObject[] installedServers = rep.getDefaultFileSystem().findResource(DIR_INSTALLED_SERVERS).getChildren();
        for (int i = 0; i < installedServers.length; ++i) {
            String val = (String)installedServers[i].getAttribute(URL_ATTR);
            if (val == null || !val.equals(url)) continue;
            return installedServers[i];
        }
        return null;
    }

    public void addInstance(String url, String username, String password, String displayName) throws InstanceCreationException {
        if (url == null || url.equals("")) {
            ErrorManager.getDefault().log(NbBundle.getMessage(ServerRegistry.class, (String)"MSG_EmptyUrl"));
            return;
        }
        this.checkInstanceAlreadyExists(url);
        if (!this.addInstanceImpl(url, username, password, displayName)) {
            throw new InstanceCreationException(NbBundle.getMessage(ServerRegistry.class, (String)"MSG_FailedToCreateInstance", (Object)displayName));
        }
    }

    private synchronized void writeInstanceToFile(String url, String username, String password) throws IOException {
        if (url == null) {
            ErrorManager.getDefault().log(65536, NbBundle.getMessage(ServerRegistry.class, (String)"MSG_NullUrl"));
            return;
        }
        Repository rep = (Repository)Lookup.getDefault().lookup(Repository.class);
        FileObject dir = rep.getDefaultFileSystem().findResource(DIR_INSTALLED_SERVERS);
        FileObject[] instanceFOs = dir.getChildren();
        FileObject instanceFO = null;
        for (int i = 0; i < instanceFOs.length; ++i) {
            if (!url.equals(instanceFOs[i].getAttribute(URL_ATTR))) continue;
            instanceFO = instanceFOs[i];
        }
        String name = FileUtil.findFreeFileName((FileObject)dir, (String)"instance", null);
        if (instanceFO == null) {
            instanceFO = dir.createData(name);
        }
        instanceFO.setAttribute(URL_ATTR, (Object)url);
        instanceFO.setAttribute(USERNAME_ATTR, (Object)username);
        instanceFO.setAttribute(PASSWORD_ATTR, (Object)password);
    }

    private synchronized void removeInstanceFromFile(String url) {
        FileObject instanceFO = ServerRegistry.getInstanceFileObject(url);
        if (instanceFO == null) {
            return;
        }
        try {
            instanceFO.delete();
        }
        catch (IOException ioe) {
            ErrorManager.getDefault().notify(1, (Throwable)ioe);
        }
    }

    private synchronized boolean addInstanceImpl(String url, String username, String password, String displayName) {
        if (this.instancesMap().containsKey(url)) {
            return false;
        }
        for (Server server : this.serversMap().values()) {
            try {
                DeploymentManager manager;
                if (!server.handlesUri(url)) continue;
                ServerInstance instance = new ServerInstance(server, url);
                this.instancesMap().put(url, instance);
                ServerString str = new ServerString(server.getShortName(), url, null);
                this.writeInstanceToFile(url, username, password);
                if (displayName != null) {
                    instance.getInstanceProperties().setProperty("displayName", displayName);
                }
                if ((manager = server.getDisconnectedDeploymentManager(url)) != null) {
                    this.fireInstanceListeners(url, true);
                    return true;
                }
                this.removeInstanceFromFile(url);
                this.instancesMap().remove(url);
            }
            catch (Exception e) {
                if (this.instancesMap().containsKey(url)) {
                    this.removeInstanceFromFile(url);
                    this.instancesMap().remove(url);
                }
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
        }
        return false;
    }

    public void addInstance(FileObject fo) {
        String url = (String)fo.getAttribute(URL_ATTR);
        String username = (String)fo.getAttribute(USERNAME_ATTR);
        String password = (String)fo.getAttribute(PASSWORD_ATTR);
        String displayName = (String)fo.getAttribute("displayName");
        this.addInstanceImpl(url, username, password, displayName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getInstances(InstanceListener il) {
        if (il != null) {
            Collection collection = this.instanceListeners;
            synchronized (collection) {
                this.instanceListenersArray = null;
                this.instanceListeners.add(il);
            }
        }
        return this.getInstances();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInstanceListener(InstanceListener il) {
        Collection collection = this.instanceListeners;
        synchronized (collection) {
            this.instanceListenersArray = null;
            this.instanceListeners.add(il);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInstanceListener(InstanceListener il) {
        Collection collection = this.instanceListeners;
        synchronized (collection) {
            this.instanceListenersArray = null;
            this.instanceListeners.remove(il);
        }
    }

    public synchronized void removePluginListener(PluginListener pl) {
        this.pluginListeners.remove(pl);
    }

    private void firePluginListeners(Server server, boolean add) {
        for (PluginListener pl : this.pluginListeners) {
            if (add) {
                pl.serverAdded(server);
                continue;
            }
            pl.serverRemoved(server);
        }
        configNamesByType = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InstanceListener[] getInstanceListeners() {
        InstanceListener[] retValue = null;
        Collection collection = this.instanceListeners;
        synchronized (collection) {
            retValue = this.instanceListenersArray;
            if (retValue == null) {
                retValue = this.instanceListeners.toArray(new InstanceListener[this.instanceListeners.size()]);
                this.instanceListenersArray = retValue;
            }
        }
        return retValue;
    }

    private void fireInstanceListeners(String instance, boolean add) {
        InstanceListener[] instListeners = this.getInstanceListeners();
        for (int i = 0; i < instListeners.length; ++i) {
            if (add) {
                instListeners[i].instanceAdded(instance);
                continue;
            }
            instListeners[i].instanceRemoved(instance);
        }
    }

    private void fireDefaultInstance(String oldInstance, String newInstance) {
        InstanceListener[] instListeners = this.getInstanceListeners();
        for (int i = 0; i < instListeners.length; ++i) {
            instListeners[i].changeDefaultInstance(oldInstance, newInstance);
        }
    }

    public void setDefaultInstance(ServerString instance) {
        if (instance != null && instance.equals(this.defaultInstance)) {
            return;
        }
        if (instance == null) {
            ServerRegistry.removeDefaultInstanceFile();
            ServerString oldValue = this.defaultInstance;
            this.defaultInstance = null;
            this.fireDefaultInstance(oldValue != null ? oldValue.getUrl() : null, null);
        } else if (ServerStringConverter.writeServerInstance(instance, DIR_INSTALLED_SERVERS, FILE_DEFAULT_INSTANCE)) {
            ServerString oldValue = this.defaultInstance;
            this.defaultInstance = instance;
            this.fireDefaultInstance(oldValue != null ? oldValue.getUrl() : null, instance != null ? instance.getUrl() : null);
        }
    }

    private static void removeDefaultInstanceFile() {
        Object lock = null;
        Object writer = null;
        try {
            String pathName = "/J2EE/InstalledServers/DefaultInstance.settings";
            FileObject fo = Repository.getDefault().getDefaultFileSystem().findResource(pathName);
            if (fo != null) {
                fo.delete();
            }
        }
        catch (Exception ioe) {
            ErrorManager.getDefault().notify(16, (Throwable)ioe);
        }
    }

    private ServerString getInstallerDefaultPlugin() {
        File propFile = InstalledFileLocator.getDefault().locate("config/install.properties", null, false);
        Properties installProp = ServerRegistry.readProperties(propFile);
        String j2eeDefaultServerFileName = installProp.getProperty(J2EE_DEFAULT_SERVER);
        if (j2eeDefaultServerFileName == null) {
            return null;
        }
        File serverFile = InstalledFileLocator.getDefault().locate(j2eeDefaultServerFileName, null, false);
        Properties defaultServerProp = ServerRegistry.readProperties(serverFile);
        String serverName = defaultServerProp.getProperty(SERVER_NAME);
        String url = defaultServerProp.getProperty(URL_ATTR);
        String user = defaultServerProp.getProperty(USERNAME_ATTR);
        String password = defaultServerProp.getProperty(PASSWORD_ATTR);
        String targetName = defaultServerProp.getProperty(TARGETNAME_ATTR);
        try {
            ServerInstance[] instances;
            Server server;
            if (url != null) {
                InstanceProperties instProp = InstanceProperties.getInstanceProperties(url);
                if (instProp == null) {
                    instProp = InstanceProperties.createInstanceProperties(url, user, password);
                }
                instProp.setProperties(defaultServerProp);
                ServerInstance inst = this.getServerInstance(url);
                if (inst != null) {
                    return new ServerString(inst, targetName);
                }
            } else if (serverName != null && (server = this.getServer(serverName)) != null && (instances = server.getInstances()).length > 1) {
                return new ServerString(instances[0]);
            }
        }
        catch (Exception e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
        }
        return null;
    }

    private static Properties readProperties(File propFile) {
        Properties prop = new Properties();
        try {
            if (propFile != null && propFile.exists()) {
                prop.load(new FileInputStream(propFile));
            }
        }
        catch (IOException ioe) {
            ErrorManager.getDefault().log(1, ioe.toString());
        }
        return prop;
    }

    public ServerString getDefaultInstance() {
        return this.getDefaultInstance(true);
    }

    public ServerString getDefaultInstance(boolean readFromFile) {
        ServerInstance[] instances;
        if (this.defaultInstance != null) {
            return this.defaultInstance;
        }
        if (readFromFile) {
            this.defaultInstance = ServerStringConverter.readServerInstance(DIR_INSTALLED_SERVERS, FILE_DEFAULT_INSTANCE);
            if (this.defaultInstance == null) {
                this.defaultInstance = this.getInstallerDefaultPlugin();
            }
        }
        if (this.defaultInstance == null && (instances = this.getServerInstances()) != null && instances.length > 0) {
            this.defaultInstance = new ServerString(instances[0]);
        }
        this.setDefaultInstance(this.defaultInstance);
        return this.defaultInstance;
    }

    private void initConfigNamesByType() {
        if (configNamesByType != null) {
            return;
        }
        configNamesByType = new HashMap();
        for (int i = 0; i < allTypes.length; ++i) {
            HashSet<String> configNames = new HashSet<String>();
            for (Server s : this.servers.values()) {
                String[] paths = s.getDeploymentPlanFiles(allTypes[i]);
                if (paths == null) continue;
                for (int k = 0; k < paths.length; ++k) {
                    File path = new File(paths[k]);
                    configNames.add(path.getName());
                }
            }
            configNamesByType.put(allTypes[i], configNames);
        }
    }

    public boolean isConfigFileName(String name, Object type) {
        this.initConfigNamesByType();
        Set configNames = (Set)configNamesByType.get(type);
        return configNames != null && configNames.contains(name);
    }

    public ServerInstance getInstanceOrDefault(String uri) {
        ServerInstance instance = this.getServerInstance(uri);
        if (instance == null) {
            instance = this.getDefaultInstance().getServerInstance();
        }
        if (instance != null) {
            return instance;
        }
        throw new RuntimeException(NbBundle.getMessage(ServerRegistry.class, (String)"MSG_NoServerInstances", (Object)uri));
    }

    public static Profiler getProfiler() {
        return (Profiler)Lookup.getDefault().lookup(Profiler.class);
    }

    public static interface PluginListener {
        public void serverAdded(Server var1);

        public void serverRemoved(Server var1);
    }

    class LayerListener
    implements FileChangeListener {
        LayerListener() {
        }

        public void fileAttributeChanged(FileAttributeEvent fae) {
            Logger.global.log(Level.FINEST, "Attribute changed event");
        }

        public void fileChanged(FileEvent fe) {
        }

        public void fileFolderCreated(FileEvent fe) {
        }

        public void fileRenamed(FileRenameEvent fe) {
        }

        public void fileDataCreated(FileEvent fe) {
        }

        public void fileDeleted(FileEvent fe) {
        }
    }

    class InstanceInstallListener
    extends LayerListener {
        InstanceInstallListener() {
        }

        public void fileDataCreated(FileEvent fe) {
            super.fileDataCreated(fe);
            ServerRegistry.this.addInstance(fe.getFile());
        }
    }

    class PluginInstallListener
    extends LayerListener {
        PluginInstallListener() {
        }

        public void fileFolderCreated(FileEvent fe) {
            super.fileFolderCreated(fe);
            ServerRegistry.this.addPlugin(fe.getFile());
        }

        public void fileDeleted(FileEvent fe) {
            super.fileDeleted(fe);
            ServerRegistry.this.removePlugin(fe.getFile());
        }
    }
}

