/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.deployment.config;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.enterprise.deploy.model.DDBean;
import javax.enterprise.deploy.model.DeployableObject;
import javax.enterprise.deploy.model.J2eeApplicationObject;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.DeploymentConfiguration;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.enterprise.deploy.spi.exceptions.DeploymentManagerCreationException;
import javax.enterprise.deploy.spi.exceptions.InvalidModuleException;
import javax.enterprise.deploy.spi.exceptions.OperationUnsupportedException;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.deployment.common.api.Datasource;
import org.netbeans.modules.j2ee.deployment.common.api.DatasourceAlreadyExistsException;
import org.netbeans.modules.j2ee.deployment.common.api.OriginalCMPMapping;
import org.netbeans.modules.j2ee.deployment.config.DDRoot;
import org.netbeans.modules.j2ee.deployment.config.DeployableObjectImpl;
import org.netbeans.modules.j2ee.deployment.config.ModuleDeploymentSupport;
import org.netbeans.modules.j2ee.deployment.config.StandardDDImpl;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.deployment.execution.DeploymentConfigurationProvider;
import org.netbeans.modules.j2ee.deployment.impl.Server;
import org.netbeans.modules.j2ee.deployment.impl.ServerInstance;
import org.netbeans.modules.j2ee.deployment.impl.ServerRegistry;
import org.netbeans.modules.j2ee.deployment.plugins.api.ConfigurationSupport;
import org.openide.ErrorManager;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConfigSupportImpl
implements J2eeModuleProvider.ConfigSupport,
DeploymentConfigurationProvider,
PropertyChangeListener {
    private static final File[] EMPTY_FILE_LIST = new File[0];
    private static final String GENERIC_EXTENSION = ".dpf";
    private String configurationPrimaryFileName = null;
    private Map relativePaths = null;
    private Map allRelativePaths = null;
    private final J2eeModuleProvider provider;
    private final ModuleDeploymentSupport mds;
    private DeploymentConfiguration deploymentConfiguration;
    private Server server;
    private ServerInstance instance;

    public ConfigSupportImpl(J2eeModuleProvider provider) {
        String serverID;
        this.provider = provider;
        this.mds = new ModuleDeploymentSupport(provider, true);
        String serverInstanceId = provider.getServerInstanceID();
        if (serverInstanceId != null) {
            this.instance = ServerRegistry.getInstance().getServerInstance(serverInstanceId);
            if (this.instance != null) {
                this.server = this.instance.getServer();
            }
        }
        if (this.server == null && (serverID = provider.getServerID()) != null) {
            this.server = ServerRegistry.getInstance().getServer(serverID);
        }
        if (this.server != null) {
            provider.addPropertyChangeListener(this);
        }
    }

    public File getConfigurationFile() {
        try {
            return this.getDeploymentPlanFileForDistribution();
        }
        catch (Exception ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
            return null;
        }
    }

    public void createDeploymentConfiguration(Server server) {
        if (server == this.server) {
            this.createInitialConfiguration();
        } else {
            ModuleDeploymentSupport mds = new ModuleDeploymentSupport(this.provider, false);
            DeployableObjectImpl dobj = mds.getDeployableObject();
            try {
                DeploymentConfiguration deployConf = server.getDisconnectedDeploymentManager().createConfiguration((DeployableObject)dobj);
                ConfigurationSupport serverConfig = server.getConfigurationSupport();
                File[] files = ConfigSupportImpl.getDeploymentConfigurationFiles(this.getProvider(), server);
                serverConfig.initConfiguration(deployConf, files, this.getProvider().getEnterpriseResourceDirectory(), false);
            }
            catch (InvalidModuleException ime) {
                ErrorManager.getDefault().notify(1, (Throwable)ime);
            }
            catch (ConfigurationException ce) {
                ErrorManager.getDefault().notify(1, (Throwable)ce);
            }
            catch (DeploymentManagerCreationException dmce) {
                ErrorManager.getDefault().notify(1, (Throwable)dmce);
            }
        }
    }

    public static File[] getDeploymentConfigurationFiles(J2eeModuleProvider provider, Server server) {
        return ConfigSupportImpl.getDeploymentConfigurationFiles(provider, server, false);
    }

    public static FileObject[] getConfigurationFiles(J2eeModuleProvider jmp) {
        Collection servers = ServerRegistry.getInstance().getServers();
        ArrayList<FileObject> files = new ArrayList<FileObject>();
        for (Server s : servers) {
            File[] configs = ConfigSupportImpl.getDeploymentConfigurationFiles(jmp, s, true);
            for (int j = 0; j < configs.length; ++j) {
                files.add(FileUtil.toFileObject((File)configs[j]));
            }
        }
        return files.toArray(new FileObject[files.size()]);
    }

    public String getDeploymentName() {
        try {
            FileObject fo = this.getProvider().getJ2eeModule().getContentDirectory();
            if (fo == null) {
                fo = this.findPrimaryConfigurationFO();
            }
            if (fo == null) {
                return null;
            }
            Project owner = FileOwnerQuery.getOwner((FileObject)fo);
            if (owner != null) {
                return owner.getProjectDirectory().getName();
            }
        }
        catch (IOException ioe) {
            ErrorManager.getDefault().notify(1, (Throwable)ioe);
        }
        return null;
    }

    public void dispose() {
        if (this.server != null) {
            this.provider.removePropertyChangeListener(this);
            ConfigurationSupport serverConfig = this.server.getConfigurationSupport();
            if (this.deploymentConfiguration != null && serverConfig != null) {
                serverConfig.disposeConfiguration(this.deploymentConfiguration);
            }
        }
        if (this.mds != null) {
            this.mds.cleanup();
        }
    }

    @Override
    public boolean createInitialConfiguration() {
        return this.getDeploymentConfiguration() != null;
    }

    @Override
    public boolean ensureConfigurationReady() {
        return this.getDeploymentConfiguration() != null;
    }

    @Override
    public String getWebContextRoot() {
        if (!this.getProvider().getJ2eeModule().getModuleType().equals(J2eeModule.WAR)) {
            ErrorManager.getDefault().log("getWebContextRoot called on other module type then WAR");
            return null;
        }
        if (this.server == null) {
            return null;
        }
        DeploymentConfiguration config = this.getDeploymentConfiguration();
        if (config == null) {
            return null;
        }
        ConfigurationSupport serverConfig = this.server.getConfigurationSupport();
        if (serverConfig == null) {
            return null;
        }
        try {
            return serverConfig.getWebContextRoot(config, config.getDeployableObject());
        }
        catch (ConfigurationException ce) {
            ErrorManager.getDefault().notify(1, (Throwable)ce);
            return null;
        }
    }

    @Override
    public void setWebContextRoot(String contextRoot) {
        if (!this.getProvider().getJ2eeModule().getModuleType().equals(J2eeModule.WAR)) {
            ErrorManager.getDefault().log("setWebContextRoot called on other module type then WAR");
            return;
        }
        if (this.server == null) {
            return;
        }
        DeploymentConfiguration config = this.getDeploymentConfiguration();
        if (config == null) {
            return;
        }
        ConfigurationSupport serverConfig = this.server.getConfigurationSupport();
        if (serverConfig == null) {
            return;
        }
        try {
            serverConfig.setWebContextRoot(config, config.getDeployableObject(), contextRoot);
        }
        catch (ConfigurationException ce) {
            ErrorManager.getDefault().notify(1, (Throwable)ce);
        }
    }

    @Override
    public String[] getDeploymentConfigurationFileNames() {
        if (this.server == null) {
            return new String[0];
        }
        if (this.hasCustomSupport()) {
            return this.getRelativePaths().keySet().toArray(new String[this.relativePaths.size()]);
        }
        return new String[]{this.getStandardDeploymentPlanName()};
    }

    @Override
    public String getContentRelativePath(String configName) {
        if (!this.hasCustomSupport()) {
            return configName;
        }
        return (String)this.getAllRelativePaths().get(configName);
    }

    @Override
    public void setCMPMappingInfo(OriginalCMPMapping[] mappings) {
        if (this.server == null) {
            return;
        }
        DeploymentConfiguration config = this.getDeploymentConfiguration();
        ConfigurationSupport serverConfig = this.server.getConfigurationSupport();
        serverConfig.setMappingInfo(config, mappings);
    }

    @Override
    public void ensureResourceDefinedForEjb(String ejbname, String ejbtype) {
        if (ejbname == null) {
            throw new NullPointerException("EJB name cannot be null");
        }
        if (ejbtype == null) {
            throw new NullPointerException("EJB type cannot be null");
        }
        if (this.server == null) {
            return;
        }
        DDBean ejbBean = this.findDDBean(ejbname, ejbtype);
        if (ejbBean != null) {
            DeploymentConfiguration config = this.getDeploymentConfiguration();
            ConfigurationSupport serverConfig = this.server.getConfigurationSupport();
            serverConfig.ensureResourceDefined(config, ejbBean);
        }
    }

    @Override
    public void ensureResourceDefinedForEjb(String ejbname, String ejbtype, String jndiName) {
        if (ejbname == null) {
            throw new NullPointerException("EJB name cannot be null");
        }
        if (ejbtype == null) {
            throw new NullPointerException("EJB type cannot be null");
        }
        if (jndiName == null) {
            throw new NullPointerException("JNDI name cannot be null");
        }
        if (this.server == null) {
            return;
        }
        DDBean ejbBean = this.findDDBean(ejbname, ejbtype);
        if (ejbBean != null) {
            DeploymentConfiguration config = this.getDeploymentConfiguration();
            ConfigurationSupport serverConfig = this.server.getConfigurationSupport();
            serverConfig.ensureResourceDefined(config, ejbBean, jndiName);
        }
    }

    private DDBean findDDBean(String ejbname, String ejbtype) {
        int i;
        if (!J2eeModule.EJB.equals(this.provider.getJ2eeModule().getModuleType())) {
            throw new IllegalArgumentException("Trying to get config bean for ejb on non ejb module!");
        }
        StandardDDImpl ejbBean = null;
        DDRoot ddroot = this.mds.getDDBeanRoot("META-INF/ejb-jar.xml");
        StandardDDImpl[] ddbeans = (StandardDDImpl[])ddroot.getChildBean("/enterprise-beans/" + ejbtype);
        for (i = 0; i < ddbeans.length; ++i) {
            String ejbName = (String)ddbeans[i].proxy.bean.getValue("EjbName");
            if (!ejbname.equals(ejbName)) continue;
            ejbBean = ddbeans[i];
            break;
        }
        if (ejbBean == null) {
            if (ddbeans != null) {
                for (i = 0; i < ddbeans.length; ++i) {
                    String msg = ddbeans[i].proxy.bean.dumpBeanNode();
                    ErrorManager.getDefault().log(65536, msg);
                }
            }
            Exception e = new Exception("Failed to lookup: " + ejbname + " type " + ejbtype);
            ErrorManager.getDefault().notify(1, (Throwable)e);
            return null;
        }
        return ejbBean;
    }

    @Override
    public Set<Datasource> getDatasources() {
        DeploymentConfiguration config;
        ConfigurationSupport configSupport;
        Set<Datasource> projectDS = Collections.emptySet();
        if (this.server != null && (configSupport = this.server.getConfigurationSupport()) != null && (config = this.getDeploymentConfiguration()) != null) {
            projectDS = configSupport.getDatasources(config);
        }
        return projectDS;
    }

    @Override
    public boolean isDatasourceCreationSupported() {
        if (this.server == null) {
            return false;
        }
        ConfigurationSupport configSupport = this.server.getConfigurationSupport();
        if (configSupport == null) {
            return false;
        }
        return configSupport.isDatasourceCreationSupported();
    }

    @Override
    public Datasource createDatasource(String jndiName, String url, String username, String password, String driver) throws OperationUnsupportedException, DatasourceAlreadyExistsException {
        DeploymentConfiguration config;
        ConfigurationSupport configSupport;
        Datasource ds = null;
        if (this.server != null && (configSupport = this.server.getConfigurationSupport()) != null && (config = this.getDeploymentConfiguration()) != null) {
            try {
                ds = configSupport.createDatasource(config, jndiName, url, username, password, driver);
            }
            catch (ConfigurationException ce) {
                ErrorManager.getDefault().notify(1, (Throwable)ce);
            }
        }
        return ds;
    }

    @Override
    public DeploymentConfiguration getDeploymentConfiguration() {
        if (this.deploymentConfiguration == null) {
            DeployableObjectImpl dobj = this.mds.getDeployableObject();
            try {
                if (this.instance != null) {
                    this.deploymentConfiguration = this.instance.getDeploymentManagerForConfiguration().createConfiguration((DeployableObject)dobj);
                } else if (this.server != null) {
                    this.deploymentConfiguration = this.server.getDisconnectedDeploymentManager().createConfiguration((DeployableObject)dobj);
                } else {
                    return null;
                }
                ConfigurationSupport serverConfig = this.server.getConfigurationSupport();
                File[] files = ConfigSupportImpl.getDeploymentConfigurationFiles(this.getProvider(), this.server);
                serverConfig.initConfiguration(this.deploymentConfiguration, files, this.getProvider().getEnterpriseResourceDirectory(), true);
            }
            catch (InvalidModuleException ime) {
                ErrorManager.getDefault().notify(1, (Throwable)ime);
                return null;
            }
            catch (ConfigurationException ce) {
                ErrorManager.getDefault().notify(1, (Throwable)ce);
                return null;
            }
            catch (DeploymentManagerCreationException dmce) {
                ErrorManager.getDefault().notify(1, (Throwable)dmce);
                return null;
            }
        }
        return this.deploymentConfiguration;
    }

    @Override
    public DeployableObject getDeployableObject(String moduleUri) {
        DeployableObjectImpl deplObj = this.mds.getDeployableObject();
        if (deplObj instanceof J2eeApplicationObject) {
            return ((J2eeApplicationObject)deplObj).getDeployableObject(moduleUri);
        }
        return this.mds.getDeployableObject();
    }

    private static File[] getDeploymentConfigurationFiles(J2eeModuleProvider provider, Server server, boolean existingOnly) {
        String[] fnames;
        if (provider == null || server == null) {
            return new File[0];
        }
        ModuleType type = (ModuleType)provider.getJ2eeModule().getModuleType();
        if (ConfigSupportImpl.hasCustomSupport(server, type)) {
            fnames = server.getDeploymentPlanFiles(type);
        } else if (server.supportsModuleType(type)) {
            fnames = new String[]{ConfigSupportImpl.getStandardDeploymentPlanName(server)};
        } else {
            return EMPTY_FILE_LIST;
        }
        ArrayList<File> files = new ArrayList<File>();
        for (int i = 0; i < fnames.length; ++i) {
            File path = new File(fnames[i]);
            String fname = path.getName();
            File file = null;
            if (existingOnly) {
                FileObject fo = provider.findDeploymentConfigurationFile(fname);
                if (fo != null) {
                    file = FileUtil.toFile((FileObject)fo);
                }
            } else {
                file = provider.getDeploymentConfigurationFile(fname);
            }
            if (file == null) continue;
            files.add(file);
        }
        return files.toArray(new File[files.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File getDeploymentPlanFileForDistribution() throws IOException, ConfigurationException {
        if (this.server == null) {
            String msg = NbBundle.getMessage(ConfigSupportImpl.class, (String)"MSG_NoTargetSelected");
            throw new ConfigurationException(msg);
        }
        FileLock lock = null;
        OutputStream out = null;
        try {
            FileObject dist = this.getProvider().getJ2eeModule().getContentDirectory();
            String planName = this.getStandardDeploymentPlanName();
            FileObject plan = null;
            if (dist != null) {
                plan = dist.getFileObject(planName);
                if (plan == null) {
                    plan = dist.createData(planName);
                }
            } else {
                File file = null;
                return file;
            }
            lock = plan.lock();
            out = plan.getOutputStream(lock);
            DeploymentConfiguration conf = this.getDeploymentConfiguration();
            if (conf != null) {
                conf.save(out);
                File file = FileUtil.toFile((FileObject)plan);
                return file;
            }
            File file = null;
            return file;
        }
        finally {
            if (lock != null) {
                lock.releaseLock();
            }
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException ioe) {
                ErrorManager.getDefault().log(ioe.toString());
            }
        }
    }

    private String getPrimaryConfigurationFileName() {
        this.getRelativePaths();
        if (this.configurationPrimaryFileName == null) {
            return this.getStandardDeploymentPlanName();
        }
        return this.configurationPrimaryFileName;
    }

    private String getStandardDeploymentPlanName() {
        return ConfigSupportImpl.getStandardDeploymentPlanName(this.server);
    }

    private static String getStandardDeploymentPlanName(Server server) {
        return server.getShortName() + GENERIC_EXTENSION;
    }

    private FileObject findPrimaryConfigurationFO() throws IOException {
        String configFileName = this.getPrimaryConfigurationFileName();
        return this.getProvider().findDeploymentConfigurationFile(configFileName);
    }

    private ModuleType getModuleType() {
        return (ModuleType)this.getProvider().getJ2eeModule().getModuleType();
    }

    private boolean hasCustomSupport() {
        return ConfigSupportImpl.hasCustomSupport(this.server, this.getModuleType());
    }

    private static boolean hasCustomSupport(Server server, ModuleType type) {
        if (server == null || server.getConfigurationSupport() == null) {
            return false;
        }
        return server.getDeploymentPlanFiles(type) != null;
    }

    private J2eeModuleProvider getProvider() {
        return this.provider;
    }

    private Map getRelativePaths() {
        if (this.relativePaths != null) {
            return this.relativePaths;
        }
        this.relativePaths = new HashMap();
        if (this.hasCustomSupport()) {
            String[] paths = this.server.getDeploymentPlanFiles(this.getModuleType());
            this.configurationPrimaryFileName = paths[0].substring(paths[0].lastIndexOf("/") + 1);
            this.collectData(this.server, this.relativePaths);
        }
        return this.relativePaths;
    }

    private void collectData(Server server, Map map) {
        if (!ConfigSupportImpl.hasCustomSupport(server, this.getModuleType())) {
            return;
        }
        String[] paths = server.getDeploymentPlanFiles(this.getModuleType());
        paths = paths == null ? new String[]{} : paths;
        for (int i = 0; i < paths.length; ++i) {
            String name = paths[i].substring(paths[i].lastIndexOf("/") + 1);
            map.put(name, paths[i]);
        }
    }

    private Map getAllRelativePaths() {
        if (this.allRelativePaths != null) {
            return this.allRelativePaths;
        }
        this.allRelativePaths = new HashMap();
        Collection servers = ServerRegistry.getInstance().getServers();
        for (Server server : servers) {
            this.collectData(server, this.allRelativePaths);
        }
        return this.allRelativePaths;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("resourceDir".equals(evt.getPropertyName())) {
            DeploymentConfiguration config = this.getDeploymentConfiguration();
            ConfigurationSupport serverConfig = this.server.getConfigurationSupport();
            Object newValue = evt.getNewValue();
            if (newValue != null && !(newValue instanceof File)) {
                throw new IllegalArgumentException("Enterprise resource directory property value is not a File");
            }
            serverConfig.updateResourceDir(config, (File)newValue);
        }
    }
}

