/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.util;

import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.event.BreakpointEvent;
import com.sun.jdi.event.ClassPrepareEvent;
import com.sun.jdi.event.ClassUnloadEvent;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.EventIterator;
import com.sun.jdi.event.EventQueue;
import com.sun.jdi.event.EventSet;
import com.sun.jdi.event.MethodEntryEvent;
import com.sun.jdi.event.StepEvent;
import com.sun.jdi.event.ThreadDeathEvent;
import com.sun.jdi.event.ThreadStartEvent;
import com.sun.jdi.event.VMDeathEvent;
import com.sun.jdi.event.VMDisconnectEvent;
import com.sun.jdi.event.VMStartEvent;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.StepRequest;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.debugger.jpda.util.Executor;
import org.openide.ErrorManager;

public class Operator {
    private Thread thread;
    private boolean breakpointsDisabled;
    private List staledEvents = new ArrayList();
    private List staledRequests = new ArrayList();
    private boolean stop;
    private static boolean verbose = System.getProperty("netbeans.debugger.jdievents") != null;

    public Operator(VirtualMachine virtualMachine, Executor starter, Runnable finalizer, final Object resumeLock) {
        EventQueue eventQueue = virtualMachine.eventQueue();
        if (eventQueue == null) {
            throw new NullPointerException();
        }
        final Object[] params = new Object[]{eventQueue, starter, finalizer};
        this.thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                EventQueue eventQueue = (EventQueue)params[0];
                Executor starter = (Executor)params[1];
                Runnable finalizer = (Runnable)params[2];
                params[0] = null;
                params[1] = null;
                params[2] = null;
                boolean processStaledEvents = false;
                block25: while (true) {
                    try {
                        EventSet eventSet;
                        while (true) {
                            block49: {
                                eventSet = null;
                                if (processStaledEvents) {
                                    Operator operator = Operator.this;
                                    synchronized (operator) {
                                        if (Operator.this.staledEvents.size() == 0) {
                                            processStaledEvents = false;
                                        } else {
                                            eventSet = (EventSet)Operator.this.staledEvents.remove(0);
                                            while (Operator.this.staledRequests.size() > 0) {
                                                EventRequest request = (EventRequest)Operator.this.staledRequests.remove(0);
                                                request.virtualMachine().eventRequestManager().deleteEventRequest(request);
                                            }
                                        }
                                    }
                                }
                                if (eventSet == null) {
                                    try {
                                        eventSet = eventQueue.remove();
                                        if (!verbose) break block49;
                                        System.out.println("HAVE EVENT(s) in the Queue: " + eventSet);
                                    }
                                    catch (InterruptedException iexc) {
                                        Operator request = Operator.this;
                                        synchronized (request) {
                                            if (Operator.this.stop) {
                                                break block25;
                                            }
                                        }
                                        processStaledEvents = true;
                                        continue;
                                    }
                                }
                            }
                            Operator iexc = Operator.this;
                            synchronized (iexc) {
                                if (Operator.this.breakpointsDisabled) {
                                    if (eventSet.suspendPolicy() == 2) {
                                        Operator.this.staledEvents.add(eventSet);
                                        eventSet.resume();
                                        if (verbose) {
                                            System.out.println("RESUMING " + eventSet);
                                        }
                                    }
                                    continue;
                                }
                            }
                            boolean resume = true;
                            boolean startEventOnly = true;
                            EventIterator i = eventSet.eventIterator();
                            if (verbose) {
                                switch (eventSet.suspendPolicy()) {
                                    case 2: {
                                        System.out.println("\nJDI new events (suspend all)=============================================");
                                        break;
                                    }
                                    case 1: {
                                        System.out.println("\nJDI new events (suspend one)=============================================");
                                        break;
                                    }
                                    case 0: {
                                        System.out.println("\nJDI new events (suspend none)=============================================");
                                        break;
                                    }
                                    default: {
                                        System.out.println("\nJDI new events (?????)=============================================");
                                    }
                                }
                            }
                            while (i.hasNext()) {
                                Event e = i.nextEvent();
                                if (e instanceof VMDeathEvent || e instanceof VMDisconnectEvent) {
                                    if (verbose) {
                                        Operator.this.printEvent(e, null);
                                    }
                                    if (finalizer != null) {
                                        finalizer.run();
                                    }
                                    finalizer = null;
                                    eventQueue = null;
                                    starter = null;
                                    return;
                                }
                                if (e instanceof VMStartEvent && starter != null) {
                                    resume &= starter.exec(e);
                                    if (!verbose) continue;
                                    Operator.this.printEvent(e, null);
                                    continue;
                                }
                                Executor exec = null;
                                if (e.request() == null) {
                                    if (verbose) {
                                        System.out.println("EVENT: " + e + " REQUEST: null");
                                    }
                                } else {
                                    exec = (Executor)e.request().getProperty("executor");
                                }
                                if (verbose) {
                                    Operator.this.printEvent(e, exec);
                                }
                                if (exec == null) continue;
                                try {
                                    startEventOnly = false;
                                    resume &= exec.exec(e);
                                }
                                catch (VMDisconnectedException exc) {
                                    if (finalizer != null) {
                                        finalizer.run();
                                    }
                                    return;
                                }
                                catch (Exception ex) {
                                    ErrorManager.getDefault().notify((Throwable)ex);
                                }
                            }
                            if (verbose) {
                                System.out.println("JDI events dispatched (resume " + (resume && !startEventOnly) + ")");
                                System.out.println("  resume = " + resume + ", startEventOnly = " + startEventOnly);
                            }
                            if (resume && !startEventOnly) break;
                        }
                        Object object = resumeLock;
                        synchronized (object) {
                            eventSet.resume();
                        }
                    }
                    catch (VMDisconnectedException e) {
                        break;
                    }
                    catch (Exception e) {
                        ErrorManager.getDefault().notify((Throwable)e);
                        break;
                    }
                }
                if (finalizer != null) {
                    finalizer.run();
                }
                finalizer = null;
                eventQueue = null;
                starter = null;
            }
        }, "Debugger operator thread");
    }

    public void start() {
        this.thread.start();
    }

    public synchronized void register(EventRequest req, Executor e) {
        req.putProperty("executor", e);
        if (this.staledEvents.size() > 0 && req instanceof StepRequest) {
            boolean addAsStaled = false;
            Iterator it = this.staledEvents.iterator();
            while (it.hasNext()) {
                EventSet evSet = (EventSet)it.next();
                Iterator itSet = evSet.iterator();
                while (itSet.hasNext()) {
                    Event ev = (Event)itSet.next();
                    EventRequest evReq = ev.request();
                    if (!(evReq instanceof StepRequest)) {
                        addAsStaled = true;
                        break;
                    }
                    ThreadReference evThread = ((StepRequest)evReq).thread();
                    ThreadReference reqThread = ((StepRequest)req).thread();
                    if (!reqThread.equals(evThread)) continue;
                    addAsStaled = true;
                    break;
                }
                if (!addAsStaled) continue;
                break;
            }
            if (addAsStaled) {
                this.staledRequests.add(req);
            }
        }
    }

    public synchronized void unregister(EventRequest req) {
        req.putProperty("executor", null);
        this.staledRequests.remove(req);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Operator operator = this;
        synchronized (operator) {
            this.stop = true;
            this.staledRequests.clear();
            this.staledEvents.clear();
        }
        this.thread.interrupt();
    }

    public synchronized void breakpointsDisabled() {
        this.breakpointsDisabled = true;
    }

    public synchronized void breakpointsEnabled() {
        this.breakpointsDisabled = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean flushStaledEvents() {
        boolean areStaledEvents;
        Operator operator = this;
        synchronized (operator) {
            boolean bl = areStaledEvents = this.staledEvents.size() > 0;
            if (areStaledEvents) {
                this.thread.interrupt();
            }
        }
        return areStaledEvents;
    }

    private void printEvent(Event e, Executor exec) {
        try {
            if (e instanceof ClassPrepareEvent) {
                System.out.println("\nJDI EVENT: ClassPrepareEvent " + ((ClassPrepareEvent)e).referenceType());
            } else if (e instanceof ClassUnloadEvent) {
                System.out.println("\nJDI EVENT: ClassUnloadEvent " + ((ClassUnloadEvent)e).className());
            } else if (e instanceof ThreadStartEvent) {
                try {
                    System.out.println("\nJDI EVENT: ThreadStartEvent " + ((ThreadStartEvent)e).thread());
                }
                catch (Exception ex) {
                    System.out.println("\nJDI EVENT: ThreadStartEvent1 " + e);
                }
            } else if (e instanceof ThreadDeathEvent) {
                try {
                    System.out.println("\nJDI EVENT: ThreadDeathEvent " + ((ThreadDeathEvent)e).thread());
                }
                catch (Exception ex) {
                    System.out.println("\nJDI EVENT: ThreadDeathEvent1 " + e);
                }
            } else if (e instanceof MethodEntryEvent) {
                try {
                    System.out.println("\nJDI EVENT: MethodEntryEvent " + e);
                }
                catch (Exception ex) {
                    System.out.println("\nJDI EVENT: MethodEntryEvent " + e);
                }
            } else if (e instanceof BreakpointEvent) {
                System.out.println("\nJDI EVENT: BreakpointEvent " + ((BreakpointEvent)e).thread() + " : " + ((BreakpointEvent)e).location());
            } else if (e instanceof StepEvent) {
                System.out.println("\nJDI EVENT: StepEvent " + ((StepEvent)e).thread() + " : " + ((StepEvent)e).location());
            } else {
                System.out.println("\nJDI EVENT: " + e + " : " + exec);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

