/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.models;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.Value;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import org.netbeans.api.debugger.Watch;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDAWatch;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.models.AbstractVariable;
import org.netbeans.modules.debugger.jpda.models.CallStackFrameImpl;

class JPDAWatchImpl
extends AbstractVariable
implements JPDAWatch {
    private JPDADebuggerImpl debugger;
    private Watch watch;
    private String exceptionDescription;
    private Reference nodeRef;

    JPDAWatchImpl(JPDADebuggerImpl debugger, Watch watch, Value v, Object node) {
        super(debugger, v, "" + watch + (v instanceof ObjectReference ? "^" : ""));
        this.debugger = debugger;
        this.watch = watch;
        this.nodeRef = new WeakReference<Object>(node);
    }

    JPDAWatchImpl(JPDADebuggerImpl debugger, Watch watch, Exception exception, Object node) {
        super(debugger, null, "" + watch);
        this.debugger = debugger;
        this.watch = watch;
        this.exceptionDescription = exception.getLocalizedMessage();
        if (this.exceptionDescription == null) {
            this.exceptionDescription = exception.getMessage();
        }
        this.nodeRef = new WeakReference<Object>(node);
    }

    public String getExpression() {
        return this.watch.getExpression();
    }

    public void setExpression(String expression) {
        this.watch.setExpression(expression);
    }

    public void remove() {
        this.watch.remove();
    }

    public String getExceptionDescription() {
        return this.exceptionDescription;
    }

    protected void setInnerValue(Value v) {
        super.setInnerValue(v);
        this.exceptionDescription = null;
    }

    protected void setValue(Value value) throws InvalidExpressionException {
        CallStackFrameImpl frame = (CallStackFrameImpl)this.debugger.getCurrentCallStackFrame();
        if (frame == null) {
            throw new InvalidExpressionException("No curent frame.");
        }
        LocalVariable local = null;
        try {
            local = frame.getStackFrame().visibleVariableByName(this.getExpression());
        }
        catch (AbsentInformationException ex) {
            throw new InvalidExpressionException("Can not set value to expression.");
        }
        if (local == null) {
            throw new InvalidExpressionException("Can not set value to expression.");
        }
        try {
            frame.getStackFrame().setValue(local, value);
        }
        catch (InvalidTypeException ex) {
            throw new InvalidExpressionException((Throwable)ex);
        }
        catch (ClassNotLoadedException ex) {
            throw new InvalidExpressionException((Throwable)ex);
        }
    }

    void setException(String exceptionDescription) {
        this.setInnerValue(null);
        this.exceptionDescription = exceptionDescription;
    }

    boolean isPrimitive() {
        return !(this.getInnerValue() instanceof ObjectReference);
    }
}

