/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.expr;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.BooleanType;
import com.sun.jdi.BooleanValue;
import com.sun.jdi.ByteType;
import com.sun.jdi.CharType;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassType;
import com.sun.jdi.DoubleType;
import com.sun.jdi.Field;
import com.sun.jdi.FloatType;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.IntegerType;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Location;
import com.sun.jdi.LongType;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.PrimitiveType;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ShortType;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Type;
import com.sun.jdi.TypeComponent;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.modules.debugger.jpda.expr.Assert;
import org.netbeans.modules.debugger.jpda.expr.EvaluationContext;
import org.netbeans.modules.debugger.jpda.expr.EvaluationException;
import org.netbeans.modules.debugger.jpda.expr.Expression;
import org.netbeans.modules.debugger.jpda.expr.Identifier;
import org.netbeans.modules.debugger.jpda.expr.JavaParserVisitor;
import org.netbeans.modules.debugger.jpda.expr.Operators;
import org.netbeans.modules.debugger.jpda.expr.SimpleNode;
import org.netbeans.modules.debugger.jpda.expr.Token;
import org.openide.util.NbBundle;

public class Evaluator
implements JavaParserVisitor {
    private static final boolean verbose = System.getProperty("netbeans.debugger.noInvokeMethods") != null;
    private Expression expression;
    private EvaluationContext evaluationContext;
    private VirtualMachine vm;
    private StackFrame frame;
    private ThreadReference frameThread;
    private int frameIndex;
    private SimpleNode currentNode;
    private String currentPackage;
    private Operators operators;
    private String brackets = "[[[[[[[[[[[[[[[[[[[";
    private static final String[] typeSignaturesSorted = new String[]{"Ljava/lang/Byte;", "B", "Ljava/lang/Character;", "C", "Ljava/lang/Short;", "S", "Ljava/lang/Integer;", "I", "Ljava/lang/Long;", "J", "Ljava/lang/Float;", "F", "Ljava/lang/Double;", "D"};
    static /* synthetic */ Class class$com$sun$jdi$FloatValue;
    static /* synthetic */ Class class$com$sun$jdi$DoubleValue;
    static /* synthetic */ Class class$com$sun$jdi$Value;

    Evaluator(Expression expression, EvaluationContext context) {
        this.expression = expression;
        this.evaluationContext = context;
    }

    public Value evaluate() throws EvaluationException, IncompatibleThreadStateException {
        this.frame = this.evaluationContext.getFrame();
        this.vm = this.evaluationContext.getFrame().virtualMachine();
        this.frameThread = this.frame.thread();
        this.frameIndex = this.indexOf(this.frameThread.frames(), this.frame);
        if (this.frameIndex == -1) {
            throw new IncompatibleThreadStateException("Thread does not contain current frame");
        }
        this.currentPackage = this.evaluationContext.getFrame().location().declaringType().name();
        int idx = this.currentPackage.lastIndexOf(46);
        this.currentPackage = idx > 0 ? this.currentPackage.substring(0, idx + 1) : "";
        this.operators = new Operators(this.vm);
        SimpleNode rootNode = this.expression.getRoot();
        return (Value)rootNode.jjtAccept(this, null);
    }

    private int indexOf(List frames, StackFrame frame) {
        int n = frames.size();
        Location loc = frame.location();
        for (int i = 0; i < n; ++i) {
            if (!((Object)loc).equals(((StackFrame)frames.get(i)).location())) continue;
            return i;
        }
        return -1;
    }

    public Object visit(SimpleNode node, Object data) throws EvaluationException {
        this.currentNode = node;
        switch (node.jjtGetID()) {
            case 8: {
                return this.visitResultType(node, data);
            }
            case 4: {
                return this.visitArrayInitializer(node, data);
            }
            case 40: {
                return this.visitArrayDimsAndInits(node, data);
            }
            case 39: {
                return this.visitAllocationExpression(node, data);
            }
            case 38: {
                return this.visitArgumentList(node, data);
            }
            case 37: {
                return this.visitArguments(node, data);
            }
            case 30: {
                return this.visitCastExpression(node, data);
            }
            case 29: {
                return this.visitPostfixExpression(node, data);
            }
            case 26: 
            case 27: {
                return this.visitPrefixExpression(node, data);
            }
            case 25: 
            case 28: {
                return this.visitUnaryExpression(node, data);
            }
            case 10: {
                return this.visitClassOrInterfaceType(node, data);
            }
            case 2: {
                return this.visitIdentifier(node, data);
            }
            case 7: {
                return this.visitPrimitiveType(node, data);
            }
            case 5: {
                return this.visitReferenceType(node, data);
            }
            case 9: {
                return this.visitName(node, data);
            }
            case 11: {
                return this.visitExpression(node, data);
            }
            case 31: {
                return this.visitPrimaryExpression(node, data);
            }
            case 32: {
                return this.visitPrimaryPrefix(node, data);
            }
            case 33: {
                return this.visitPrimarySuffix(node, data);
            }
            case 13: {
                return this.visitConditionalExpression(node, data);
            }
            case 14: 
            case 15: {
                return this.visitConditionalOrAndExpression(node, data);
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                return this.visitBinaryExpression(node, data);
            }
            case 20: {
                return this.visitInstanceOfExpression(node, data);
            }
            case 34: {
                return this.visitLiteral(node, data);
            }
            case 35: {
                return this.visitBooleanLiteral(node, data);
            }
            case 36: {
                return null;
            }
        }
        return Assert.error(node, "unknownNonterminal");
    }

    private ObjectReference primitiveClass(String name) throws IncompatibleThreadStateException {
        ReferenceType primType = this.resolveType("java.lang." + name.substring(0, 1).toUpperCase() + name.substring(1));
        return (ObjectReference)primType.getValue(primType.fieldByName("TYPE"));
    }

    private Object visitResultType(SimpleNode node, Object data) {
        try {
            if (node.getAttribute("void") != null) {
                return this.primitiveClass("void");
            }
            Type type = (Type)node.jjtGetChild(0).jjtAccept(this, data);
            if (type instanceof ReferenceType) {
                return type;
            }
            return this.primitiveClass(type.name());
        }
        catch (IncompatibleThreadStateException e) {
            return Assert.error(node, "internalErrorResolvingType", "void");
        }
    }

    private Object visitArrayInitializer(SimpleNode node, Object data) {
        Object[] values = new Object[node.jjtGetNumChildren()];
        for (int i = 0; i < values.length; ++i) {
            values[i] = node.jjtGetChild(i).jjtAccept(this, data);
            if (values[i] instanceof Value || values[i] instanceof Object[]) continue;
            Assert.error(node, "invalidArrayInitializer", values[i]);
        }
        return values;
    }

    private Object visitArrayDimsAndInits(SimpleNode node, Object data) {
        Type arrayType = (Type)data;
        int dimensions = (Integer)node.getAttribute("dimensions");
        Object arrayRef = null;
        try {
            if (node.getAttribute("initializers") != null) {
                Object[] initValues = (Object[])node.jjtGetChild(0).jjtAccept(this, data);
                return this.createArray(arrayType, dimensions, initValues);
            }
            int sizeCount = node.jjtGetNumChildren();
            int[] sizes = new int[sizeCount];
            for (int i = 0; i < sizeCount; ++i) {
                Object sizeObj = node.jjtGetChild(i).jjtAccept(this, data);
                Assert.assertAssignable(sizeObj, class$com$sun$jdi$PrimitiveValue == null ? Evaluator.class$("com.sun.jdi.PrimitiveValue") : class$com$sun$jdi$PrimitiveValue, node, "arraySizeBadType", sizeObj);
                Assert.assertNotAssignable(sizeObj, class$com$sun$jdi$BooleanValue == null ? Evaluator.class$("com.sun.jdi.BooleanValue") : class$com$sun$jdi$BooleanValue, node, "arraySizeBadType", sizeObj);
                Assert.assertNotAssignable(sizeObj, class$com$sun$jdi$FloatValue == null ? Evaluator.class$("com.sun.jdi.FloatValue") : class$com$sun$jdi$FloatValue, node, "arraySizeBadType", sizeObj);
                Assert.assertNotAssignable(sizeObj, class$com$sun$jdi$DoubleValue == null ? Evaluator.class$("com.sun.jdi.DoubleValue") : class$com$sun$jdi$DoubleValue, node, "arraySizeBadType", sizeObj);
                sizes[i] = ((PrimitiveValue)sizeObj).intValue();
            }
            return this.createArray(arrayType, dimensions, sizes, 0);
        }
        catch (IncompatibleThreadStateException e) {
            Assert.error(node, "arrayCreateError", e);
        }
        catch (ClassNotLoadedException e) {
            Assert.error(node, "arrayCreateError", e);
        }
        catch (InvalidTypeException e) {
            Assert.error(node, "arrayCreateError", e);
        }
        catch (UnsupportedOperationException uoex) {
            return Assert.error(node, "calleeException", uoex);
        }
        return arrayRef;
    }

    private String brackets(int length) {
        if (this.brackets.length() < length) {
            char[] bracketsArray = new char[length];
            Arrays.fill(bracketsArray, '[');
            this.brackets = new String(bracketsArray);
        }
        return this.brackets.substring(0, length);
    }

    private ArrayReference createArray(Type baseType, int dimensions, int[] sizes, int index) throws IncompatibleThreadStateException, ClassNotLoadedException, InvalidTypeException {
        ArrayType arrayType = (ArrayType)this.resolveType(this.brackets(dimensions) + baseType.signature());
        ArrayReference arrayRef = arrayType.newInstance(sizes[index]);
        if (sizes.length > index + 1) {
            for (int i = 0; i < sizes[index]; ++i) {
                arrayRef.setValue(i, (Value)this.createArray(baseType, dimensions - 1, sizes, index + 1));
            }
        }
        return arrayRef;
    }

    private ArrayReference createArray(Type baseType, int dimensions, Object[] values) throws IncompatibleThreadStateException, ClassNotLoadedException, InvalidTypeException {
        ArrayType arrayType = (ArrayType)this.resolveType(this.brackets(dimensions) + baseType.signature());
        ArrayReference arrayRef = arrayType.newInstance(values.length);
        for (int i = 0; i < values.length; ++i) {
            if (values[i] instanceof Object[]) {
                arrayRef.setValue(i, (Value)this.createArray(baseType, dimensions - 1, (Object[])values[i]));
                continue;
            }
            arrayRef.setValue(i, (Value)values[i]);
        }
        return arrayRef;
    }

    private Object visitAllocationExpression(SimpleNode node, Object data) {
        Type arrayType = (Type)node.jjtGetChild(0).jjtAccept(this, data);
        if (((SimpleNode)node.jjtGetChild(1)).jjtGetID() == 37) {
            if (arrayType instanceof ClassType) {
                Identifier fvmc = new Identifier(false, (ReferenceType)arrayType, "<init>");
                return node.jjtGetChild(1).jjtAccept(this, fvmc);
            }
            Assert.assertNotAssignable(arrayType, InterfaceType.class, node, "instantiateInterface", arrayType.name());
        }
        return node.jjtGetChild(1).jjtAccept(this, arrayType);
    }

    private Object visitPrimitiveType(SimpleNode node, Object data) {
        Token token = (Token)node.getAttribute("token");
        switch (token.kind) {
            case 20: {
                return this.vm.mirrorOf(true).type();
            }
            case 25: {
                return this.vm.mirrorOf('a').type();
            }
            case 22: {
                return this.vm.mirrorOf((byte)0).type();
            }
            case 56: {
                return this.vm.mirrorOf((short)0).type();
            }
            case 45: {
                return this.vm.mirrorOf(0).type();
            }
            case 47: {
                return this.vm.mirrorOf(0L).type();
            }
            case 38: {
                return this.vm.mirrorOf(1.0f).type();
            }
            case 31: {
                return this.vm.mirrorOf(1.0).type();
            }
        }
        throw new RuntimeException("Unknown primitive type: " + token.image);
    }

    private Object visitCastExpression(SimpleNode node, Object data) {
        Object value = node.jjtGetChild(1).jjtAccept(this, data);
        if (value == null) {
            return null;
        }
        Type castType = (Type)node.jjtGetChild(0).jjtAccept(this, data);
        if (value instanceof PrimitiveValue) {
            PrimitiveValue primValue = (PrimitiveValue)value;
            if (primValue instanceof BooleanValue) {
                Assert.assertAssignable(castType, BooleanType.class, node, "castToBooleanRequired", primValue, castType);
                return primValue;
            }
            Assert.assertNotAssignable(castType, BooleanType.class, node, "castFromBooleanRequired", primValue, castType);
            if (castType instanceof ByteType) {
                return this.vm.mirrorOf(primValue.byteValue());
            }
            if (castType instanceof CharType) {
                return this.vm.mirrorOf(primValue.charValue());
            }
            if (castType instanceof DoubleType) {
                return this.vm.mirrorOf(primValue.doubleValue());
            }
            if (castType instanceof FloatType) {
                return this.vm.mirrorOf(primValue.floatValue());
            }
            if (castType instanceof IntegerType) {
                return this.vm.mirrorOf(primValue.intValue());
            }
            if (castType instanceof LongType) {
                return this.vm.mirrorOf(primValue.longValue());
            }
            return this.vm.mirrorOf(primValue.shortValue());
        }
        ObjectReference valueType = (ObjectReference)value;
        if (!this.instanceOf(valueType.type(), castType)) {
            Assert.error(node, "castError", valueType.type(), castType);
        }
        return value;
    }

    private Object visitPostfixExpression(SimpleNode node, Object data) {
        Object value = node.jjtGetChild(0).jjtAccept(this, data);
        Assert.assertAssignable(value, PrimitiveValue.class, node, "badOperandForPostfixOperator", value);
        Assert.assertNotAssignable(value, BooleanValue.class, node, "badOperandForPostfixOperator", value);
        Token operator = (Token)node.getAttribute("operator");
        try {
            return this.operators.evaluate(operator, (PrimitiveValue)value);
        }
        catch (IllegalArgumentException e) {
            return Assert.error(node, "postfixOperatorEvaluationError", operator, e);
        }
    }

    private Object visitPrefixExpression(SimpleNode node, Object data) {
        Object value = node.jjtGetChild(0).jjtAccept(this, data);
        Assert.assertAssignable(value, PrimitiveValue.class, node, "badOperandForPrefixOperator", value);
        Assert.assertNotAssignable(value, BooleanValue.class, node, "badOperandForPrefixOperator", value);
        Token operator = (Token)node.getAttribute("operator");
        try {
            return this.operators.evaluate(operator, (PrimitiveValue)value);
        }
        catch (IllegalArgumentException e) {
            return Assert.error(node, "prefixOperatorEvaluationError", operator, e);
        }
    }

    private Object visitUnaryExpression(SimpleNode node, Object data) {
        Object value = node.jjtGetChild(0).jjtAccept(this, data);
        Assert.assertAssignable(value, PrimitiveValue.class, node, "badOperandForUnaryOperator", value);
        Token operator = (Token)node.getAttribute("operator");
        try {
            return this.operators.evaluate(operator, (PrimitiveValue)value);
        }
        catch (IllegalArgumentException e) {
            return Assert.error(node, "unaryOperatorEvaluationError", operator, e);
        }
    }

    private Object visitIdentifier(SimpleNode node, Object data) {
        return ((Token)node.getAttribute((String)"token")).image;
    }

    private Object visitClassOrInterfaceType(SimpleNode node, Object data) {
        StringBuffer fullName = new StringBuffer();
        int n = node.jjtGetNumChildren();
        for (int i = 0; i < n; ++i) {
            SimpleNode nextNode;
            String namePart = (String)node.jjtGetChild(i).jjtAccept(this, data);
            fullName.append('.');
            fullName.append(namePart);
            if (i >= n - 1 || (nextNode = (SimpleNode)node.jjtGetChild(i + 1)).jjtGetID() != 6) continue;
            ++i;
        }
        String name = fullName.substring(1);
        try {
            return this.resolveType(name);
        }
        catch (IncompatibleThreadStateException e) {
            return Assert.error(node, "internalErrorResolvingType", name);
        }
    }

    private ReferenceType resolveType(String name) throws IncompatibleThreadStateException {
        String innerName;
        ReferenceType type;
        if (name.charAt(0) == '[') {
            type = this.getClass(name);
            if (type != null) {
                return type;
            }
            Assert.error(this.currentNode, "unknownType", name);
        }
        if ((type = this.getClass(innerName = this.frame.location().declaringType().name() + "$" + name)) != null) {
            return type;
        }
        int idx = name.lastIndexOf(46);
        if (idx == -1 ? (type = this.getClass(this.currentPackage + name)) != null : (type = this.getClass(name)) != null) {
            return type;
        }
        if (idx != -1) {
            innerName = name.substring(0, idx) + "$" + name.substring(idx + 1);
            if (innerName.indexOf(46) == -1) {
                innerName = this.currentPackage + innerName;
            }
            if ((type = this.getClass(innerName)) != null) {
                return type;
            }
        }
        List imports = this.evaluationContext.getImports();
        Iterator i = imports.iterator();
        while (i.hasNext()) {
            String fullName;
            int ix;
            String importStatement = (String)i.next();
            String qualifier = importStatement.substring((ix = importStatement.lastIndexOf(46)) + 1);
            if (!qualifier.equals("*") && !qualifier.equals(name) || (type = this.getClass(fullName = importStatement.substring(0, ix + 1) + name)) == null) continue;
            return type;
        }
        Assert.error(this.currentNode, "unknownType", name);
        return null;
    }

    private ReferenceType getClass(String typeName) throws IncompatibleThreadStateException {
        List<ReferenceType> classes = this.vm.classesByName(typeName);
        if (classes.size() != 0) {
            return classes.get(0);
        }
        return null;
    }

    private Object visitReferenceType(SimpleNode node, Object data) {
        Type baseType = (Type)node.jjtGetChild(0).jjtAccept(this, data);
        int dimensions = (Integer)node.getAttribute("arrayCount");
        if (dimensions > 0) {
            try {
                return this.resolveType(this.brackets(dimensions) + baseType.signature().replace('/', '.'));
            }
            catch (IncompatibleThreadStateException e) {
                Assert.error(node, "internalError");
            }
        }
        return baseType;
    }

    private Object visitInstanceOfExpression(SimpleNode node, Object data) {
        Object leftOper = node.jjtGetChild(0).jjtAccept(this, data);
        if (leftOper == null) {
            return this.vm.mirrorOf(false);
        }
        Assert.assertAssignable(leftOper, ObjectReference.class, node, "instanceOfLeftOperandNotAReference", leftOper);
        ReferenceType left = ((ObjectReference)leftOper).referenceType();
        ReferenceType right = (ReferenceType)node.jjtGetChild(1).jjtAccept(this, data);
        return this.vm.mirrorOf(this.instanceOf(left, right));
    }

    private boolean instanceOf(Type left, Type right) {
        if (left == null) {
            return false;
        }
        if (left.equals(right)) {
            return true;
        }
        if (right instanceof ArrayType) {
            Type rightType;
            Type leftType;
            if (!(left instanceof ArrayType)) {
                return false;
            }
            ArrayType leftArray = (ArrayType)left;
            ArrayType rightArray = (ArrayType)right;
            try {
                leftType = leftArray.componentType();
                rightType = rightArray.componentType();
            }
            catch (ClassNotLoadedException e) {
                return false;
            }
            return this.instanceOf(leftType, rightType);
        }
        if (left instanceof ClassType) {
            ClassType classLeft = (ClassType)left;
            if (right instanceof InterfaceType) {
                List<InterfaceType> ifaces = classLeft.allInterfaces();
                Iterator<InterfaceType> i = ifaces.iterator();
                while (i.hasNext()) {
                    InterfaceType type = i.next();
                    if (!type.equals(right)) continue;
                    return true;
                }
                return false;
            }
            do {
                if ((classLeft = classLeft.superclass()) != null) continue;
                return false;
            } while (!classLeft.equals(right));
            return true;
        }
        return false;
    }

    private Object visitConditionalOrAndExpression(SimpleNode node, Object data) {
        Token operator = (Token)node.getAttribute("operator");
        int n = node.jjtGetNumChildren();
        for (int i = 0; i < n; ++i) {
            Object value = node.jjtGetChild(i).jjtAccept(this, data);
            Assert.assertAssignable(value, class$com$sun$jdi$BooleanValue == null ? Evaluator.class$("com.sun.jdi.BooleanValue") : class$com$sun$jdi$BooleanValue, node, "conditionalOrAndBooleanOperandRequired", value);
            boolean val = ((BooleanValue)value).booleanValue();
            if ((operator.kind != 103 || !val) && (operator.kind != 104 || val)) continue;
            return value;
        }
        return this.vm.mirrorOf(operator.kind == 104);
    }

    private Object visitConditionalExpression(SimpleNode node, Object data) {
        Object condition = node.jjtGetChild(0).jjtAccept(this, data);
        Assert.assertAssignable(condition, BooleanValue.class, node, "conditionalQuestionMarkBooleanOperandRequired", condition);
        boolean val = ((BooleanValue)condition).booleanValue();
        if (val) {
            return node.jjtGetChild(1).jjtAccept(this, data);
        }
        return node.jjtGetChild(2).jjtAccept(this, data);
    }

    private Object visitBooleanLiteral(SimpleNode node, Object data) {
        Token token = (Token)node.getAttribute("token");
        return this.vm.mirrorOf(token.kind == 66);
    }

    private Object visitName(SimpleNode node, Object data) {
        Object[] tokens = node.getAttributes("token");
        StringBuffer name = new StringBuffer();
        for (int i = 0; i < tokens.length; ++i) {
            name.append('.');
            name.append(tokens[i]);
        }
        return name.substring(1);
    }

    private Object visitPrimaryPrefix(SimpleNode node, Object data) {
        if (node.jjtGetNumChildren() == 0) {
            ObjectReference thisObject = this.frame.thisObject();
            if (thisObject == null) {
                Assert.error(node, "thisObjectUnavailable");
            }
            if (node.getAttribute("this") != null) {
                return thisObject;
            }
            String qualifier = (String)node.getAttribute("qualifier");
            String identifier = (String)node.getAttribute("identifier");
            return new Identifier(thisObject, identifier, qualifier);
        }
        SimpleNode first = (SimpleNode)node.jjtGetChild(0);
        switch (first.jjtGetID()) {
            case 34: {
                return this.visit(first, data);
            }
            case 11: {
                return this.visit(first, data);
            }
            case 9: {
                String identifier = (String)this.visit(first, data);
                if (identifier.indexOf(46) == -1) {
                    return new Identifier(true, this.frame.thisObject(), this.frame.location().declaringType(), identifier);
                }
                int idx = identifier.indexOf(46);
                String name = identifier.substring(0, idx);
                ObjectReference member = null;
                try {
                    Value variable = this.evaluateVariable(new Identifier(true, this.frame.thisObject(), this.frame.location().declaringType(), name));
                    Assert.assertAssignable(variable, ObjectReference.class, node, "objectReferenceRequiredOnDereference", variable);
                    member = (ObjectReference)variable;
                }
                catch (EvaluationException e) {
                    // empty catch block
                }
                ReferenceType type = null;
                if (member == null) {
                    while (true) {
                        try {
                            type = this.resolveType(name);
                            break;
                        }
                        catch (EvaluationException e) {
                        }
                        catch (IncompatibleThreadStateException e) {
                            Assert.error(node, "internalError");
                        }
                        idx = identifier.indexOf(46, idx + 1);
                        if (idx == -1) break;
                        name = identifier.substring(0, idx);
                    }
                    if (type == null) {
                        Assert.error(node, "unknownType", identifier);
                    }
                }
                while (true) {
                    int idx2;
                    int idx22 = idx2 = identifier.indexOf(46, idx + 1);
                    if (idx2 == -1) {
                        idx2 = identifier.length();
                    }
                    Identifier ident = member != null ? new Identifier(false, member, identifier.substring(idx + 1, idx2)) : new Identifier(false, type, identifier.substring(idx + 1, idx2));
                    if (idx22 == -1) {
                        return ident;
                    }
                    Value variable = this.evaluateVariable(ident);
                    Assert.assertAssignable(variable, class$com$sun$jdi$ObjectReference == null ? Evaluator.class$("com.sun.jdi.ObjectReference") : class$com$sun$jdi$ObjectReference, node, "objectReferenceRequiredOnDereference", variable);
                    member = (ObjectReference)variable;
                    idx = idx2;
                }
            }
            case 8: {
                Object type = first.jjtAccept(this, data);
                if (type instanceof ReferenceType) {
                    return ((ReferenceType)type).classObject();
                }
                return type;
            }
        }
        return first.jjtAccept(this, data);
    }

    private Object visitArgumentList(SimpleNode node, Object data) {
        int n = node.jjtGetNumChildren();
        Value[] argValues = new Value[n];
        for (int i = 0; i < n; ++i) {
            Object val = node.jjtGetChild(i).jjtAccept(this, data);
            if (val != null) {
                Assert.assertAssignable(val, class$com$sun$jdi$Value == null ? Evaluator.class$("com.sun.jdi.Value") : class$com$sun$jdi$Value, node, "badArgument", val);
            }
            argValues[i] = (Value)val;
        }
        return argValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private Object visitArguments(SimpleNode node, Object data) {
        Identifier ctx;
        block83: {
            MethodCall method;
            Assert.assertAssignable(data, Identifier.class, node, "argumentsBadSyntax", data);
            ctx = (Identifier)data;
            Value[] args = node.jjtGetNumChildren() > 0 ? (Value[])node.jjtGetChild(0).jjtAccept(this, null) : new Value[]{};
            try {
                method = this.getConcreteMethod(ctx, args);
            }
            catch (UnsupportedOperationException uoex) {
                return Assert.error(node, "calleeException", uoex, ctx);
            }
            if (method.instanceContext != null) {
                try {
                    if (verbose) {
                        throw new UnsupportedOperationException(NbBundle.getMessage((Class)Evaluator.class, (String)"CTL_UnsupportedOperationException"));
                    }
                    if (!this.evaluationContext.canInvokeMethods()) {
                        Object uoex = Assert.error(node, "calleeException", new UnsupportedOperationException(), ctx);
                        return uoex;
                    }
                    this.evaluationContext.methodToBeInvoked();
                    Value uoex = method.instanceContext.invokeMethod(this.frameThread, method.method, method.args, 3);
                    return uoex;
                }
                catch (InvalidTypeException e) {
                    Assert.error(node, "callException", e, ctx);
                }
                catch (ClassNotLoadedException e) {
                    Assert.error(node, "callException", e, ctx);
                }
                catch (IncompatibleThreadStateException e) {
                    Assert.error(node, "callException", e, ctx);
                }
                catch (InvocationException e) {
                    Assert.error(node, "calleeException", e, ctx);
                }
                catch (UnsupportedOperationException e) {
                    this.evaluationContext.setCanInvokeMethods(false);
                    Assert.error(node, "calleeException", e, ctx);
                }
                finally {
                    try {
                        this.frame = this.frameThread.frame(this.frameIndex);
                    }
                    catch (IncompatibleThreadStateException e) {
                        Assert.error(node, "callException", e, ctx);
                    }
                }
            }
            if (method.typeContext instanceof ClassType) {
                ClassType classContext = (ClassType)method.typeContext;
                try {
                    if (method.method.isConstructor()) {
                        if (verbose) {
                            throw new UnsupportedOperationException(NbBundle.getMessage((Class)Evaluator.class, (String)"CTL_UnsupportedOperationException"));
                        }
                        try {
                            ObjectReference e = classContext.newInstance(this.frameThread, method.method, method.args, 1);
                            return e;
                        }
                        catch (UnsupportedOperationException uoex) {
                            Object e = Assert.error(node, "calleeException", uoex, ctx);
                            try {
                                this.frame = this.frameThread.frame(this.frameIndex);
                            }
                            catch (IncompatibleThreadStateException e2) {
                                Assert.error(node, "callException", e2, ctx);
                            }
                            return e;
                        }
                    }
                    if (verbose) {
                        throw new UnsupportedOperationException(NbBundle.getMessage((Class)Evaluator.class, (String)"CTL_UnsupportedOperationException"));
                    }
                    if (!this.evaluationContext.canInvokeMethods()) {
                        Object uoex = Assert.error(node, "calleeException", new UnsupportedOperationException(), ctx);
                        return uoex;
                    }
                    this.evaluationContext.methodToBeInvoked();
                    Value uoex = classContext.invokeMethod(this.frameThread, method.method, method.args, 1);
                    return uoex;
                    {
                        catch (InvalidTypeException e) {
                            Assert.error(node, "callException", e, ctx);
                            break block83;
                        }
                        catch (ClassNotLoadedException e) {
                            Assert.error(node, "callException", e, ctx);
                            break block83;
                        }
                        catch (IncompatibleThreadStateException e) {
                            Assert.error(node, "callException", e, ctx);
                            break block83;
                        }
                        catch (InvocationException e) {
                            Assert.error(node, "calleeException", e, ctx);
                            break block83;
                        }
                        catch (IllegalArgumentException e) {
                            Assert.error(node, "callException", e, ctx);
                            break block83;
                        }
                        catch (UnsupportedOperationException e) {
                            this.evaluationContext.setCanInvokeMethods(false);
                            Assert.error(node, "calleeException", e, ctx);
                            break block83;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    try {
                        this.frame = this.frameThread.frame(this.frameIndex);
                    }
                    catch (IncompatibleThreadStateException e) {
                        Assert.error(node, "callException", e, ctx);
                    }
                }
            }
        }
        return Assert.error(node, "noSuchMethod", ctx);
    }

    private boolean isAccessible(TypeComponent member) {
        int idx2;
        if (member.isPublic()) {
            return true;
        }
        ReferenceType callerType = this.frame.location().declaringType();
        ReferenceType calleeType = member.declaringType();
        if (member.isPrivate()) {
            if (((Object)callerType).equals(calleeType)) {
                return true;
            }
            return this.isNested(calleeType, callerType) || this.isNested(callerType, calleeType);
        }
        String callerName = callerType.name();
        String calleeName = calleeType.name();
        int idx1 = callerName.lastIndexOf(46);
        if (idx1 * (idx2 = calleeName.lastIndexOf(46)) < 0) {
            return false;
        }
        if (idx1 + idx2 == -2) {
            return true;
        }
        if (callerName.substring(0, idx1).equals(calleeName.substring(0, idx2))) {
            return true;
        }
        if (member.isProtected()) {
            return this.instanceOf(callerType, calleeType);
        }
        return false;
    }

    private boolean isNested(ReferenceType outter, ReferenceType inner) {
        List<ReferenceType> nestedTypes = outter.nestedTypes();
        Iterator<ReferenceType> i = nestedTypes.iterator();
        while (i.hasNext()) {
            ReferenceType type = i.next();
            if (!((Object)type).equals(inner) && !this.isNested(type, inner)) continue;
            return true;
        }
        return false;
    }

    private MethodCall getConcreteMethod(Identifier ctx, Value[] args) {
        ReferenceType type = ctx.typeContext;
        ObjectReference object = ctx.instanceContext;
        if (ctx.superQualifier != null) {
            if (!(ctx.typeContext instanceof ClassType)) {
                Assert.error(this.currentNode, "superUsedOnNonClass", ctx);
            }
            if (ctx.superQualifier.length() > 0) {
                object = this.getEnclosingObject(ctx.instanceContext, ctx.superQualifier);
                Assert.assertNotNull(object, this.currentNode, "notEnclosingType", ctx);
            }
            ClassType cls = (ClassType)object.referenceType();
            type = cls.superclass();
        }
        if (ctx.typeContext == null) {
            Assert.error(this.currentNode, "methodCallOnNull", ctx.identifier);
        }
        List<Method> methods = type.methodsByName(ctx.identifier);
        ReferenceType origType = type;
        ObjectReference origObject = object;
        while (methods.size() == 0) {
            Field outerRef = type.fieldByName("this$0");
            if (outerRef == null) {
                type = origType;
                object = origObject;
                break;
            }
            object = (ObjectReference)object.getValue(outerRef);
            type = object.referenceType();
            methods = type.methodsByName(ctx.identifier);
        }
        if (ctx.localContext && methods.size() == 0) {
            Iterator i = this.staticImportsIterator(ctx.identifier);
            while (i.hasNext()) {
                String typeName = (String)i.next();
                try {
                    ReferenceType importedType = this.resolveType(typeName);
                    methods = importedType.methodsByName(ctx.identifier);
                    if (methods.size() <= 0) continue;
                    type = importedType;
                    object = null;
                    break;
                }
                catch (Exception e) {
                }
            }
        }
        ArrayList<MethodCall> possibleMethods = new ArrayList<MethodCall>();
        Iterator<Method> i = methods.iterator();
        while (i.hasNext()) {
            List newArgs;
            Method method = i.next();
            if (!this.isAccessible(method)) continue;
            List<Type> argTypes = null;
            try {
                argTypes = method.argumentTypes();
            }
            catch (ClassNotLoadedException e) {
                continue;
            }
            if (args.length == 0 && "<init>".equals(ctx.identifier) && argTypes.size() == 1 && this.frame.thisObject() != null && argTypes.get(0).equals(this.frame.location().declaringType())) {
                args = new Value[]{this.frame.thisObject()};
            }
            if ((newArgs = this.prepareArguments(args, argTypes)) == null) continue;
            possibleMethods.add(new MethodCall(type, object, method, newArgs));
        }
        Assert.assertNonEmpty(possibleMethods, this.currentNode, "noSuchMethod", ctx);
        MethodCall call = this.mostSpecific(possibleMethods, args);
        Assert.assertNotNull(call, this.currentNode, "ambigousMethod", ctx);
        return call;
    }

    private MethodCall mostSpecific(List possibleMethods, Value[] args) {
        if (possibleMethods.size() == 0) {
            return null;
        }
        if (possibleMethods.size() == 1) {
            return (MethodCall)possibleMethods.get(0);
        }
        MethodCall mostSpecific = null;
        int conversions = Integer.MAX_VALUE;
        Iterator i = possibleMethods.iterator();
        while (i.hasNext()) {
            MethodCall methodCall = (MethodCall)i.next();
            List<Type> methodArguments = null;
            try {
                methodArguments = methodCall.method.argumentTypes();
            }
            catch (ClassNotLoadedException e) {
                continue;
            }
            int cc = this.conversionsCount(methodArguments, args);
            if (cc == 0) {
                return methodCall;
            }
            if (cc == conversions) {
                return null;
            }
            if (cc >= conversions) continue;
            conversions = cc;
            mostSpecific = methodCall;
        }
        return mostSpecific;
    }

    private int conversionsCount(List argumentTypes, Value[] args) {
        int idx = 0;
        int cc = 0;
        Iterator i = argumentTypes.iterator();
        while (i.hasNext()) {
            Type argType = (Type)i.next();
            if (args[idx] != null && !this.representSameType(argType, args[idx].type())) {
                ++cc;
            }
            ++idx;
        }
        return cc;
    }

    private boolean representSameType(Type t1, Type t2) {
        String t2s;
        String t1s = t1.signature();
        if (t1s.equals(t2s = t2.signature())) {
            return true;
        }
        if (t1s.length() == 1 && t2s.length() == 1 || t1s.length() > 1 && t2s.length() > 1) {
            return false;
        }
        String primitiveType = t1s.length() == 1 ? t1s : t2s;
        String classType = t1s.length() > 1 ? t1s : t2s;
        return this.wrapperSignature(primitiveType.charAt(0)).equals(classType);
    }

    private List prepareArguments(Value[] args, List argTypes) {
        boolean ellipsis;
        try {
            ellipsis = argTypes.size() > 0 && argTypes.get(argTypes.size() - 1) instanceof ArrayType && (args.length == 0 || args[args.length - 1] == null || this.isConvertible(((ArrayType)argTypes.get(argTypes.size() - 1)).componentType(), args[args.length - 1]));
        }
        catch (ClassNotLoadedException e) {
            return null;
        }
        if (ellipsis ? args.length < argTypes.size() - 1 : args.length != argTypes.size()) {
            return null;
        }
        ArrayList<Value> newArgs = new ArrayList<Value>();
        int idx = 0;
        Iterator i = argTypes.iterator();
        while (i.hasNext()) {
            Type type = (Type)i.next();
            if (!ellipsis || i.hasNext()) {
                if (!this.isConvertible(type, args[idx])) {
                    return null;
                }
                newArgs.add(this.boxUnboxIfNeeded(args[idx], type));
            }
            ++idx;
        }
        if (ellipsis) {
            ArrayType elipsisType = (ArrayType)argTypes.get(argTypes.size() - 1);
            if (args.length != argTypes.size() - 1) {
                Type componentType = null;
                try {
                    componentType = elipsisType.componentType();
                }
                catch (ClassNotLoadedException e) {
                    return null;
                }
                if (args.length == argTypes.size()) {
                    if (args[args.length - 1] != null && !elipsisType.equals(args[args.length - 1].type()) && !this.isConvertible(componentType, args[args.length - 1])) {
                        return null;
                    }
                    newArgs.add(this.boxUnboxIfNeeded(args[args.length - 1], componentType));
                } else if (args.length > argTypes.size()) {
                    for (int i2 = argTypes.size() - 1; i2 < args.length; ++i2) {
                        if (!this.isConvertible(componentType, args[i2])) {
                            return null;
                        }
                        newArgs.add(this.boxUnboxIfNeeded(args[i2], componentType));
                    }
                }
            }
        }
        return newArgs;
    }

    private Value boxUnboxIfNeeded(Value value, Type type) {
        if (value instanceof ObjectReference && type instanceof PrimitiveType) {
            return this.unbox((ObjectReference)value, type);
        }
        if (value instanceof PrimitiveValue && type instanceof ClassType) {
            return this.box((PrimitiveValue)value, (ClassType)type);
        }
        return value;
    }

    private ObjectReference box(PrimitiveValue primitiveValue, ClassType type) {
        try {
            if (type instanceof Object) {
                type = this.wrapperType((PrimitiveType)primitiveValue.type());
            }
            return this.newInstance(type, new Value[]{primitiveValue});
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected exception while invoking boxing method", e);
        }
    }

    private ClassType wrapperType(PrimitiveType type) throws IncompatibleThreadStateException {
        char sig = type.signature().charAt(0);
        return (ClassType)this.resolveType(this.wrapperClassname(sig));
    }

    private String wrapperSignature(char primitiveSignature) {
        switch (primitiveSignature) {
            case 'Z': {
                return "Ljava/lang/Boolean;";
            }
            case 'B': {
                return "Ljava/lang/Byte;";
            }
            case 'C': {
                return "Ljava/lang/Character;";
            }
            case 'S': {
                return "Ljava/lang/Short;";
            }
            case 'I': {
                return "Ljava/lang/Integer;";
            }
            case 'J': {
                return "Ljava/lang/Long;";
            }
            case 'F': {
                return "Ljava/lang/Float;";
            }
            case 'D': {
                return "Ljava/lang/Double;";
            }
        }
        throw new RuntimeException();
    }

    private String wrapperClassname(char primitiveSignature) {
        switch (primitiveSignature) {
            case 'Z': {
                return "java.lang.Boolean";
            }
            case 'B': {
                return "java.lang.Byte";
            }
            case 'C': {
                return "java.lang.Character";
            }
            case 'S': {
                return "java.lang.Short";
            }
            case 'I': {
                return "java.lang.Integer";
            }
            case 'J': {
                return "java.lang.Long";
            }
            case 'F': {
                return "java.lang.Float";
            }
            case 'D': {
                return "java.lang.Double";
            }
        }
        throw new RuntimeException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ObjectReference newInstance(ClassType type, Value[] constructorArgs) throws InvocationException, ClassNotLoadedException, IncompatibleThreadStateException, InvalidTypeException {
        MethodCall method = this.getConcreteMethod(new Identifier(type, "<init>"), constructorArgs);
        try {
            ObjectReference objectReference = type.newInstance(this.frameThread, method.method, method.args, 1);
            return objectReference;
        }
        finally {
            this.frame = this.frameThread.frame(this.frameIndex);
        }
    }

    private PrimitiveValue unbox(ObjectReference val, Type type) {
        if (type instanceof BooleanType) {
            return this.invokeUnboxingMethod(val, "booleanValue");
        }
        if (type instanceof ByteType) {
            return this.invokeUnboxingMethod(val, "byteValue");
        }
        if (type instanceof CharType) {
            return this.invokeUnboxingMethod(val, "charValue");
        }
        if (type instanceof ShortType) {
            return this.invokeUnboxingMethod(val, "shortValue");
        }
        if (type instanceof IntegerType) {
            return this.invokeUnboxingMethod(val, "intValue");
        }
        if (type instanceof LongType) {
            return this.invokeUnboxingMethod(val, "longValue");
        }
        if (type instanceof FloatType) {
            return this.invokeUnboxingMethod(val, "floatValue");
        }
        if (type instanceof DoubleType) {
            return this.invokeUnboxingMethod(val, "doubleValue");
        }
        throw new RuntimeException("Invalid type while unboxing: " + type.signature());
    }

    private PrimitiveValue invokeUnboxingMethod(ObjectReference reference, String methodName) {
        Method toCall = reference.referenceType().methodsByName(methodName).get(0);
        try {
            if (verbose) {
                throw new UnsupportedOperationException(NbBundle.getMessage((Class)Evaluator.class, (String)"CTL_UnsupportedOperationException"));
            }
            if (!this.evaluationContext.canInvokeMethods()) {
                throw new UnsupportedOperationException();
            }
            this.evaluationContext.methodToBeInvoked();
            PrimitiveValue primitiveValue = (PrimitiveValue)reference.invokeMethod(this.frameThread, toCall, new ArrayList(0), 1);
            return primitiveValue;
        }
        catch (UnsupportedOperationException uoex) {
            this.evaluationContext.setCanInvokeMethods(false);
            throw new RuntimeException("Unexpected exception while invoking unboxing method", uoex);
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected exception while invoking unboxing method", e);
        }
        finally {
            try {
                this.frame = this.frameThread.frame(this.frameIndex);
            }
            catch (IncompatibleThreadStateException e) {
                throw new RuntimeException("Unexpected exception while invoking unboxing method", e);
            }
        }
    }

    private boolean isConvertible(Type wideType, Value value) {
        if (value == null) {
            return wideType instanceof ReferenceType;
        }
        String narrow = value.type().signature();
        String wide = wideType.signature();
        if (wide.equals(narrow)) {
            return true;
        }
        if (wide.length() == 1) {
            if (wide.equals("Z")) {
                return narrow.equals("Ljava/lang/Boolean;");
            }
            for (int i = 0; i < typeSignaturesSorted.length; ++i) {
                if (narrow.equals(typeSignaturesSorted[i])) {
                    return true;
                }
                if (!wide.equals(typeSignaturesSorted[i])) continue;
                return false;
            }
            return false;
        }
        if (wide.equals("Ljava/lang/Object;")) {
            return true;
        }
        if (narrow.length() == 1) {
            if (narrow.equals("Z")) {
                return wide.equals("Ljava/lang/Boolean;");
            }
            for (int i = 0; i < typeSignaturesSorted.length; ++i) {
                if (!narrow.equals(typeSignaturesSorted[i])) continue;
                for (int j = i - 1; j < typeSignaturesSorted.length; ++j) {
                    if (!wide.equals(typeSignaturesSorted[j])) continue;
                    return true;
                }
                return false;
            }
        }
        return this.instanceOf(value.type(), wideType);
    }

    private Object visitPrimarySuffix(SimpleNode node, Object data) {
        Token token = (Token)node.getAttribute("token");
        if (token == null) {
            return node.jjtGetChild(0).jjtAccept(this, data);
        }
        switch (token.kind) {
            case 79: {
                data = this.resolveVariable(data);
                Assert.assertAssignable(data, ObjectReference.class, node, "identifierNotAReference", data);
                return new Identifier(false, (ObjectReference)data, token.image);
            }
            case 86: {
                data = this.resolveVariable(data);
                Assert.assertAssignable(data, ArrayReference.class, node, "notarray", data, token);
                Object index = node.jjtGetChild(0).jjtAccept(this, data);
                Assert.assertAssignable(index, PrimitiveValue.class, node, "arrayIndexNAN", data, index);
                Assert.assertNotAssignable(index, BooleanValue.class, node, "arrayIndexNAN", data, index);
                int idx = ((PrimitiveValue)index).intValue();
                ArrayReference array = (ArrayReference)data;
                Assert.assertLess(idx, array.length(), node, "arrayIndexOutOfBounds", array, new Integer(idx));
                return array.getValue(idx);
            }
            case 59: 
            case 62: {
                Identifier ctx = (Identifier)data;
                if (!this.vm.canGetSyntheticAttribute()) {
                    Assert.error(node, "unknownType", ctx.identifier);
                }
                ObjectReference enclosingObject = this.getEnclosingObject(this.frame.thisObject(), ctx.identifier);
                Assert.assertNotNull(enclosingObject, node, "unknownType", ctx.identifier);
                return enclosingObject;
            }
        }
        return Assert.error(node, "internalError");
    }

    private ObjectReference getEnclosingObject(ObjectReference obj, String typeQualifier) {
        boolean done;
        block0: do {
            done = true;
            List<Field> fields = obj.referenceType().allFields();
            Iterator<Field> j = fields.iterator();
            while (j.hasNext()) {
                Field field = j.next();
                if (!field.isSynthetic() || !field.name().startsWith("this$")) continue;
                ClassType type = (ClassType)(obj = (ObjectReference)obj.getValue(field)).referenceType();
                if (type.name().endsWith(typeQualifier)) {
                    return obj;
                }
                done = false;
                continue block0;
            }
        } while (!done);
        return null;
    }

    private Value evaluateVariable(Identifier ctx) {
        ObjectReference or;
        Field helpField;
        Field field;
        if (ctx.localContext) {
            try {
                LocalVariable var = this.frame.visibleVariableByName(ctx.identifier);
                if (var != null) {
                    return this.frame.getValue(var);
                }
            }
            catch (AbsentInformationException e) {
                // empty catch block
            }
        }
        if (ctx.instanceContext != null) {
            field = ctx.typeContext.fieldByName(ctx.identifier);
            if (field != null) {
                return ctx.instanceContext.getValue(field);
            }
            if (ctx.instanceContext instanceof ArrayReference && ctx.identifier.equals("length")) {
                return this.vm.mirrorOf(((ArrayReference)ctx.instanceContext).length());
            }
        }
        field = ctx.typeContext.fieldByName(ctx.identifier);
        try {
            if (field != null) {
                return ctx.typeContext.getValue(field);
            }
        }
        catch (IllegalArgumentException e) {
            Assert.error(this.currentNode, "accessInstanceVariableFromStaticContext", ctx);
        }
        if (ctx.instanceContext != null && (field = ctx.typeContext.fieldByName("val$" + ctx.identifier)) != null) {
            return ctx.instanceContext.getValue(field);
        }
        if (ctx.instanceContext != null && (helpField = ctx.typeContext.fieldByName("this$0")) != null && (or = (ObjectReference)ctx.instanceContext.getValue(helpField)) != null && (field = or.referenceType().fieldByName(ctx.identifier)) != null) {
            return or.getValue(field);
        }
        Iterator i = this.staticImportsIterator(ctx.identifier);
        while (i.hasNext()) {
            String typeName = (String)i.next();
            try {
                ReferenceType type = this.resolveType(typeName);
                field = type.fieldByName(ctx.identifier);
                if (field == null) continue;
                return type.getValue(field);
            }
            catch (Exception e) {
            }
        }
        return (Value)Assert.error(this.currentNode, "unknownVariable", ctx);
    }

    private Iterator staticImportsIterator(String identifier) {
        return this.iterator(this.evaluationContext.getStaticImports(), identifier);
    }

    private Iterator iterator(List imports, String identifier) {
        ArrayList<String> filteredList = new ArrayList<String>();
        Iterator i = imports.iterator();
        while (i.hasNext()) {
            int idx;
            String statement = (String)i.next();
            String qualifier = statement.substring((idx = statement.lastIndexOf(46)) + 1);
            if (!qualifier.equals("*") && !qualifier.equals(identifier)) continue;
            filteredList.add(statement.substring(0, idx));
        }
        return filteredList.iterator();
    }

    private Value resolveVariable(Object data) {
        if (data == null || data instanceof Value) {
            return (Value)data;
        }
        Identifier name = (Identifier)data;
        return this.evaluateVariable(name);
    }

    private Object visitPrimaryExpression(SimpleNode node, Object data) {
        int n = node.jjtGetNumChildren();
        Object value = node.jjtGetChild(0).jjtAccept(this, data);
        for (int i = 1; i < n; ++i) {
            value = node.jjtGetChild(i).jjtAccept(this, value);
        }
        if (value instanceof Identifier) {
            Identifier ctx = (Identifier)value;
            return this.evaluateVariable(ctx);
        }
        return value;
    }

    private Object visitExpression(SimpleNode node, Object data) {
        int n = node.jjtGetNumChildren();
        if (n == 1) {
            return node.jjtGetChild(0).jjtAccept(this, data);
        }
        return node.jjtGetChild(2).jjtAccept(this, data);
    }

    private Object visitLiteral(SimpleNode node, Object data) {
        Token token = (Token)node.getAttribute("token");
        if (token == null) {
            return node.jjtGetChild(0).jjtAccept(this, data);
        }
        try {
            switch (token.kind) {
                case 71: {
                    String name = token.image.toLowerCase();
                    boolean isLong = name.endsWith("l");
                    if (isLong) {
                        name = name.substring(0, name.length() - 1);
                    }
                    long value = name.startsWith("0x") ? Long.parseLong(name.substring(2), 16) : (name.length() > 1 && name.charAt(0) == '0' ? Long.parseLong(name.substring(1), 8) : Long.parseLong(name));
                    if (isLong) {
                        return this.vm.mirrorOf(value);
                    }
                    if (value > Integer.MAX_VALUE || value < Integer.MIN_VALUE) {
                        Assert.error(node, "integerLiteralTooBig", name);
                    } else {
                        return this.vm.mirrorOf((int)value);
                    }
                }
                case 75: {
                    char spec = token.image.charAt(token.image.length() - 1);
                    if (spec == 'f' || spec == 'F') {
                        return this.vm.mirrorOf(Float.parseFloat(token.image));
                    }
                    return this.vm.mirrorOf(Double.parseDouble(token.image));
                }
                case 78: {
                    return this.vm.mirrorOf(this.resolveString(token.image.substring(1, token.image.length() - 1)));
                }
                case 77: {
                    return this.vm.mirrorOf(this.resolveString(token.image.substring(1, token.image.length() - 1)).charAt(0));
                }
            }
            return Assert.error(node, "unknownLiteralType", token.image);
        }
        catch (NumberFormatException e) {
            return Assert.error(node, "badFormatOfIntegerLiteral", token.image);
        }
    }

    private String resolveString(String input) {
        String result = "";
        for (int index = 0; index < input.length(); ++index) {
            char c;
            if (input.charAt(index) != '\\') {
                result = result + input.charAt(index);
                continue;
            }
            switch (input.charAt(++index)) {
                case 'b': {
                    c = '\b';
                    break;
                }
                case 't': {
                    c = '\t';
                    break;
                }
                case 'n': {
                    c = '\n';
                    break;
                }
                case 'f': {
                    c = '\f';
                    break;
                }
                case 'r': {
                    c = '\r';
                    break;
                }
                case '\"': {
                    c = '\"';
                    break;
                }
                case '\'': {
                    c = '\'';
                    break;
                }
                case '\\': {
                    c = '\\';
                    break;
                }
                default: {
                    c = '\u0000';
                    while (index < input.length() && input.charAt(index) >= '0' && input.charAt(index) <= '7' && c * 8 + input.charAt(index) - 48 < 256) {
                        c = (char)(c * 8 + (input.charAt(index) - 48));
                        ++index;
                    }
                    --index;
                }
            }
            result = result + c;
        }
        return result;
    }

    private Object visitBinaryExpression(SimpleNode node, Object data) {
        Object[] operators = node.getAttributes("operator");
        int n = node.jjtGetNumChildren();
        Value value = (Value)node.jjtGetChild(0).jjtAccept(this, data);
        for (int i = 1; i < n; ++i) {
            Value next = (Value)node.jjtGetChild(i).jjtAccept(this, data);
            try {
                value = this.operators.evaluate(value, (Token)operators[i - 1], next);
                continue;
            }
            catch (IllegalArgumentException e) {
                return Assert.error(node, "evaluateError", value, ((Token)operators[i - 1]).image, next);
            }
        }
        return value;
    }

    public static Value invokeVirtual(ObjectReference objectReference, Method method, ThreadReference evaluationThread, List args) throws InvalidExpressionException {
        try {
            Value value = objectReference.invokeMethod(evaluationThread, method, args, 1);
            return value;
        }
        catch (InvalidTypeException itex) {
            throw new InvalidExpressionException((Throwable)itex);
        }
        catch (ClassNotLoadedException cnlex) {
            throw new InvalidExpressionException((Throwable)cnlex);
        }
        catch (IncompatibleThreadStateException itsex) {
            InvalidExpressionException ieex = new InvalidExpressionException((Throwable)itsex);
            ieex.initCause((Throwable)itsex);
            throw ieex;
        }
        catch (InvocationException iex) {
            InvalidExpressionException ieex = new InvalidExpressionException((Throwable)iex);
            ieex.initCause((Throwable)iex);
            throw ieex;
        }
        catch (UnsupportedOperationException uoex) {
            InvalidExpressionException ieex = new InvalidExpressionException((Throwable)uoex);
            ieex.initCause((Throwable)uoex);
            throw ieex;
        }
    }

    private class MethodCall {
        ReferenceType typeContext;
        ObjectReference instanceContext;
        Method method;
        List args;

        public MethodCall(ReferenceType typeContext, ObjectReference instanceContext, Method method, List args) {
            this.typeContext = typeContext;
            this.instanceContext = instanceContext;
            this.method = method;
            this.args = args;
        }
    }
}

