/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.loader;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import javax.swing.JPanel;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.StyledDocument;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.db.api.sql.execute.SQLExecuteCookie;
import org.netbeans.modules.db.sql.execute.SQLExecuteHelper;
import org.netbeans.modules.db.sql.execute.SQLExecutionResults;
import org.netbeans.modules.db.sql.execute.ui.SQLResultPanel;
import org.netbeans.modules.db.sql.execute.ui.SQLResultPanelModel;
import org.netbeans.modules.db.sql.loader.SQLCloneableEditor;
import org.netbeans.modules.db.sql.loader.SQLDataObject;
import org.netbeans.modules.db.sql.loader.SQLExecutionLoggerImpl;
import org.openide.ErrorManager;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.EditCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.PrintCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.loaders.DataObject;
import org.openide.loaders.MultiDataObject;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditor;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.DataEditorSupport;
import org.openide.util.Cancellable;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.CloneableOpenSupport;

public class SQLEditorSupport
extends DataEditorSupport
implements OpenCookie,
EditCookie,
EditorCookie.Observable,
PrintCookie,
SQLExecuteCookie {
    private static final ErrorManager LOGGER = ErrorManager.getDefault().getInstance(SQLEditorSupport.class.getName());
    private static final boolean LOG = LOGGER.isLoggable(1);
    static final String EDITOR_CONTAINER = "sqlEditorContainer";
    private static final String MIME_TYPE = "text/x-sql";
    private final PropertyChangeSupport sqlPropChangeSupport = new PropertyChangeSupport(this);
    private final RequestProcessor rp = new RequestProcessor("SQLExecution", 1, true);
    private String encoding;
    private DatabaseConnection dbconn;
    private boolean executing;
    private SQLExecutionResults executionResults;
    private SQLExecutionLoggerImpl logger;
    private final SaveCookie saveCookie = new SaveCookie(){

        public void save() throws IOException {
            SQLEditorSupport.this.saveDocument();
        }
    };

    public SQLEditorSupport(SQLDataObject obj) {
        super((DataObject)obj, (CloneableEditorSupport.Env)new Environment(obj));
        this.setMIMEType(MIME_TYPE);
    }

    protected boolean notifyModified() {
        if (!super.notifyModified()) {
            return false;
        }
        if (!this.isConsole()) {
            FileObject fo = this.getDataObject().getPrimaryFile();
            SQLDataObject obj = (SQLDataObject)this.getDataObject();
            if (obj.getCookie(SaveCookie.class) == null) {
                obj.addCookie((Node.Cookie)this.saveCookie);
                obj.setModified(true);
            }
        }
        return true;
    }

    protected void notifyUnmodified() {
        super.notifyUnmodified();
        SQLDataObject obj = (SQLDataObject)this.getDataObject();
        Node.Cookie cookie = obj.getCookie(SaveCookie.class);
        if (cookie != null && cookie.equals(this.saveCookie)) {
            obj.removeCookie((Node.Cookie)this.saveCookie);
            obj.setModified(false);
        }
    }

    protected String messageToolTip() {
        if (this.isConsole()) {
            return this.getDataObject().getPrimaryFile().getName();
        }
        return super.messageToolTip();
    }

    protected String messageName() {
        if (!this.getDataObject().isValid()) {
            return "";
        }
        if (this.isConsole()) {
            return this.getDataObject().getName();
        }
        return super.messageName();
    }

    protected String messageHtmlName() {
        if (!this.getDataObject().isValid()) {
            return "";
        }
        if (this.isConsole()) {
            String name = this.getDataObject().getName();
            if (name != null && !name.startsWith("<html>")) {
                name = "<html>" + name;
            }
            return name;
        }
        return super.messageHtmlName();
    }

    protected void notifyClosed() {
        super.notifyClosed();
        this.closeExecutionResult();
        this.closeLogger();
        if (this.isConsole() && this.getDataObject().isValid()) {
            try {
                this.getDataObject().delete();
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
        }
    }

    protected boolean canClose() {
        if (this.isConsole()) {
            return true;
        }
        return super.canClose();
    }

    boolean isConsole() {
        try {
            return "nbfs".equals(this.getDataObject().getPrimaryFile().getURL().getProtocol());
        }
        catch (FileStateInvalidException e) {
            return false;
        }
    }

    protected CloneableEditor createCloneableEditor() {
        return new SQLCloneableEditor(this);
    }

    protected Component wrapEditorComponent(Component editor) {
        JPanel container = new JPanel(new BorderLayout());
        container.setName(EDITOR_CONTAINER);
        container.add(editor, "Center");
        return container;
    }

    void addSQLPropertyChangeListener(PropertyChangeListener listener) {
        this.sqlPropChangeSupport.addPropertyChangeListener(listener);
    }

    void removeSQLPropertyChangeListener(PropertyChangeListener listener) {
        this.sqlPropChangeSupport.removePropertyChangeListener(listener);
    }

    synchronized DatabaseConnection getDatabaseConnection() {
        return this.dbconn;
    }

    public synchronized void setDatabaseConnection(DatabaseConnection dbconn) {
        this.dbconn = dbconn;
        this.sqlPropChangeSupport.firePropertyChange("databaseConnection", null, null);
    }

    public void execute() {
        StyledDocument doc = this.getDocument();
        if (doc == null) {
            return;
        }
        String sql = null;
        try {
            sql = doc.getText(0, doc.getLength());
        }
        catch (BadLocationException e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
            sql = "";
        }
        this.execute(sql, 0, sql.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void execute(String sql, int startOffset, int endOffset) {
        DatabaseConnection dbconn;
        SQLEditorSupport sQLEditorSupport = this;
        synchronized (sQLEditorSupport) {
            dbconn = this.dbconn;
        }
        if (dbconn == null) {
            return;
        }
        SQLExecutor executor = new SQLExecutor(this, dbconn, sql, startOffset, endOffset);
        RequestProcessor.Task task = this.rp.create((Runnable)executor);
        executor.setTask(task);
        task.schedule(0);
    }

    synchronized boolean isExecuting() {
        return this.executing;
    }

    private synchronized void setExecuting(boolean executing) {
        this.executing = executing;
        this.sqlPropChangeSupport.firePropertyChange("executing", null, null);
    }

    private void setResultModelToEditors(final SQLResultPanelModel model) {
        Mutex.EVENT.writeAccess(new Runnable(){

            public void run() {
                Enumeration editors = SQLEditorSupport.this.allEditors.getComponents();
                while (editors.hasMoreElements()) {
                    SQLResultPanel resultComponent;
                    SQLCloneableEditor editor = (SQLCloneableEditor)((Object)editors.nextElement());
                    if (model == null && !editor.hasResultComponent() || (resultComponent = editor.getResultComponent()) == null) continue;
                    resultComponent.setModel(model);
                }
            }
        });
    }

    private void setExecutionResults(SQLExecutionResults executionResults) {
        this.executionResults = executionResults;
    }

    private void closeExecutionResult() {
        this.setResultModelToEditors(null);
        Runnable run = new Runnable(){

            public void run() {
                if (SQLEditorSupport.this.executionResults != null) {
                    SQLEditorSupport.this.executionResults.close();
                    SQLEditorSupport.this.executionResults = null;
                }
            }
        };
        if (this.rp.isRequestProcessorThread()) {
            run.run();
        } else {
            this.rp.post(run);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SQLExecutionLoggerImpl createLogger() {
        this.closeLogger();
        String loggerDisplayName = null;
        loggerDisplayName = this.isConsole() ? this.getDataObject().getName() : this.getDataObject().getNodeDelegate().getDisplayName();
        SQLEditorSupport sQLEditorSupport = this;
        synchronized (sQLEditorSupport) {
            this.logger = new SQLExecutionLoggerImpl(loggerDisplayName, (LineCookie)this);
        }
        return this.logger;
    }

    private synchronized void closeLogger() {
        if (this.logger != null) {
            this.logger.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadFromStreamToKit(StyledDocument doc, InputStream stream, EditorKit kit) throws IOException, BadLocationException {
        this.encoding = SQLEditorSupport.getEncoding(stream);
        if (LOG) {
            LOGGER.log(1, "Encoding: " + this.encoding);
        }
        if (this.encoding != null) {
            InputStreamReader reader = new InputStreamReader(stream, this.encoding);
            try {
                kit.read(reader, (Document)doc, 0);
            }
            finally {
                stream.close();
            }
        } else {
            super.loadFromStreamToKit(doc, stream, kit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveFromKitToStream(StyledDocument doc, EditorKit kit, OutputStream stream) throws IOException, BadLocationException {
        if (this.encoding != null) {
            if ("utf-8".equals(this.encoding)) {
                stream.write(239);
                stream.write(187);
                stream.write(191);
            }
            OutputStreamWriter writer = new OutputStreamWriter(stream, this.encoding);
            try {
                kit.write(writer, (Document)doc, 0, doc.getLength());
            }
            finally {
                writer.close();
            }
        } else {
            super.saveFromKitToStream(doc, kit, stream);
        }
    }

    private static String getEncoding(InputStream stream) throws IOException {
        boolean isUTF8;
        if (!stream.markSupported()) {
            return null;
        }
        stream.mark(3);
        boolean bl = isUTF8 = stream.read() == 239 && stream.read() == 187 && stream.read() == 191;
        if (isUTF8) {
            return "utf-8";
        }
        stream.reset();
        return null;
    }

    static final class Environment
    extends DataEditorSupport.Env {
        public static final long serialVersionUID = 7968926994844480435L;
        private transient boolean modified = false;
        private transient FileLock fileLock;

        public Environment(SQLDataObject obj) {
            super((DataObject)obj);
        }

        protected FileObject getFile() {
            return this.getDataObject().getPrimaryFile();
        }

        protected FileLock takeLock() throws IOException {
            MultiDataObject obj = (MultiDataObject)this.getDataObject();
            this.fileLock = obj.getPrimaryEntry().takeLock();
            return this.fileLock;
        }

        public void markModified() throws IOException {
            if (this.findSQLEditorSupport().isConsole()) {
                this.modified = true;
            } else {
                super.markModified();
            }
        }

        public void unmarkModified() {
            if (this.findSQLEditorSupport().isConsole()) {
                this.modified = false;
                if (this.fileLock != null && this.fileLock.isValid()) {
                    this.fileLock.releaseLock();
                }
            } else {
                super.unmarkModified();
            }
        }

        public boolean isModified() {
            if (this.findSQLEditorSupport().isConsole()) {
                return this.modified;
            }
            return super.isModified();
        }

        public CloneableOpenSupport findCloneableOpenSupport() {
            return this.findSQLEditorSupport();
        }

        private SQLEditorSupport findSQLEditorSupport() {
            return (SQLEditorSupport)this.getDataObject().getCookie(class$org$netbeans$modules$db$sql$loader$SQLEditorSupport == null ? (class$org$netbeans$modules$db$sql$loader$SQLEditorSupport = SQLEditorSupport.class$("org.netbeans.modules.db.sql.loader.SQLEditorSupport")) : class$org$netbeans$modules$db$sql$loader$SQLEditorSupport);
        }
    }

    private static final class SQLExecutor
    implements Runnable,
    Cancellable {
        private final SQLEditorSupport parent;
        private final DatabaseConnection dbconn;
        private final String sql;
        private final int startOffset;
        private final int endOffset;
        private RequestProcessor.Task task;
        static final /* synthetic */ boolean $assertionsDisabled;

        public SQLExecutor(SQLEditorSupport parent, DatabaseConnection dbconn, String sql, int startOffset, int endOffset) {
            if (!$assertionsDisabled && parent == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && dbconn == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && sql == null) {
                throw new AssertionError();
            }
            this.parent = parent;
            this.dbconn = dbconn;
            this.sql = sql;
            this.startOffset = startOffset;
            this.endOffset = endOffset;
        }

        public void setTask(RequestProcessor.Task task) {
            this.task = task;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (!$assertionsDisabled && this.task == null) {
                throw new AssertionError((Object)"Should have called setTask()");
            }
            this.parent.setExecuting(true);
            try {
                if (LOG) {
                    LOGGER.log("Started the SQL execution task");
                    LOGGER.log(1, "Executing against " + this.dbconn);
                }
                Mutex.EVENT.readAccess(new Mutex.Action(){

                    public Object run() {
                        ConnectionManager.getDefault().showConnectionDialog(SQLExecutor.this.dbconn);
                        return null;
                    }
                });
                Connection conn = this.dbconn.getJDBCConnection();
                if (LOG) {
                    LOGGER.log(1, "SQL connection: " + conn);
                }
                if (conn == null) {
                    return;
                }
                try {
                    Mutex.EVENT.readAccess(new Mutex.ExceptionAction(){

                        public Object run() throws Exception {
                            SQLExecutor.this.parent.saveDocument();
                            return null;
                        }
                    });
                }
                catch (MutexException e) {
                    ErrorManager.getDefault().notify((Throwable)e.getException());
                    this.parent.setExecuting(false);
                    return;
                }
                ProgressHandle handle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage((Class)(class$org$netbeans$modules$db$sql$loader$SQLEditorSupport == null ? (class$org$netbeans$modules$db$sql$loader$SQLEditorSupport = SQLEditorSupport.class$("org.netbeans.modules.db.sql.loader.SQLEditorSupport")) : class$org$netbeans$modules$db$sql$loader$SQLEditorSupport), (String)"LBL_ExecutingStatements"), (Cancellable)this);
                handle.start();
                try {
                    handle.switchToIndeterminate();
                    this.setStatusText("");
                    if (LOG) {
                        LOGGER.log(1, "Closing the old execution result");
                    }
                    this.parent.closeExecutionResult();
                    SQLExecutionLoggerImpl logger = this.parent.createLogger();
                    SQLExecutionResults executionResults = SQLExecuteHelper.execute(this.sql, this.startOffset, this.endOffset, conn, handle, logger);
                    this.handleExecutionResults(executionResults, logger);
                }
                finally {
                    handle.finish();
                }
            }
            finally {
                this.parent.setExecuting(false);
            }
        }

        private void handleExecutionResults(SQLExecutionResults executionResults, SQLExecutionLoggerImpl logger) {
            SQLResultPanelModel model;
            if (executionResults == null) {
                this.setStatusText(NbBundle.getMessage((Class)(class$org$netbeans$modules$db$sql$loader$SQLEditorSupport == null ? (class$org$netbeans$modules$db$sql$loader$SQLEditorSupport = SQLEditorSupport.class$("org.netbeans.modules.db.sql.loader.SQLEditorSupport")) : class$org$netbeans$modules$db$sql$loader$SQLEditorSupport), (String)"LBL_ExecutionCancelled"));
                return;
            }
            this.parent.setExecutionResults(executionResults);
            if (executionResults.hasExceptions()) {
                this.setStatusText(NbBundle.getMessage((Class)(class$org$netbeans$modules$db$sql$loader$SQLEditorSupport == null ? (class$org$netbeans$modules$db$sql$loader$SQLEditorSupport = SQLEditorSupport.class$("org.netbeans.modules.db.sql.loader.SQLEditorSupport")) : class$org$netbeans$modules$db$sql$loader$SQLEditorSupport), (String)"LBL_ExecutionFinishedWithErrors"));
                return;
            }
            if (executionResults.size() <= 0) {
                this.setStatusText(NbBundle.getMessage((Class)(class$org$netbeans$modules$db$sql$loader$SQLEditorSupport == null ? (class$org$netbeans$modules$db$sql$loader$SQLEditorSupport = SQLEditorSupport.class$("org.netbeans.modules.db.sql.loader.SQLEditorSupport")) : class$org$netbeans$modules$db$sql$loader$SQLEditorSupport), (String)"LBL_ExecutedSuccessfully"));
                return;
            }
            try {
                model = SQLResultPanelModel.create(executionResults);
            }
            catch (SQLException e) {
                logger.logResultSetException(e);
                this.setStatusText(NbBundle.getMessage((Class)(class$org$netbeans$modules$db$sql$loader$SQLEditorSupport == null ? (class$org$netbeans$modules$db$sql$loader$SQLEditorSupport = SQLEditorSupport.class$("org.netbeans.modules.db.sql.loader.SQLEditorSupport")) : class$org$netbeans$modules$db$sql$loader$SQLEditorSupport), (String)"LBL_ResultSetError"));
                return;
            }
            catch (IOException e) {
                logger.logResultSetException(e);
                this.setStatusText(NbBundle.getMessage((Class)(class$org$netbeans$modules$db$sql$loader$SQLEditorSupport == null ? (class$org$netbeans$modules$db$sql$loader$SQLEditorSupport = SQLEditorSupport.class$("org.netbeans.modules.db.sql.loader.SQLEditorSupport")) : class$org$netbeans$modules$db$sql$loader$SQLEditorSupport), (String)"LBL_ResultSetError"));
                return;
            }
            if (model == null) {
                this.setStatusText(NbBundle.getMessage((Class)(class$org$netbeans$modules$db$sql$loader$SQLEditorSupport == null ? (class$org$netbeans$modules$db$sql$loader$SQLEditorSupport = SQLEditorSupport.class$("org.netbeans.modules.db.sql.loader.SQLEditorSupport")) : class$org$netbeans$modules$db$sql$loader$SQLEditorSupport), (String)"LBL_ExecutionCancelled"));
                return;
            }
            if (!model.isEmpty()) {
                this.parent.setResultModelToEditors(model);
            }
            this.setStatusText(NbBundle.getMessage((Class)(class$org$netbeans$modules$db$sql$loader$SQLEditorSupport == null ? (class$org$netbeans$modules$db$sql$loader$SQLEditorSupport = SQLEditorSupport.class$("org.netbeans.modules.db.sql.loader.SQLEditorSupport")) : class$org$netbeans$modules$db$sql$loader$SQLEditorSupport), (String)"LBL_ExecutedSuccessfully"));
        }

        private void setStatusText(String statusText) {
            StatusDisplayer.getDefault().setStatusText(statusText);
        }

        public boolean cancel() {
            return this.task.cancel();
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$modules$db$sql$loader$SQLEditorSupport == null ? (class$org$netbeans$modules$db$sql$loader$SQLEditorSupport = SQLEditorSupport.class$("org.netbeans.modules.db.sql.loader.SQLEditorSupport")) : class$org$netbeans$modules$db$sql$loader$SQLEditorSupport).desiredAssertionStatus();
        }
    }
}

