/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.jsploader;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import javax.swing.JEditorPane;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.java.JavaDataObject;
import org.netbeans.modules.web.core.jsploader.JspDataObject;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.MultiFileLoader;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.text.Line;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Task;

public class JspServletDataObject
extends JavaDataObject {
    public static final String EA_ORIGIN_JSP_PAGE = "NetBeansAttrOriginJspPage";
    private transient ServletEditorCookie servletEditor;

    public JspServletDataObject(FileObject pf, MultiFileLoader loader) throws DataObjectExistsException {
        super(pf, loader);
        this.init();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.init();
    }

    public CookieSet getCookieSet0() {
        return this.getCookieSet();
    }

    public Node.Cookie getCookie(Class c) {
        if (c.isAssignableFrom(ServletEditorCookie.class)) {
            EditorCookie ed;
            if (this.servletEditor == null && (ed = (EditorCookie)super.getCookie(EditorCookie.class)) != null) {
                this.servletEditor = new ServletEditorCookie(ed, this);
            }
            if (this.servletEditor != null) {
                return this.servletEditor;
            }
        }
        return super.getCookie(c);
    }

    private void init() {
    }

    public String getName() {
        String fileIndex;
        DataObject jsp = this.getSourceJspPage();
        if (jsp == null) {
            return super.getName();
        }
        int markIndex = this.getPrimaryFile().getName().lastIndexOf("_jsp");
        String string = fileIndex = markIndex == -1 ? "" : this.getPrimaryFile().getName().substring(markIndex + "_jsp".length());
        if (fileIndex.startsWith("_")) {
            fileIndex = fileIndex.substring(1);
        }
        if ("".equals(fileIndex)) {
            return NbBundle.getMessage(JspServletDataObject.class, (String)"LBL_ServletDisplayNameNoNumber", (Object)jsp.getPrimaryFile().getName());
        }
        return NbBundle.getMessage(JspServletDataObject.class, (String)"LBL_ServletDisplayName", (Object[])new Object[]{fileIndex, jsp.getPrimaryFile().getName()});
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public void setSourceJspPage(DataObject jspPage) throws IOException {
        JspServletDataObject.setSourceJspPage(this.getPrimaryFile(), jspPage);
        this.firePropertyChange("cookie", null, null);
    }

    public static void setSourceJspPage(FileObject generatedServlet, DataObject jspPage) throws IOException {
        generatedServlet.setAttribute(EA_ORIGIN_JSP_PAGE, (Object)jspPage.getPrimaryFile());
    }

    public DataObject getSourceJspPage() {
        Object obj = this.getPrimaryFile().getAttribute(EA_ORIGIN_JSP_PAGE);
        if (obj instanceof DataObject) {
            return (DataObject)obj;
        }
        if (obj instanceof FileObject && ((FileObject)obj).isValid()) {
            try {
                return DataObject.find((FileObject)((FileObject)obj));
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    private static class ServletEditorCookie
    implements EditorCookie.Observable,
    PropertyChangeListener {
        private EditorCookie original;
        private JspServletDataObject servlet;
        private EditorCookie currentEditor;
        private PropertyChangeSupport pcs;

        public ServletEditorCookie(EditorCookie original, JspServletDataObject servlet) {
            this.original = original;
            this.servlet = servlet;
            this.pcs = new PropertyChangeSupport(this);
        }

        private EditorCookie currentEditorCookie() {
            EditorCookie newCurrent = this.computeCurrentEditorCookie();
            if (this.currentEditor != newCurrent) {
                if (this.currentEditor != null && this.currentEditor instanceof EditorCookie.Observable) {
                    ((EditorCookie.Observable)this.currentEditor).removePropertyChangeListener((PropertyChangeListener)this);
                }
                if (newCurrent != null && newCurrent instanceof EditorCookie.Observable) {
                    ((EditorCookie.Observable)newCurrent).addPropertyChangeListener((PropertyChangeListener)this);
                }
                this.currentEditor = newCurrent;
            }
            return this.currentEditor;
        }

        private EditorCookie computeCurrentEditorCookie() {
            EditorCookie newCookie;
            DataObject jsp = this.servlet.getSourceJspPage();
            if (jsp != null && jsp instanceof JspDataObject && ((JspDataObject)jsp).getServletDataObject() == this.servlet && (newCookie = ((JspDataObject)jsp).getServletEditor()) != null) {
                return newCookie;
            }
            return this.original;
        }

        public Line.Set getLineSet() {
            return this.currentEditorCookie().getLineSet();
        }

        public void open() {
            this.currentEditorCookie().open();
        }

        public boolean close() {
            return this.currentEditorCookie().close();
        }

        public Task prepareDocument() {
            return this.currentEditorCookie().prepareDocument();
        }

        public StyledDocument openDocument() throws IOException {
            return this.currentEditorCookie().openDocument();
        }

        public StyledDocument getDocument() {
            return this.currentEditorCookie().getDocument();
        }

        public void saveDocument() throws IOException {
            this.currentEditorCookie().saveDocument();
        }

        public boolean isModified() {
            return this.currentEditorCookie().isModified();
        }

        public JEditorPane[] getOpenedPanes() {
            return this.currentEditorCookie().getOpenedPanes();
        }

        public void addPropertyChangeListener(PropertyChangeListener l) {
            this.pcs.addPropertyChangeListener(l);
        }

        public void removePropertyChangeListener(PropertyChangeListener l) {
            this.pcs.removePropertyChangeListener(l);
        }

        public void propertyChange(PropertyChangeEvent evt) {
            this.pcs.firePropertyChange(evt);
        }
    }
}

