/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit.output;

import java.awt.Color;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.accessibility.AccessibleContext;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.junit.output.ResultDisplayHandler;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;

final class ResultPanelOutput
extends JScrollPane
implements ActionListener {
    private static final boolean LOG = false;
    static final Color selectedFg;
    static final Color unselectedFg;
    static final Color selectedErr;
    static final Color unselectedErr;
    private static final int UPDATE_DELAY = 300;
    private final Style outputStyle;
    private final Style errOutputStyle;
    private final JTextPane textPane = new JTextPane();
    private final StyledDocument doc = this.textPane.getStyledDocument();
    private final ResultDisplayHandler displayHandler;
    boolean newLinePending = false;
    private Timer timer = null;
    private volatile boolean timerRunning = false;

    ResultPanelOutput(ResultDisplayHandler displayHandler) {
        this.textPane.setEditable(false);
        this.setViewportView(this.textPane);
        AccessibleContext accessibleContext = this.textPane.getAccessibleContext();
        accessibleContext.setAccessibleName(NbBundle.getMessage(this.getClass(), (String)"ACSN_OutputTextPane"));
        accessibleContext.setAccessibleDescription(NbBundle.getMessage(this.getClass(), (String)"ACSD_OutputTextPane"));
        Style defaultStyle = StyleContext.getDefaultStyleContext().getStyle("default");
        this.outputStyle = this.doc.addStyle("output", defaultStyle);
        StyleConstants.setFontFamily(this.outputStyle, "Monospaced");
        StyleConstants.setForeground(this.outputStyle, unselectedFg);
        this.errOutputStyle = this.doc.addStyle("error", this.outputStyle);
        StyleConstants.setForeground(this.errOutputStyle, unselectedErr);
        this.displayHandler = displayHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNotify() {
        Object[] pendingOutput;
        super.addNotify();
        Object object = this.displayHandler.getOutputQueueLock();
        synchronized (object) {
            pendingOutput = this.displayHandler.consumeOutput();
            if (pendingOutput.length == 0) {
                this.displayHandler.setOutputListener(this);
            }
        }
        if (pendingOutput.length != 0) {
            this.displayOutput(pendingOutput);
            this.startTimer();
        }
    }

    void outputAvailable() {
        Object[] pendingOutput = this.displayHandler.consumeOutput();
        assert (pendingOutput.length != 0);
        new OutputDisplayer(pendingOutput).run();
        this.displayHandler.setOutputListener(null);
        if (!this.timerRunning) {
            this.startTimer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent e) {
        assert (EventQueue.isDispatchThread());
        Object[] pendingOutput = this.displayHandler.consumeOutput();
        if (pendingOutput.length != 0) {
            this.displayOutput(pendingOutput);
        } else {
            Object object = this.displayHandler.getOutputQueueLock();
            synchronized (object) {
                this.stopTimer();
                this.displayHandler.setOutputListener(this);
            }
        }
    }

    private void startTimer() {
        if (this.timer == null) {
            this.timer = new Timer(300, this);
        }
        this.timerRunning = true;
        this.timer.start();
    }

    private void stopTimer() {
        if (this.timer != null) {
            this.timer.stop();
            this.timerRunning = false;
        }
    }

    void displayOutput(Object[] output) {
        Object o;
        assert (EventQueue.isDispatchThread());
        int index = 0;
        while ((o = output[index++]) != null) {
            boolean errOutput = false;
            if (o == Boolean.TRUE) {
                o = output[index++];
                errOutput = true;
            }
            this.displayOutputLine(o.toString(), errOutput);
        }
    }

    private void displayOutputLine(String text, boolean error) {
        Style textStyle = error ? this.errOutputStyle : this.outputStyle;
        try {
            if (this.newLinePending) {
                this.doc.insertString(this.doc.getLength(), "\n", this.outputStyle);
                this.newLinePending = false;
            }
            this.doc.insertString(this.doc.getLength(), text, textStyle);
            this.newLinePending = true;
        }
        catch (BadLocationException ex) {
            ErrorManager.getDefault().notify(65536, (Throwable)ex);
        }
    }

    private void clear() {
        assert (EventQueue.isDispatchThread());
        try {
            this.doc.remove(0, this.doc.getLength());
        }
        catch (BadLocationException ex) {
            ErrorManager.getDefault().notify(65536, (Throwable)ex);
        }
    }

    public boolean requestFocusInWindow() {
        return this.textPane.requestFocusInWindow();
    }

    static {
        Color color = UIManager.getColor("nb.output.foreground.selected");
        if (color == null && (color = UIManager.getColor("textText")) == null) {
            color = Color.BLACK;
        }
        selectedFg = color;
        color = UIManager.getColor("nb.output.foreground");
        if (color == null) {
            color = selectedFg;
        }
        unselectedFg = color;
        color = UIManager.getColor("nb.output.err.foreground.selected");
        if (color == null) {
            color = new Color(164, 0, 0);
        }
        selectedErr = color;
        color = UIManager.getColor("nb.output.err.foreground");
        if (color == null) {
            color = selectedErr;
        }
        unselectedErr = color;
    }

    final class OutputDisplayer
    implements Runnable {
        private final Object[] output;

        OutputDisplayer(Object[] output) {
            this.output = output;
        }

        public void run() {
            if (!EventQueue.isDispatchThread()) {
                EventQueue.invokeLater(this);
                return;
            }
            ResultPanelOutput.this.displayOutput(this.output);
        }
    }
}

