/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit;

import java.util.ArrayList;
import java.util.Map;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.junit.JUnitCfgOfCreate;
import org.netbeans.modules.junit.JUnitPluginTrampoline;
import org.netbeans.modules.junit.TestAction;
import org.netbeans.modules.junit.TestUtil;
import org.netbeans.modules.junit.plugin.JUnitPlugin;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class CreateTestAction
extends TestAction {
    public CreateTestAction() {
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public String getName() {
        return NbBundle.getMessage(CreateTestAction.class, (String)"LBL_Action_CreateTest");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(CreateTestAction.class);
    }

    protected void initialize() {
        super.initialize();
        this.putProperty("ShortDescription", NbBundle.getMessage(CreateTestAction.class, (String)"HINT_Action_CreateTest"));
    }

    protected String iconResource() {
        return "org/netbeans/modules/junit/resources/CreateTestActionIcon.gif";
    }

    private static String checkNodesValidity(Node[] nodes) {
        FileObject[] files = CreateTestAction.getFiles(nodes);
        Project project = CreateTestAction.getProject(files);
        if (project == null) {
            return NbBundle.getMessage(CreateTestAction.class, (String)"MSG_multiproject_selection");
        }
        if (!CreateTestAction.checkPackages(files)) {
            return NbBundle.getMessage(CreateTestAction.class, (String)"MSG_invalid_packages");
        }
        return null;
    }

    private static boolean checkPackages(FileObject[] files) {
        if (files.length == 0) {
            return true;
        }
        Project project = FileOwnerQuery.getOwner((FileObject)files[0]);
        for (int i = 0; i < files.length; ++i) {
            String packageName = CreateTestAction.getPackage(project, files[i]);
            if (packageName != null && TestUtil.isValidPackageName(packageName)) continue;
            return false;
        }
        return true;
    }

    private static String getPackage(Project project, FileObject file) {
        SourceGroup srcGrp = TestUtil.findSourceGroupOwner(project, file);
        if (srcGrp != null) {
            ClassPath cp = ClassPathSupport.createClassPath((FileObject[])new FileObject[]{srcGrp.getRootFolder()});
            return cp.getResourceName(file, '.', false);
        }
        return null;
    }

    private static FileObject[] getFiles(Node[] nodes) {
        FileObject[] ret = new FileObject[nodes.length];
        for (int i = 0; i < nodes.length; ++i) {
            ret[i] = TestUtil.getFileObjectFromNode(nodes[i]);
        }
        return ret;
    }

    private static Project getProject(FileObject[] files) {
        Project project = null;
        for (int i = 0; i < files.length; ++i) {
            Project nodeProject = FileOwnerQuery.getOwner((FileObject)files[i]);
            if (project == null) {
                project = nodeProject;
                continue;
            }
            if (project == nodeProject) continue;
            return null;
        }
        return project;
    }

    protected void performAction(Node[] nodes) {
        String problem = CreateTestAction.checkNodesValidity(nodes);
        if (problem != null) {
            NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)problem, 2);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
            return;
        }
        JUnitCfgOfCreate cfg = new JUnitCfgOfCreate(nodes);
        if (!cfg.configure()) {
            return;
        }
        boolean singleClass = cfg.isSingleClass();
        Map<JUnitPlugin.CreateTestParam, Object> params = TestUtil.getSettingsMap(!singleClass);
        if (singleClass) {
            params.put(JUnitPlugin.CreateTestParam.CLASS_NAME, cfg.getTestClassName());
        }
        FileObject targetFolder = cfg.getTargetFolder();
        cfg = null;
        FileObject[] filesToTest = CreateTestAction.getFileObjectsFromNodes(nodes);
        if (filesToTest == null) {
            return;
        }
        JUnitPlugin plugin = TestUtil.getPluginForProject(FileOwnerQuery.getOwner((FileObject)filesToTest[0]));
        FileObject[] testFileObjects = JUnitPluginTrampoline.DEFAULT.createTests(plugin, filesToTest, targetFolder, params);
        if (testFileObjects.length == 1) {
            try {
                DataObject dobj = DataObject.find((FileObject)testFileObjects[0]);
                EditorCookie ec = (EditorCookie)dobj.getCookie(EditorCookie.class);
                if (ec != null) {
                    ec.open();
                }
            }
            catch (DataObjectNotFoundException ex) {
                ex.printStackTrace();
            }
        }
    }

    private static FileObject[] getFileObjectsFromNodes(Node[] nodes) {
        FileObject[] fileObjects = new FileObject[nodes.length];
        ArrayList<FileObject> fileObjectsList = null;
        for (int i = 0; i < nodes.length; ++i) {
            FileObject fo;
            Node node = nodes[i];
            if (!CreateTestAction.hasParentAmongNodes(nodes, i) && (fo = CreateTestAction.getTestFileObject(node)) != null) {
                if (fileObjects != null) {
                    fileObjects[i] = fo;
                    continue;
                }
                if (fileObjectsList == null) {
                    fileObjectsList = new ArrayList<FileObject>(nodes.length - i);
                }
                fileObjectsList.add(fo);
                continue;
            }
            fileObjects = null;
        }
        if (fileObjects == null && fileObjectsList != null) {
            fileObjects = fileObjectsList.toArray(new FileObject[fileObjectsList.size()]);
            fileObjectsList = null;
        }
        return fileObjects;
    }

    private static FileObject getTestFileObject(Node node) {
        FileObject fo = TestUtil.getFileObjectFromNode(node);
        if (fo == null) {
            TestUtil.notifyUser(NbBundle.getMessage(CreateTestAction.class, (String)"MSG_file_from_node_failed"));
            return null;
        }
        ClassPath cp = ClassPath.getClassPath((FileObject)fo, (String)"classpath/source");
        if (cp == null) {
            TestUtil.notifyUser(NbBundle.getMessage(CreateTestAction.class, (String)"MSG_no_project", (Object)fo));
            return null;
        }
        return fo;
    }

    private static boolean hasParentAmongNodes(Node[] nodes, int idx) {
        for (Node node = nodes[idx].getParentNode(); null != node; node = node.getParentNode()) {
            for (int i = 0; i < nodes.length; ++i) {
                if (i == idx || node != nodes[i]) continue;
                return true;
            }
        }
        return false;
    }
}

