/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.plaf.aqua;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.netbeans.swing.plaf.aqua.ShapeGradientPaint;
import org.netbeans.swing.plaf.util.UIUtils;

public final class DropShadowBorder
implements Border {
    int offset = 7;
    private static final int[] xpoints = new int[5];
    private static final int[] ypoints = new int[5];
    static final Color DEFAULT_SHADOWLIGHT = new Color(255, 255, 255, 0);
    private Color shadowLight = DEFAULT_SHADOWLIGHT;
    private Color shadowDark = null;
    private static final Composite transparency = AlphaComposite.getInstance(3, 0.7f);
    private static final int WIDTH = 17;
    private static final int HEIGHT = 17;
    private static final int ARC = 12;
    private static final int GAP = 6;

    private Color getShadowLight() {
        return DEFAULT_SHADOWLIGHT;
    }

    private Color getShadowDark() {
        Color result = null;
        if (this.shadowDark == null) {
            result = UIManager.getColor("controlDkShadow");
            result = new Color(result.getRed(), result.getGreen(), result.getBlue(), 128);
        } else {
            result = this.shadowDark;
        }
        return result;
    }

    public Insets getBorderInsets(Component c) {
        return new Insets(1, 17, 22, 17);
    }

    public boolean isBorderOpaque() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
        UIUtils.configureRenderingHints(g);
        Graphics2D g2d = (Graphics2D)g;
        Composite comp = g2d.getComposite();
        Paint paint = g2d.getPaint();
        try {
            Insets ins = this.getBorderInsets(c);
            int bottom = y + (h - (ins.bottom + ins.top)) + 6;
            int left = x + ins.left - 6;
            int right = x + w - ins.right + 6;
            int top = y + ins.top + 1;
            int arctop = y + (h - (ins.bottom + ins.top + 12));
            int arcright = right - 18;
            int arcleft = x + ins.left + 12;
            GeneralPath gp = new GeneralPath();
            gp.moveTo(left, top + 27);
            gp.lineTo(left, arctop);
            gp.quadTo(left, bottom, arcleft, bottom);
            gp.lineTo(arcright, bottom);
            gp.quadTo(right, bottom, right, arctop);
            gp.lineTo(right, top + 27);
            gp.quadTo(right, top + 22, right - 6, top + 18);
            gp.lineTo(right - 9, top + 5);
            gp.quadTo(right - 9, top, right - 14, top);
            gp.lineTo(left + 11, top);
            gp.quadTo(left + 11, top, left + 8, top + 3);
            gp.lineTo(left + 11, top + 16);
            gp.quadTo(left, top + 21, left, top + 26);
            gp.closePath();
            g.setColor(Color.WHITE);
            g2d.fill(gp);
            Area a = new Area(new Rectangle(x, y, w, h));
            a.subtract(new Area(gp));
            g2d.setPaint(new ShapeGradientPaint(gp.getBounds(), this.getShadowDark(), this.getShadowLight()));
            g2d.fill(a);
            g.setColor(UIManager.getColor("controlShadow"));
            g2d.draw(gp);
        }
        finally {
            g2d.setComposite(comp);
            g2d.setPaint(paint);
        }
    }
}

