/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.ws.wsdl.document;

import com.sun.tools.ws.wsdl.document.Documentation;
import com.sun.tools.ws.wsdl.document.Kinds;
import com.sun.tools.ws.wsdl.document.Operation;
import com.sun.tools.ws.wsdl.document.WSDLConstants;
import com.sun.tools.ws.wsdl.document.WSDLDocumentVisitor;
import com.sun.tools.ws.wsdl.framework.Defining;
import com.sun.tools.ws.wsdl.framework.Entity;
import com.sun.tools.ws.wsdl.framework.EntityAction;
import com.sun.tools.ws.wsdl.framework.ExtensibilityHelper;
import com.sun.tools.ws.wsdl.framework.Extensible;
import com.sun.tools.ws.wsdl.framework.Extension;
import com.sun.tools.ws.wsdl.framework.GlobalEntity;
import com.sun.tools.ws.wsdl.framework.Kind;
import com.sun.tools.ws.wsdl.framework.ValidationException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;

public class PortType
extends GlobalEntity
implements Extensible {
    private Documentation _documentation;
    private List _operations = new ArrayList();
    private Set _operationKeys = new HashSet();
    private ExtensibilityHelper _helper = new ExtensibilityHelper();

    public PortType(Defining defining) {
        super(defining);
    }

    public void add(Operation operation) {
        String key = operation.getUniqueKey();
        if (this._operationKeys.contains(key)) {
            throw new ValidationException("validation.ambiguousName", operation.getName());
        }
        this._operationKeys.add(key);
        this._operations.add(operation);
    }

    public Iterator operations() {
        return this._operations.iterator();
    }

    public Set getOperationsNamed(String s) {
        HashSet<Operation> result = new HashSet<Operation>();
        for (Operation operation : this._operations) {
            if (!operation.getName().equals(s)) continue;
            result.add(operation);
        }
        return result;
    }

    public Kind getKind() {
        return Kinds.PORT_TYPE;
    }

    public QName getElementName() {
        return WSDLConstants.QNAME_PORT_TYPE;
    }

    public Documentation getDocumentation() {
        return this._documentation;
    }

    public void setDocumentation(Documentation d) {
        this._documentation = d;
    }

    public void withAllSubEntitiesDo(EntityAction action) {
        super.withAllSubEntitiesDo(action);
        Iterator iter = this._operations.iterator();
        while (iter.hasNext()) {
            action.perform((Entity)iter.next());
        }
        this._helper.withAllSubEntitiesDo(action);
    }

    public void accept(WSDLDocumentVisitor visitor) throws Exception {
        visitor.preVisit(this);
        this._helper.accept(visitor);
        Iterator iter = this._operations.iterator();
        while (iter.hasNext()) {
            ((Operation)iter.next()).accept(visitor);
        }
        visitor.postVisit(this);
    }

    public void validateThis() {
        if (this.getName() == null) {
            this.failValidation("validation.missingRequiredAttribute", "name");
        }
    }

    public void addExtension(Extension e) {
        this._helper.addExtension(e);
    }

    public Iterator extensions() {
        return this._helper.extensions();
    }
}

