/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.debugger;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Lookup;

public final class Session {
    public static final String PROP_CURRENT_LANGUAGE = "currentLanguage";
    public static final String PROP_SUPPORTED_LANGUAGES = "supportedLanguages";
    private String name;
    private String locationName;
    private DebuggerEngine currentDebuggerEngine;
    private String currentLanguage;
    private String[] languages;
    private DebuggerEngine[] engines;
    private PropertyChangeSupport pcs;
    private Lookup lookup;
    Lookup privateLookup;

    Session(String name, String locationName, String id, Object[] services, Lookup diLookup) {
        this.name = name;
        this.locationName = locationName;
        this.languages = new String[0];
        this.engines = new DebuggerEngine[0];
        this.pcs = new PropertyChangeSupport(this);
        Object[] s = new Object[services.length + 1];
        System.arraycopy(services, 0, s, 0, services.length);
        s[s.length - 1] = this;
        this.privateLookup = new Lookup.Compound(new Lookup.Instance(s), new Lookup.MetaInf(id));
        this.lookup = new Lookup.Compound(diLookup, this.privateLookup);
    }

    public String getName() {
        return this.name;
    }

    public String getLocationName() {
        return this.locationName;
    }

    public DebuggerEngine getCurrentEngine() {
        return this.currentDebuggerEngine;
    }

    public String getCurrentLanguage() {
        return this.currentLanguage;
    }

    public String[] getSupportedLanguages() {
        return this.languages;
    }

    public List lookup(String folder, Class service) {
        return this.lookup.lookup(folder, service);
    }

    public Object lookupFirst(String folder, Class service) {
        return this.lookup.lookupFirst(folder, service);
    }

    public void kill() {
        HashSet<DebuggerEngine> dead = new HashSet<DebuggerEngine>(Arrays.asList(this.engines));
        Iterator<DebuggerEngine> i = dead.iterator();
        while (i.hasNext()) {
            i.next().getActionsManager().doAction(ActionsManager.ACTION_KILL);
        }
    }

    public DebuggerEngine getEngineForLanguage(String language) {
        int k = this.languages.length;
        for (int i = 0; i < k; ++i) {
            if (!this.languages[i].equals(language)) continue;
            return this.engines[i];
        }
        return null;
    }

    public void setCurrentLanguage(String language) {
        int k = this.languages.length;
        for (int i = 0; i < k; ++i) {
            if (!language.equals(this.languages[i])) continue;
            String oldL = this.currentLanguage;
            this.currentLanguage = language;
            this.currentDebuggerEngine = this.engines[i];
            this.pcs.firePropertyChange(PROP_CURRENT_LANGUAGE, oldL, this.currentLanguage);
        }
    }

    Lookup getLookup() {
        return this.lookup;
    }

    void addLanguage(String language, DebuggerEngine engine) {
        int k = this.languages.length;
        for (int i = 0; i < k; ++i) {
            if (!language.equals(this.languages[i])) continue;
            this.engines[i] = engine;
            return;
        }
        String[] newLanguages = new String[this.languages.length + 1];
        DebuggerEngine[] newEngines = new DebuggerEngine[this.engines.length + 1];
        System.arraycopy(this.languages, 0, newLanguages, 0, this.languages.length);
        System.arraycopy(this.engines, 0, newEngines, 0, this.engines.length);
        newLanguages[this.languages.length] = language;
        newEngines[this.engines.length] = engine;
        String[] oldL = this.languages;
        this.languages = newLanguages;
        this.engines = newEngines;
        DebuggerManager.getDebuggerManager().addEngine(engine);
        this.pcs.firePropertyChange(PROP_SUPPORTED_LANGUAGES, oldL, this.languages);
        if (this.currentLanguage == null) {
            this.setCurrentLanguage(language);
        }
    }

    void removeEngine(DebuggerEngine engine) {
        if (this.engines.length == 0) {
            return;
        }
        int k = this.engines.length;
        ArrayList<String> newLanguages = new ArrayList<String>();
        ArrayList<DebuggerEngine> newEngines = new ArrayList<DebuggerEngine>();
        for (int i = 0; i < k; ++i) {
            if (engine.equals(this.engines[i])) continue;
            newLanguages.add(this.languages[i]);
            newEngines.add(this.engines[i]);
        }
        String[] oldL = this.languages;
        this.languages = newLanguages.toArray(new String[newLanguages.size()]);
        this.engines = newEngines.toArray(new DebuggerEngine[newEngines.size()]);
        DebuggerManager.getDebuggerManager().removeEngine(engine);
        this.pcs.firePropertyChange(PROP_SUPPORTED_LANGUAGES, oldL, this.languages);
    }

    void removeLanguage(String language, DebuggerEngine engine) {
        int i;
        int k = this.languages.length;
        for (i = 0; i < k; ++i) {
            if (!language.equals(this.languages[i])) continue;
            if (this.engines[i] == engine) break;
            throw new IllegalArgumentException();
        }
        if (i >= k) {
            return;
        }
        String[] newLanguages = new String[k - 1];
        DebuggerEngine[] newEngines = new DebuggerEngine[k - 1];
        if (i > 0) {
            System.arraycopy(this.languages, 0, newLanguages, 0, i);
            System.arraycopy(this.engines, 0, newEngines, 0, i);
        }
        System.arraycopy(this.languages, i + 1, newLanguages, i, k - i - 1);
        System.arraycopy(this.engines, i + 1, newEngines, i, k - i - 1);
        String[] oldL = this.languages;
        this.languages = newLanguages;
        this.engines = newEngines;
        this.pcs.firePropertyChange(PROP_SUPPORTED_LANGUAGES, oldL, this.languages);
        k = this.engines.length;
        for (i = 0; i < k; ++i) {
            if (this.engines[i] != engine) continue;
            return;
        }
        DebuggerManager.getDebuggerManager().removeEngine(engine);
    }

    public String toString() {
        return "" + this.getClass().getName() + " " + this.getLocationName() + ":" + this.getName();
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(l);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(propertyName, l);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(propertyName, l);
    }
}

