/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.view.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.netbeans.core.windows.view.SlidingView;
import org.netbeans.core.windows.view.ViewElement;
import org.netbeans.core.windows.view.ui.slides.SlideOperation;
import org.openide.windows.TopComponent;

public final class DesktopImpl {
    private JLayeredPane layeredPane = new JLayeredPane();
    private JPanel desktop;
    private ViewElement splitRoot;
    private ViewElement maximizedMode;
    private Component splitRootComponent;
    private Component viewComponent;
    private Set slidingViews;
    private SlideOperation curSlideIn;
    private static final int MIN_EDITOR_ALIGN_THICK = 200;

    public DesktopImpl() {
        this.layeredPane.setLayout(new LayeredLayout());
        this.desktop = new JPanel();
        this.desktop.setLayout(new GridBagLayout());
        this.layeredPane.add(this.desktop);
    }

    public Component getDesktopComponent() {
        return this.layeredPane;
    }

    public Dimension getInnerPaneDimension() {
        int width = this.desktop.getSize().width;
        int height = this.desktop.getSize().height;
        SlidingView view = this.findView("left");
        width = view != null ? width - view.getComponent().getSize().width : width;
        view = this.findView("right");
        width = view != null ? width - view.getComponent().getSize().width : width;
        view = this.findView("bottom");
        height = view != null ? height - view.getComponent().getSize().height : height;
        return new Dimension(width, height);
    }

    public void setSplitRoot(ViewElement splitRoot) {
        this.splitRoot = splitRoot;
        if (splitRoot != null) {
            this.setViewComponent(splitRoot.getComponent());
        } else {
            this.setViewComponent(null);
        }
    }

    public void setMaximizedView(ViewElement component) {
        this.maximizedMode = component;
        if (component.getComponent() != this.viewComponent) {
            this.setViewComponent(component.getComponent());
        }
    }

    private void setViewComponent(Component component) {
        if (this.viewComponent == component) {
            return;
        }
        if (this.viewComponent != null) {
            this.desktop.remove(this.viewComponent);
        }
        this.viewComponent = component;
        if (this.viewComponent != null) {
            GridBagConstraints constr = new GridBagConstraints();
            constr.gridx = 1;
            constr.gridy = 0;
            constr.fill = 1;
            constr.weightx = 1.0;
            constr.weighty = 1.0;
            this.desktop.add(component, constr);
        }
        this.layeredPane.revalidate();
        this.layeredPane.repaint();
    }

    public ViewElement getSplitRoot() {
        return this.splitRoot;
    }

    public void addSlidingView(SlidingView view) {
        Set slidingViews = this.getSlidingViews();
        if (slidingViews.contains(view)) {
            return;
        }
        slidingViews.add(view);
        GridBagConstraints constraint = new GridBagConstraints();
        constraint.fill = 1;
        if ("bottom".equals(view.getSide())) {
            constraint.gridx = 1;
            constraint.gridy = 1;
            constraint.anchor = 16;
        } else if ("left".equals(view.getSide())) {
            constraint.gridx = 0;
            constraint.gridy = 0;
            constraint.gridheight = 2;
            constraint.anchor = 18;
        } else if ("right".equals(view.getSide())) {
            constraint.gridx = 2;
            constraint.gridy = 0;
            constraint.gridheight = 2;
            constraint.anchor = 12;
        }
        this.desktop.add(view.getComponent(), constraint);
        this.layeredPane.revalidate();
    }

    public void removeSlidingView(SlidingView view) {
        Set slidingViews = this.getSlidingViews();
        if (!slidingViews.contains(view)) {
            return;
        }
        slidingViews.remove(view);
        this.desktop.remove(view.getComponent());
        this.checkCurSlide();
        this.layeredPane.revalidate();
    }

    private void checkCurSlide() {
        if (this.curSlideIn != null) {
            SlidingView curView = null;
            Component curSlideComp = this.curSlideIn.getComponent();
            Iterator iter = this.slidingViews.iterator();
            while (iter.hasNext()) {
                curView = (SlidingView)iter.next();
                if (!curView.getTopComponents().contains(curSlideComp)) continue;
                return;
            }
            this.layeredPane.remove(curSlideComp);
        }
    }

    public void performSlideIn(SlideOperation operation, Rectangle editorBounds) {
        Rectangle slideInBounds = this.computeSlideInBounds(operation, editorBounds);
        operation.setFinishBounds(slideInBounds);
        operation.setStartBounds(this.computeThinBounds(operation, slideInBounds));
        this.performSlide(operation);
        this.curSlideIn = operation;
    }

    public void performSlideOut(SlideOperation operation, Rectangle editorBounds) {
        Rectangle slideOutBounds = operation.getComponent().getBounds();
        operation.setStartBounds(slideOutBounds);
        operation.setFinishBounds(this.computeThinBounds(operation, slideOutBounds));
        this.curSlideIn = null;
        this.performSlide(operation);
        this.desktop.revalidate();
        this.desktop.repaint();
    }

    public void performSlideIntoEdge(SlideOperation operation, Rectangle editorBounds) {
        operation.setFinishBounds(this.computeLastButtonBounds(operation));
        Rectangle screenStart = operation.getStartBounds();
        operation.setStartBounds(this.convertRectFromScreen(this.layeredPane, screenStart));
        this.performSlide(operation);
    }

    public void performSlideIntoDesktop(SlideOperation operation, Rectangle editorBounds) {
        Rectangle screenStart = operation.getStartBounds();
        operation.setStartBounds(this.convertRectFromScreen(this.layeredPane, screenStart));
        Rectangle screenFinish = operation.getStartBounds();
        operation.setStartBounds(this.convertRectFromScreen(this.layeredPane, screenFinish));
        this.performSlide(operation);
    }

    public void performSlideResize(SlideOperation operation) {
        this.performSlide(operation);
    }

    private void performSlide(SlideOperation operation) {
        operation.run(this.layeredPane, new Integer(102));
    }

    private Rectangle convertRectFromScreen(Component comp, Rectangle screenRect) {
        if (screenRect == null) {
            screenRect = new Rectangle(0, 0, 0, 0);
        }
        Point leftTop = screenRect.getLocation();
        SwingUtilities.convertPointFromScreen(leftTop, comp);
        return new Rectangle(leftTop, screenRect.getSize());
    }

    private Rectangle computeSlideInBounds(SlideOperation operation, Rectangle editorBounds) {
        Point editorLeftTop = editorBounds.getLocation();
        SwingUtilities.convertPointFromScreen(editorLeftTop, this.layeredPane);
        editorBounds = new Rectangle(editorLeftTop, editorBounds.getSize());
        String side = operation.getSide();
        SlidingView view = this.findView(side);
        Rectangle splitRootRect = this.viewComponent.getBounds();
        Rectangle result = new Rectangle();
        Rectangle viewRect = view.getComponent().getBounds();
        Dimension viewPreferred = view.getComponent().getPreferredSize();
        int minThick = 200;
        TopComponent tc = view.getSelectedTopComponent();
        if (null != tc && Boolean.TRUE.equals(tc.getClientProperty((Object)"keepPreferredSizeWhenSlideIn"))) {
            minThick = 20;
        }
        if ("left".equals(side)) {
            result.x = viewRect.x + Math.max(viewRect.width, viewPreferred.width);
            result.y = 0;
            result.height = splitRootRect.height;
            result.width = view.getSlideBounds().width;
            if (result.width < minThick) {
                result.width = splitRootRect.width / 3;
            }
            if (result.width > splitRootRect.width) {
                result.width = splitRootRect.width - splitRootRect.width / 10;
            }
        } else if ("right".equals(side)) {
            int rightLimit = this.layeredPane.getBounds().width - Math.max(viewRect.width, viewPreferred.width);
            int n = result.x = view.getSlideBounds().width < minThick ? rightLimit - splitRootRect.width / 3 : rightLimit - view.getSlideBounds().width;
            if (result.x < 0) {
                result.x = splitRootRect.width / 10;
            }
            result.y = 0;
            result.height = splitRootRect.height;
            result.width = rightLimit - result.x;
        } else if ("bottom".equals(side)) {
            int lowerLimit = viewRect.y + viewRect.height - Math.max(viewRect.height, viewPreferred.height);
            result.x = splitRootRect.x;
            int n = result.y = view.getSlideBounds().height < minThick ? lowerLimit - splitRootRect.height / 3 : lowerLimit - view.getSlideBounds().height;
            if (result.y < 0) {
                result.y = splitRootRect.width / 10;
            }
            result.height = lowerLimit - result.y;
            result.width = splitRootRect.width;
        }
        return result;
    }

    private Rectangle computeThinBounds(SlideOperation operation, Rectangle slideInFinish) {
        String side = operation.getSide();
        Rectangle result = new Rectangle();
        if ("left".equals(side)) {
            result.x = slideInFinish.x;
            result.y = slideInFinish.y;
            result.height = slideInFinish.height;
            result.width = 0;
        } else if ("right".equals(side)) {
            result.x = slideInFinish.x + slideInFinish.width;
            result.y = slideInFinish.y;
            result.height = slideInFinish.height;
            result.width = 0;
        } else if ("bottom".equals(side)) {
            result.x = slideInFinish.x;
            result.y = slideInFinish.y + slideInFinish.height;
            result.height = 0;
            result.width = slideInFinish.width;
        }
        return result;
    }

    private Rectangle computeLastButtonBounds(SlideOperation operation) {
        String side = operation.getSide();
        SlidingView view = this.findView(side);
        Rectangle screenRect = view.getTabBounds(view.getTopComponents().size() - 1);
        Point leftTop = screenRect.getLocation();
        if ("bottom".equals(side)) {
            leftTop.y += this.desktop.getHeight() - view.getComponent().getPreferredSize().height;
        } else if ("right".equals(side)) {
            leftTop.x += this.desktop.getWidth() - view.getComponent().getPreferredSize().width;
        }
        return new Rectangle(leftTop, screenRect.getSize());
    }

    private SlidingView findView(String side) {
        Iterator iter = this.getSlidingViews().iterator();
        while (iter.hasNext()) {
            SlidingView view = (SlidingView)iter.next();
            if (!side.equals(view.getSide())) continue;
            return view;
        }
        return null;
    }

    private Set getSlidingViews() {
        if (this.slidingViews == null) {
            this.slidingViews = new HashSet(5);
        }
        return this.slidingViews;
    }

    private final class LayeredLayout
    implements LayoutManager {
        private Dimension lastSize;

        private LayeredLayout() {
        }

        public void layoutContainer(Container parent) {
            String side;
            SlidingView curView;
            Dimension size = parent.getSize();
            DesktopImpl.this.desktop.setBounds(0, 0, size.width, size.height);
            if (DesktopImpl.this.curSlideIn != null && DesktopImpl.this.curSlideIn.getComponent().isVisible() && (curView = DesktopImpl.this.findView(side = DesktopImpl.this.curSlideIn.getSide())) != null && DesktopImpl.this.viewComponent != null) {
                Component slidedComp = DesktopImpl.this.curSlideIn.getComponent();
                Rectangle result = slidedComp.getBounds();
                Rectangle viewRect = curView.getComponent().getBounds();
                Dimension viewPrefSize = curView.getComponent().getPreferredSize();
                Rectangle splitRootRect = DesktopImpl.this.viewComponent.getBounds();
                if ("left".equals(side)) {
                    result.height = splitRootRect.height;
                    if (this.lastSize != null && !this.lastSize.equals(size)) {
                        int wid = curView.getSlideBounds().width;
                        result.width = wid > size.width - viewRect.width ? size.width - size.width / 10 : wid;
                    }
                } else if ("right".equals(side)) {
                    result.height = splitRootRect.height;
                    if (this.lastSize != null && !this.lastSize.equals(size)) {
                        int wid;
                        int avail = size.width - Math.max(viewRect.width, viewPrefSize.width);
                        if (avail - (wid = curView.getSlideBounds().width) < wid / 10) {
                            result.x = 0 + wid / 10;
                            result.width = avail - wid / 10;
                        } else {
                            result.x = avail - result.width;
                            result.width = wid;
                        }
                    }
                } else if ("bottom".equals(side)) {
                    result.width = splitRootRect.width;
                    if (this.lastSize != null && !this.lastSize.equals(size)) {
                        int avail = size.height - Math.max(viewRect.height, viewPrefSize.height);
                        int hei = viewRect.height;
                        if (hei < curView.getSlideBounds().height) {
                            hei = curView.getSlideBounds().height;
                        }
                        if (avail - hei < hei / 10) {
                            result.y = 0 + hei / 10;
                            result.height = avail - hei / 10;
                        } else {
                            result.y = avail - hei;
                            result.height = hei;
                        }
                    }
                }
                slidedComp.setBounds(result);
            }
            this.lastSize = size;
        }

        public Dimension minimumLayoutSize(Container parent) {
            return DesktopImpl.this.desktop.getMinimumSize();
        }

        public Dimension preferredLayoutSize(Container parent) {
            return DesktopImpl.this.desktop.getPreferredSize();
        }

        public void addLayoutComponent(String name, Component comp) {
        }

        public void removeLayoutComponent(Component comp) {
        }
    }
}

