/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.generator;

import com.sun.xml.rpc.processor.ProcessorAction;
import com.sun.xml.rpc.processor.config.Configuration;
import com.sun.xml.rpc.processor.generator.GeneratorConstants;
import com.sun.xml.rpc.processor.generator.GeneratorException;
import com.sun.xml.rpc.processor.generator.Names;
import com.sun.xml.rpc.processor.generator.writer.SerializerWriterFactory;
import com.sun.xml.rpc.processor.generator.writer.SerializerWriterFactoryImpl;
import com.sun.xml.rpc.processor.model.AbstractType;
import com.sun.xml.rpc.processor.model.Block;
import com.sun.xml.rpc.processor.model.Fault;
import com.sun.xml.rpc.processor.model.Model;
import com.sun.xml.rpc.processor.model.ModelVisitor;
import com.sun.xml.rpc.processor.model.Operation;
import com.sun.xml.rpc.processor.model.Parameter;
import com.sun.xml.rpc.processor.model.Port;
import com.sun.xml.rpc.processor.model.Request;
import com.sun.xml.rpc.processor.model.Response;
import com.sun.xml.rpc.processor.model.Service;
import com.sun.xml.rpc.processor.model.literal.LiteralAllType;
import com.sun.xml.rpc.processor.model.literal.LiteralArrayType;
import com.sun.xml.rpc.processor.model.literal.LiteralArrayWrapperType;
import com.sun.xml.rpc.processor.model.literal.LiteralAttachmentType;
import com.sun.xml.rpc.processor.model.literal.LiteralAttributeMember;
import com.sun.xml.rpc.processor.model.literal.LiteralElementMember;
import com.sun.xml.rpc.processor.model.literal.LiteralEnumerationType;
import com.sun.xml.rpc.processor.model.literal.LiteralFragmentType;
import com.sun.xml.rpc.processor.model.literal.LiteralIDType;
import com.sun.xml.rpc.processor.model.literal.LiteralListType;
import com.sun.xml.rpc.processor.model.literal.LiteralSequenceType;
import com.sun.xml.rpc.processor.model.literal.LiteralSimpleType;
import com.sun.xml.rpc.processor.model.literal.LiteralStructuredType;
import com.sun.xml.rpc.processor.model.literal.LiteralType;
import com.sun.xml.rpc.processor.model.literal.LiteralTypeVisitor;
import com.sun.xml.rpc.processor.model.soap.RPCRequestOrderedStructureType;
import com.sun.xml.rpc.processor.model.soap.RPCRequestUnorderedStructureType;
import com.sun.xml.rpc.processor.model.soap.RPCResponseStructureType;
import com.sun.xml.rpc.processor.model.soap.SOAPAnyType;
import com.sun.xml.rpc.processor.model.soap.SOAPArrayType;
import com.sun.xml.rpc.processor.model.soap.SOAPAttributeMember;
import com.sun.xml.rpc.processor.model.soap.SOAPCustomType;
import com.sun.xml.rpc.processor.model.soap.SOAPEnumerationType;
import com.sun.xml.rpc.processor.model.soap.SOAPListType;
import com.sun.xml.rpc.processor.model.soap.SOAPOrderedStructureType;
import com.sun.xml.rpc.processor.model.soap.SOAPSimpleType;
import com.sun.xml.rpc.processor.model.soap.SOAPStructureMember;
import com.sun.xml.rpc.processor.model.soap.SOAPStructureType;
import com.sun.xml.rpc.processor.model.soap.SOAPType;
import com.sun.xml.rpc.processor.model.soap.SOAPTypeVisitor;
import com.sun.xml.rpc.processor.model.soap.SOAPUnorderedStructureType;
import com.sun.xml.rpc.processor.util.IndentingWriter;
import com.sun.xml.rpc.processor.util.ProcessorEnvironment;
import com.sun.xml.rpc.soap.SOAPVersion;
import com.sun.xml.rpc.util.exception.LocalizableExceptionAdapter;
import com.sun.xml.rpc.util.localization.Localizable;
import com.sun.xml.rpc.util.localization.LocalizableMessageFactory;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;

public abstract class GeneratorBase
implements GeneratorConstants,
ProcessorAction,
ModelVisitor,
SOAPTypeVisitor,
LiteralTypeVisitor {
    protected File sourceDir;
    protected File destDir;
    protected File nonclassDestDir;
    protected ProcessorEnvironment env;
    protected Model model;
    protected Service service;
    protected IndentingWriter out;
    protected boolean encodeTypes;
    protected boolean multiRefEncoding;
    protected boolean serializeInterfaces;
    protected SerializerWriterFactory writerFactory;
    protected SOAPVersion curSOAPVersion;
    protected String JAXRPCVersion;
    protected String targetVersion;
    protected boolean generateSerializableIf;
    protected boolean donotOverride;
    protected String servicePackage;
    private LocalizableMessageFactory messageFactory;
    private Set visitedTypes;

    public GeneratorBase() {
        this.sourceDir = null;
        this.destDir = null;
        this.nonclassDestDir = null;
        this.env = null;
        this.model = null;
        this.out = null;
    }

    protected void doGeneration() {
        try {
            this.model.accept(this);
        }
        catch (Exception e) {
            throw new GeneratorException("generator.nestedGeneratorError", new LocalizableExceptionAdapter(e));
        }
    }

    protected void postVisitBlock(Block block) throws Exception {
    }

    protected void preVisitBlock(Block block) throws Exception {
    }

    protected void requestBodyBlock(Block block) throws Exception {
    }

    protected void requestHeaderBlock(Block block) throws Exception {
    }

    protected void responseAttachmentBlock(Block block) throws Exception {
    }

    protected void responseBodyBlock(Block block) throws Exception {
    }

    protected void responseHeaderBlock(Block block) throws Exception {
    }

    public void visit(Block block) throws Exception {
        this.preVisitBlock(block);
        this.visitBlock(block);
        this.postVisitBlock(block);
    }

    protected void visitBlock(Block block) throws Exception {
    }

    protected void postVisitFault(Fault fault) throws Exception {
    }

    protected void preVisitFault(Fault fault) throws Exception {
    }

    public void visit(Fault fault) throws Exception {
        this.preVisitFault(fault);
        this.visitFault(fault);
        this.postVisitFault(fault);
    }

    protected void visitFault(Fault fault) throws Exception {
        AbstractType type = fault.getBlock().getType();
        if (type.isSOAPType()) {
            ((SOAPType)type).accept(this);
        }
    }

    protected void postVisitModel(Model model) throws Exception {
    }

    protected void preVisitModel(Model model) throws Exception {
    }

    public void visit(Model model) throws Exception {
        this.visitedTypes = new HashSet();
        this.preVisitModel(model);
        this.visitModel(model);
        this.postVisitModel(model);
    }

    protected void visitModel(Model model) throws Exception {
        this.env.getNames().resetPrefixFactory();
        this.writerFactory = new SerializerWriterFactoryImpl(this.env.getNames());
        Iterator services = model.getServices();
        while (services.hasNext()) {
            ((Service)services.next()).accept(this);
        }
    }

    protected void postVisitOperation(Operation operation) throws Exception {
    }

    protected void preVisitOperation(Operation operation) throws Exception {
    }

    public void visit(Operation operation) throws Exception {
        this.preVisitOperation(operation);
        this.visitOperation(operation);
        this.postVisitOperation(operation);
    }

    protected void visitOperation(Operation operation) throws Exception {
        Iterator faults;
        operation.getRequest().accept(this);
        if (operation.getResponse() != null) {
            operation.getResponse().accept(this);
        }
        if ((faults = operation.getAllFaults()) != null) {
            while (faults.hasNext()) {
                Fault fault = (Fault)faults.next();
                fault.accept(this);
            }
        }
    }

    protected void postVisitParameter(Parameter param) throws Exception {
    }

    protected void preVisitParameter(Parameter param) throws Exception {
    }

    public void visit(Parameter param) throws Exception {
        this.preVisitParameter(param);
        this.visitParameter(param);
        this.postVisitParameter(param);
    }

    protected void visitParameter(Parameter param) throws Exception {
    }

    protected void postVisitPort(Port port) throws Exception {
        this.curSOAPVersion = null;
    }

    protected void preVisitPort(Port port) throws Exception {
        this.curSOAPVersion = port.getSOAPVersion();
    }

    public void visit(Port port) throws Exception {
        this.preVisitPort(port);
        this.visitPort(port);
        this.postVisitPort(port);
    }

    protected void visitPort(Port port) throws Exception {
        Iterator operations = port.getOperations();
        while (operations.hasNext()) {
            ((Operation)operations.next()).accept(this);
        }
    }

    protected void postVisitRequest(Request request) throws Exception {
    }

    protected void preVisitRequest(Request request) throws Exception {
    }

    public void visit(Request request) throws Exception {
        this.preVisitRequest(request);
        this.visitRequest(request);
        this.postVisitRequest(request);
    }

    protected void visitRequest(Request request) throws Exception {
        AbstractType type;
        Block block;
        Iterator iter = request.getParameters();
        while (iter.hasNext()) {
            ((Parameter)iter.next()).accept(this);
        }
        iter = request.getBodyBlocks();
        while (iter.hasNext()) {
            block = (Block)iter.next();
            type = block.getType();
            if (type.isSOAPType()) {
                ((SOAPType)type).accept(this);
            } else if (type.isLiteralType()) {
                ((LiteralType)type).accept(this);
            }
            this.requestBodyBlock(block);
        }
        iter = request.getHeaderBlocks();
        while (iter.hasNext()) {
            block = (Block)iter.next();
            type = block.getType();
            if (type.isSOAPType()) {
                ((SOAPType)type).accept(this);
            } else if (type.isLiteralType()) {
                ((LiteralType)type).accept(this);
            }
            this.requestHeaderBlock(block);
        }
    }

    protected void postVisitResponse(Response response) throws Exception {
    }

    protected void preVisitResponse(Response response) throws Exception {
    }

    public void visit(Response response) throws Exception {
        this.preVisitResponse(response);
        this.visitResponse(response);
        this.postVisitResponse(response);
    }

    protected void visitResponse(Response response) throws Exception {
        AbstractType type;
        Block block;
        Iterator iter = response.getParameters();
        while (iter.hasNext()) {
            ((Parameter)iter.next()).accept(this);
        }
        iter = response.getBodyBlocks();
        while (iter.hasNext()) {
            block = (Block)iter.next();
            type = block.getType();
            if (type.isSOAPType()) {
                ((SOAPType)type).accept(this);
            } else if (type.isLiteralType()) {
                ((LiteralType)type).accept(this);
            }
            this.responseBodyBlock(block);
        }
        iter = response.getHeaderBlocks();
        while (iter.hasNext()) {
            block = (Block)iter.next();
            type = block.getType();
            if (type.isSOAPType()) {
                ((SOAPType)type).accept(this);
            } else if (type.isLiteralType()) {
                ((LiteralType)type).accept(this);
            }
            this.responseHeaderBlock(block);
        }
        iter = response.getAttachmentBlocks();
        while (iter.hasNext()) {
            block = (Block)iter.next();
            type = block.getType();
            if (type.isSOAPType()) {
                ((SOAPType)type).accept(this);
            } else if (type.isLiteralType()) {
                ((LiteralType)type).accept(this);
            }
            this.responseAttachmentBlock(block);
        }
    }

    protected void postVisitService(Service service) throws Exception {
        Iterator extraTypes = this.model.getExtraTypes();
        while (extraTypes.hasNext()) {
            AbstractType type = (AbstractType)extraTypes.next();
            if (type.isSOAPType()) {
                ((SOAPType)type).accept(this);
                continue;
            }
            if (!type.isLiteralType()) continue;
            ((LiteralType)type).accept(this);
        }
        this.servicePackage = null;
    }

    protected void preVisitService(Service service) throws Exception {
        this.servicePackage = Names.getPackageName(service);
    }

    public void visit(Service service) throws Exception {
        this.preVisitService(service);
        this.visitService(service);
        this.postVisitService(service);
    }

    protected void visitService(Service service) throws Exception {
        this.service = service;
        Iterator ports = service.getPorts();
        while (ports.hasNext()) {
            ((Port)ports.next()).accept(this);
        }
        this.service = null;
    }

    protected void postVisitLiteralAllType(LiteralAllType type) throws Exception {
    }

    protected void preVisitLiteralAllType(LiteralAllType type) throws Exception {
    }

    public void visit(LiteralAllType type) throws Exception {
        this.preVisitLiteralAllType(type);
        this.visitLiteralAllType(type);
        this.postVisitLiteralAllType(type);
    }

    protected void visitLiteralAllType(LiteralAllType type) throws Exception {
        if (!this.visitedTypes.contains(type)) {
            this.visitedTypes.add(type);
            if (type.getParentType() != null) {
                type.getParentType().accept(this);
            }
            Iterator attributes = type.getAttributeMembers();
            while (attributes.hasNext()) {
                LiteralAttributeMember attribute = (LiteralAttributeMember)attributes.next();
                attribute.getType().accept(this);
            }
            Iterator elements = type.getElementMembers();
            while (elements.hasNext()) {
                LiteralElementMember element = (LiteralElementMember)elements.next();
                element.getType().accept(this);
            }
            Iterator subTypes = type.getSubtypes();
            while (subTypes != null && subTypes.hasNext()) {
                ((LiteralStructuredType)subTypes.next()).accept(this);
            }
        }
    }

    protected void postVisitLiteralArrayType(LiteralArrayType type) throws Exception {
    }

    protected void preVisitLiteralArrayType(LiteralArrayType type) throws Exception {
    }

    public void visit(LiteralArrayType type) throws Exception {
        this.preVisitLiteralArrayType(type);
        this.visitLiteralArrayType(type);
        this.postVisitLiteralArrayType(type);
    }

    protected void visitLiteralArrayType(LiteralArrayType type) throws Exception {
        type.getElementType().accept(this);
    }

    protected void postVisitLiteralArrayWrapperType(LiteralArrayWrapperType type) throws Exception {
    }

    protected void preVisitLiteralArrayWrapperType(LiteralArrayWrapperType type) throws Exception {
    }

    public void visit(LiteralArrayWrapperType type) throws Exception {
        this.preVisitLiteralArrayWrapperType(type);
        this.visitLiteralArrayWrapperType(type);
        this.postVisitLiteralArrayWrapperType(type);
    }

    protected void visitLiteralArrayWrapperType(LiteralArrayWrapperType type) throws Exception {
        type.getElementMember().getType().accept(this);
    }

    protected void postVisitLiteralAttachmentType(LiteralAttachmentType type) throws Exception {
    }

    protected void preVisitLiteralAttachmentType(LiteralAttachmentType type) throws Exception {
    }

    public void visit(LiteralAttachmentType type) throws Exception {
        this.preVisitLiteralAttachmentType(type);
        this.visitLiteralAttachmentType(type);
        this.postVisitLiteralAttachmentType(type);
    }

    protected void visitLiteralAttachmentType(LiteralAttachmentType type) throws Exception {
    }

    public void postVisitLiteralEnumerationType(LiteralEnumerationType type) throws Exception {
    }

    public void preVisitLiteralEnumerationType(LiteralEnumerationType type) throws Exception {
    }

    public void visit(LiteralEnumerationType type) throws Exception {
        this.preVisitLiteralEnumerationType(type);
        this.visitLiteralEnumerationType(type);
        this.postVisitLiteralEnumerationType(type);
    }

    public void visitLiteralEnumerationType(LiteralEnumerationType type) throws Exception {
        type.getBaseType().accept(this);
    }

    protected void postVisitLiteralFragmentType(LiteralFragmentType type) throws Exception {
    }

    protected void preVisitLiteralFragmentType(LiteralFragmentType type) throws Exception {
    }

    public void visit(LiteralFragmentType type) throws Exception {
        this.preVisitLiteralFragmentType(type);
        this.visitLiteralFragmentType(type);
        this.postVisitLiteralFragmentType(type);
    }

    protected void visitLiteralFragmentType(LiteralFragmentType type) throws Exception {
    }

    public void visit(LiteralIDType type) throws Exception {
    }

    private void postVisitLiteralListType(LiteralListType type) {
    }

    private void preVisitLiteralListType(LiteralListType type) {
    }

    public void visit(LiteralListType type) throws Exception {
        this.preVisitLiteralListType(type);
        this.visitLiteralListType(type);
        this.postVisitLiteralListType(type);
    }

    protected void visitLiteralListType(LiteralListType type) throws Exception {
        LiteralType itemType = type.getItemType();
        itemType.accept(this);
    }

    protected void postVisitLiteralSequenceType(LiteralSequenceType type) throws Exception {
    }

    protected void preVisitLiteralSequenceType(LiteralSequenceType type) throws Exception {
    }

    public void visit(LiteralSequenceType type) throws Exception {
        this.preVisitLiteralSequenceType(type);
        this.visitLiteralSequenceType(type);
        this.postVisitLiteralSequenceType(type);
    }

    protected void visitLiteralSequenceType(LiteralSequenceType type) throws Exception {
        if (!this.visitedTypes.contains(type)) {
            this.visitedTypes.add(type);
            if (type.getParentType() != null) {
                type.getParentType().accept(this);
            }
            Iterator attributes = type.getAttributeMembers();
            while (attributes.hasNext()) {
                LiteralAttributeMember attribute = (LiteralAttributeMember)attributes.next();
                attribute.getType().accept(this);
            }
            Iterator elements = type.getElementMembers();
            while (elements.hasNext()) {
                LiteralElementMember element = (LiteralElementMember)elements.next();
                element.getType().accept(this);
            }
            Iterator subTypes = type.getSubtypes();
            while (subTypes != null && subTypes.hasNext()) {
                ((LiteralStructuredType)subTypes.next()).accept(this);
            }
        }
    }

    protected void postVisitLiteralSimpleType(LiteralSimpleType type) throws Exception {
    }

    protected void preVisitLiteralSimpleType(LiteralSimpleType type) throws Exception {
    }

    public void visit(LiteralSimpleType type) throws Exception {
        this.preVisitLiteralSimpleType(type);
        this.visitLiteralSimpleType(type);
        this.postVisitLiteralSimpleType(type);
    }

    protected void visitLiteralSimpleType(LiteralSimpleType type) throws Exception {
    }

    protected void postVisitRPCRequestOrderedStructureType(RPCRequestOrderedStructureType type) throws Exception {
        this.postVisitSOAPStructureType(type);
    }

    protected void preVisitRPCRequestOrderedStructureType(RPCRequestOrderedStructureType type) throws Exception {
        this.preVisitSOAPStructureType(type);
    }

    public void visit(RPCRequestOrderedStructureType type) throws Exception {
        this.preVisitRPCRequestOrderedStructureType(type);
        this.visitRPCRequestOrderedStructureType(type);
        this.postVisitRPCRequestOrderedStructureType(type);
    }

    protected void visitRPCRequestOrderedStructureType(RPCRequestOrderedStructureType type) throws Exception {
        this.visit((SOAPStructureType)type);
    }

    protected void postVisitRPCRequestUnorderedStructureType(RPCRequestUnorderedStructureType type) throws Exception {
        this.postVisitSOAPStructureType(type);
    }

    protected void preVisitRPCRequestUnorderedStructureType(RPCRequestUnorderedStructureType type) throws Exception {
        this.preVisitSOAPStructureType(type);
    }

    public void visit(RPCRequestUnorderedStructureType type) throws Exception {
        this.preVisitRPCRequestUnorderedStructureType(type);
        this.visitRPCRequestUnorderedStructureType(type);
        this.postVisitRPCRequestUnorderedStructureType(type);
    }

    protected void visitRPCRequestUnorderedStructureType(RPCRequestUnorderedStructureType type) throws Exception {
        this.visit((SOAPStructureType)type);
    }

    protected void postVisitRPCResponseStructureType(RPCResponseStructureType type) throws Exception {
        this.postVisitSOAPStructureType(type);
    }

    protected void preVisitRPCResponseStructureType(RPCResponseStructureType type) throws Exception {
        this.preVisitSOAPStructureType(type);
    }

    public void visit(RPCResponseStructureType type) throws Exception {
        this.preVisitRPCResponseStructureType(type);
        this.visitRPCResponseStructureType(type);
        this.postVisitRPCResponseStructureType(type);
    }

    protected void visitRPCResponseStructureType(RPCResponseStructureType type) throws Exception {
        this.visit((SOAPStructureType)type);
    }

    protected void postVisitSOAPAnyType(SOAPAnyType type) throws Exception {
    }

    protected void preVisitSOAPAnyType(SOAPAnyType type) throws Exception {
    }

    public void visit(SOAPAnyType type) throws Exception {
        this.preVisitSOAPAnyType(type);
        this.visitSOAPAnyType(type);
        this.postVisitSOAPAnyType(type);
    }

    protected void visitSOAPAnyType(SOAPAnyType type) throws Exception {
    }

    protected void postVisitSOAPArrayType(SOAPArrayType type) throws Exception {
    }

    protected void preVisitSOAPArrayType(SOAPArrayType type) throws Exception {
    }

    public void visit(SOAPArrayType type) throws Exception {
        this.preVisitSOAPArrayType(type);
        this.visitSOAPArrayType(type);
        this.postVisitSOAPArrayType(type);
    }

    protected void visitSOAPArrayType(SOAPArrayType type) throws Exception {
        SOAPType elemType = type.getElementType();
        elemType.accept(this);
    }

    protected void postVisitSOAPCustomType(SOAPCustomType type) throws Exception {
    }

    protected void preVisitSOAPCustomType(SOAPCustomType type) throws Exception {
    }

    public void visit(SOAPCustomType type) throws Exception {
        this.preVisitSOAPCustomType(type);
        this.visitSOAPCustomType(type);
        this.postVisitSOAPCustomType(type);
    }

    protected void visitSOAPCustomType(SOAPCustomType type) throws Exception {
    }

    protected void postVisitSOAPEnumerationType(SOAPEnumerationType type) throws Exception {
    }

    protected void preVisitSOAPEnumerationType(SOAPEnumerationType type) throws Exception {
    }

    public void visit(SOAPEnumerationType type) throws Exception {
        this.preVisitSOAPEnumerationType(type);
        this.visitSOAPEnumerationType(type);
        this.postVisitSOAPEnumerationType(type);
    }

    protected void visitSOAPEnumerationType(SOAPEnumerationType type) throws Exception {
    }

    private void postVisitSOAPListType(SOAPListType type) {
    }

    private void preVisitSOAPListType(SOAPListType type) {
    }

    public void visit(SOAPListType type) throws Exception {
        this.preVisitSOAPListType(type);
        this.visitSOAPListType(type);
        this.postVisitSOAPListType(type);
    }

    protected void visitSOAPListType(SOAPListType type) throws Exception {
        SOAPType itemType = type.getItemType();
        itemType.accept(this);
    }

    protected void postVisitSOAPOrderedStructureType(SOAPOrderedStructureType type) throws Exception {
        this.postVisitSOAPStructureType(type);
    }

    protected void preVisitSOAPOrderedStructureType(SOAPOrderedStructureType type) throws Exception {
        this.preVisitSOAPStructureType(type);
    }

    public void visit(SOAPOrderedStructureType type) throws Exception {
        this.preVisitSOAPOrderedStructureType(type);
        this.visitSOAPOrderedStructureType(type);
        this.postVisitSOAPOrderedStructureType(type);
    }

    protected void visitSOAPOrderedStructureType(SOAPOrderedStructureType type) throws Exception {
        this.visit((SOAPStructureType)type);
    }

    protected void postVisitSOAPSimpleType(SOAPSimpleType type) throws Exception {
    }

    protected void preVisitSOAPSimpleType(SOAPSimpleType type) throws Exception {
    }

    public void visit(SOAPSimpleType type) throws Exception {
        this.preVisitSOAPSimpleType(type);
        this.visitSOAPSimpleType(type);
        this.postVisitSOAPSimpleType(type);
    }

    protected void visitSOAPSimpleType(SOAPSimpleType type) throws Exception {
    }

    protected void postVisitSOAPStructureType(SOAPStructureType type) throws Exception {
    }

    protected void preVisitSOAPStructureType(SOAPStructureType type) throws Exception {
    }

    public void visit(SOAPStructureType type) throws Exception {
        this.preVisitSOAPStructureType(type);
        this.visitSOAPStructureType(type);
        this.postVisitSOAPStructureType(type);
    }

    protected void visitSOAPStructureType(SOAPStructureType type) throws Exception {
        if (!this.visitedTypes.contains(type)) {
            this.visitedTypes.add(type);
            if (type.getParentType() != null) {
                type.getParentType().accept(this);
            }
            Iterator members = type.getMembers();
            while (members.hasNext()) {
                SOAPStructureMember member = (SOAPStructureMember)members.next();
                member.getType().accept(this);
            }
            Iterator attributes = type.getAttributeMembers();
            while (attributes.hasNext()) {
                SOAPAttributeMember attribute = (SOAPAttributeMember)attributes.next();
                attribute.getType().accept(this);
            }
            Iterator subTypes = type.getSubtypes();
            while (subTypes != null && subTypes.hasNext()) {
                ((SOAPStructureType)subTypes.next()).accept(this);
            }
        }
    }

    protected void postVisitSOAPUnorderedStructureType(SOAPUnorderedStructureType type) throws Exception {
        this.postVisitSOAPStructureType(type);
    }

    protected void preVisitSOAPUnorderedStructureType(SOAPUnorderedStructureType type) throws Exception {
        this.preVisitSOAPStructureType(type);
    }

    public void visit(SOAPUnorderedStructureType type) throws Exception {
        this.preVisitSOAPUnorderedStructureType(type);
        this.visitSOAPUnorderedStructureType(type);
        this.postVisitSOAPUnorderedStructureType(type);
    }

    protected void visitSOAPUnorderedStructureType(SOAPUnorderedStructureType type) throws Exception {
        this.visit((SOAPStructureType)type);
    }

    protected void writeWarning(IndentingWriter p) throws IOException {
        GeneratorBase.writeWarning(p, this.JAXRPCVersion, this.targetVersion);
    }

    protected static void fail(Localizable arg) {
        throw new GeneratorException("generator.nestedGeneratorError", arg);
    }

    protected static void fail(String key) {
        throw new GeneratorException(key);
    }

    protected void info(String key) {
        this.env.info(this.messageFactory.getMessage(key));
    }

    protected void log(String msg) {
        if (this.env.verbose()) {
            System.out.println("[" + Names.stripQualifier(this.getClass().getName()) + ": " + msg + "]");
        }
    }

    protected void warn(String key) {
        this.env.warn(this.messageFactory.getMessage(key));
    }

    protected static void fail(Throwable arg) {
        throw new GeneratorException("generator.nestedGeneratorError", new LocalizableExceptionAdapter(arg));
    }

    protected void warn(String key, Object[] args) {
        this.env.warn(this.messageFactory.getMessage(key, args));
    }

    public void writePackage(IndentingWriter p, String classNameStr) throws IOException {
        GeneratorBase.writePackage(p, classNameStr, this.JAXRPCVersion, this.targetVersion);
    }

    public static void writePackageOnly(IndentingWriter p, String classNameStr) throws IOException {
        int idx = classNameStr.lastIndexOf(".");
        if (idx > 0) {
            p.pln("package " + classNameStr.substring(0, idx) + ";");
            p.pln();
        }
    }

    protected static void fail(String key, String arg) {
        throw new GeneratorException(key, arg);
    }

    protected void info(String key, String arg) {
        this.env.info(this.messageFactory.getMessage(key, arg));
    }

    protected void warn(String key, String arg) {
        this.env.warn(this.messageFactory.getMessage(key, arg));
    }

    public static void writeWarning(IndentingWriter p, String version, String targetVersion) throws IOException {
        p.pln("// This class was generated by the JAXRPC SI, do not edit.");
        p.pln("// Contents subject to change without notice.");
        p.pln("// " + version);
        p.pln("// Generated source version: " + targetVersion);
        p.pln();
    }

    protected static void fail(String key, String arg1, String arg2) {
        throw new GeneratorException(key, new Object[]{arg1, arg2});
    }

    protected GeneratorBase(Model model, Configuration config, Properties properties) {
        this.model = model;
        this.env = (ProcessorEnvironment)config.getEnvironment();
        String key = "destinationDirectory";
        String dirPath = properties.getProperty(key);
        this.destDir = new File(dirPath);
        key = "sourceDirectory";
        String sourcePath = properties.getProperty(key);
        this.sourceDir = new File(sourcePath);
        key = "nonclassDestinationDirectory";
        String nonclassDestPath = properties.getProperty(key);
        this.nonclassDestDir = new File(nonclassDestPath);
        key = "encodeTypes";
        this.encodeTypes = Boolean.valueOf(properties.getProperty(key));
        key = "multiRefEncoding";
        this.multiRefEncoding = Boolean.valueOf(properties.getProperty(key));
        this.messageFactory = new LocalizableMessageFactory("com.sun.xml.rpc.resources.generator");
        key = "serializerInterfaces";
        this.serializeInterfaces = Boolean.valueOf(properties.getProperty(key));
        this.JAXRPCVersion = properties.getProperty("JAXRPC Version");
        this.targetVersion = properties.getProperty("sourceVersion");
        key = "serializable";
        this.generateSerializableIf = Boolean.valueOf(properties.getProperty(key));
        key = "donotOverride";
        this.donotOverride = Boolean.valueOf(properties.getProperty(key));
    }

    public void perform(Model model, Configuration config, Properties properties) {
        ProcessorEnvironment env = (ProcessorEnvironment)config.getEnvironment();
        String key = "destinationDirectory";
        String dirPath = properties.getProperty(key);
        File destDir = new File(dirPath);
        key = "sourceDirectory";
        String sourcePath = properties.getProperty(key);
        File sourceDir = new File(sourcePath);
        key = "nonclassDestinationDirectory";
        String nonclassDestPath = properties.getProperty(key);
        File nonclassDestDir = new File(nonclassDestPath);
        GeneratorBase generator = this.getGenerator(model, config, properties);
        generator.doGeneration();
    }

    public abstract GeneratorBase getGenerator(Model var1, Configuration var2, Properties var3);

    public static void writePackage(IndentingWriter p, String classNameStr, String version, String sourceVersion) throws IOException {
        GeneratorBase.writeWarning(p, version, sourceVersion);
        GeneratorBase.writePackageOnly(p, classNameStr);
    }

    public abstract GeneratorBase getGenerator(Model var1, Configuration var2, Properties var3, SOAPVersion var4);
}

