/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javahelp;

import java.io.IOException;
import java.net.URL;
import javax.help.HelpSet;
import javax.help.HelpSetException;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.SwingUtilities;
import org.netbeans.modules.javahelp.Installer;
import org.netbeans.modules.javahelp.NbDocsStreamHandler;
import org.openide.cookies.InstanceCookie;
import org.openide.loaders.XMLDataObject;
import org.openide.util.Lookup;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public final class HelpSetProcessor
implements XMLDataObject.Processor,
InstanceCookie.Of {
    public static final String HELPSET_MERGE_CONTEXT = "OpenIDE";
    public static final String HELPSET_MERGE_ATTR = "mergeIntoMaster";
    public static final BoundedRangeModel parseModel = new DefaultBoundedRangeModel(0, 0, 0, 0);
    private XMLDataObject xml;
    private HelpSet hs;

    public void attachTo(XMLDataObject xml) {
        if (this.xml == xml) {
            return;
        }
        this.hs = null;
        this.xml = xml;
        Installer.err.log("processing help set ref: " + xml.getPrimaryFile());
        BPMChanger.invoke(0);
    }

    protected void finalize() {
        BPMChanger.invoke(1);
    }

    public Class instanceClass() throws IOException, ClassNotFoundException {
        return HelpSet.class;
    }

    public String instanceName() {
        return "javax.help.HelpSet";
    }

    public boolean instanceOf(Class type) {
        return type == HelpSet.class;
    }

    public synchronized Object instanceCreate() throws IOException, ClassNotFoundException {
        if (this.hs == null) {
            Installer.err.log("creating help set from ref: " + this.xml.getPrimaryFile());
            try {
                Document doc = this.xml.getDocument();
                Element el = doc.getDocumentElement();
                if (!el.getNodeName().equals("helpsetref")) {
                    throw new IOException();
                }
                String url = el.getAttribute("url");
                if (url == null || url.equals("")) {
                    throw new IOException("no url attr on <helpsetref>! doc.class=" + doc.getClass().getName() + " doc.documentElement=" + el);
                }
                String mergeS = el.getAttribute("merge");
                boolean merge = mergeS == null || mergeS.equals("") || Boolean.valueOf(mergeS) != false;
                Class ignore = NbDocsStreamHandler.class;
                this.hs = new HelpSet((ClassLoader)Lookup.getDefault().lookup(ClassLoader.class), new URL(url));
                this.hs.setKeyData(HELPSET_MERGE_CONTEXT, HELPSET_MERGE_ATTR, merge ? Boolean.TRUE : Boolean.FALSE);
                BPMChanger.invoke(2);
            }
            catch (SAXException saxe) {
                IOException ioe = new IOException(saxe.toString());
                Installer.err.annotate((Throwable)ioe, (Throwable)saxe);
                throw ioe;
            }
            catch (HelpSetException hse) {
                IOException ioe = new IOException(hse.toString());
                Installer.err.annotate((Throwable)ioe, (Throwable)hse);
                throw ioe;
            }
        }
        return this.hs;
    }

    private static final class BPMChanger
    implements Runnable {
        public static final int INC_MAXIMUM = 0;
        public static final int DEC_VALUE_AND_MAXIMUM = 1;
        public static final int INC_VALUE = 2;
        private final int action;

        public static void invoke(int action) {
            SwingUtilities.invokeLater(new BPMChanger(action));
        }

        private BPMChanger(int action) {
            this.action = action;
        }

        public void run() {
            switch (this.action) {
                case 0: {
                    parseModel.setMaximum(parseModel.getMaximum() + 1);
                    break;
                }
                case 1: {
                    parseModel.setValue(parseModel.getValue() - 1);
                    parseModel.setMaximum(parseModel.getMaximum() - 1);
                    break;
                }
                case 2: {
                    parseModel.setValue(parseModel.getValue() + 1);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
    }
}

