/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.retriever.catalog.impl;

import java.io.IOException;
import java.util.WeakHashMap;
import java.util.logging.Logger;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.xml.retriever.catalog.CatalogWriteModel;
import org.netbeans.modules.xml.retriever.catalog.CatalogWriteModelFactory;
import org.netbeans.modules.xml.retriever.catalog.Utilities;
import org.netbeans.modules.xml.retriever.catalog.impl.CatalogModelImpl;
import org.netbeans.modules.xml.retriever.catalog.impl.CatalogWriteModelImpl;
import org.netbeans.modules.xml.retriever.catalog.impl.LSResourceResolverImpl;
import org.netbeans.modules.xml.xam.ModelSource;
import org.netbeans.modules.xml.xam.locator.CatalogModel;
import org.netbeans.modules.xml.xam.locator.CatalogModelException;
import org.openide.filesystems.FileObject;
import org.w3c.dom.ls.LSResourceResolver;

public class CatalogModelFactoryImpl
extends CatalogWriteModelFactory {
    private static Logger logger = Utilities.getLogger();
    private static WeakHashMap<Project, CatalogWriteModel> projcat = new WeakHashMap();
    private static WeakHashMap<Project, CatalogModel> proj2cm = new WeakHashMap();

    public CatalogWriteModel getCatalogWriteModelForProject(FileObject anyFileObjectExistingInAProject) throws CatalogModelException {
        logger.entering("CatalogModelFactoryImpl", "getCatalogModelForProject");
        Project project = FileOwnerQuery.getOwner((FileObject)anyFileObjectExistingInAProject);
        assert (project != null);
        CatalogWriteModelImpl result = null;
        try {
            result = new CatalogWriteModelImpl(project);
        }
        catch (IOException ex) {
            throw new CatalogModelException((Throwable)ex);
        }
        return result;
    }

    public CatalogModel getCatalogModel(ModelSource modelSource) throws CatalogModelException {
        if (modelSource == null) {
            throw new IllegalArgumentException("modelSource arg is null.");
        }
        CatalogModel catalogModel = (CatalogModel)modelSource.getLookup().lookup(CatalogModel.class);
        if (catalogModel == null) {
            FileObject fo = (FileObject)modelSource.getLookup().lookup(FileObject.class);
            if (fo == null) {
                throw new IllegalArgumentException("ModelSource must have FileObject in its lookup");
            }
            return this.getCatalogModel(fo);
        }
        return catalogModel;
    }

    public CatalogModel getCatalogModel(FileObject fo) throws CatalogModelException {
        CatalogModelImpl catalogModel = null;
        Project project = FileOwnerQuery.getOwner((FileObject)fo);
        if (project != null) {
            catalogModel = proj2cm.get(fo);
            if (catalogModel != null) {
                return catalogModel;
            }
            try {
                catalogModel = new CatalogModelImpl(project);
            }
            catch (IOException ex) {
                throw new CatalogModelException((Throwable)ex);
            }
            return catalogModel;
        }
        catalogModel = new CatalogModelImpl();
        return catalogModel;
    }

    public LSResourceResolver getLSResourceResolver() {
        return new LSResourceResolverImpl();
    }

    public CatalogWriteModel getCatalogWriteModelForCatalogFile(FileObject fileObjectOfCatalogFile) throws CatalogModelException {
        try {
            return new CatalogWriteModelImpl(fileObjectOfCatalogFile);
        }
        catch (IOException ex) {
            throw new CatalogModelException((Throwable)ex);
        }
    }
}

