/*
 * Decompiled with CFR 0.152.
 */
package javax.mail;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;
import java.util.Vector;
import javax.mail.SecuritySupport;

class SecuritySupport12
extends SecuritySupport {
    SecuritySupport12() {
    }

    public ClassLoader getContextClassLoader() {
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ClassLoader classLoader = null;
                try {
                    classLoader = Thread.currentThread().getContextClassLoader();
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                return classLoader;
            }
        });
    }

    public InputStream getResourceAsStream(final Class clazz, final String string) throws IOException {
        try {
            return (InputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    return clazz.getResourceAsStream(string);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
    }

    public URL[] getResources(final ClassLoader classLoader, final String string) {
        return (URL[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Object[] objectArray = null;
                try {
                    Vector<URL> vector = new Vector<URL>();
                    Enumeration<URL> enumeration = classLoader.getResources(string);
                    while (enumeration != null && enumeration.hasMoreElements()) {
                        URL uRL = enumeration.nextElement();
                        if (uRL == null) continue;
                        vector.addElement(uRL);
                    }
                    if (vector.size() > 0) {
                        objectArray = new URL[vector.size()];
                        vector.copyInto(objectArray);
                    }
                }
                catch (IOException iOException) {
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                return objectArray;
            }
        });
    }

    public URL[] getSystemResources(final String string) {
        return (URL[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Object[] objectArray = null;
                try {
                    Vector<URL> vector = new Vector<URL>();
                    Enumeration<URL> enumeration = ClassLoader.getSystemResources(string);
                    while (enumeration != null && enumeration.hasMoreElements()) {
                        URL uRL = enumeration.nextElement();
                        if (uRL == null) continue;
                        vector.addElement(uRL);
                    }
                    if (vector.size() > 0) {
                        objectArray = new URL[vector.size()];
                        vector.copyInto(objectArray);
                    }
                }
                catch (IOException iOException) {
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                return objectArray;
            }
        });
    }

    public InputStream openStream(final URL uRL) throws IOException {
        try {
            return (InputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    return uRL.openStream();
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
    }
}

