/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.imap;

import com.sun.mail.iap.BadCommandException;
import com.sun.mail.iap.CommandFailedException;
import com.sun.mail.iap.ConnectionException;
import com.sun.mail.iap.ProtocolException;
import com.sun.mail.iap.Response;
import com.sun.mail.iap.ResponseHandler;
import com.sun.mail.imap.ACL;
import com.sun.mail.imap.DefaultFolder;
import com.sun.mail.imap.IMAPMessage;
import com.sun.mail.imap.IMAPStore;
import com.sun.mail.imap.MessageLiteral;
import com.sun.mail.imap.Quota;
import com.sun.mail.imap.Rights;
import com.sun.mail.imap.Utility;
import com.sun.mail.imap.protocol.FetchResponse;
import com.sun.mail.imap.protocol.IMAPProtocol;
import com.sun.mail.imap.protocol.IMAPResponse;
import com.sun.mail.imap.protocol.ListInfo;
import com.sun.mail.imap.protocol.MailboxInfo;
import com.sun.mail.imap.protocol.MessageSet;
import com.sun.mail.imap.protocol.Status;
import com.sun.mail.imap.protocol.UID;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Date;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.mail.FetchProfile;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.FolderClosedException;
import javax.mail.FolderNotFoundException;
import javax.mail.Message;
import javax.mail.MessageRemovedException;
import javax.mail.MessagingException;
import javax.mail.ReadOnlyFolderException;
import javax.mail.StoreClosedException;
import javax.mail.UIDFolder;
import javax.mail.search.FlagTerm;
import javax.mail.search.SearchException;
import javax.mail.search.SearchTerm;

public class IMAPFolder
extends Folder
implements UIDFolder,
ResponseHandler {
    protected String fullName;
    protected String name;
    protected int type;
    protected char separator;
    protected Flags availableFlags;
    protected Flags permanentFlags;
    protected boolean exists = false;
    protected boolean isNamespace = false;
    protected IMAPProtocol protocol;
    protected Vector messageCache;
    protected Object messageCacheLock;
    protected Hashtable uidTable;
    protected static final char UNKNOWN_SEPARATOR = '\uffff';
    private boolean opened = false;
    private boolean reallyClosed = true;
    private int total = -1;
    private int recent = -1;
    private int realTotal = -1;
    private int uidvalidity = -1;
    private boolean doExpungeNotification = true;
    private Status cachedStatus = null;
    private long cachedStatusTime = 0L;
    private boolean debug = false;
    private PrintStream out;
    private boolean connectionPoolDebug;

    protected IMAPFolder(String string, char c, IMAPStore iMAPStore) {
        this(string, c, iMAPStore, false);
    }

    protected IMAPFolder(String string, char c, IMAPStore iMAPStore, boolean bl) {
        super(iMAPStore);
        if (string == null) {
            throw new NullPointerException("Folder name is null");
        }
        this.fullName = string;
        this.separator = c;
        this.isNamespace = bl;
        this.messageCacheLock = new Object();
        this.debug = iMAPStore.getSession().getDebug();
        this.connectionPoolDebug = iMAPStore.getConnectionPoolDebug();
        this.out = iMAPStore.getSession().getDebugOut();
        if (this.out == null) {
            this.out = System.out;
        }
    }

    protected IMAPFolder(ListInfo listInfo, IMAPStore iMAPStore) {
        this(listInfo.name, listInfo.separator, iMAPStore);
        if (listInfo.hasInferiors) {
            this.type |= 2;
        }
        if (listInfo.canOpen) {
            this.type |= 1;
        }
        this.exists = true;
    }

    private void checkExists() throws MessagingException {
        if (!this.exists && !this.exists()) {
            throw new FolderNotFoundException(this, this.fullName + " not found");
        }
    }

    private void checkClosed() {
        if (this.opened) {
            throw new IllegalStateException("This operation is not allowed on an open folder");
        }
    }

    private void checkOpened() throws FolderClosedException {
        if (!this.opened) {
            if (this.reallyClosed) {
                throw new IllegalStateException("This operation is not allowed on a closed folder");
            }
            throw new FolderClosedException(this, "Lost folder connection to server");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkRange(int n) throws MessagingException {
        if (n < 1) {
            throw new IndexOutOfBoundsException();
        }
        if (n <= this.total) {
            return;
        }
        Object object = this.messageCacheLock;
        synchronized (object) {
            try {
                this.keepConnectionAlive(false);
            }
            catch (ConnectionException connectionException) {
                throw new FolderClosedException(this, connectionException.getMessage());
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), protocolException);
            }
        }
        if (n > this.total) {
            throw new IndexOutOfBoundsException();
        }
    }

    private void checkFlags(Flags flags) throws MessagingException {
        if (this.mode != 2) {
            throw new IllegalStateException("Cannot change flags on READ_ONLY folder: " + this.fullName);
        }
        if (!this.availableFlags.contains(flags)) {
            throw new MessagingException("These flags are not supported by this implementation");
        }
    }

    public String getName() {
        if (this.name == null) {
            try {
                this.name = this.fullName.substring(this.fullName.lastIndexOf(this.getSeparator0()) + 1);
            }
            catch (MessagingException messagingException) {
                // empty catch block
            }
        }
        return this.name;
    }

    public String getFullName() {
        return this.fullName;
    }

    public Folder getParent() throws MessagingException {
        char c = this.getSeparator0();
        int n = this.fullName.lastIndexOf(c);
        if (n != -1) {
            return new IMAPFolder(this.fullName.substring(0, n), c, (IMAPStore)this.store);
        }
        return new DefaultFolder((IMAPStore)this.store);
    }

    public boolean exists() throws MessagingException {
        ListInfo[] listInfoArray = null;
        final String string = this.isNamespace && this.separator != '\u0000' ? this.fullName + this.separator : this.fullName;
        listInfoArray = (ListInfo[])this.doCommand(new ProtocolCommand(){

            public Object doCommand(IMAPProtocol iMAPProtocol) throws ProtocolException {
                return iMAPProtocol.list("", string);
            }
        });
        if (listInfoArray != null) {
            int n = this.findName(listInfoArray, string);
            this.fullName = listInfoArray[n].name;
            this.separator = listInfoArray[n].separator;
            int n2 = this.fullName.length();
            if (this.separator != '\u0000' && n2 > 0 && this.fullName.charAt(n2 - 1) == this.separator) {
                this.fullName = this.fullName.substring(0, n2 - 1);
            }
            if (listInfoArray[n].hasInferiors) {
                this.type |= 2;
            }
            if (listInfoArray[n].canOpen) {
                this.type |= 1;
            }
            this.exists = true;
        } else {
            this.exists = false;
        }
        return this.exists;
    }

    private int findName(ListInfo[] listInfoArray, String string) {
        int n;
        for (n = 0; n < listInfoArray.length && !listInfoArray[n].name.equals(string); ++n) {
        }
        if (n >= listInfoArray.length) {
            n = 0;
        }
        return n;
    }

    public Folder[] list(String string) throws MessagingException {
        return this.doList(string, false);
    }

    public Folder[] listSubscribed(String string) throws MessagingException {
        return this.doList(string, true);
    }

    private Folder[] doList(final String string, final boolean bl) throws MessagingException {
        this.checkExists();
        if (!this.isDirectory()) {
            return new Folder[0];
        }
        final char c = this.getSeparator0();
        ListInfo[] listInfoArray = (ListInfo[])this.doCommandIgnoreFailure(new ProtocolCommand(){

            public Object doCommand(IMAPProtocol iMAPProtocol) throws ProtocolException {
                if (bl) {
                    return iMAPProtocol.lsub("", IMAPFolder.this.fullName + c + string);
                }
                return iMAPProtocol.list("", IMAPFolder.this.fullName + c + string);
            }
        });
        if (listInfoArray == null) {
            return new Folder[0];
        }
        int n = 0;
        if (listInfoArray.length > 0 && listInfoArray[0].name.equals(this.fullName + c)) {
            n = 1;
        }
        Folder[] folderArray = new IMAPFolder[listInfoArray.length - n];
        for (int i = n; i < listInfoArray.length; ++i) {
            folderArray[i - n] = new IMAPFolder(listInfoArray[i], (IMAPStore)this.store);
        }
        return folderArray;
    }

    public synchronized char getSeparator() throws MessagingException {
        this.checkExists();
        return this.getSeparator0();
    }

    private synchronized char getSeparator0() throws MessagingException {
        if (this.separator == '\uffff') {
            ListInfo[] listInfoArray = null;
            listInfoArray = (ListInfo[])this.doCommand(new ProtocolCommand(){

                public Object doCommand(IMAPProtocol iMAPProtocol) throws ProtocolException {
                    if (iMAPProtocol.isREV1()) {
                        return iMAPProtocol.list(IMAPFolder.this.fullName, "");
                    }
                    return iMAPProtocol.list("", IMAPFolder.this.fullName);
                }
            });
            this.separator = listInfoArray != null ? listInfoArray[0].separator : (char)47;
        }
        return this.separator;
    }

    public int getType() throws MessagingException {
        this.checkExists();
        return this.type;
    }

    public boolean isSubscribed() {
        ListInfo[] listInfoArray = null;
        final String string = this.isNamespace && this.separator != '\u0000' ? this.fullName + this.separator : this.fullName;
        try {
            listInfoArray = (ListInfo[])this.doProtocolCommand(new ProtocolCommand(){

                public Object doCommand(IMAPProtocol iMAPProtocol) throws ProtocolException {
                    return iMAPProtocol.lsub("", string);
                }
            });
        }
        catch (ProtocolException protocolException) {
            // empty catch block
        }
        if (listInfoArray != null) {
            int n = this.findName(listInfoArray, string);
            return listInfoArray[n].canOpen;
        }
        return false;
    }

    public void setSubscribed(final boolean bl) throws MessagingException {
        this.checkExists();
        this.doCommandIgnoreFailure(new ProtocolCommand(){

            public Object doCommand(IMAPProtocol iMAPProtocol) throws ProtocolException {
                if (bl) {
                    iMAPProtocol.subscribe(IMAPFolder.this.fullName);
                } else {
                    iMAPProtocol.unsubscribe(IMAPFolder.this.fullName);
                }
                return null;
            }
        });
    }

    public synchronized boolean create(final int n) throws MessagingException {
        char c;
        Object object;
        char c2 = '\u0000';
        if ((n & 1) == 0) {
            c2 = this.getSeparator0();
        }
        if ((object = this.doCommandIgnoreFailure(new ProtocolCommand(c = c2){
            private final /* synthetic */ char val$sep;
            {
                this.val$sep = c;
            }

            public Object doCommand(IMAPProtocol iMAPProtocol) throws ProtocolException {
                if ((n & 1) == 0) {
                    iMAPProtocol.create(IMAPFolder.this.fullName + this.val$sep);
                } else {
                    ListInfo[] listInfoArray;
                    iMAPProtocol.create(IMAPFolder.this.fullName);
                    if ((n & 2) != 0 && (listInfoArray = iMAPProtocol.list("", IMAPFolder.this.fullName)) != null && !listInfoArray[0].hasInferiors) {
                        iMAPProtocol.delete(IMAPFolder.this.fullName);
                        throw new ProtocolException("Unsupported type");
                    }
                }
                return Boolean.TRUE;
            }
        })) == null) {
            return false;
        }
        this.exists = true;
        this.type = n;
        this.notifyFolderListeners(1);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean hasNewMessages() throws MessagingException {
        this.checkExists();
        if (this.opened) {
            Object object = this.messageCacheLock;
            synchronized (object) {
                try {
                    this.keepConnectionAlive(true);
                }
                catch (ConnectionException connectionException) {
                    throw new FolderClosedException(this, connectionException.getMessage());
                }
                catch (ProtocolException protocolException) {
                    throw new MessagingException(protocolException.getMessage(), protocolException);
                }
            }
            return this.recent > 0;
        }
        Boolean bl = (Boolean)this.doCommandIgnoreFailure(new ProtocolCommand(){

            public Object doCommand(IMAPProtocol iMAPProtocol) throws ProtocolException {
                ListInfo[] listInfoArray = iMAPProtocol.list("", IMAPFolder.this.fullName);
                if (listInfoArray != null) {
                    if (listInfoArray[0].changeState == 1) {
                        return Boolean.TRUE;
                    }
                    if (listInfoArray[0].changeState == 2) {
                        return Boolean.FALSE;
                    }
                }
                Status status = IMAPFolder.this.getStatus();
                if (status.recent > 0) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        });
        if (bl == null) {
            return false;
        }
        return bl;
    }

    public Folder getFolder(String string) throws MessagingException {
        if (this.exists && !this.isDirectory()) {
            throw new MessagingException("Cannot contain subfolders");
        }
        char c = this.getSeparator0();
        return new IMAPFolder(this.fullName + c + string, c, (IMAPStore)this.store);
    }

    public synchronized boolean delete(boolean bl) throws MessagingException {
        Object object;
        this.checkClosed();
        if (bl) {
            object = this.list();
            for (int i = 0; i < ((Folder[])object).length; ++i) {
                object[i].delete(bl);
            }
        }
        if ((object = this.doCommandIgnoreFailure(new ProtocolCommand(){

            public Object doCommand(IMAPProtocol iMAPProtocol) throws ProtocolException {
                iMAPProtocol.delete(IMAPFolder.this.fullName);
                return Boolean.TRUE;
            }
        })) == null) {
            return false;
        }
        this.exists = false;
        this.notifyFolderListeners(2);
        return true;
    }

    public synchronized boolean renameTo(final Folder folder) throws MessagingException {
        this.checkClosed();
        this.checkExists();
        if (folder.getStore() != this.store) {
            throw new MessagingException("Can't rename across Stores");
        }
        Object object = this.doCommandIgnoreFailure(new ProtocolCommand(){

            public Object doCommand(IMAPProtocol iMAPProtocol) throws ProtocolException {
                iMAPProtocol.rename(IMAPFolder.this.fullName, folder.getFullName());
                return Boolean.TRUE;
            }
        });
        if (object == null) {
            return false;
        }
        this.exists = false;
        this.notifyFolderRenamedListeners(folder);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void open(int n) throws MessagingException {
        this.checkClosed();
        this.checkExists();
        if ((this.type & 1) == 0) {
            throw new MessagingException("folder cannot contain messages");
        }
        MailboxInfo mailboxInfo = null;
        this.protocol = ((IMAPStore)this.store).getProtocol(this);
        Object object = this.messageCacheLock;
        synchronized (object) {
            this.protocol.addResponseHandler(this);
            try {
                mailboxInfo = n == 1 ? this.protocol.examine(this.fullName) : this.protocol.select(this.fullName);
            }
            catch (CommandFailedException commandFailedException) {
                this.releaseProtocol(true);
                this.protocol = null;
                throw new MessagingException(commandFailedException.getMessage(), commandFailedException);
            }
            catch (ProtocolException protocolException) {
                try {
                    try {
                        this.protocol.logout();
                    }
                    catch (ProtocolException protocolException2) {
                        Object var7_9 = null;
                        this.releaseProtocol(false);
                        this.protocol = null;
                        throw new MessagingException(protocolException.getMessage(), protocolException);
                    }
                    Object var7_8 = null;
                    this.releaseProtocol(false);
                    this.protocol = null;
                    throw new MessagingException(protocolException.getMessage(), protocolException);
                }
                catch (Throwable throwable) {
                    Object var7_10 = null;
                    this.releaseProtocol(false);
                    this.protocol = null;
                    throw new MessagingException(protocolException.getMessage(), protocolException);
                }
            }
            if (!(mailboxInfo.mode == n || n == 2 && mailboxInfo.mode == 1 && ((IMAPStore)this.store).allowReadOnlySelect())) {
                try {
                    try {
                        this.protocol.close();
                        this.releaseProtocol(true);
                    }
                    catch (ProtocolException protocolException) {
                        try {
                            this.protocol.logout();
                        }
                        catch (ProtocolException protocolException3) {
                        }
                        finally {
                            this.releaseProtocol(false);
                        }
                        Object var10_15 = null;
                        this.protocol = null;
                        throw new ReadOnlyFolderException(this, "Cannot open in desired mode");
                    }
                    Object var10_14 = null;
                    this.protocol = null;
                    throw new ReadOnlyFolderException(this, "Cannot open in desired mode");
                }
                catch (Throwable throwable) {
                    Object var10_16 = null;
                    this.protocol = null;
                    throw new ReadOnlyFolderException(this, "Cannot open in desired mode");
                }
            }
            this.opened = true;
            this.reallyClosed = false;
            this.mode = mailboxInfo.mode;
            this.availableFlags = mailboxInfo.availableFlags;
            this.permanentFlags = mailboxInfo.permanentFlags;
            this.total = this.realTotal = mailboxInfo.total;
            this.recent = mailboxInfo.recent;
            this.uidvalidity = mailboxInfo.uidvalidity;
            this.messageCache = new Vector(this.total);
            int i = 0;
            while (true) {
                if (i >= this.total) {
                    // MONITOREXIT @DISABLED, blocks:[18, 19, 8] lbl76 : MonitorExitStatement: MONITOREXIT : object
                    this.notifyConnectionListeners(1);
                    return;
                }
                this.messageCache.addElement(new IMAPMessage(this, i + 1, i + 1));
                ++i;
            }
        }
    }

    public synchronized void fetch(Message[] messageArray, FetchProfile fetchProfile) throws MessagingException {
        this.checkOpened();
        IMAPMessage.fetch(this, messageArray, fetchProfile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setFlags(Message[] messageArray, Flags flags, boolean bl) throws MessagingException {
        this.checkOpened();
        this.checkFlags(flags);
        if (messageArray.length == 0) {
            return;
        }
        Object object = this.messageCacheLock;
        synchronized (object) {
            try {
                MessageSet[] messageSetArray = Utility.toMessageSet(messageArray, null);
                if (messageSetArray == null) {
                    throw new MessageRemovedException("Messages have been removed");
                }
                this.protocol.storeFlags(messageSetArray, flags, bl);
            }
            catch (ConnectionException connectionException) {
                throw new FolderClosedException(this, connectionException.getMessage());
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), protocolException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close(boolean bl) throws MessagingException {
        Object object = this.messageCacheLock;
        synchronized (object) {
            block19: {
                if (!this.opened && this.reallyClosed) {
                    throw new IllegalStateException("This operation is not allowed on a closed folder");
                }
                this.reallyClosed = true;
                if (!this.opened) {
                    return;
                }
                try {
                    block20: {
                        if (((IMAPStore)this.store).isConnectionPoolFull()) {
                            if (this.debug) {
                                this.out.println("DEBUG: pool is full, not adding an Authenticated connection");
                            }
                            if (bl) {
                                this.protocol.close();
                            }
                            if (this.protocol != null) {
                                this.protocol.logout();
                            }
                            break block19;
                        }
                        if (!bl && this.mode == 2) {
                            try {
                                MailboxInfo mailboxInfo = this.protocol.examine(this.fullName);
                            }
                            catch (ProtocolException protocolException) {
                                if (this.protocol == null) break block20;
                                this.protocol.disconnect();
                            }
                        }
                    }
                    if (this.protocol != null) {
                        this.protocol.close();
                    }
                }
                catch (ProtocolException protocolException) {
                    throw new MessagingException(protocolException.getMessage(), protocolException);
                }
                finally {
                    if (this.opened) {
                        this.cleanup(true);
                    }
                }
            }
        }
    }

    private void cleanup(boolean bl) {
        this.releaseProtocol(bl);
        this.protocol = null;
        this.messageCache = null;
        this.uidTable = null;
        this.exists = false;
        this.opened = false;
        this.notifyConnectionListeners(3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean isOpen() {
        Object object = this.messageCacheLock;
        synchronized (object) {
            if (this.opened) {
                try {
                    this.keepConnectionAlive(false);
                }
                catch (ProtocolException protocolException) {
                    // empty catch block
                }
            }
        }
        return this.opened;
    }

    public Flags getPermanentFlags() {
        return this.permanentFlags;
    }

    public synchronized int getMessageCount() throws MessagingException {
        this.checkExists();
        if (!this.opened) {
            try {
                Status status = this.getStatus();
                return status.total;
            }
            catch (BadCommandException badCommandException) {
                IMAPProtocol iMAPProtocol = null;
                try {
                    iMAPProtocol = this.getStoreProtocol();
                    MailboxInfo mailboxInfo = iMAPProtocol.examine(this.fullName);
                    iMAPProtocol.close();
                    int n = mailboxInfo.total;
                    return n;
                }
                catch (ProtocolException protocolException) {
                    throw new MessagingException(protocolException.getMessage(), protocolException);
                }
                finally {
                    this.releaseStoreProtocol(iMAPProtocol);
                }
            }
            catch (ConnectionException connectionException) {
                throw new StoreClosedException(this.store, connectionException.getMessage());
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), protocolException);
            }
        }
        Object object = this.messageCacheLock;
        synchronized (object) {
            try {
                this.keepConnectionAlive(true);
                return this.total;
            }
            catch (ConnectionException connectionException) {
                throw new FolderClosedException(this, connectionException.getMessage());
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), protocolException);
            }
        }
    }

    public synchronized int getNewMessageCount() throws MessagingException {
        this.checkExists();
        if (!this.opened) {
            try {
                Status status = this.getStatus();
                return status.recent;
            }
            catch (BadCommandException badCommandException) {
                IMAPProtocol iMAPProtocol = null;
                try {
                    iMAPProtocol = this.getStoreProtocol();
                    MailboxInfo mailboxInfo = iMAPProtocol.examine(this.fullName);
                    iMAPProtocol.close();
                    int n = mailboxInfo.recent;
                    return n;
                }
                catch (ProtocolException protocolException) {
                    throw new MessagingException(protocolException.getMessage(), protocolException);
                }
                finally {
                    this.releaseStoreProtocol(iMAPProtocol);
                }
            }
            catch (ConnectionException connectionException) {
                throw new StoreClosedException(this.store, connectionException.getMessage());
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), protocolException);
            }
        }
        Object object = this.messageCacheLock;
        synchronized (object) {
            try {
                this.keepConnectionAlive(true);
                return this.recent;
            }
            catch (ConnectionException connectionException) {
                throw new FolderClosedException(this, connectionException.getMessage());
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), protocolException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int getUnreadMessageCount() throws MessagingException {
        this.checkExists();
        if (!this.opened) {
            try {
                Status status = this.getStatus();
                return status.unseen;
            }
            catch (BadCommandException badCommandException) {
                return -1;
            }
            catch (ConnectionException connectionException) {
                throw new StoreClosedException(this.store, connectionException.getMessage());
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), protocolException);
            }
        }
        Flags flags = new Flags();
        flags.add(Flags.Flag.SEEN);
        try {
            Object object = this.messageCacheLock;
            synchronized (object) {
                int[] nArray = this.protocol.search(new FlagTerm(flags, false));
                return nArray.length;
            }
        }
        catch (ConnectionException connectionException) {
            throw new FolderClosedException(this, connectionException.getMessage());
        }
        catch (ProtocolException protocolException) {
            throw new MessagingException(protocolException.getMessage(), protocolException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int getDeletedMessageCount() throws MessagingException {
        this.checkExists();
        if (!this.opened) {
            return -1;
        }
        Flags flags = new Flags();
        flags.add(Flags.Flag.DELETED);
        try {
            Object object = this.messageCacheLock;
            synchronized (object) {
                int[] nArray = this.protocol.search(new FlagTerm(flags, true));
                return nArray.length;
            }
        }
        catch (ConnectionException connectionException) {
            throw new FolderClosedException(this, connectionException.getMessage());
        }
        catch (ProtocolException protocolException) {
            throw new MessagingException(protocolException.getMessage(), protocolException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Status getStatus() throws ProtocolException {
        int n = ((IMAPStore)this.store).getStatusCacheTimeout();
        if (n > 0 && this.cachedStatus != null && System.currentTimeMillis() - this.cachedStatusTime < (long)n) {
            return this.cachedStatus;
        }
        IMAPProtocol iMAPProtocol = null;
        try {
            iMAPProtocol = this.getStoreProtocol();
            Status status = iMAPProtocol.status(this.fullName, null);
            if (n > 0) {
                this.cachedStatus = status;
                this.cachedStatusTime = System.currentTimeMillis();
            }
            Status status2 = status;
            return status2;
        }
        finally {
            this.releaseStoreProtocol(iMAPProtocol);
        }
    }

    public synchronized Message getMessage(int n) throws MessagingException {
        this.checkOpened();
        this.checkRange(n);
        return (Message)this.messageCache.elementAt(n - 1);
    }

    public void appendMessages(Message[] messageArray) throws MessagingException {
        this.checkExists();
        int n = ((IMAPStore)this.store).getAppendBufferSize();
        for (int i = 0; i < messageArray.length; ++i) {
            MessageLiteral messageLiteral;
            Message message = messageArray[i];
            try {
                messageLiteral = new MessageLiteral(message, message.getSize() > n ? 0 : n);
            }
            catch (IOException iOException) {
                throw new MessagingException("IOException while appending messages", iOException);
            }
            catch (MessageRemovedException messageRemovedException) {
                continue;
            }
            Date date = message.getReceivedDate();
            if (date == null) {
                date = message.getSentDate();
            }
            final Date date2 = date;
            final Flags flags = message.getFlags();
            this.doCommand(new ProtocolCommand(){

                public Object doCommand(IMAPProtocol iMAPProtocol) throws ProtocolException {
                    iMAPProtocol.append(IMAPFolder.this.fullName, flags, date2, messageLiteral);
                    return null;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void copyMessages(Message[] messageArray, Folder folder) throws MessagingException {
        this.checkOpened();
        if (messageArray.length == 0) {
            return;
        }
        if (folder.getStore() == this.store) {
            Object object = this.messageCacheLock;
            synchronized (object) {
                try {
                    MessageSet[] messageSetArray = Utility.toMessageSet(messageArray, null);
                    if (messageSetArray == null) {
                        throw new MessageRemovedException("Messages have been removed");
                    }
                    this.protocol.copy(messageSetArray, folder.getFullName());
                }
                catch (CommandFailedException commandFailedException) {
                    if (commandFailedException.getMessage().indexOf("TRYCREATE") != -1) {
                        throw new FolderNotFoundException(folder, folder.getFullName() + " does not exist");
                    }
                    throw new MessagingException(commandFailedException.getMessage(), commandFailedException);
                }
                catch (ConnectionException connectionException) {
                    throw new FolderClosedException(this, connectionException.getMessage());
                }
                catch (ProtocolException protocolException) {
                    throw new MessagingException(protocolException.getMessage(), protocolException);
                }
            }
        }
        super.copyMessages(messageArray, folder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Message[] expunge() throws MessagingException {
        this.checkOpened();
        Vector<IMAPMessage> vector = new Vector<IMAPMessage>();
        Object[] objectArray = this.messageCacheLock;
        synchronized (this.messageCacheLock) {
            this.doExpungeNotification = false;
            try {
                this.protocol.expunge();
            }
            catch (CommandFailedException commandFailedException) {
                if (this.mode != 2) {
                    throw new IllegalStateException("Cannot expunge READ_ONLY folder: " + this.fullName);
                }
                throw new MessagingException(commandFailedException.getMessage(), commandFailedException);
            }
            catch (ConnectionException connectionException) {
                throw new FolderClosedException(this, connectionException.getMessage());
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), protocolException);
            }
            finally {
                this.doExpungeNotification = true;
            }
            int n = 0;
            while (n < this.messageCache.size()) {
                IMAPMessage iMAPMessage = (IMAPMessage)this.messageCache.elementAt(n);
                if (iMAPMessage.isExpunged()) {
                    long l;
                    vector.addElement(iMAPMessage);
                    this.messageCache.removeElementAt(n);
                    if (this.uidTable == null || (l = iMAPMessage.getUID()) == -1L) continue;
                    this.uidTable.remove(new Long(l));
                    continue;
                }
                iMAPMessage.setMessageNumber(iMAPMessage.getSequenceNumber());
                ++n;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.total = this.messageCache.size();
            objectArray = new Message[vector.size()];
            vector.copyInto(objectArray);
            if (objectArray.length > 0) {
                this.notifyMessageRemovedListeners(true, (Message[])objectArray);
            }
            return objectArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Message[] search(SearchTerm searchTerm) throws MessagingException {
        this.checkOpened();
        try {
            Message[] messageArray = null;
            Object object = this.messageCacheLock;
            synchronized (object) {
                int[] nArray = this.protocol.search(searchTerm);
                if (nArray != null) {
                    messageArray = new IMAPMessage[nArray.length];
                    for (int i = 0; i < nArray.length; ++i) {
                        messageArray[i] = this.getMessageBySeqNumber(nArray[i]);
                    }
                }
            }
            return messageArray;
        }
        catch (CommandFailedException commandFailedException) {
            return super.search(searchTerm);
        }
        catch (SearchException searchException) {
            return super.search(searchTerm);
        }
        catch (ConnectionException connectionException) {
            throw new FolderClosedException(this, connectionException.getMessage());
        }
        catch (ProtocolException protocolException) {
            throw new MessagingException(protocolException.getMessage(), protocolException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Message[] search(SearchTerm searchTerm, Message[] messageArray) throws MessagingException {
        this.checkOpened();
        if (messageArray.length == 0) {
            return messageArray;
        }
        try {
            Message[] messageArray2 = null;
            Object object = this.messageCacheLock;
            synchronized (object) {
                MessageSet[] messageSetArray = Utility.toMessageSet(messageArray, null);
                if (messageSetArray == null) {
                    throw new MessageRemovedException("Messages have been removed");
                }
                int[] nArray = this.protocol.search(messageSetArray, searchTerm);
                if (nArray != null) {
                    messageArray2 = new IMAPMessage[nArray.length];
                    for (int i = 0; i < nArray.length; ++i) {
                        messageArray2[i] = this.getMessageBySeqNumber(nArray[i]);
                    }
                }
            }
            return messageArray2;
        }
        catch (CommandFailedException commandFailedException) {
            return super.search(searchTerm, messageArray);
        }
        catch (SearchException searchException) {
            return super.search(searchTerm, messageArray);
        }
        catch (ConnectionException connectionException) {
            throw new FolderClosedException(this, connectionException.getMessage());
        }
        catch (ProtocolException protocolException) {
            throw new MessagingException(protocolException.getMessage(), protocolException);
        }
    }

    public synchronized long getUIDValidity() throws MessagingException {
        if (this.opened) {
            return this.uidvalidity;
        }
        IMAPProtocol iMAPProtocol = null;
        Status status = null;
        try {
            iMAPProtocol = this.getStoreProtocol();
            String[] stringArray = new String[]{"UIDVALIDITY"};
            status = iMAPProtocol.status(this.fullName, stringArray);
        }
        catch (BadCommandException badCommandException) {
            throw new MessagingException("Cannot obtain UIDValidity", badCommandException);
        }
        catch (ConnectionException connectionException) {
            this.throwClosedException(connectionException);
        }
        catch (ProtocolException protocolException) {
            throw new MessagingException(protocolException.getMessage(), protocolException);
        }
        finally {
            this.releaseStoreProtocol(iMAPProtocol);
        }
        return status.uidvalidity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Message getMessageByUID(long l) throws MessagingException {
        this.checkOpened();
        Long l2 = new Long(l);
        IMAPMessage iMAPMessage = null;
        if (this.uidTable != null) {
            iMAPMessage = (IMAPMessage)this.uidTable.get(l2);
            if (iMAPMessage != null) {
                return iMAPMessage;
            }
        } else {
            this.uidTable = new Hashtable();
        }
        try {
            Object object = this.messageCacheLock;
            synchronized (object) {
                UID uID = this.protocol.fetchSequenceNumber(l);
                if (uID != null && uID.msgno <= this.total) {
                    iMAPMessage = (IMAPMessage)this.messageCache.elementAt(uID.msgno - 1);
                    iMAPMessage.setUID(uID.uid);
                    this.uidTable.put(l2, iMAPMessage);
                }
            }
        }
        catch (ConnectionException connectionException) {
            throw new FolderClosedException(this, connectionException.getMessage());
        }
        catch (ProtocolException protocolException) {
            throw new MessagingException(protocolException.getMessage(), protocolException);
        }
        return iMAPMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Message[] getMessagesByUID(long l, long l2) throws MessagingException {
        Message[] messageArray;
        this.checkOpened();
        if (this.uidTable == null) {
            this.uidTable = new Hashtable();
        }
        try {
            Object object = this.messageCacheLock;
            synchronized (object) {
                UID[] uIDArray = this.protocol.fetchSequenceNumbers(l, l2);
                messageArray = new Message[uIDArray.length];
                for (int i = 0; i < uIDArray.length; ++i) {
                    IMAPMessage iMAPMessage = (IMAPMessage)this.messageCache.elementAt(uIDArray[i].msgno - 1);
                    iMAPMessage.setUID(uIDArray[i].uid);
                    messageArray[i] = iMAPMessage;
                    this.uidTable.put(new Long(uIDArray[i].uid), iMAPMessage);
                }
            }
        }
        catch (ConnectionException connectionException) {
            throw new FolderClosedException(this, connectionException.getMessage());
        }
        catch (ProtocolException protocolException) {
            throw new MessagingException(protocolException.getMessage(), protocolException);
        }
        return messageArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Message[] getMessagesByUID(long[] lArray) throws MessagingException {
        int n;
        UID[] uIDArray;
        Message[] messageArray;
        this.checkOpened();
        long[] lArray2 = lArray;
        if (this.uidTable != null) {
            int n2;
            messageArray = new Vector();
            for (n2 = 0; n2 < lArray.length; ++n2) {
                uIDArray = new Long(lArray[n2]);
                if (this.uidTable.containsKey(uIDArray)) continue;
                messageArray.addElement(uIDArray);
            }
            n2 = messageArray.size();
            lArray2 = new long[n2];
            for (n = 0; n < n2; ++n) {
                lArray2[n] = (Long)messageArray.elementAt(n);
            }
        } else {
            this.uidTable = new Hashtable();
        }
        if (lArray2.length > 0) {
            try {
                messageArray = this.messageCacheLock;
                synchronized (messageArray) {
                    uIDArray = this.protocol.fetchSequenceNumbers(lArray2);
                    for (n = 0; n < uIDArray.length; ++n) {
                        IMAPMessage iMAPMessage = (IMAPMessage)this.messageCache.elementAt(uIDArray[n].msgno - 1);
                        iMAPMessage.setUID(uIDArray[n].uid);
                        this.uidTable.put(new Long(uIDArray[n].uid), iMAPMessage);
                    }
                }
            }
            catch (ConnectionException connectionException) {
                throw new FolderClosedException(this, connectionException.getMessage());
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), protocolException);
            }
        }
        messageArray = new Message[lArray.length];
        for (int i = 0; i < lArray.length; ++i) {
            messageArray[i] = (Message)this.uidTable.get(new Long(lArray[i]));
        }
        return messageArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized long getUID(Message message) throws MessagingException {
        if (message.getFolder() != this) {
            throw new NoSuchElementException("Message does not belong to this folder");
        }
        this.checkOpened();
        IMAPMessage iMAPMessage = (IMAPMessage)message;
        long l = iMAPMessage.getUID();
        if (l != -1L) {
            return l;
        }
        UID uID = null;
        Object object = this.messageCacheLock;
        synchronized (object) {
            iMAPMessage.checkExpunged();
            try {
                uID = this.protocol.fetchUID(iMAPMessage.getSequenceNumber());
            }
            catch (ConnectionException connectionException) {
                throw new FolderClosedException(this, connectionException.getMessage());
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), protocolException);
            }
        }
        if (uID != null) {
            l = uID.uid;
            iMAPMessage.setUID(l);
            if (this.uidTable == null) {
                this.uidTable = new Hashtable();
            }
            this.uidTable.put(new Long(l), iMAPMessage);
        }
        return l;
    }

    public Quota[] getQuota() throws MessagingException {
        return (Quota[])this.doOptionalCommand("QUOTA not supported", new ProtocolCommand(){

            public Object doCommand(IMAPProtocol iMAPProtocol) throws ProtocolException {
                return iMAPProtocol.getQuotaRoot(IMAPFolder.this.fullName);
            }
        });
    }

    public void setQuota(final Quota quota) throws MessagingException {
        this.doOptionalCommand("QUOTA not supported", new ProtocolCommand(){

            public Object doCommand(IMAPProtocol iMAPProtocol) throws ProtocolException {
                iMAPProtocol.setQuota(quota);
                return null;
            }
        });
    }

    public ACL[] getACL() throws MessagingException {
        return (ACL[])this.doOptionalCommand("ACL not supported", new ProtocolCommand(){

            public Object doCommand(IMAPProtocol iMAPProtocol) throws ProtocolException {
                return iMAPProtocol.getACL(IMAPFolder.this.fullName);
            }
        });
    }

    public void addACL(ACL aCL) throws MessagingException {
        this.setACL(aCL, '\u0000');
    }

    public void removeACL(final String string) throws MessagingException {
        this.doOptionalCommand("ACL not supported", new ProtocolCommand(){

            public Object doCommand(IMAPProtocol iMAPProtocol) throws ProtocolException {
                iMAPProtocol.deleteACL(IMAPFolder.this.fullName, string);
                return null;
            }
        });
    }

    public void addRights(ACL aCL) throws MessagingException {
        this.setACL(aCL, '+');
    }

    public void removeRights(ACL aCL) throws MessagingException {
        this.setACL(aCL, '-');
    }

    public Rights[] listRights(final String string) throws MessagingException {
        return (Rights[])this.doOptionalCommand("ACL not supported", new ProtocolCommand(){

            public Object doCommand(IMAPProtocol iMAPProtocol) throws ProtocolException {
                return iMAPProtocol.listRights(IMAPFolder.this.fullName, string);
            }
        });
    }

    public Rights myRights() throws MessagingException {
        return (Rights)this.doOptionalCommand("ACL not supported", new ProtocolCommand(){

            public Object doCommand(IMAPProtocol iMAPProtocol) throws ProtocolException {
                return iMAPProtocol.myRights(IMAPFolder.this.fullName);
            }
        });
    }

    private void setACL(final ACL aCL, final char c) throws MessagingException {
        this.doOptionalCommand("ACL not supported", new ProtocolCommand(){

            public Object doCommand(IMAPProtocol iMAPProtocol) throws ProtocolException {
                iMAPProtocol.setACL(IMAPFolder.this.fullName, c, aCL);
                return null;
            }
        });
    }

    public void handleResponse(Response response) {
        if (response.isOK() || response.isNO() || response.isBAD() || response.isBYE()) {
            ((IMAPStore)this.store).handleResponseCode(response);
        }
        if (response.isBYE()) {
            if (this.opened) {
                this.cleanup(false);
            }
            return;
        }
        if (response.isOK()) {
            return;
        }
        if (!response.isUnTagged()) {
            return;
        }
        if (!(response instanceof IMAPResponse)) {
            this.out.println("UNEXPECTED RESPONSE : " + response.toString());
            this.out.println("CONTACT javamail@sun.com");
            return;
        }
        IMAPResponse iMAPResponse = (IMAPResponse)response;
        if (iMAPResponse.keyEquals("EXISTS")) {
            int n = iMAPResponse.getNumber();
            if (n <= this.realTotal) {
                return;
            }
            int n2 = n - this.realTotal;
            Message[] messageArray = new Message[n2];
            for (int i = 0; i < n2; ++i) {
                IMAPMessage iMAPMessage = new IMAPMessage(this, ++this.total, ++this.realTotal);
                messageArray[i] = iMAPMessage;
                this.messageCache.addElement(iMAPMessage);
            }
            this.notifyMessageAddedListeners(messageArray);
        } else if (iMAPResponse.keyEquals("EXPUNGE")) {
            IMAPMessage iMAPMessage = this.getMessageBySeqNumber(iMAPResponse.getNumber());
            iMAPMessage.setExpunged(true);
            for (int i = iMAPMessage.getMessageNumber(); i < this.total; ++i) {
                IMAPMessage iMAPMessage2 = (IMAPMessage)this.messageCache.elementAt(i);
                if (iMAPMessage2.isExpunged()) continue;
                iMAPMessage2.setSequenceNumber(iMAPMessage2.getSequenceNumber() - 1);
            }
            --this.realTotal;
            if (this.doExpungeNotification) {
                Message[] messageArray = new Message[]{iMAPMessage};
                this.notifyMessageRemovedListeners(false, messageArray);
            }
        } else if (iMAPResponse.keyEquals("FETCH")) {
            IMAPMessage iMAPMessage;
            FetchResponse fetchResponse = (FetchResponse)iMAPResponse;
            Flags flags = (Flags)((Object)fetchResponse.getItem(Flags.class));
            if (flags != null && (iMAPMessage = this.getMessageBySeqNumber(fetchResponse.getNumber())) != null) {
                iMAPMessage._setFlags(flags);
                this.notifyMessageChangedListeners(1, iMAPMessage);
            }
        } else if (iMAPResponse.keyEquals("RECENT")) {
            this.recent = iMAPResponse.getNumber();
        }
    }

    void handleResponses(Response[] responseArray) {
        for (int i = 0; i < responseArray.length; ++i) {
            if (responseArray[i] == null) continue;
            this.handleResponse(responseArray[i]);
        }
    }

    protected synchronized IMAPProtocol getStoreProtocol() throws ProtocolException {
        if (this.connectionPoolDebug) {
            this.out.println("DEBUG: getStoreProtocol() - borrowing a connection");
        }
        return ((IMAPStore)this.store).getStoreProtocol();
    }

    private synchronized void throwClosedException(ConnectionException connectionException) throws FolderClosedException, StoreClosedException {
        if (connectionException.getProtocol() == this.protocol) {
            throw new FolderClosedException(this, connectionException.getMessage());
        }
        throw new StoreClosedException(this.store, connectionException.getMessage());
    }

    public IMAPProtocol getProtocol() {
        return this.protocol;
    }

    public Object doCommand(ProtocolCommand protocolCommand) throws MessagingException {
        try {
            return this.doProtocolCommand(protocolCommand);
        }
        catch (ConnectionException connectionException) {
            this.throwClosedException(connectionException);
        }
        catch (ProtocolException protocolException) {
            throw new MessagingException(protocolException.getMessage(), protocolException);
        }
        return null;
    }

    public Object doOptionalCommand(String string, ProtocolCommand protocolCommand) throws MessagingException {
        try {
            return this.doProtocolCommand(protocolCommand);
        }
        catch (BadCommandException badCommandException) {
            throw new MessagingException(string, badCommandException);
        }
        catch (ConnectionException connectionException) {
            this.throwClosedException(connectionException);
        }
        catch (ProtocolException protocolException) {
            throw new MessagingException(protocolException.getMessage(), protocolException);
        }
        return null;
    }

    public Object doCommandIgnoreFailure(ProtocolCommand protocolCommand) throws MessagingException {
        try {
            return this.doProtocolCommand(protocolCommand);
        }
        catch (CommandFailedException commandFailedException) {
            return null;
        }
        catch (ConnectionException connectionException) {
            this.throwClosedException(connectionException);
        }
        catch (ProtocolException protocolException) {
            throw new MessagingException(protocolException.getMessage(), protocolException);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object doProtocolCommand(ProtocolCommand protocolCommand) throws ProtocolException {
        Object object = this;
        synchronized (object) {
            if (this.opened && !((IMAPStore)this.store).hasSeparateStoreConnection()) {
                Object object2 = this.messageCacheLock;
                synchronized (object2) {
                    return protocolCommand.doCommand(this.getProtocol());
                }
            }
        }
        object = null;
        try {
            object = this.getStoreProtocol();
            Object object3 = protocolCommand.doCommand((IMAPProtocol)object);
            return object3;
        }
        finally {
            this.releaseStoreProtocol((IMAPProtocol)object);
        }
    }

    protected synchronized void releaseStoreProtocol(IMAPProtocol iMAPProtocol) {
        if (iMAPProtocol != this.protocol) {
            ((IMAPStore)this.store).releaseStoreProtocol(iMAPProtocol);
        }
    }

    private void releaseProtocol(boolean bl) {
        if (this.protocol != null) {
            this.protocol.removeResponseHandler(this);
            if (bl) {
                ((IMAPStore)this.store).releaseProtocol(this, this.protocol);
            } else {
                ((IMAPStore)this.store).releaseProtocol(this, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void keepConnectionAlive(boolean bl) throws ProtocolException {
        if (System.currentTimeMillis() - this.protocol.getTimestamp() > 1000L) {
            this.protocol.noop();
        }
        if (bl && ((IMAPStore)this.store).hasSeparateStoreConnection()) {
            IMAPProtocol iMAPProtocol = null;
            try {
                iMAPProtocol = ((IMAPStore)this.store).getStoreProtocol();
                if (System.currentTimeMillis() - iMAPProtocol.getTimestamp() > 1000L) {
                    iMAPProtocol.noop();
                }
            }
            finally {
                ((IMAPStore)this.store).releaseStoreProtocol(iMAPProtocol);
            }
        }
    }

    IMAPMessage getMessageBySeqNumber(int n) {
        for (int i = n - 1; i < this.total; ++i) {
            IMAPMessage iMAPMessage = (IMAPMessage)this.messageCache.elementAt(i);
            if (iMAPMessage.getSequenceNumber() != n) continue;
            return iMAPMessage;
        }
        return null;
    }

    private boolean isDirectory() {
        return (this.type & 2) != 0;
    }

    public static interface ProtocolCommand {
        public Object doCommand(IMAPProtocol var1) throws ProtocolException;
    }

    public static class FetchProfileItem
    extends FetchProfile.Item {
        public static final FetchProfileItem HEADERS = new FetchProfileItem("HEADERS");
        public static final FetchProfileItem SIZE = new FetchProfileItem("SIZE");

        protected FetchProfileItem(String string) {
            super(string);
        }
    }
}

