/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.options;

import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.beans.IntrospectionException;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OptionalDataException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.KeyStroke;
import javax.swing.text.AttributeSet;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyleConstants;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.settings.EditorStyleConstants;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.api.editor.settings.KeyBindingSettings;
import org.netbeans.api.editor.settings.MultiKeyBinding;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.Coloring;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsDefaults;
import org.netbeans.editor.SettingsUtil;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.editor.FormatterIndentEngine;
import org.netbeans.modules.editor.IndentEngineFormatter;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.editor.SimpleIndentEngine;
import org.netbeans.modules.editor.options.AbbrevsMIMEProcessor;
import org.netbeans.modules.editor.options.AllOptionsFolder;
import org.netbeans.modules.editor.options.FontsColorsMIMEProcessor;
import org.netbeans.modules.editor.options.KeyBindingsMIMEProcessor;
import org.netbeans.modules.editor.options.MIMEOptionFile;
import org.netbeans.modules.editor.options.MIMEOptionFolder;
import org.netbeans.modules.editor.options.MIMEOptionNode;
import org.netbeans.modules.editor.options.MacrosMIMEProcessor;
import org.netbeans.modules.editor.options.MultiPropertyFolder;
import org.netbeans.modules.editor.options.OptionSupport;
import org.netbeans.modules.editor.options.OptionUtilities;
import org.netbeans.modules.editor.options.PropertiesMIMEProcessor;
import org.openide.ServiceType;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.IndentEngine;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

public class BaseOptions
extends OptionSupport {
    protected static final int LATEST_OPTIONS_VERSION = 21;
    protected static final String OPTIONS_VERSION_PROP = "optionsVersion";
    public static final String ABBREV_MAP_PROP = "abbrevMap";
    public static final String BASE = "base";
    public static final String CARET_BLINK_RATE_PROP = "caretBlinkRate";
    public static final String CARET_COLOR_INSERT_MODE_PROP = "caretColorInsertMode";
    public static final String CARET_COLOR_OVERWRITE_MODE_PROP = "caretColorOverwriteMode";
    public static final String CARET_ITALIC_INSERT_MODE_PROP = "caretItalicInsertMode";
    public static final String CARET_ITALIC_OVERWRITE_MODE_PROP = "caretItalicOverwriteMode";
    public static final String CARET_TYPE_INSERT_MODE_PROP = "caretTypeInsertMode";
    public static final String CARET_TYPE_OVERWRITE_MODE_PROP = "caretTypeOverwriteMode";
    public static final String COLORING_MAP_PROP = "coloringMap";
    public static final String EXPAND_TABS_PROP = "expandTabs";
    public static final String FIND_HIGHLIGHT_SEARCH_PROP = "findHighlightSearch";
    public static final String FIND_HISTORY_PROP = "findHistory";
    public static final String FIND_HISTORY_SIZE_PROP = "findHistorySize";
    public static final String FIND_INC_SEARCH_DELAY_PROP = "findIncSearchDelay";
    public static final String FIND_INC_SEARCH_PROP = "findIncSearch";
    public static final String FIND_MATCH_CASE_PROP = "findMatchCase";
    public static final String FIND_REG_EXP_PROP = "findRegExp";
    public static final String FIND_SMART_CASE_PROP = "findSmartCase";
    public static final String FIND_WHOLE_WORDS_PROP = "findWholeWords";
    public static final String FIND_WRAP_SEARCH_PROP = "findWrapSearch";
    public static final String FIND_BLOCK_SEARCH_PROP = "findBlockSearch";
    public static final String FONT_SIZE_PROP = "fontSize";
    public static final String HIGHLIGHT_CARET_ROW_PROP = "highlightCaretRow";
    public static final String HIGHLIGHT_MATCHING_BRACKET_PROP = "highlightMatchingBracket";
    public static final String INDENT_ENGINE_PROP = "indentEngine";
    public static final String KEY_BINDING_LIST_PROP = "keyBindingList";
    public static final String LINE_HEIGHT_CORRECTION_PROP = "lineHeightCorrection";
    public static final String LINE_NUMBER_VISIBLE_PROP = "lineNumberVisible";
    public static final String MACRO_MAP_PROP = "macroMap";
    public static final String MARGIN_PROP = "margin";
    public static final String PAIR_CHARACTERS_COMPLETION = "pairCharactersCompletion";
    public static final String SCROLL_FIND_INSETS_PROP = "scrollFindInsets";
    public static final String SCROLL_JUMP_INSETS_PROP = "scrollJumpInsets";
    public static final String SPACES_PER_TAB_PROP = "spacesPerTab";
    public static final String STATUS_BAR_CARET_DELAY_PROP = "statusBarCaretDelay";
    public static final String STATUS_BAR_VISIBLE_PROP = "statusBarVisible";
    public static final String TAB_SIZE_PROP = "tabSize";
    public static final String TEXT_LIMIT_LINE_COLOR_PROP = "textLimitLineColor";
    public static final String TEXT_LIMIT_LINE_VISIBLE_PROP = "textLimitLineVisible";
    public static final String TEXT_LIMIT_WIDTH_PROP = "textLimitWidth";
    public static final String TOOLBAR_VISIBLE_PROP = "toolbarVisible";
    public static final String TEXT_ANTIALIASING_PROP = "textAntialiasing";
    public static final String CODE_FOLDING_PROPS_PROP = "codeFoldingProps";
    protected static final String[] BASE_PROP_NAMES = new String[]{"abbrevMap", "caretBlinkRate", "caretColorInsertMode", "caretColorOverwriteMode", "caretItalicInsertMode", "caretItalicOverwriteMode", "caretTypeInsertMode", "caretTypeOverwriteMode", "coloringMap", "expandTabs", "fontSize", "highlightCaretRow", "highlightMatchingBracket", "indentEngine", "keyBindingList", "lineHeightCorrection", "macroMap", "margin", "pairCharactersCompletion", "scrollFindInsets", "scrollJumpInsets", "spacesPerTab", "statusBarCaretDelay", "statusBarVisible", "tabSize", "textLimitLineColor", "textLimitLineVisible", "textLimitWidth", "optionsVersion"};
    static final long serialVersionUID = -5469192431366914841L;
    private static final String NO_INDENT_ENGINE = "NO_INDENT_ENGINE";
    private static final boolean debugFormat = Boolean.getBoolean("netbeans.debug.editor.format");
    private transient Settings.Initializer coloringMapInitializer;
    private transient int optionsVersion;
    private transient IndentEngine readExternalIndentEngine;
    private transient boolean inReadExternal;
    private transient MIMEOptionNode mimeNode;
    private transient Map defaultAbbrevsMap;
    private transient Map defaultMacrosMap;
    private transient Map defaultKeyBindingsMap;
    private transient MIMEOptionFolder settingsFolder;
    private transient boolean usingNewOptions = false;
    private transient FontColorSettings fontColorSettings;
    private transient KeyBindingSettings keyBindingsSettings;
    private transient LookupListener lookupListener;
    private static final HashMap kitClass2Options = new HashMap();
    public static final String CODE_TEMPLATE_EXPAND_KEY = "code-template-expand-key";
    private Lookup.Result resultKB;
    private LookupListener weakLookupListenerKB;
    private LookupListener lookupListenerKB;
    private static Object gaspConst = RenderingHints.VALUE_TEXT_ANTIALIAS_OFF;

    public BaseOptions() {
        this(BaseKit.class, BASE);
        this.optionsVersion = 21;
    }

    public BaseOptions(Class kitClass, String typeName) {
        super(kitClass, typeName);
        kitClass2Options.put(kitClass, this);
        if (!BASE.equals(typeName)) {
            AttributeSet as;
            BaseKit kit = BaseKit.getKit((Class)kitClass);
            String name = kit.getContentType();
            FontColorSettings fcs = this.getFontColorSettings();
            this.usingNewOptions = false;
            if (fcs != null && (as = fcs.getTokenFontColors("default")) != null) {
                this.usingNewOptions = true;
            }
        }
    }

    public boolean usesNewOptionsDialog() {
        return this.usingNewOptions;
    }

    protected String getContentType() {
        BaseKit kit = BaseKit.getKit((Class)this.getKitClass());
        return kit.getContentType();
    }

    public static BaseOptions getOptions(Class kitClass) {
        BaseOptions option = null;
        for (Class c = kitClass; option == null && c != null && (option = (BaseOptions)((Object)kitClass2Options.get(c))) == null; c = c.getSuperclass()) {
            AllOptionsFolder.getDefault().loadMIMEOption(c, false);
            option = (BaseOptions)((Object)kitClass2Options.get(c));
            if (option != null) break;
        }
        return option;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MIMEOptionFolder getMIMEFolder() {
        BaseKit kit = BaseKit.getKit((Class)this.getKitClass());
        String name = kit.getContentType();
        if (name == null) {
            return null;
        }
        BaseOptions baseOptions = this;
        synchronized (baseOptions) {
            FileObject fo;
            if (this.settingsFolder != null) {
                return this.settingsFolder;
            }
            FileObject f = Repository.getDefault().getDefaultFileSystem().findResource("Editors/" + name);
            if (f == null && (fo = Repository.getDefault().getDefaultFileSystem().findResource("Editors")) != null) {
                try {
                    StringTokenizer stok = new StringTokenizer(name, "/");
                    while (stok.hasMoreElements()) {
                        String newFolder = stok.nextToken();
                        if (fo.getFileObject(newFolder) == null) {
                            fo = fo.createFolder(newFolder);
                            continue;
                        }
                        fo = fo.getFileObject(newFolder);
                    }
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
                f = Repository.getDefault().getDefaultFileSystem().findResource("Editors/" + name);
            }
            if (f != null) {
                try {
                    DataObject d = DataObject.find((FileObject)f);
                    DataFolder df = (DataFolder)d.getCookie(DataFolder.class);
                    if (df != null) {
                        this.settingsFolder = new MIMEOptionFolder(df, this);
                        return this.settingsFolder;
                    }
                }
                catch (DataObjectNotFoundException ex) {
                    ex.printStackTrace();
                }
            }
            return null;
        }
    }

    public synchronized MIMEOptionNode getMimeNode() {
        if (this.mimeNode == null) {
            this.createMIMENode(this.getTypeName());
        }
        return this.mimeNode;
    }

    private void createMIMENode(String typeName) {
        if (typeName.equals(BASE)) {
            return;
        }
        try {
            this.mimeNode = new MIMEOptionNode(this);
        }
        catch (IntrospectionException ie) {
            ie.printStackTrace();
        }
    }

    protected void updateSettingsMap(Class kitClass, Map settingsMap) {
        super.updateSettingsMap(kitClass, settingsMap);
        if (kitClass == this.getKitClass()) {
            settingsMap.put(INDENT_ENGINE_PROP, new Settings.Evaluator(){

                public Object getValue(Class kitClass2, String settingName) {
                    return BaseOptions.this.getIndentEngine();
                }
            });
            settingsMap.put("formatter", new Settings.Evaluator(){

                public Object getValue(Class kitClass2, String settingName) {
                    IndentEngine eng = BaseOptions.this.getIndentEngine();
                    return eng != null ? (eng instanceof FormatterIndentEngine ? ((FormatterIndentEngine)eng).getFormatter() : new IndentEngineFormatter(BaseOptions.this.getKitClass(), eng)) : null;
                }
            });
            if (kitClass == BaseKit.class) {
                settingsMap.put("rendering-hints", new Settings.Evaluator(){

                    public Object getValue(Class kitClass2, String settingName) {
                        return BaseOptions.this.computeTextAntialiasingMap(BaseOptions.this.isTextAntialiasing());
                    }
                });
            }
            if (this.coloringMapInitializer != null) {
                this.coloringMapInitializer.updateSettingsMap(kitClass, settingsMap);
            }
        }
        if (kitClass == BaseKit.class && this.coloringMapInitializer != null) {
            this.coloringMapInitializer.updateSettingsMap(BaseKit.class, settingsMap);
        }
    }

    private Map computeTextAntialiasingMap(boolean aaSetting) {
        Map<RenderingHints.Key, Object> result;
        if (!aaSetting) {
            return Collections.EMPTY_MAP;
        }
        Map defaultHints = (Map)Toolkit.getDefaultToolkit().getDesktopProperty("awt.font.desktophints");
        if (defaultHints != null) {
            Object systemSetting = defaultHints.get(RenderingHints.KEY_TEXT_ANTIALIASING);
            if (systemSetting == RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT || systemSetting == RenderingHints.VALUE_TEXT_ANTIALIAS_OFF || this.isGasp(systemSetting)) {
                result = new HashMap();
                result.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            } else {
                result = defaultHints;
            }
        } else {
            result = new HashMap<RenderingHints.Key, Object>();
            result.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        return result;
    }

    private boolean isGasp(Object systemSetting) {
        if (gaspConst == RenderingHints.VALUE_TEXT_ANTIALIAS_OFF) {
            try {
                Field aaConst = RenderingHints.class.getField("VALUE_TEXT_ANTIALIAS_GASP");
                gaspConst = aaConst.get(null);
            }
            catch (NoSuchFieldException e) {
                gaspConst = null;
            }
            catch (IllegalAccessException e) {
                gaspConst = null;
            }
        }
        return systemSetting == gaspConst;
    }

    public int getTabSize() {
        return this.getSettingInteger("tab-size");
    }

    public void setTabSize(int tabSize) {
        if (tabSize < 0) {
            NbEditorUtilities.invalidArgument("MSG_NegativeValue");
            return;
        }
        this.setSettingInteger("tab-size", tabSize, TAB_SIZE_PROP);
    }

    public void setExpandTabs(boolean expandTabs) {
        this.setSettingBoolean("expand-tabs", expandTabs, EXPAND_TABS_PROP);
    }

    public void setSpacesPerTab(int i) {
        if (i > 0) {
            this.setSettingInteger("spaces-per-tab", i, SPACES_PER_TAB_PROP);
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public Map getDefaultAbbrevMap() {
        this.loadDefaultAbbreviations();
        return this.defaultAbbrevsMap;
    }

    private void loadDefaultAbbreviations() {
        if (this.defaultAbbrevsMap != null) {
            return;
        }
        MIMEOptionFolder mimeFolder = this.getMIMEFolder();
        if (mimeFolder == null) {
            return;
        }
        MIMEOptionFolder mof = mimeFolder.getFolder("Defaults");
        if (mof == null) {
            return;
        }
        MIMEOptionFile file = mof.getFile(AbbrevsMIMEProcessor.class, false);
        if (file != null && !file.isLoaded()) {
            file.loadSettings(false);
            this.defaultAbbrevsMap = new HashMap(file.getAllProperties());
        }
    }

    public Map getAbbrevMap() {
        this.loadDefaultAbbreviations();
        this.loadSettings(AbbrevsMIMEProcessor.class);
        Map settingsMap = (Map)super.getSettingValue("abbrev-map");
        if (settingsMap == null) {
            Utilities.annotateLoggable((Throwable)new NullPointerException("settingsMap is null for kit:" + this.getKitClass()));
        }
        HashMap ret = settingsMap == null ? new HashMap() : new HashMap(settingsMap);
        return ret;
    }

    public void setAbbrevMap(Map map, boolean saveToXML) {
        Map diffMap = null;
        if (saveToXML) {
            this.loadDefaultAbbreviations();
            diffMap = OptionUtilities.getMapDiff(this.getAbbrevMap(), map, true);
            if (diffMap.size() > 0) {
                this.updateSettings(AbbrevsMIMEProcessor.class, diffMap);
            }
        }
        super.setSettingValue("abbrev-map", map, ABBREV_MAP_PROP);
    }

    public void setAbbrevMap(Map map) {
        this.setAbbrevMap(map, true);
    }

    public String getCaretTypeInsertMode() {
        return (String)this.getSettingValue("caret-type-insert-mode");
    }

    public void setCaretTypeInsertMode(String type) {
        this.setSettingValue("caret-type-insert-mode", type, CARET_TYPE_INSERT_MODE_PROP);
    }

    public String getCaretTypeOverwriteMode() {
        return (String)this.getSettingValue("caret-type-overwrite-mode");
    }

    public void setCaretTypeOverwriteMode(String type) {
        this.setSettingValue("caret-type-overwrite-mode", type, CARET_TYPE_OVERWRITE_MODE_PROP);
    }

    public boolean getCaretItalicInsertMode() {
        return false;
    }

    public void setCaretItalicInsertMode(boolean b) {
        this.setSettingBoolean("caret-italic-insert-mode", b, CARET_ITALIC_INSERT_MODE_PROP);
    }

    public boolean getCaretItalicOverwriteMode() {
        return false;
    }

    public void setCaretItalicOverwriteMode(boolean b) {
        this.setSettingBoolean("caret-italic-overwrite-mode", b, CARET_ITALIC_OVERWRITE_MODE_PROP);
    }

    public Color getCaretColorInsertMode() {
        this.loadSettings(FontsColorsMIMEProcessor.class);
        return (Color)super.getSettingValue("caret-color-insert-mode");
    }

    public void setCaretColorInsertMode(Color color) {
        this.setCaretColorInsertMode(color, true);
    }

    public void setCaretColorInsertMode(Color color, boolean saveToXML) {
        if (saveToXML && !this.getCaretColorInsertMode().equals(color) && color != null) {
            HashMap<String, Color> map = new HashMap<String, Color>();
            map.put("caret-color-insert-mode", color);
            if (map != null) {
                this.updateSettings(FontsColorsMIMEProcessor.class, map);
            }
        }
        super.setSettingValue("caret-color-insert-mode", color, CARET_COLOR_INSERT_MODE_PROP);
    }

    public Color getCaretColorOverwriteMode() {
        this.loadSettings(FontsColorsMIMEProcessor.class);
        return (Color)super.getSettingValue("caret-color-overwrite-mode");
    }

    public void setCaretColorOverwriteMode(Color color) {
        this.setCaretColorOverwriteMode(color, true);
    }

    public void setCaretColorOverwriteMode(Color color, boolean saveToXML) {
        if (saveToXML && !this.getCaretColorOverwriteMode().equals(color) && color != null) {
            HashMap<String, Color> map = new HashMap<String, Color>();
            map.put("caret-color-overwrite-mode", color);
            if (map != null) {
                this.updateSettings(FontsColorsMIMEProcessor.class, map);
            }
        }
        super.setSettingValue("caret-color-overwrite-mode", color, CARET_COLOR_OVERWRITE_MODE_PROP);
    }

    public int getCaretBlinkRate() {
        return this.getSettingInteger("caret-blink-rate");
    }

    public void setCaretBlinkRate(int rate) {
        if (rate < 0) {
            NbEditorUtilities.invalidArgument("MSG_NegativeValue");
            return;
        }
        this.setSettingInteger("caret-blink-rate", rate, CARET_BLINK_RATE_PROP);
    }

    public boolean getLineNumberVisible() {
        return this.getSettingBoolean("line-number-visible");
    }

    public void setLineNumberVisible(boolean b) {
        this.setSettingBoolean("line-number-visible", b, LINE_NUMBER_VISIBLE_PROP);
    }

    public Insets getScrollJumpInsets() {
        return (Insets)this.getSettingValue("scroll-jump-insets");
    }

    public void setScrollJumpInsets(Insets i) {
        this.setSettingValue("scroll-jump-insets", i, SCROLL_JUMP_INSETS_PROP);
    }

    public Insets getScrollFindInsets() {
        return (Insets)this.getSettingValue("scroll-find-insets");
    }

    public void setScrollFindInsets(Insets i) {
        this.setSettingValue("scroll-find-insets", i, SCROLL_FIND_INSETS_PROP);
    }

    public Map getDefaultKeyBindingsMap() {
        this.loadDefaultKeyBindings();
        return this.defaultKeyBindingsMap;
    }

    private void loadDefaultKeyBindings() {
        if (this.defaultKeyBindingsMap != null) {
            return;
        }
        MIMEOptionFolder mimeFolder = AllOptionsFolder.getDefault().getMIMEFolder();
        if (mimeFolder == null) {
            return;
        }
        MIMEOptionFolder mof = mimeFolder.getFolder("Defaults");
        if (mof == null) {
            return;
        }
        MIMEOptionFile file = mof.getFile(KeyBindingsMIMEProcessor.class, false);
        if (file != null && !file.isLoaded()) {
            file.loadSettings(false);
            this.defaultKeyBindingsMap = new HashMap(file.getAllProperties());
        }
        if (!this.usingNewOptions && !BASE.equals(this.getTypeName())) {
            super.setSettingValue("key-bindings", new ArrayList(this.defaultKeyBindingsMap.values()), KEY_BINDING_LIST_PROP);
        }
    }

    private List getKBList() {
        if (!this.usingNewOptions) {
            this.loadDefaultKeyBindings();
            this.loadSettings(KeyBindingsMIMEProcessor.class);
        }
        Class kitClass = this.getKitClass();
        Settings.KitAndValue[] kav = this.getSettingValueHierarchy("key-bindings");
        List<org.netbeans.editor.MultiKeyBinding> kbList = null;
        for (int i = 0; i < kav.length; ++i) {
            if (kav[i].kitClass != kitClass) continue;
            kbList = (List)kav[i].value;
        }
        if (kbList == null) {
            kbList = new ArrayList();
        }
        int cnt = kbList.size();
        for (int i = 0; i < cnt; ++i) {
            Object o = kbList.get(i);
            if (o instanceof org.netbeans.editor.MultiKeyBinding || o == null) continue;
            JTextComponent.KeyBinding b = (JTextComponent.KeyBinding)o;
            kbList.set(i, new org.netbeans.editor.MultiKeyBinding(b.key, b.actionName));
        }
        return new ArrayList(kbList);
    }

    public List getKeyBindingList() {
        ArrayList<String> kb2 = new ArrayList<String>(this.getKBList());
        kb2.add(0, this.getKitClass().getName());
        return kb2;
    }

    public void setKeyBindingList(List list) {
        this.setKeyBindingList(list, true);
    }

    public void setKeyBindingsDiffMap(Map diffMap) {
        if (diffMap != null && diffMap.size() > 0) {
            this.updateSettings(KeyBindingsMIMEProcessor.class, diffMap);
        }
    }

    public void setKeyBindingList(List list, boolean saveToXML) {
        if (list.size() > 0 && (list.get(0) instanceof Class || list.get(0) instanceof String)) {
            list.remove(0);
        }
        Map diffMap = null;
        if (saveToXML) {
            this.loadDefaultKeyBindings();
            List kbMap = this.getKeyBindingList();
            if (kbMap.size() > 0 && (kbMap.get(0) instanceof Class || kbMap.get(0) instanceof String)) {
                kbMap.remove(0);
            }
            if ((diffMap = OptionUtilities.getMapDiff(OptionUtilities.makeKeyBindingsMap(kbMap), OptionUtilities.makeKeyBindingsMap(list), true)).size() > 0) {
                this.updateSettings(KeyBindingsMIMEProcessor.class, diffMap);
            }
        }
        super.setSettingValue("key-bindings", list, KEY_BINDING_LIST_PROP);
    }

    static Font toFont(AttributeSet s, Integer defSize) {
        Object fontFamily = s.getAttribute(StyleConstants.FontFamily);
        Object fontSize = s.getAttribute(StyleConstants.FontSize);
        if (fontFamily == null) {
            return null;
        }
        if (fontSize == null) {
            fontSize = defSize;
        }
        int style = 0;
        if (Boolean.TRUE.equals(s.getAttribute(StyleConstants.Bold))) {
            ++style;
        }
        if (Boolean.TRUE.equals(s.getAttribute(StyleConstants.Italic))) {
            style += 2;
        }
        return new Font((String)fontFamily, style, (Integer)fontSize);
    }

    private void updateKeybindingsFromNewOptionsDialogAttributes() {
        KeyBindingSettings kbs = this.getKeybindingSettings();
        if (kbs == null) {
            return;
        }
        ArrayList<org.netbeans.editor.MultiKeyBinding> newKeybs = new ArrayList<org.netbeans.editor.MultiKeyBinding>();
        List newOptionDialogKeybs = kbs.getKeyBindings();
        for (int i = 0; i < newOptionDialogKeybs.size(); ++i) {
            MultiKeyBinding mkb = (MultiKeyBinding)newOptionDialogKeybs.get(i);
            List lst = mkb.getKeyStrokeList();
            KeyStroke[] keys = new KeyStroke[lst.size()];
            lst.toArray(keys);
            org.netbeans.editor.MultiKeyBinding editorMkb = new org.netbeans.editor.MultiKeyBinding(keys, mkb.getActionName());
            newKeybs.add(editorMkb);
        }
        super.setSettingValue("key-bindings", newKeybs, KEY_BINDING_LIST_PROP);
    }

    private void updateColoringsFromNewOptionsDialogAttributes() {
        Color current;
        Color color;
        Object fsObj;
        Map m = this.getColoringMap();
        m.remove(null);
        FontColorSettings fcs = this.getFontColorSettings();
        if (fcs == null) {
            return;
        }
        Iterator it = m.keySet().iterator();
        AttributeSet defAS = fcs.getTokenFontColors("default");
        Integer defSize = null;
        if (defAS != null && (fsObj = defAS.getAttribute(StyleConstants.FontSize)) instanceof Integer) {
            defSize = (Integer)fsObj;
        }
        if (defSize == null) {
            defSize = new Integer(SettingsDefaults.defaultFont.getSize());
        }
        while (it.hasNext()) {
            Font font;
            String category = (String)it.next();
            if (category == null) continue;
            AttributeSet as = fcs.getTokenFontColors(category);
            if (as == null) {
                as = fcs.getFontColors(category);
            }
            if (as == null) {
                System.out.println("ColorBridge.unknown category " + category);
                continue;
            }
            Font font2 = font = as.getAttribute(StyleConstants.FontFamily) != null ? BaseOptions.toFont(as, defSize) : null;
            if (category.equals("default")) {
                if (font == null) {
                    System.out.println("ColorBridge null font!!! ");
                    continue;
                }
                if (as.getAttribute(StyleConstants.Foreground) == null) {
                    System.out.println("ColorBridge null Foreground!!! ");
                    continue;
                }
                if (as.getAttribute(StyleConstants.Background) == null) {
                    System.out.println("ColorBridge null Background!!! ");
                    continue;
                }
            }
            Coloring c = new Coloring(font, 7, (Color)as.getAttribute(StyleConstants.Foreground), (Color)as.getAttribute(StyleConstants.Background), (Color)as.getAttribute(StyleConstants.Underline), (Color)as.getAttribute(StyleConstants.StrikeThrough), (Color)as.getAttribute(EditorStyleConstants.WaveUnderlineColor));
            m.put(category, c);
        }
        m.put(null, this.getKitClass().getName());
        this.setColoringMap(m);
        AttributeSet set = fcs.getFontColors("caret-color-insert-mode");
        if (set != null) {
            color = (Color)set.getAttribute(StyleConstants.Foreground);
            current = this.getCaretColorInsertMode();
            if (color != null && !color.equals(current)) {
                this.setCaretColorInsertMode(color);
                this.setCaretColorOverwriteMode(color);
            }
        }
        if ((set = fcs.getFontColors("text-limit-line-color")) != null) {
            color = (Color)set.getAttribute(StyleConstants.Foreground);
            current = this.getTextLimitLineColor();
            if (color != null && !color.equals(current)) {
                this.setTextLimitLineColor(color);
            }
        }
    }

    private synchronized KeyBindingSettings getKeybindingSettings() {
        if (this.keyBindingsSettings == null) {
            String mime = this.getContentType();
            MimeLookup lookup = MimeLookup.getMimeLookup((String)mime);
            this.resultKB = lookup.lookup(new Lookup.Template(KeyBindingSettings.class));
            Collection inst = this.resultKB.allInstances();
            this.lookupListenerKB = new LookupListener(){

                public void resultChanged(LookupEvent ev) {
                    Lookup.Result result = (Lookup.Result)ev.getSource();
                    Collection newInstances = result.allInstances();
                    if (newInstances.size() > 0) {
                        BaseOptions.this.keyBindingsSettings = (KeyBindingSettings)newInstances.iterator().next();
                    }
                    BaseOptions.this.updateKeybindingsFromNewOptionsDialogAttributes();
                }
            };
            this.weakLookupListenerKB = (LookupListener)WeakListeners.create((Class)LookupListener.class, (EventListener)this.lookupListenerKB, (Object)this.resultKB);
            this.resultKB.addLookupListener(this.weakLookupListenerKB);
            if (inst.size() > 0) {
                this.keyBindingsSettings = (KeyBindingSettings)inst.iterator().next();
            }
        }
        return this.keyBindingsSettings;
    }

    private synchronized FontColorSettings getFontColorSettings() {
        if (this.fontColorSettings == null) {
            String mime = this.getContentType();
            MimeLookup lookup = MimeLookup.getMimeLookup((String)mime);
            Lookup.Result result = lookup.lookup(new Lookup.Template(FontColorSettings.class));
            Collection inst = result.allInstances();
            this.lookupListener = new LookupListener(){

                public void resultChanged(LookupEvent ev) {
                    Lookup.Result result = (Lookup.Result)ev.getSource();
                    Collection newInstances = result.allInstances();
                    if (newInstances.size() > 0) {
                        BaseOptions.this.fontColorSettings = (FontColorSettings)newInstances.iterator().next();
                    }
                    BaseOptions.this.updateColoringsFromNewOptionsDialogAttributes();
                }
            };
            result.addLookupListener(this.lookupListener);
            if (inst.size() > 0) {
                this.fontColorSettings = (FontColorSettings)inst.iterator().next();
            }
        }
        return this.fontColorSettings;
    }

    public Map getColoringMap() {
        Map settingsMap;
        if (!this.usingNewOptions) {
            this.loadSettings(FontsColorsMIMEProcessor.class);
        }
        if ((settingsMap = SettingsUtil.getColoringMap((Class)this.getKitClass(), (boolean)false, (boolean)true)) == null) {
            Utilities.annotateLoggable((Throwable)new NullPointerException("settingsMap is null for kit:" + this.getKitClass()));
        }
        HashMap<Object, String> cm = settingsMap == null ? new HashMap<Object, String>() : new HashMap(settingsMap);
        cm.put(null, this.getKitClass().getName());
        return cm;
    }

    public void setColoringMap(Map coloringMap) {
        this.setColoringMap(coloringMap, true);
    }

    public void setColoringMap(final Map coloringMap, boolean saveToXML) {
        Map diffMap = null;
        if (coloringMap != null) {
            if (this.inReadExternal) {
                // empty if block
            }
            if (!this.usingNewOptions && saveToXML && (diffMap = OptionUtilities.getMapDiff(this.getColoringMap(), coloringMap, false)).size() > 0) {
                this.updateSettings(FontsColorsMIMEProcessor.class, diffMap);
            }
            coloringMap.remove(null);
            Settings.update((Runnable)new Runnable(){

                public void run() {
                    SettingsUtil.setColoringMap((Class)BaseOptions.this.getKitClass(), (Map)coloringMap, (boolean)false);
                }
            });
            this.coloringMapInitializer = SettingsUtil.getColoringMapInitializer((Class)this.getKitClass(), (Map)coloringMap, (boolean)false, (String)(this.getTypeName() + "-coloring-map-initializer"));
            this.firePropertyChange(COLORING_MAP_PROP, null, null);
        }
    }

    public int getFontSize() {
        Coloring dc = SettingsUtil.getColoring((Class)this.getKitClass(), (String)"default", (boolean)false);
        return dc != null ? dc.getFont().getSize() : SettingsDefaults.defaultFont.getSize();
    }

    public void setFontSize(int size) {
        if (size < 0) {
            NbEditorUtilities.invalidArgument("MSG_NegativeValue");
            return;
        }
        int oldSize = this.getFontSize();
        Map cm = SettingsUtil.getColoringMap((Class)this.getKitClass(), (boolean)false, (boolean)true);
        if (cm != null) {
            Iterator it = cm.entrySet().iterator();
            while (it.hasNext()) {
                Coloring c;
                Font font;
                Map.Entry entry = it.next();
                Object value = entry.getValue();
                if (!(value instanceof Coloring) || (font = (c = (Coloring)value).getFont()) == null || font.getSize() == size) continue;
                font = font.deriveFont((float)size);
                Coloring newColoring = new Coloring(font, c.getFontMode(), c.getForeColor(), c.getBackColor());
                entry.setValue(newColoring);
            }
            this.setColoringMap(cm);
            this.firePropertyChange(FONT_SIZE_PROP, null, null);
        }
    }

    public float getLineHeightCorrection() {
        return ((Float)this.getSettingValue("line-height-correction")).floatValue();
    }

    public void setLineHeightCorrection(float f) {
        if (f <= 0.0f) {
            NbEditorUtilities.invalidArgument("MSG_OutOfRange");
            return;
        }
        this.setSettingValue("line-height-correction", new Float(f), LINE_HEIGHT_CORRECTION_PROP);
    }

    public Map getDefaultMacrosMap() {
        this.loadDefaultMacros();
        return this.defaultMacrosMap;
    }

    private void loadDefaultMacros() {
        if (this.defaultMacrosMap != null) {
            return;
        }
        MIMEOptionFolder mimeFolder = this.getMIMEFolder();
        if (mimeFolder == null) {
            return;
        }
        MIMEOptionFolder mof = mimeFolder.getFolder("Defaults");
        if (mof == null) {
            return;
        }
        MIMEOptionFile file = mof.getFile(MacrosMIMEProcessor.class, false);
        if (file != null && !file.isLoaded()) {
            file.loadSettings(false);
            this.defaultMacrosMap = new HashMap(file.getAllProperties());
        }
    }

    private void processMacroKeyBindings(Map diff, List oldKB) {
        ArrayList<org.netbeans.editor.MultiKeyBinding> deletedKB = new ArrayList<org.netbeans.editor.MultiKeyBinding>();
        ArrayList<org.netbeans.editor.MultiKeyBinding> addedKB = new ArrayList<org.netbeans.editor.MultiKeyBinding>();
        List newKB = this.getKBList();
        Iterator i = diff.keySet().iterator();
        block0: while (i.hasNext()) {
            org.netbeans.editor.MultiKeyBinding mkb;
            int j;
            String key = (String)i.next();
            if (!(diff.get(key) instanceof String)) continue;
            String action = (String)diff.get(key);
            String kbActionName = new String("macro-" + key);
            if (action.length() != 0) {
                for (j = 0; j < oldKB.size(); ++j) {
                    if (!(oldKB.get(j) instanceof org.netbeans.editor.MultiKeyBinding)) continue;
                    mkb = (org.netbeans.editor.MultiKeyBinding)oldKB.get(j);
                    if (!kbActionName.equals(mkb.actionName)) continue;
                    addedKB.add(mkb);
                    continue block0;
                }
                continue;
            }
            for (j = 0; j < newKB.size(); ++j) {
                if (!(newKB.get(j) instanceof org.netbeans.editor.MultiKeyBinding)) continue;
                mkb = (org.netbeans.editor.MultiKeyBinding)newKB.get(j);
                if (!kbActionName.equals(mkb.actionName)) continue;
                deletedKB.add(mkb);
                continue block0;
            }
        }
        if (deletedKB.size() > 0 || addedKB.size() > 0) {
            newKB.removeAll(deletedKB);
            newKB.addAll(addedKB);
            this.setKeyBindingsDiffMap(OptionUtilities.getMapDiff(OptionUtilities.makeKeyBindingsMap(this.getKBList()), OptionUtilities.makeKeyBindingsMap(newKB), true));
            Settings.setValue((Class)this.getKitClass(), (String)"key-bindings", (Object)newKB);
        }
    }

    public Map getMacroMap() {
        this.loadDefaultMacros();
        this.loadSettings(MacrosMIMEProcessor.class);
        Map settingsMap = (Map)super.getSettingValue("macro-map");
        if (settingsMap == null) {
            Utilities.annotateLoggable((Throwable)new NullPointerException("settingsMap is null for kit:" + this.getKitClass()));
        }
        HashMap<Object, List> ret = settingsMap == null ? new HashMap<Object, List>() : new HashMap(settingsMap);
        ret.put(null, this.getKBList());
        return ret;
    }

    public void setMacroDiffMap(Map diffMap) {
        if (diffMap != null && diffMap.size() > 0) {
            this.updateSettings(MacrosMIMEProcessor.class, diffMap);
        }
    }

    public void setMacroMap(Map map, boolean saveToXML) {
        Map diffMap = null;
        ArrayList kb = new ArrayList();
        if (map.containsKey(null)) {
            kb.addAll((List)map.get(null));
            map.remove(null);
        }
        if (saveToXML) {
            this.loadDefaultMacros();
            diffMap = OptionUtilities.getMapDiff(this.getMacroMap(), map, true);
            if (diffMap.containsKey(null)) {
                diffMap.remove(null);
            }
            if (diffMap.size() > 0) {
                this.processMacroKeyBindings(diffMap, kb);
                this.updateSettings(MacrosMIMEProcessor.class, diffMap);
            }
        }
        super.setSettingValue("macro-map", map);
    }

    public void setMacroMap(Map map) {
        this.setMacroMap(map, true);
    }

    public Insets getMargin() {
        return (Insets)this.getSettingValue(MARGIN_PROP);
    }

    public void setMargin(Insets i) {
        this.setSettingValue(MARGIN_PROP, i, MARGIN_PROP);
    }

    public boolean getStatusBarVisible() {
        return this.getSettingBoolean("status-bar-visible");
    }

    public void setStatusBarVisible(boolean v) {
        this.setSettingBoolean("status-bar-visible", v, STATUS_BAR_VISIBLE_PROP);
    }

    public int getStatusBarCaretDelay() {
        return this.getSettingInteger("status-bar-caret-delay");
    }

    public void setStatusBarCaretDelay(int delay) {
        if (delay < 0) {
            NbEditorUtilities.invalidArgument("MSG_NegativeValue");
            return;
        }
        this.setSettingInteger("status-bar-caret-delay", delay, STATUS_BAR_CARET_DELAY_PROP);
    }

    public boolean getFindHighlightSearch() {
        return this.getSettingBoolean("find-highlight-search");
    }

    public void setFindHighlightSearch(boolean b) {
        this.setSettingBoolean("find-highlight-search", b, FIND_HIGHLIGHT_SEARCH_PROP);
    }

    public boolean getFindBlockSearch() {
        return this.getSettingBoolean("find-block-search");
    }

    public void setFindBlockSearch(boolean b) {
        this.setSettingBoolean("find-block-search", b, FIND_BLOCK_SEARCH_PROP);
    }

    public boolean getFindIncSearch() {
        return this.getSettingBoolean("find-inc-search");
    }

    public void setFindIncSearch(boolean b) {
        this.setSettingBoolean("find-inc-search", b, FIND_INC_SEARCH_PROP);
    }

    public int getFindIncSearchDelay() {
        return this.getSettingInteger("find-inc-search-delay");
    }

    public void setFindIncSearchDelay(int delay) {
        if (delay < 0) {
            NbEditorUtilities.invalidArgument("MSG_NegativeValue");
            return;
        }
        this.setSettingInteger("find-inc-search-delay", delay, FIND_INC_SEARCH_DELAY_PROP);
    }

    public boolean getFindWrapSearch() {
        return this.getSettingBoolean("find-wrap-search");
    }

    public void setFindWrapSearch(boolean b) {
        this.setSettingBoolean("find-wrap-search", b, FIND_WRAP_SEARCH_PROP);
    }

    public boolean getFindSmartCase() {
        return this.getSettingBoolean("find-smart-case");
    }

    public void setFindSmartCase(boolean b) {
        this.setSettingBoolean("find-smart-case", b, FIND_SMART_CASE_PROP);
    }

    public Map getFindHistory() {
        return new HashMap((Map)this.getSettingValue("find-history"));
    }

    public void setFindHistory(Map m) {
        this.setSettingValue("find-history", m, FIND_HISTORY_PROP);
    }

    public int getFindHistorySize() {
        return this.getSettingInteger("find-history-size");
    }

    public void setFindHistorySize(int size) {
        this.setSettingInteger("find-history-size", size, FIND_HISTORY_SIZE_PROP);
    }

    public boolean getPairCharactersCompletion() {
        return this.getSettingBoolean("pair-characters-completion");
    }

    public void setPairCharactersCompletion(boolean v) {
        this.setSettingBoolean("pair-characters-completion", v, PAIR_CHARACTERS_COMPLETION);
    }

    public Color getTextLimitLineColor() {
        this.loadSettings(FontsColorsMIMEProcessor.class);
        return (Color)super.getSettingValue("text-limit-line-color");
    }

    public void setTextLimitLineColor(Color color) {
        this.setTextLimitLineColor(color, true);
    }

    public void setTextLimitLineColor(Color color, boolean saveToXML) {
        if (saveToXML && !this.getTextLimitLineColor().equals(color) && color != null) {
            HashMap<String, Color> map = new HashMap<String, Color>();
            map.put("text-limit-line-color", color);
            if (map != null) {
                this.updateSettings(FontsColorsMIMEProcessor.class, map);
            }
        }
        super.setSettingValue("text-limit-line-color", color, TEXT_LIMIT_LINE_COLOR_PROP);
    }

    public int getTextLimitWidth() {
        return this.getSettingInteger("text-limit-width");
    }

    public void setTextLimitWidth(int width) {
        if (width <= 0) {
            NbEditorUtilities.invalidArgument("MSG_OutOfRange");
            return;
        }
        this.setSettingInteger("text-limit-width", width, TEXT_LIMIT_WIDTH_PROP);
    }

    public boolean getTextLimitLineVisible() {
        return this.getSettingBoolean("text-limit-line-visible");
    }

    public void setTextLimitLineVisible(boolean visible) {
        this.setSettingBoolean("text-limit-line-visible", visible, TEXT_LIMIT_LINE_VISIBLE_PROP);
    }

    public boolean getHighlightMatchingBracket() {
        return this.getSettingBoolean("highlight-match-brace");
    }

    public void setHighlightMatchingBracket(boolean highlight) {
        this.setSettingBoolean("highlight-match-brace", highlight, HIGHLIGHT_MATCHING_BRACKET_PROP);
    }

    public boolean getHighlightCaretRow() {
        return this.getSettingBoolean("highlight-caret-row");
    }

    public void setHighlightCaretRow(boolean highlight) {
        this.setSettingBoolean("highlight-caret-row", highlight, HIGHLIGHT_CARET_ROW_PROP);
    }

    public boolean isToolbarVisible() {
        return this.getSettingBoolean(TOOLBAR_VISIBLE_PROP);
    }

    public void setToolbarVisible(boolean toolbarVisible) {
        this.setSettingBoolean(TOOLBAR_VISIBLE_PROP, toolbarVisible, TOOLBAR_VISIBLE_PROP);
    }

    public boolean isTextAntialiasing() {
        Boolean val = (Boolean)this.getSettingValue(TEXT_ANTIALIASING_PROP);
        if (val != null) {
            return val;
        }
        if (Boolean.getBoolean("javax.aatext")) {
            return true;
        }
        if (org.openide.util.Utilities.getOperatingSystem() == 4096) {
            return true;
        }
        return BaseOptions.isSystemAntialias();
    }

    private static boolean isSystemAntialias() {
        Map systemHints = (Map)Toolkit.getDefaultToolkit().getDesktopProperty("awt.font.desktophints");
        if (systemHints != null) {
            Object o = systemHints.get(RenderingHints.KEY_TEXT_ANTIALIASING);
            boolean result = o != null && o != RenderingHints.VALUE_TEXT_ANTIALIAS_OFF && o != RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT;
            return result;
        }
        return false;
    }

    public void setTextAntialiasing(boolean textAntialiasing) {
        this.setSettingBoolean(TEXT_ANTIALIASING_PROP, textAntialiasing, TEXT_ANTIALIASING_PROP);
        Settings.touchValue((Class)this.getKitClass(), (String)"rendering-hints");
    }

    public Map getCodeFoldingProps() {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        Boolean val = (Boolean)this.getSettingValue("code-folding-enable");
        map.put("code-folding-enable", val);
        return map;
    }

    public void setCodeFoldingProps(Map props) {
        String name = "code-folding-enable";
        this.setSettingValue(name, props.get(name));
    }

    public void initPopupMenuItems() {
        List orderedPopupFiles = this.getOrderedMultiPropertyFolderFiles("Popup");
    }

    public List getOrderedMultiPropertyFolderFiles(String folderName) {
        MultiPropertyFolder mpf;
        MIMEOptionFolder mimeFolder;
        if (!BASE.equals(this.getTypeName()) && (mimeFolder = this.getMIMEFolder()) != null && (mpf = mimeFolder.getMPFolder(folderName, false)) != null) {
            DataFolder df = mpf.getDataFolder();
            ArrayList mimeFolderAttribs = new ArrayList();
            Enumeration e = df.getPrimaryFile().getAttributes();
            while (e.hasMoreElements()) {
                mimeFolderAttribs.add(e.nextElement());
            }
            if (mpf.getProperties().size() != 0 || mimeFolderAttribs.size() != 0) {
                HashSet mergedItems = new HashSet(OptionUtilities.getGlobalMenuItems(folderName));
                mergedItems.addAll(mpf.getProperties());
                HashSet mergedAttribs = new HashSet(OptionUtilities.getGlobalAttribs(folderName));
                mergedAttribs.addAll(mimeFolderAttribs);
                return OptionUtilities.arrangeMergedFolderObjects(mergedItems, mergedAttribs);
            }
        }
        return OptionUtilities.getGlobalMenuItems(folderName);
    }

    public IndentEngine getIndentEngine() {
        IndentEngine eng;
        Object o;
        if (this.inReadExternal) {
            return this.readExternalIndentEngine;
        }
        if (!BASE.equals(this.getTypeName())) {
            Map setMap;
            Object handle;
            MIMEOptionFile file;
            this.loadSettings(PropertiesMIMEProcessor.class);
            MIMEOptionFolder mimeFolder = this.getMIMEFolder();
            if (mimeFolder != null && (file = mimeFolder.getFile(PropertiesMIMEProcessor.class, false)) != null && (handle = (setMap = file.getAllProperties()).get(INDENT_ENGINE_PROP)) instanceof String) {
                Object instance = null;
                String handleString = (String)handle;
                if (handleString.equals(NO_INDENT_ENGINE)) {
                    return IndentEngine.getDefault();
                }
                Lookup.Template tmp = new Lookup.Template(null, handleString, null);
                Lookup.Item item = Lookup.getDefault().lookupItem(tmp);
                if (item != null && (instance = item.getInstance()) instanceof IndentEngine) {
                    return (IndentEngine)instance;
                }
            }
        }
        if ((o = this.getProperty(INDENT_ENGINE_PROP)) instanceof ServiceType.Handle) {
            eng = (IndentEngine)((ServiceType.Handle)o).getServiceType();
            if (eng != null) {
                this.setIndentEngine(eng);
                return eng;
            }
        } else if (o instanceof IndentEngine) {
            this.setIndentEngine((IndentEngine)o);
            return (IndentEngine)o;
        }
        if ((eng = this.findDefaultIndentEngine()) != null) {
            this.setIndentEngine(eng);
        }
        return eng;
    }

    public void setIndentEngine(IndentEngine eng) {
        if (!this.inReadExternal) {
            String id = null;
            if (eng != null) {
                Lookup.Template tmp = new Lookup.Template(null, null, (Object)eng);
                Lookup.Item item = Lookup.getDefault().lookupItem(tmp);
                if (item != null) {
                    id = item.getId();
                }
            }
            if (!BASE.equals(this.getTypeName())) {
                HashMap<String, String> map = new HashMap<String, String>();
                if (id == null) {
                    id = NO_INDENT_ENGINE;
                }
                map.put(INDENT_ENGINE_PROP, id);
                this.updateSettings(PropertiesMIMEProcessor.class, map, false);
            }
            this.refreshIndentEngineSettings();
        }
    }

    private void refreshIndentEngineSettings() {
        RequestProcessor.postRequest((Runnable)new Runnable(){

            public void run() {
                Settings.touchValue((Class)BaseOptions.this.getKitClass(), (String)BaseOptions.INDENT_ENGINE_PROP);
                Settings.touchValue((Class)BaseOptions.this.getKitClass(), (String)"formatter");
            }
        });
    }

    protected Class getDefaultIndentEngineClass() {
        return SimpleIndentEngine.class;
    }

    private IndentEngine findDefaultIndentEngine() {
        if (this.getDefaultIndentEngineClass() != null) {
            return (IndentEngine)Lookup.getDefault().lookup(this.getDefaultIndentEngineClass());
        }
        return null;
    }

    public void setOptionsVersion(int optionsVersion) {
        int oldOptionsVersion = this.optionsVersion;
        this.optionsVersion = optionsVersion;
        if (optionsVersion != oldOptionsVersion) {
            this.firePropertyChange(OPTIONS_VERSION_PROP, new Integer(oldOptionsVersion), new Integer(optionsVersion));
        }
    }

    public int getOptionsVersion() {
        return this.optionsVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.readExternalIndentEngine = this.getIndentEngine();
        this.inReadExternal = true;
        this.optionsVersion = 0;
        try {
            super.readExternal(in);
        }
        catch (OptionalDataException optionalDataException) {
        }
        finally {
            this.refreshIndentEngineSettings();
            this.optionsVersion = 21;
            this.inReadExternal = false;
            this.readExternalIndentEngine = null;
        }
    }

    protected void upgradeOptions(int version, int latestVersion) {
    }

    private void loadSettings(Class processor) {
        MIMEOptionFile file;
        if (BASE.equals(this.getTypeName())) {
            MIMEOptionFolder mimeFolder = AllOptionsFolder.getDefault().getMIMEFolder();
            if (mimeFolder == null) {
                return;
            }
            file = mimeFolder.getFile(processor, false);
        } else {
            MIMEOptionFolder mimeFolder = this.getMIMEFolder();
            if (mimeFolder == null) {
                return;
            }
            file = mimeFolder.getFile(processor, false);
        }
        if (file != null && !file.isLoaded()) {
            file.loadSettings();
        }
    }

    private void updateSettings(Class processor, Map settings) {
        this.updateSettings(processor, settings, true);
    }

    private void updateSettings(Class processor, Map settings, boolean useRequestProcessorForSaving) {
        MIMEOptionFile fileX;
        MIMEOptionFolder mimeFolder;
        if (this.usingNewOptions && processor == FontsColorsMIMEProcessor.class) {
            return;
        }
        if (BASE.equals(this.getTypeName())) {
            mimeFolder = AllOptionsFolder.getDefault().getMIMEFolder();
            if (mimeFolder == null) {
                return;
            }
            fileX = mimeFolder.getFile(processor, true);
        } else {
            mimeFolder = this.getMIMEFolder();
            if (mimeFolder == null) {
                return;
            }
            fileX = mimeFolder.getFile(processor, true);
        }
        final Map finalSettings = settings;
        final MIMEOptionFile file = fileX;
        if (file != null) {
            if (useRequestProcessorForSaving) {
                RequestProcessor.postRequest((Runnable)new Runnable(){

                    public void run() {
                        file.updateSettings(finalSettings);
                    }
                });
            } else {
                file.updateSettings(finalSettings);
            }
        } else {
            System.err.println("!!!!!!!!!!!!!!!!!!!!!!!!" + processor.toString() + " type file haven't been found in folder:" + mimeFolder.getDataFolder());
        }
    }

    public void setSettingValue(String settingName, Object newValue) {
        this.setSettingValue(settingName, newValue, settingName);
    }

    private boolean isTheSame(String settingName, Object newValue) {
        if (settingName == null || settingName.equals(INDENT_ENGINE_PROP) || settingName.equals("formatter")) {
            return true;
        }
        Object oldValue = this.getSettingValue(settingName);
        return oldValue == null && newValue == null || oldValue != null && oldValue.equals(newValue);
    }

    public void setSettingValue(String settingName, Object newValue, String propertyName) {
        if (!this.isTheSame(settingName, newValue)) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(settingName, newValue);
            this.updateSettings(PropertiesMIMEProcessor.class, map);
        }
        super.setSettingValue(settingName, newValue, propertyName);
    }

    public Object getSettingValue(String settingName) {
        this.loadSettings(PropertiesMIMEProcessor.class);
        return super.getSettingValue(settingName);
    }

    protected final void setSettingBoolean(String settingName, boolean newValue, String propertyName) {
        this.setSettingValue(settingName, newValue ? Boolean.TRUE : Boolean.FALSE);
    }

    protected final void setSettingInteger(String settingName, int newValue, String propertyName) {
        this.setSettingValue(settingName, new Integer(newValue));
    }

    protected void loadXMLSettings() {
        if (this.usingNewOptions) {
            this.updateKeybindingsFromNewOptionsDialogAttributes();
        } else {
            this.getKeyBindingList();
        }
        this.getAbbrevMap();
        this.getMacroMap();
        if (this.usingNewOptions) {
            this.updateColoringsFromNewOptionsDialogAttributes();
        } else {
            this.loadSettings(FontsColorsMIMEProcessor.class);
        }
        this.loadSettings(PropertiesMIMEProcessor.class);
    }

    public void writeExternal() throws IOException {
    }

    public void writeExternal(ObjectOutput out) throws IOException {
    }

    protected void firePropertyChange(String name, Object oldValue, Object newValue) {
    }

    public static void setCodeTemplateExpandKey(KeyStroke ks) {
        String s = OptionUtilities.keyToString(ks);
        BaseOptions base = BaseOptions.getOptions(BaseKit.class);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(CODE_TEMPLATE_EXPAND_KEY, s);
        base.updateSettings(PropertiesMIMEProcessor.class, map);
    }

    public static KeyStroke getCodeTemplateExpandKey() {
        MIMEOptionFile file;
        MIMEOptionFolder mimeFolder = AllOptionsFolder.getDefault().getMIMEFolder();
        if (mimeFolder != null && (file = mimeFolder.getFile(PropertiesMIMEProcessor.class, false)) != null) {
            Map properties;
            String s;
            if (!file.isLoaded()) {
                file.loadSettings(false);
            }
            if ((s = (String)(properties = file.getAllProperties()).get(CODE_TEMPLATE_EXPAND_KEY)) != null) {
                return OptionUtilities.stringToKey(s);
            }
        }
        return KeyStroke.getKeyStroke(32, 0);
    }
}

