/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javadoc.comments;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.text.BadLocationException;
import org.netbeans.jmi.javamodel.Attribute;
import org.netbeans.jmi.javamodel.CallableFeature;
import org.netbeans.jmi.javamodel.ClassMember;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.modules.javadoc.comments.JavaDocEditorPanel;
import org.netbeans.modules.javadoc.comments.JavaTagNames;
import org.netbeans.modules.javadoc.comments.TagPanel;
import org.openide.ErrorManager;
import org.openide.src.JavaDocSupport;
import org.openide.src.JavaDocTag;
import org.openide.util.NbBundle;

public class StandardTagPanel
extends TagPanel
implements JavaTagNames {
    private static final String cardName = "CRD_STANDARD";
    private static final String[] classTags = new String[]{"@author", "@deprecated", "@since", "@version"};
    private static final String[] fieldTags = new String[]{"@deprecated", "@serial", "@since"};
    private static final String[] methodTags = new String[]{"@deprecated", "@return", "@serialData", "@since"};
    static final long serialVersionUID = 134652804415020896L;
    private JScrollPane descriptionScrollPane;
    private JComboBox nameComboBox;
    private JLabel jLabel2;
    private JLabel jLabel1;
    private JEditorPane descriptionTextArea;

    public StandardTagPanel(JavaDocEditorPanel editorPanel) {
        super(editorPanel);
        this.initComponents();
        this.jLabel2.setDisplayedMnemonic(NbBundle.getBundle((Class)StandardTagPanel.class).getString("CTL_StandardTagPanel.jLabel2.text_Mnemonic").charAt(0));
        this.jLabel1.setDisplayedMnemonic(NbBundle.getBundle((Class)StandardTagPanel.class).getString("CTL_StandardTagPanel.jLabel1.text_Mnemonic").charAt(0));
        this.addHTMLComponent(this.descriptionTextArea);
        editorPanel.registerComponent(this.descriptionTextArea);
        this.nameComboBox.getEditor().getEditorComponent().addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                StandardTagPanel.this.commitTagChange();
            }
        });
        this.initAccessibility();
    }

    public StandardTagPanel(ClassMember element, JavaDocEditorPanel editorPanel) {
        this(editorPanel);
        this.setElement(element);
    }

    public void setElement(ClassMember element) {
        int i;
        this.nameComboBox.removeAllItems();
        if (element instanceof CallableFeature) {
            for (i = 0; i < methodTags.length; ++i) {
                this.nameComboBox.addItem(methodTags[i]);
            }
            this.nameComboBox.setSelectedItem("");
        } else if (element instanceof Field || element instanceof Attribute) {
            for (i = 0; i < fieldTags.length; ++i) {
                this.nameComboBox.addItem(fieldTags[i]);
            }
            this.nameComboBox.setSelectedItem("");
        }
        if (element instanceof JavaClass) {
            for (i = 0; i < classTags.length; ++i) {
                this.nameComboBox.addItem(classTags[i]);
            }
            this.nameComboBox.setSelectedItem("");
        }
    }

    private void initAccessibility() {
        this.jLabel2.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)StandardTagPanel.class).getString("ACS_StandardTagPanel.jLabel2.textA11yDesc"));
        this.nameComboBox.getAccessibleContext().setAccessibleName(NbBundle.getBundle((Class)StandardTagPanel.class).getString("ACS_StandardTagPanel.nameComboBox.textA11yName"));
        this.jLabel1.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)StandardTagPanel.class).getString("ACS_StandardTagPanel.jLabel1.textA11yDesc"));
        this.descriptionTextArea.getAccessibleContext().setAccessibleName(NbBundle.getBundle((Class)StandardTagPanel.class).getString("ACS_StandardTagPanel.descriptionTextArea.textA11yName"));
    }

    private void initComponents() {
        this.jLabel2 = new JLabel();
        this.nameComboBox = new JComboBox();
        this.jLabel1 = new JLabel();
        this.descriptionScrollPane = new JScrollPane();
        this.descriptionTextArea = new JEditorPane();
        this.setLayout(new GridBagLayout());
        this.jLabel2.setText(NbBundle.getBundle((Class)StandardTagPanel.class).getString("CTL_StandardTagPanel.jLabel2.text"));
        this.jLabel2.setHorizontalAlignment(2);
        this.jLabel2.setLabelFor(this.nameComboBox);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 1);
        this.add((Component)this.jLabel2, gridBagConstraints);
        this.nameComboBox.setMaximumRowCount(4);
        this.nameComboBox.setToolTipText(NbBundle.getBundle((Class)StandardTagPanel.class).getString("ACS_StandardTagPanel.nameComboBox.textA11yDesc"));
        this.nameComboBox.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 1, 2, 2);
        this.add((Component)this.nameComboBox, gridBagConstraints);
        this.jLabel1.setText(NbBundle.getBundle((Class)StandardTagPanel.class).getString("CTL_StandardTagPanel.jLabel1.text"));
        this.jLabel1.setHorizontalAlignment(2);
        this.jLabel1.setLabelFor(this.descriptionTextArea);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 2, 2, 1);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.descriptionTextArea.setToolTipText(NbBundle.getBundle((Class)StandardTagPanel.class).getString("ACS_StandardTagPanel.descriptionTextArea.textA11yDesc"));
        this.descriptionTextArea.setContentType("text/html");
        this.descriptionTextArea.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                StandardTagPanel.this.descriptionTextAreaFocusGained(evt);
            }

            public void focusLost(FocusEvent evt) {
                StandardTagPanel.this.descriptionTextAreaFocusLost(evt);
            }
        });
        this.descriptionScrollPane.setViewportView(this.descriptionTextArea);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 1, 2, 2);
        this.add((Component)this.descriptionScrollPane, gridBagConstraints);
    }

    private void descriptionTextAreaFocusGained(FocusEvent evt) {
        this.enableHTMLButtons(true);
    }

    private void descriptionTextAreaFocusLost(FocusEvent evt) {
        this.enableHTMLButtons(false);
        this.commitTagChange();
    }

    void setData(JavaDocTag tag) {
        this.nameComboBox.getEditor().setItem(tag.name());
        if (tag.text() != null && !"".equals(tag.text().trim())) {
            this.descriptionTextArea.setText(tag.text());
        } else {
            try {
                this.descriptionTextArea.getDocument().remove(0, this.descriptionTextArea.getDocument().getLength());
            }
            catch (BadLocationException e) {
                ErrorManager.getDefault().annotate((Throwable)e, "Failed to remove the text in the descriptionTextArea.");
            }
        }
    }

    JavaDocTag getTag(String tagName) {
        return JavaDocSupport.createTag((String)((String)this.nameComboBox.getEditor().getItem()), (String)this.descriptionTextArea.getText());
    }

    String getCardName() {
        return cardName;
    }

    void grabFirstFocus() {
        if (this.nameComboBox.getSelectedIndex() == -1 && this.nameComboBox.getSelectedItem().equals("")) {
            this.nameComboBox.requestFocus();
        } else {
            this.descriptionTextArea.requestFocus();
        }
    }
}

