/*
 * Decompiled with CFR 0.152.
 */
package org.openide.src;

import org.openide.src.ClassElement;
import org.openide.src.ElementFormat;
import org.openide.src.ElementPrinter;
import org.openide.src.ElementPrinterInterruptException;
import org.openide.src.Identifier;
import org.openide.src.JavaDoc;
import org.openide.src.JavaDocSupport;
import org.openide.src.MemberElement;
import org.openide.src.SourceException;
import org.openide.src.Type;
import org.openide.util.NbBundle;

public final class FieldElement
extends MemberElement {
    private static final ElementFormat FIELD_FORMAT = new ElementFormat("{m,,\" \"}{t} {n}");
    static final long serialVersionUID = 2195820119328567201L;

    public FieldElement() {
        this(new Memory(), null);
    }

    public FieldElement(Impl impl, ClassElement declaringClass) {
        super(impl, declaringClass);
    }

    public Object clone() {
        return new FieldElement(new Memory(this), null);
    }

    final Impl getFieldImpl() {
        return (Impl)this.impl;
    }

    public Type getType() {
        return this.getFieldImpl().getType();
    }

    public void setType(Type type) throws SourceException {
        if (type == null) {
            this.throwSourceException(NbBundle.getMessage((Class)FieldElement.class, (String)"ERR_NullType"));
        } else if (type.equals(Type.VOID)) {
            this.throwSourceException(NbBundle.getMessage((Class)FieldElement.class, (String)"ERR_FieldTypeVoid"));
        }
        this.getFieldImpl().setType(type);
    }

    public String getInitValue() {
        return this.getFieldImpl().getInitValue();
    }

    public void setInitValue(String value) throws SourceException {
        this.getFieldImpl().setInitValue(value);
    }

    public int getModifiersMask() {
        if (this.isDeclaredInInterface()) {
            return 25;
        }
        return 223;
    }

    public final void setName(Identifier name) throws SourceException {
        FieldElement f;
        ClassElement c = this.getDeclaringClass();
        if (c != null && (f = c.getField(name)) != null && f != this) {
            String msg = NbBundle.getMessage((Class)ElementFormat.class, (String)"FMT_EXC_RenameField", (Object)c.getName().getName(), (Object)name);
            this.throwSourceException(msg);
        }
        super.setName(name);
    }

    public JavaDoc.Field getJavaDoc() {
        return this.getFieldImpl().getJavaDoc();
    }

    public void print(ElementPrinter printer) throws ElementPrinterInterruptException {
        printer.markField(this, 0);
        JavaDoc.Field doc = this.getJavaDoc();
        if (doc != null && !doc.isEmpty()) {
            printer.markField(this, 2);
            FieldElement.printJavaDoc(doc, printer);
            printer.markField(this, 3);
            printer.println("");
        }
        printer.markField(this, 4);
        printer.print(FIELD_FORMAT.format(this));
        printer.markField(this, 5);
        String init = this.getInitValue();
        if (init.length() > 0) {
            printer.print(" = ");
            printer.markField(this, 6);
            printer.print(init);
            printer.markField(this, 7);
        }
        printer.print(";");
        printer.markField(this, 1);
    }

    static class Memory
    extends MemberElement.Memory
    implements Impl {
        private Type type;
        private String initValue;
        private JavaDoc.Field javaDoc;
        static final long serialVersionUID = 1407258001185361107L;

        Memory() {
            this.type = Type.VOID;
            this.initValue = "";
            this.javaDoc = JavaDocSupport.createFieldJavaDoc(null);
        }

        Memory(FieldElement field) {
            super(field);
            this.type = field.getType();
            this.initValue = field.getInitValue();
            this.javaDoc = field.getJavaDoc().isEmpty() ? JavaDocSupport.createFieldJavaDoc(null) : JavaDocSupport.createFieldJavaDoc(field.getJavaDoc().getRawText());
        }

        public Type getType() {
            return this.type;
        }

        public void setType(Type type) {
            Type old = this.type;
            this.type = type;
            this.firePropertyChange("type", old, type);
        }

        public String getInitValue() {
            return this.initValue;
        }

        public void setInitValue(String value) {
            String old = this.initValue;
            this.initValue = value;
            this.firePropertyChange("initValue", old, value);
        }

        public JavaDoc.Field getJavaDoc() {
            return this.javaDoc;
        }

        public Object readResolve() {
            return new FieldElement(this, null);
        }
    }

    public static interface Impl
    extends MemberElement.Impl {
        public static final long serialVersionUID = -1612065404733395830L;

        public Type getType();

        public void setType(Type var1) throws SourceException;

        public String getInitValue();

        public void setInitValue(String var1) throws SourceException;

        public JavaDoc.Field getJavaDoc();
    }
}

