/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.propertysheet.editors;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.lang.reflect.Modifier;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.swing.JPanel;
import org.openide.ErrorManager;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.explorer.propertysheet.editors.ModifierPanel;
import org.openide.util.NbBundle;

public class ModifierEditor
extends JPanel
implements ExPropertyEditor {
    private ModifierPanel panel;
    static final long serialVersionUID = 6324048239020120791L;
    private int mask;
    private int modifier = 0;
    private PropertyEnv env;

    public ModifierEditor() {
        this(1535);
    }

    public ModifierEditor(int mask) {
        this.setMask(mask & 0x5FF);
        this.getAccessibleContext().setAccessibleDescription(ModifierEditor.getString("ACSD_ModifierPanel"));
    }

    public void addNotify() {
        this.setLayout(new BorderLayout());
        this.panel = new ModifierPanel(this);
        this.panel.setMnemonics(this.env);
        this.add((Component)this.panel, "Center");
        super.addNotify();
    }

    public void removeNotify() {
        super.removeNotify();
        if (this.panel != null) {
            this.remove(this.panel);
            this.panel = null;
        }
    }

    int getMask() {
        return this.mask;
    }

    public void setMask(int mask) {
        if (this.mask != mask) {
            int oldMask = this.mask;
            this.mask = mask & 0x5FF;
            this.firePropertyChange("mask", new Integer(oldMask), new Integer(mask));
            this.setModifier(this.modifier & mask);
        }
    }

    int getModifier() {
        return this.modifier;
    }

    void setModifier(int modifier) {
        if (this.modifier != modifier) {
            int oldModifier = this.modifier;
            this.modifier = modifier;
            this.firePropertyChange("modifier", new Integer(oldModifier), new Integer(modifier));
            this.firePropertyChange("modifiers", new Integer(oldModifier), new Integer(modifier));
        }
    }

    public void setValue(Object object) throws IllegalArgumentException {
        if (object == null) {
            this.setModifier(0);
            return;
        }
        if (!(object instanceof Integer)) {
            throw new IllegalArgumentException();
        }
        this.setModifier((Integer)object);
    }

    public String getJavaInitializationString() {
        return new Integer(this.getModifier()).toString();
    }

    public Object getValue() {
        return new Integer(this.getModifier());
    }

    public boolean isPaintable() {
        return false;
    }

    public void paintValue(Graphics g, Rectangle rectangle) {
    }

    public String getAsText() {
        return Modifier.toString(this.getModifier());
    }

    public void setAsText(String string) throws IllegalArgumentException {
        int newValue = 0;
        int oldValue = this.modifier;
        StringTokenizer tukac = new StringTokenizer(string, ", ", false);
        while (tukac.hasMoreTokens()) {
            int i;
            String token = tukac.nextToken();
            boolean known = false;
            for (i = 0; i < ModifierPanel.MODIFIER_COUNT; ++i) {
                if ((ModifierPanel.MODIFIER_VALUES[i] & this.mask) == 0 || !token.equals(ModifierPanel.MODIFIER_NAMES[i])) continue;
                if (ModifierPanel.MODIFIER_VALUES[i] == 16 && (newValue & 0x400) != 0 || ModifierPanel.MODIFIER_VALUES[i] == 1024 && (newValue & 0x10) != 0) break;
                newValue |= ModifierPanel.MODIFIER_VALUES[i];
                known = true;
                break;
            }
            if ((newValue & 7) == 0) {
                for (i = 1; i <= 3; ++i) {
                    if ((ModifierPanel.ACCESS_VALUES[i] & this.mask) == 0 || !token.equals(ModifierPanel.ACCESS_NAMES[i])) continue;
                    newValue |= ModifierPanel.ACCESS_VALUES[i];
                    known = true;
                    break;
                }
            }
            if (known) continue;
            IllegalArgumentException x = new IllegalArgumentException("Invalid modifier: " + token);
            String message = MessageFormat.format(ModifierEditor.getString("MSG_IllegalModifierString"), token);
            ErrorManager.getDefault().annotate((Throwable)x, 256, null, message, null, null);
            throw x;
        }
        if (oldValue != newValue) {
            this.modifier = newValue;
            this.firePropertyChange("modifier", new Integer(oldValue), new Integer(this.modifier));
        }
    }

    public String[] getTags() {
        return null;
    }

    public Component getCustomEditor() {
        return this;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public Object getPropertyValue() throws IllegalStateException {
        return this.getValue();
    }

    public void attachEnv(PropertyEnv env) {
        this.env = env;
    }

    private static String getString(String key) {
        return NbBundle.getBundle((String)"org.openide.explorer.propertysheet.editors.Bundle2", (Locale)Locale.getDefault(), (ClassLoader)ModifierEditor.class.getClassLoader()).getString(key);
    }
}

