/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.wizard.fromdb;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.mdr.events.AttributeEvent;
import org.netbeans.api.mdr.events.MDRChangeEvent;
import org.netbeans.api.mdr.events.MDRChangeListener;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.jmi.javamodel.Annotation;
import org.netbeans.jmi.javamodel.AttributeValue;
import org.netbeans.jmi.javamodel.Constructor;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.MultipartId;
import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.modules.j2ee.common.JMIGenerationUtil;
import org.netbeans.modules.j2ee.persistence.dd.PersistenceUtils;
import org.netbeans.modules.j2ee.persistence.dd.orm.model_1_0.Entity;
import org.netbeans.modules.j2ee.persistence.dd.orm.model_1_0.Table;
import org.netbeans.modules.j2ee.persistence.dd.persistence.model_1_0.PersistenceUnit;
import org.netbeans.modules.j2ee.persistence.entitygenerator.CMPMappingModel;
import org.netbeans.modules.j2ee.persistence.entitygenerator.EntityClass;
import org.netbeans.modules.j2ee.persistence.entitygenerator.EntityMember;
import org.netbeans.modules.j2ee.persistence.entitygenerator.RelationshipRole;
import org.netbeans.modules.j2ee.persistence.provider.ProviderUtil;
import org.netbeans.modules.j2ee.persistence.unit.PUDataObject;
import org.netbeans.modules.j2ee.persistence.wizard.Util;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.PersistenceGenerator;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.ProgressPanel;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.RelatedCMPHelper;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.RelatedCMPWizard;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.ErrorManager;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaPersistenceGenerator
implements PersistenceGenerator {
    private Map<String, String> entityName2TableName = new HashMap<String, String>();
    private HashMap genDataCache = new HashMap(13);
    private boolean fieldAccess = true;
    private boolean genNamedParams = true;
    private boolean genSerializableEntities = true;

    private String getCmrFieldBaseType(RelationshipRole role, String pkg, JavaClass jc) {
        String jcPkgName = jc.getResource().getPackageName();
        boolean samePackages = Utilities.compareObjects((Object)pkg, (Object)jcPkgName);
        RelationshipRole rA = role.getParent().getRoleA();
        RelationshipRole rB = role.getParent().getRoleB();
        RelationshipRole otherRole = role.equals(rA) ? rB : rA;
        String typeName = samePackages || pkg == null || pkg.length() == 0 ? otherRole.getEntityName() : pkg + "." + otherRole.getEntityName();
        return typeName;
    }

    @Override
    public void generateBeans(ProgressPanel progressPanel, RelatedCMPHelper helper, FileObject dbSchemaFile, ProgressHandle handle, boolean justTesting) throws IOException {
        MDRInstanceNameListener mdrListener = new MDRInstanceNameListener();
        EntityClass[] genBeans = helper.getBeans();
        int max = genBeans.length;
        handle.switchToDeterminate(max);
        String pkgName = helper.getPackageName();
        HashMap<String, EntityClass> beanMap = new HashMap<String, EntityClass>();
        ArrayList<FileObject> fileObjects = new ArrayList<FileObject>(genBeans.length);
        for (EntityClass e : genBeans) {
            beanMap.put(e.getClassName(), e);
        }
        for (int i = 0; i < genBeans.length; ++i) {
            PUDataObject pudo;
            PersistenceUnit[] pu;
            String className = genBeans[i].getClassName();
            FileObject packageFileObject = genBeans[i].getPackageFileObject();
            if (packageFileObject.getFileObject(className, "java") != null) {
                handle.progress(i);
                continue;
            }
            handle.progress(NbBundle.getMessage(RelatedCMPWizard.class, (String)"TXT_GeneratingClass", (Object)className), i);
            progressPanel.setText(NbBundle.getMessage(RelatedCMPWizard.class, (String)"TXT_GeneratingClass", (Object)className));
            CMPMappingModel dbMappings = genBeans[i].getCMPMapping();
            boolean rollback = true;
            boolean needsPKClass = !genBeans[i].isUsePkField();
            JavaClass pkClass = null;
            String pkClassName = null;
            ArrayList<Field> fieldsToAdd = new ArrayList<Field>();
            ArrayList<Field> nonNullableFields = new ArrayList<Field>();
            ArrayList<Method> methodsToAdd = new ArrayList<Method>();
            ArrayList<Field> fieldsToAddPK = null;
            ArrayList<Method> methodsToAddPK = null;
            ArrayList<String> pkColumns = new ArrayList<String>();
            ArrayList<Annotation> namedQueriesList = new ArrayList<Annotation>();
            String namedQueryPrefix = null;
            Field pkField = null;
            String pkFieldName = null;
            boolean genQueries = helper.isGenerateFinderMethods();
            if (i > 20) {
                mdrListener.register(className);
            }
            JavaClass javaClass = JMIGenerationUtil.createEntityClass((FileObject)packageFileObject, (String)className);
            if (i > 20) {
                mdrListener.waitInstance();
                mdrListener.unregister();
            }
            if (needsPKClass) {
                pkClassName = className + "PK";
                pkClass = JMIGenerationUtil.createClass((FileObject)packageFileObject, (String)pkClassName);
                String templateJavaDoc = pkClass.getJavadocText();
                pkClass.setJavadocText(NbBundle.getMessage(JavaPersistenceGenerator.class, (String)"MSG_Javadoc_PKClass", (Object)className, (Object)pkClassName) + templateJavaDoc);
            }
            JavaModel.getJavaRepository().beginTrans(true);
            try {
                List javaClassFeatures = javaClass.getFeatures();
                if (this.genSerializableEntities) {
                    JMIGenerationUtil.addInterface((JavaClass)javaClass, (String)"java.io.Serializable");
                }
                List entityAttributeValues = null;
                Annotation entityAnnotation = JMIGenerationUtil.createAnnotation((Element)javaClass, (String)"javax.persistence.Entity", entityAttributeValues);
                javaClass.getAnnotations().add(entityAnnotation);
                AttributeValue tableNameAttrValue = JMIGenerationUtil.createAttributeValue((Element)javaClass, (String)"name", (String)dbMappings.getTableName());
                Annotation tableAnnotation = JMIGenerationUtil.createAnnotation((Element)javaClass, (String)"javax.persistence.Table", Collections.singletonList(tableNameAttrValue));
                javaClass.getAnnotations().add(tableAnnotation);
                if (needsPKClass) {
                    pkFieldName = this.getFieldName(pkClassName);
                    JMIGenerationUtil.addInterface((JavaClass)pkClass, (String)"java.io.Serializable");
                    Annotation embeddableAnnotation = JMIGenerationUtil.createAnnotation((Element)pkClass, (String)"javax.persistence.Embeddable", null);
                    pkClass.getAnnotations().add(embeddableAnnotation);
                    JMIGenerationUtil.ensurePublicConstructor((JavaClass)pkClass);
                    fieldsToAddPK = new ArrayList<Field>();
                    methodsToAddPK = new ArrayList<Method>();
                    pkField = this.createField(pkFieldName, pkClassName, 4, javaClass);
                    pkField.setJavadocText(NbBundle.getMessage(JavaPersistenceGenerator.class, (String)"MSG_Javadoc_EmbeddedId"));
                    fieldsToAdd.add(pkField);
                    Method getter = JMIGenerationUtil.createGetterMethod((String)pkFieldName, (String)pkClassName, (String)pkClassName, (JavaClass)javaClass);
                    methodsToAdd.add(getter);
                    Annotation embeddedIdAnnotation = JMIGenerationUtil.createAnnotation((Element)javaClass, (String)"javax.persistence.EmbeddedId", (List)Collections.EMPTY_LIST);
                    this.addAnnotation(this.fieldAccess, pkField, getter, embeddedIdAnnotation);
                    methodsToAdd.add(JMIGenerationUtil.createSetterMethod((String)pkFieldName, (String)pkClassName, (String)pkClassName, (JavaClass)javaClass));
                }
                HashMap<Field, String> fieldToTypeName = new HashMap<Field, String>();
                Iterator fieldIt = genBeans[i].getFields().iterator();
                String beanName = javaClass.getSimpleName();
                while (fieldIt.hasNext()) {
                    boolean isLobType;
                    EntityMember m = (EntityMember)fieldIt.next();
                    String memberName = m.getMemberName();
                    String memberType = m.getMemberType();
                    String cmFieldMethodName = this.getCapitalizedFieldName(memberName);
                    boolean isPKMember = m.isPrimaryKey();
                    boolean addMembersToPKClass = needsPKClass && isPKMember;
                    JavaClass addToClass = addMembersToPKClass ? pkClass : javaClass;
                    ArrayList<Field> addToFieldsList = addMembersToPKClass ? fieldsToAddPK : fieldsToAdd;
                    ArrayList<Method> addToMethodsList = addMembersToPKClass ? methodsToAddPK : methodsToAdd;
                    String temporal = null;
                    if ("java.sql.Date".equals(memberType)) {
                        m.setMemberType("java.util.Date");
                        temporal = "DATE";
                    } else if ("java.sql.Time".equals(memberType)) {
                        m.setMemberType("java.util.Date");
                        temporal = "TIME";
                    } else if ("java.sql.Timestamp".equals(memberType)) {
                        m.setMemberType("java.util.Date");
                        temporal = "TIMESTAMP";
                    }
                    if (temporal != null) {
                        memberType = m.getMemberType();
                    }
                    Field field = this.createField(memberName, memberType, 2, addToClass);
                    addToFieldsList.add(field);
                    fieldToTypeName.put(field, memberType);
                    Method getter = JMIGenerationUtil.createGetterMethod((String)memberName, (String)cmFieldMethodName, (String)memberType, (JavaClass)addToClass);
                    if (isPKMember) {
                        if (!needsPKClass) {
                            pkField = field;
                        }
                        pkFieldName = pkField.getName();
                        genBeans[i].setPkFieldName(pkFieldName);
                        if (!needsPKClass) {
                            Annotation idAnnotation = JMIGenerationUtil.createAnnotation((Element)addToClass, (String)"javax.persistence.Id", (List)Collections.EMPTY_LIST);
                            this.addAnnotation(this.fieldAccess, field, getter, idAnnotation);
                        }
                    }
                    if (isLobType = m.isLobType()) {
                        Annotation lobAnnotation = JMIGenerationUtil.createAnnotation((Element)javaClass, (String)"javax.persistence.Lob", (List)Collections.EMPTY_LIST);
                        this.addAnnotation(this.fieldAccess, field, getter, lobAnnotation);
                    }
                    ArrayList<AttributeValue> colAttrs = new ArrayList<AttributeValue>();
                    String columnName = (String)dbMappings.getCMPFieldMapping().get(memberName);
                    AttributeValue columnNameAttrValue = JMIGenerationUtil.createAttributeValue((Element)addToClass, (String)"name", (String)columnName);
                    colAttrs.add(columnNameAttrValue);
                    if (!m.isNullable()) {
                        AttributeValue columnNullableAttrValue = JMIGenerationUtil.createAttributeValue((Element)addToClass, (String)"nullable", (boolean)false);
                        colAttrs.add(columnNullableAttrValue);
                        if (!isPKMember) {
                            nonNullableFields.add(field);
                        } else {
                            pkColumns.add(columnName);
                        }
                    }
                    Annotation columnAnnotation = JMIGenerationUtil.createAnnotation((Element)addToClass, (String)"javax.persistence.Column", colAttrs);
                    this.addAnnotation(this.fieldAccess, field, getter, columnAnnotation);
                    if (temporal != null) {
                        AttributeValue tempAttrValue = JMIGenerationUtil.createAttributeValue((Element)addToClass, (String)"", (String)"javax.persistence.TemporalType", (String)temporal);
                        Annotation temporalAnnotation = JMIGenerationUtil.createAnnotation((Element)addToClass, (String)"javax.persistence.Temporal", Collections.singletonList(tempAttrValue));
                        this.addAnnotation(this.fieldAccess, field, getter, temporalAnnotation);
                    }
                    addToMethodsList.add(getter);
                    addToMethodsList.add(JMIGenerationUtil.createSetterMethod((String)memberName, (String)cmFieldMethodName, (String)memberType, (JavaClass)addToClass));
                    if (!genQueries || isLobType) continue;
                    ArrayList<AttributeValue> queryAttrs = new ArrayList<AttributeValue>();
                    AttributeValue queryNameAttrValue = JMIGenerationUtil.createAttributeValue((Element)javaClass, (String)"name", (String)(beanName + ".findBy" + cmFieldMethodName));
                    queryAttrs.add(queryNameAttrValue);
                    if (namedQueryPrefix == null) {
                        char firstLetter = beanName.toLowerCase().charAt(0);
                        namedQueryPrefix = "SELECT " + firstLetter + " FROM " + beanName + " " + firstLetter + " WHERE " + firstLetter + ".";
                    }
                    String memberAccessString = addMembersToPKClass ? pkFieldName + "." + memberName : memberName;
                    AttributeValue queryStringAttrValue = JMIGenerationUtil.createAttributeValue((Element)javaClass, (String)"query", (String)(namedQueryPrefix + memberAccessString + (this.genNamedParams ? " = :" + memberName : "= ?1")));
                    queryAttrs.add(queryStringAttrValue);
                    Annotation namedQueryAnnotation = JMIGenerationUtil.createAnnotation((Element)javaClass, (String)"javax.persistence.NamedQuery", queryAttrs);
                    namedQueriesList.add(namedQueryAnnotation);
                }
                if (genQueries && !namedQueriesList.isEmpty()) {
                    ArrayList<AttributeValue> queryAttrs = new ArrayList<AttributeValue>();
                    AttributeValue queryValueAttrValue = JMIGenerationUtil.createAttributeValue((Element)javaClass, (String)"", namedQueriesList);
                    queryAttrs.add(queryValueAttrValue);
                    Annotation namedQueriesAnnotation = JMIGenerationUtil.createAnnotation((Element)javaClass, (String)"javax.persistence.NamedQueries", queryAttrs);
                    javaClass.getAnnotations().add(namedQueriesAnnotation);
                }
                List<Object> pkFields = Collections.singletonList(pkField);
                javaClassFeatures.add(JMIGenerationUtil.createConstructor((JavaClass)javaClass, pkFields));
                if (nonNullableFields.size() > 0) {
                    nonNullableFields.add(0, pkField);
                    javaClassFeatures.add(JMIGenerationUtil.createConstructor((JavaClass)javaClass, nonNullableFields));
                }
                for (RelationshipRole role : genBeans[i].getRoles()) {
                    ArrayList<Annotation> joinCols;
                    String memberName = role.getFieldName();
                    String cmFieldMethodName = this.getCapitalizedFieldName(memberName);
                    boolean isToMany = role.isToMany();
                    String rv = this.getCmrFieldBaseType(role, genBeans[i].getPackage(), javaClass);
                    String rvType = isToMany ? Collection.class.getName() : rv;
                    Field field = this.createField(memberName, rvType, 2, javaClass);
                    if (isToMany) {
                        List typeArgs = ((MultipartId)field.getTypeName()).getTypeArguments();
                        typeArgs.add(JMIGenerationUtil.createImport((Element)javaClass, (String)rv));
                    }
                    fieldsToAdd.add(field);
                    Method getter = JMIGenerationUtil.createGetterMethod((String)memberName, (String)cmFieldMethodName, (String)rvType, (JavaClass)javaClass);
                    if (isToMany) {
                        List typeArgs = ((MultipartId)getter.getTypeName()).getTypeArguments();
                        typeArgs.add(JMIGenerationUtil.createImport((Element)javaClass, (String)rv));
                    }
                    boolean cascadeDelete = role.isCascade();
                    ArrayList<AttributeValue> annAttributes = new ArrayList<AttributeValue>();
                    if (cascadeDelete) {
                        AttributeValue cascadeAttibuteValue = JMIGenerationUtil.createAttributeValue((Element)javaClass, (String)"cascade", (String)"javax.persistence.CascadeType", (String)"ALL");
                        annAttributes.add(cascadeAttibuteValue);
                    }
                    if (role.equals(role.getParent().getRoleB())) {
                        AttributeValue mappedByAttibuteValue = JMIGenerationUtil.createAttributeValue((Element)javaClass, (String)"mappedBy", (String)role.getParent().getRoleA().getFieldName());
                        annAttributes.add(mappedByAttibuteValue);
                    } else if (role.isMany() && role.isToMany()) {
                        ArrayList<AttributeValue> joinAttributes = new ArrayList<AttributeValue>();
                        AttributeValue joinTableNameAttrValue = JMIGenerationUtil.createAttributeValue((Element)javaClass, (String)"name", (String)((String)dbMappings.getJoinTableMapping().get(role.getFieldName())));
                        joinAttributes.add(joinTableNameAttrValue);
                        CMPMappingModel.JoinTableColumnMapping joinColumnMap = dbMappings.getJoinTableColumnMppings().get(role.getFieldName());
                        joinCols = new ArrayList<Annotation>();
                        String[] colNames = joinColumnMap.getColumns();
                        String[] refColNames = joinColumnMap.getReferencedColumns();
                        for (int colIndex = 0; colIndex < colNames.length; ++colIndex) {
                            AttributeValue joinColumnNameAttrValue = JMIGenerationUtil.createAttributeValue((Element)javaClass, (String)"name", (String)colNames[colIndex]);
                            AttributeValue joinColumnRefNameAttrValue = JMIGenerationUtil.createAttributeValue((Element)javaClass, (String)"referencedColumnName", (String)refColNames[colIndex]);
                            ArrayList<AttributeValue> attrs = new ArrayList<AttributeValue>();
                            attrs.add(joinColumnNameAttrValue);
                            attrs.add(joinColumnRefNameAttrValue);
                            Annotation joinColumnAnnotation = JMIGenerationUtil.createAnnotation((Element)javaClass, (String)"javax.persistence.JoinColumn", attrs);
                            joinCols.add(joinColumnAnnotation);
                        }
                        AttributeValue joinColumnsNameAttrValue = JMIGenerationUtil.createAttributeValue((Element)javaClass, (String)"joinColumns", joinCols);
                        joinAttributes.add(joinColumnsNameAttrValue);
                        ArrayList<Annotation> inverseCols = new ArrayList<Annotation>();
                        String[] invColNames = joinColumnMap.getInverseColumns();
                        String[] refInvColNames = joinColumnMap.getReferencedInverseColumns();
                        for (int colIndex = 0; colIndex < invColNames.length; ++colIndex) {
                            AttributeValue joinColumnNameAttrValue = JMIGenerationUtil.createAttributeValue((Element)javaClass, (String)"name", (String)invColNames[colIndex]);
                            AttributeValue joinColumnRefNameAttrValue = JMIGenerationUtil.createAttributeValue((Element)javaClass, (String)"referencedColumnName", (String)refInvColNames[colIndex]);
                            ArrayList<AttributeValue> attrs = new ArrayList<AttributeValue>();
                            attrs.add(joinColumnNameAttrValue);
                            attrs.add(joinColumnRefNameAttrValue);
                            Annotation joinColumnAnnotation = JMIGenerationUtil.createAnnotation((Element)javaClass, (String)"javax.persistence.JoinColumn", attrs);
                            inverseCols.add(joinColumnAnnotation);
                        }
                        AttributeValue inverseColumnsNameAttrValue = JMIGenerationUtil.createAttributeValue((Element)javaClass, (String)"inverseJoinColumns", inverseCols);
                        joinAttributes.add(inverseColumnsNameAttrValue);
                        Annotation joinTableAnnotation = JMIGenerationUtil.createAnnotation((Element)javaClass, (String)"javax.persistence.JoinTable", joinAttributes);
                        this.addAnnotation(this.fieldAccess, field, getter, joinTableAnnotation);
                    } else {
                        String[] colNames = (String[])dbMappings.getCmrFieldMapping().get(role.getFieldName());
                        CMPMappingModel relatedMappings = ((EntityClass)beanMap.get(role.getParent().getRoleB().getEntityName())).getCMPMapping();
                        String[] invColNames = (String[])relatedMappings.getCmrFieldMapping().get(role.getParent().getRoleB().getFieldName());
                        if (colNames.length == 1) {
                            AttributeValue joinColumnNameAttrValue = JMIGenerationUtil.createAttributeValue((Element)javaClass, (String)"name", (String)colNames[0]);
                            AttributeValue joinColumnRefNameAttrValue = JMIGenerationUtil.createAttributeValue((Element)javaClass, (String)"referencedColumnName", (String)invColNames[0]);
                            ArrayList<AttributeValue> attrs = new ArrayList<AttributeValue>();
                            attrs.add(joinColumnNameAttrValue);
                            attrs.add(joinColumnRefNameAttrValue);
                            this.makeReadOnlyIfNecessary(pkColumns, colNames[0], javaClass, attrs);
                            Annotation joinColumnAnnotation = JMIGenerationUtil.createAnnotation((Element)javaClass, (String)"javax.persistence.JoinColumn", attrs);
                            this.addAnnotation(this.fieldAccess, field, getter, joinColumnAnnotation);
                        } else {
                            joinCols = new ArrayList();
                            for (int colIndex = 0; colIndex < colNames.length; ++colIndex) {
                                AttributeValue joinColumnNameAttrValue = JMIGenerationUtil.createAttributeValue((Element)javaClass, (String)"name", (String)colNames[colIndex]);
                                AttributeValue joinColumnRefNameAttrValue = JMIGenerationUtil.createAttributeValue((Element)javaClass, (String)"referencedColumnName", (String)invColNames[colIndex]);
                                ArrayList<AttributeValue> attrs = new ArrayList<AttributeValue>();
                                attrs.add(joinColumnNameAttrValue);
                                attrs.add(joinColumnRefNameAttrValue);
                                this.makeReadOnlyIfNecessary(pkColumns, colNames[colIndex], javaClass, attrs);
                                Annotation joinColumnAnnotation = JMIGenerationUtil.createAnnotation((Element)javaClass, (String)"javax.persistence.JoinColumn", attrs);
                                joinCols.add(joinColumnAnnotation);
                            }
                            AttributeValue joinColumnsNameAttrValue = JMIGenerationUtil.createAttributeValue((Element)javaClass, (String)"value", joinCols);
                            Annotation joinColumnsAnnotation = JMIGenerationUtil.createAnnotation((Element)javaClass, (String)"javax.persistence.JoinColumns", Collections.singletonList(joinColumnsNameAttrValue));
                            this.addAnnotation(this.fieldAccess, field, getter, joinColumnsAnnotation);
                        }
                    }
                    String relationAnn = role.isMany() && role.isToMany() ? "ManyToMany" : (role.isMany() ? "ManyToOne" : (role.isToMany() ? "OneToMany" : "OneToOne"));
                    Annotation relAnnotation = JMIGenerationUtil.createAnnotation((Element)javaClass, (String)("javax.persistence." + relationAnn), annAttributes);
                    this.addAnnotation(this.fieldAccess, field, getter, relAnnotation);
                    methodsToAdd.add(getter);
                    Method setter = JMIGenerationUtil.createSetterMethod((String)memberName, (String)cmFieldMethodName, (String)rvType, (JavaClass)javaClass);
                    if (isToMany) {
                        List typeArgs = ((MultipartId)((Parameter)setter.getParameters().get(0)).getTypeName()).getTypeArguments();
                        typeArgs.add(JMIGenerationUtil.createImport((Element)javaClass, (String)rv));
                    }
                    methodsToAdd.add(setter);
                }
                methodsToAdd.add(JMIGenerationUtil.createHashCodeMethod((JavaClass)javaClass, pkFields));
                methodsToAdd.add(JMIGenerationUtil.createEntityEqualsMethod((JavaClass)javaClass, pkFields));
                methodsToAdd.add(JMIGenerationUtil.createToStringMethod((JavaClass)javaClass, pkFields));
                if (fieldsToAddPK != null) {
                    Constructor constructor = JMIGenerationUtil.createConstructor((JavaClass)javaClass, (int)1);
                    String simpleName = pkClass.getSimpleName();
                    StringBuffer constructorBody = new StringBuffer("this." + pkFieldName + " = new " + simpleName + "(");
                    StringBuffer constructorJavaDoc = new StringBuffer(NbBundle.getMessage(JavaPersistenceGenerator.class, (String)"MSG_Javadoc_Constructor", (Object)simpleName));
                    List params = constructor.getParameters();
                    List featuresList = pkClass.getFeatures();
                    int pkFieldsCount = fieldsToAddPK.size();
                    Collections.reverse(fieldsToAddPK);
                    featuresList.add(JMIGenerationUtil.createConstructor((JavaClass)pkClass, fieldsToAddPK));
                    for (int j = 0; j < pkFieldsCount; ++j) {
                        Field nextField = (Field)fieldsToAddPK.get(j);
                        String fieldName = nextField.getName();
                        Type fieldType = nextField.getType();
                        Parameter fieldParameter = JMIGenerationUtil.createParameter((Element)javaClass, (String)fieldName, (String)fieldType.getName());
                        featuresList.add(0, nextField);
                        params.add(fieldParameter);
                        constructorBody.append(fieldName);
                        constructorBody.append(j < pkFieldsCount - 1 ? ", " : ");");
                        String fieldTypeName = (String)fieldToTypeName.get(nextField);
                        JMIGenerationUtil.createImport((Element)javaClass, (String)fieldTypeName);
                        constructorJavaDoc.append(NbBundle.getMessage(JavaPersistenceGenerator.class, (String)"MSG_Javadoc_ConstructorParam", (Object)fieldName, (Object)simpleName));
                    }
                    constructor.setBodyText(constructorBody.toString());
                    constructor.setJavadocText(constructorJavaDoc.toString());
                    javaClassFeatures.add(constructor);
                    methodsToAddPK.add(JMIGenerationUtil.createHashCodeMethod((JavaClass)pkClass, fieldsToAddPK));
                    methodsToAddPK.add(JMIGenerationUtil.createEntityEqualsMethod((JavaClass)pkClass, fieldsToAddPK));
                    methodsToAddPK.add(JMIGenerationUtil.createToStringMethod((JavaClass)pkClass, fieldsToAddPK));
                    Iterator it = methodsToAddPK.iterator();
                    while (it.hasNext()) {
                        featuresList.add((Method)it.next());
                    }
                }
                Collections.reverse(fieldsToAdd);
                Iterator it = fieldsToAdd.iterator();
                while (it.hasNext()) {
                    javaClassFeatures.add(0, (Field)it.next());
                }
                it = methodsToAdd.iterator();
                while (it.hasNext()) {
                    javaClassFeatures.add((Method)it.next());
                }
                rollback = false;
            }
            catch (Exception e) {
                String message = e.getMessage();
                String newMessage = message == null ? NbBundle.getMessage(RelatedCMPWizard.class, (String)"ERR_GeneratingClass_NoExceptionMessage", (Object)className) : NbBundle.getMessage(RelatedCMPWizard.class, (String)"ERR_GeneratingClass", (Object)className, (Object)message);
                IOException wrappedException = new IOException(newMessage);
                wrappedException.initCause(e);
                throw wrappedException;
            }
            finally {
                JavaModel.getJavaRepository().endTrans(rollback);
            }
            FileObject fo = javaClass == null ? null : JavaModel.getFileObject((Resource)javaClass.getResource());
            Project project = FileOwnerQuery.getOwner((FileObject)packageFileObject);
            if (fo == null) continue;
            fileObjects.add(fo);
            if (Util.isSupportedJavaEEVersion(project) || ProviderUtil.getDDFile(project) == null || (pu = (pudo = ProviderUtil.getPUDataObject(project)).getPersistence().getPersistenceUnit()).length != 1) continue;
            pudo.addClass(pu[0], javaClass.getName());
        }
        JavaMetamodel manager = JavaMetamodel.getManager();
        for (FileObject fileObj : fileObjects) {
            manager.addModified(fileObj);
        }
        JavaModel.getJavaRepository().beginTrans(true);
        JavaModel.getJavaRepository().endTrans(false);
        handle.progress(max);
    }

    @Override
    public void init(WizardDescriptor wiz) {
        Project project = Templates.getProject((WizardDescriptor)wiz);
        try {
            this.processEntities(PersistenceUtils.getEntityClasses(project));
        }
        catch (IOException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
        this.processEntities(PersistenceUtils.getAnnotationEntityClasses(project));
    }

    private void processEntities(Set<Entity> entityClasses) {
        for (Entity entity : entityClasses) {
            Table entityTable = entity.getTable();
            if (entityTable == null) continue;
            this.entityName2TableName.put(entityTable.getName(), entity.getClass2());
        }
    }

    @Override
    public void uninit() {
    }

    @Override
    public String getFQClassName(String tableName) {
        return this.entityName2TableName.get(tableName);
    }

    @Override
    public String generateEntityName(String name) {
        return name;
    }

    @Override
    public Set createdObjects() {
        return Collections.EMPTY_SET;
    }

    private String getFieldName(String capitalizedFieldName) {
        StringBuffer sb = new StringBuffer(capitalizedFieldName);
        sb.setCharAt(0, Character.toLowerCase(sb.charAt(0)));
        return sb.toString();
    }

    private String getCapitalizedFieldName(String fieldName) {
        StringBuffer sb = new StringBuffer(fieldName);
        sb.setCharAt(0, Character.toUpperCase(sb.charAt(0)));
        return sb.toString();
    }

    private Field createField(String fieldName, String fieldType, int modifiers, JavaClass javaClass) {
        return JMIGenerationUtil.createField((Element)javaClass, (String)fieldName, (int)modifiers, (String)fieldType);
    }

    private void addAnnotation(boolean isFieldAccess, Field field, Method getter, Annotation annotation) {
        if (isFieldAccess) {
            field.getAnnotations().add(annotation);
        } else {
            getter.getAnnotations().add(annotation);
        }
    }

    private void makeReadOnlyIfNecessary(List pkColumns, String testColumnName, JavaClass javaClass, List attrs) {
        if (pkColumns.contains(testColumnName)) {
            AttributeValue insertableAttrValue = JMIGenerationUtil.createAttributeValue((Element)javaClass, (String)"insertable", (boolean)false);
            AttributeValue updatableAttrValue = JMIGenerationUtil.createAttributeValue((Element)javaClass, (String)"updatable", (boolean)false);
            attrs.add(insertableAttrValue);
            attrs.add(updatableAttrValue);
        }
    }

    private class MDRInstanceNameListener
    implements MDRChangeListener {
        private boolean instanceDetected;
        private String name;

        private MDRInstanceNameListener() {
        }

        public synchronized void change(MDRChangeEvent e) {
            Object newElem = ((AttributeEvent)e).getNewElement();
            if (newElem instanceof String && ((String)newElem).endsWith(this.name)) {
                this.instanceDetected = true;
                this.notify();
            }
        }

        public synchronized void waitInstance() {
            if (this.instanceDetected) {
                return;
            }
            try {
                this.wait(3000L);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void register(String name) {
            MDRInstanceNameListener mDRInstanceNameListener = this;
            synchronized (mDRInstanceNameListener) {
                this.instanceDetected = false;
                this.name = name;
            }
            JavaModel.getJavaRepository().addListener((MDRChangeListener)this, 0x101FFFF);
        }

        public void unregister() {
            JavaModel.getJavaRepository().removeListener((MDRChangeListener)this);
        }
    }
}

