/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.ui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.modules.j2ee.persistence.dd.orm.model_1_0.Entity;
import org.netbeans.modules.j2ee.persistence.dd.orm.model_1_0.EntityMappings;
import org.netbeans.modules.j2ee.persistence.ui.EntityChildren;
import org.netbeans.modules.javacore.api.JavaModel;
import org.openide.ErrorManager;
import org.openide.actions.OpenAction;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.util.Lookup;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public class EntityNode
extends AbstractNode
implements OpenCookie {
    private final PropertyChangeListener nameChangeListener;
    private Entity entity;
    private ClassPath srcPath;

    public EntityNode(Entity model, EntityMappings module, ClassPath srcPath) {
        this(new InstanceContent(), model, module, srcPath);
    }

    private EntityNode(InstanceContent content, Entity model, EntityMappings module, ClassPath srcPath) {
        super((Children)new EntityChildren(model, srcPath, module), (Lookup)new AbstractLookup((AbstractLookup.Content)content));
        this.setIconBaseWithExtension("org/netbeans/modules/j2ee/persistence/ui/resources/EntityNodeIcon.gif");
        this.setName(model.getName() + "");
        this.entity = model;
        this.srcPath = srcPath;
        this.setDisplayName();
        this.nameChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent pce) {
                EntityNode.this.setDisplayName();
            }
        };
        model.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.nameChangeListener, (Object)((Object)model)));
        content.add((Object)this);
        JavaClass jc = (JavaClass)JavaModel.getDefaultExtent().getType().resolve(this.entity.getClass2());
        if (jc != null) {
            content.add((Object)jc);
        }
    }

    private void setDisplayName() {
        this.setDisplayName(this.entity.getName());
    }

    public Action[] getActions(boolean context) {
        return new SystemAction[]{SystemAction.get(OpenAction.class)};
    }

    public void open() {
        OpenCookie cookie;
        DataObject ce = this.getBeanDo();
        if (ce != null && (cookie = (OpenCookie)ce.getCookie(OpenCookie.class)) != null) {
            cookie.open();
        }
    }

    public Action getPreferredAction() {
        return SystemAction.get(OpenAction.class);
    }

    private FileObject findBeanFo() {
        return this.srcPath.findResource(this.entity.getClass2().replace('.', '/') + ".java");
    }

    public DataObject getBeanDo() {
        FileObject src = this.findBeanFo();
        try {
            if (src != null) {
                return DataObject.find((FileObject)src);
            }
        }
        catch (DataObjectNotFoundException ex) {
            ErrorManager.getDefault().log("Cannot find data object for " + this.entity.getClass2());
        }
        return null;
    }
}

