/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.verification.persistence.hints;

import java.awt.Dialog;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.netbeans.jmi.javamodel.AnnotableElement;
import org.netbeans.jmi.javamodel.Annotation;
import org.netbeans.jmi.javamodel.AttributeValue;
import org.netbeans.jmi.javamodel.ClassMember;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.NamedElement;
import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.jmi.javamodel.ParameterizedType;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.jmi.javamodel.StringLiteral;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.jmi.javamodel.TypedElement;
import org.netbeans.modules.editor.hints.spi.ChangeInfo;
import org.netbeans.modules.j2ee.common.JMIGenerationUtil;
import org.netbeans.modules.j2ee.verification.JEEVerificationContextInfo;
import org.netbeans.modules.j2ee.verification.JEEVerificationHint;
import org.netbeans.modules.j2ee.verification.ProblemFindingUtils;
import org.netbeans.modules.j2ee.verification.persistence.BeanAccessType;
import org.netbeans.modules.j2ee.verification.persistence.PersistenceAPIHelper;
import org.netbeans.modules.j2ee.verification.persistence.hints.CreateOneToOneAnnotationHint;
import org.netbeans.modules.j2ee.verification.persistence.hints.CreateRelationshipPanel;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.javacore.internalapi.JavaModelUtil;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CreateRelationshipAbstractHint
extends JEEVerificationHint {
    private static final String MAPPED_BY = "mappedBy";
    private String annotationClass;
    private String complimentaryAnnotationClassName;
    private String relationName;
    private static Set<String> relationAnnotations = new TreeSet<String>(Arrays.asList("javax.persistence.OneToOne", "javax.persistence.OneToMany", "javax.persistence.ManyToMany", "javax.persistence.ManyToOne"));

    public CreateRelationshipAbstractHint(JEEVerificationContextInfo problemContext, String annotationClass, String complimentaryAnnotationClassName) {
        super(problemContext);
        this.annotationClass = annotationClass;
        this.complimentaryAnnotationClassName = complimentaryAnnotationClassName;
        int dotPos = annotationClass.lastIndexOf(46);
        this.relationName = dotPos > -1 ? annotationClass.substring(dotPos + 1) : annotationClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChangeInfo implement() {
        boolean owningSide = this.isOwningSideByDefault();
        JavaClass javaClass = this.getProblemContext().getJavaClass();
        String localFieldName = null;
        String mappedBy = null;
        Element[] availableElements = null;
        JavaClass targetClass = null;
        JavaModel.getJavaRepository().beginTrans(false);
        try {
            JavaModel.setClassPath((Resource)javaClass.getResource());
            targetClass = this.getTargetEntityClass();
            localFieldName = CreateRelationshipAbstractHint.getFieldNameFromElement(this.getProblemContext().getElement());
            mappedBy = this.getExistingFieldInRelation(javaClass, targetClass, localFieldName);
            if (mappedBy == null) {
                Element[] compatibleElements = this.getCompatibleFieldsOrProperties(targetClass, javaClass);
                availableElements = this.filterOutElementsInRelation(compatibleElements);
            }
        }
        finally {
            JavaModel.getJavaRepository().endTrans(false);
        }
        if (mappedBy == null) {
            CreateRelationshipPanel pnlPickOrCreateField = new CreateRelationshipPanel();
            pnlPickOrCreateField.setEntityClassNames(javaClass.getSimpleName(), targetClass.getSimpleName());
            pnlPickOrCreateField.setAvailableSelection(this.getAvailableRelationTypeSelection());
            pnlPickOrCreateField.setAvailableFields(this.wrapFields(availableElements));
            Set<String> existingFieldNames = this.getExistingFieldNames(targetClass);
            String defaultFieldName = this.genDefaultFieldName(javaClass, existingFieldNames);
            pnlPickOrCreateField.setDefaultFieldName(defaultFieldName);
            pnlPickOrCreateField.setExistingFieldNames(existingFieldNames);
            DialogDescriptor ddesc = new DialogDescriptor((Object)pnlPickOrCreateField, NbBundle.getMessage(CreateOneToOneAnnotationHint.class, (String)"LBL_CreateRelationDlgTitle", (Object)this.relationName, (Object)targetClass.getSimpleName()));
            pnlPickOrCreateField.setDlgDescriptor(ddesc);
            Dialog dlg = DialogDisplayer.getDefault().createDialog(ddesc);
            dlg.setLocationRelativeTo(null);
            dlg.setVisible(true);
            if (ddesc.getValue() == DialogDescriptor.OK_OPTION) {
                String fieldName = null;
                fieldName = pnlPickOrCreateField.wasCreateNewFieldSelected() ? pnlPickOrCreateField.getNewIdName() : pnlPickOrCreateField.getSelectedField().toString();
                owningSide = pnlPickOrCreateField.owningSide();
                if (!javaClass.getName().equals(targetClass.getName()) || !localFieldName.equals(fieldName)) {
                    this.createFieldOrPropertyAtTargetClass(owningSide, targetClass, fieldName);
                }
                mappedBy = fieldName;
            }
        }
        if (mappedBy != null) {
            JavaModel.getJavaRepository().beginTrans(true);
            try {
                Annotation ann = JMIGenerationUtil.createAnnotation((Element)javaClass, (String)this.annotationClass, (List)Collections.EMPTY_LIST);
                if (!owningSide) {
                    this.addMappedByAttribute(ann, mappedBy);
                }
                Element e = this.getProblemContext().getElement();
                ((AnnotableElement)e).getAnnotations().add(ann);
            }
            finally {
                JavaModel.getJavaRepository().endTrans(false);
            }
        }
        return null;
    }

    protected JavaClass getTargetEntityClass() {
        TypedElement e = (TypedElement)this.getProblemContext().getElement();
        JavaClass targetClass = (JavaClass)e.getType();
        while (targetClass instanceof ParameterizedType) {
            targetClass = ((ParameterizedType)targetClass).getDefinition();
        }
        return targetClass;
    }

    protected String genDefaultFieldName(JavaClass javaClass, Set<String> existingNames) {
        String defaultFieldNameBase = javaClass.getSimpleName();
        char initial = Character.toLowerCase(defaultFieldNameBase.charAt(0));
        defaultFieldNameBase = initial + defaultFieldNameBase.substring(1);
        if (this.isMultiValuedAtTargetEntity()) {
            defaultFieldNameBase = defaultFieldNameBase + "s";
        }
        String defaultFieldName = null;
        int suffix = 0;
        do {
            defaultFieldName = defaultFieldNameBase + (suffix == 0 ? "" : Integer.valueOf(suffix));
            ++suffix;
        } while (existingNames.contains(defaultFieldName));
        return defaultFieldName;
    }

    private ElementWrapper[] wrapFields(Element[] fields) {
        ArrayList<ElementWrapper> r = new ArrayList<ElementWrapper>();
        for (Element element : fields) {
            r.add(ElementWrapper.create(element));
        }
        return r.toArray(new ElementWrapper[0]);
    }

    private String getExistingFieldInRelation(JavaClass localClass, JavaClass targetClass, String localFieldName) {
        for (Element e : this.getCompatibleFieldsOrProperties(targetClass, localClass)) {
            for (Annotation a : this.getRelationAnnotations((AnnotableElement)e)) {
                for (AttributeValue av : a.getAttributeValues()) {
                    if (!MAPPED_BY.equals(av.getName()) || !localFieldName.equals(((StringLiteral)av.getValue()).getValue())) continue;
                    return CreateRelationshipAbstractHint.getFieldNameFromElement(e);
                }
            }
        }
        return null;
    }

    private Element[] getCompatibleFieldsOrProperties(JavaClass javaClass, JavaClass type) {
        ArrayList<Feature> r = new ArrayList<Feature>();
        Class elementClass = PersistenceAPIHelper.findAccessTypeOfHierarchy(javaClass) == BeanAccessType.FIELD ? Field.class : Method.class;
        for (Feature f : javaClass.getFeatures()) {
            Feature element;
            if (!elementClass.isInstance(f) || !this.typeMatches((TypedElement)(element = f), type)) continue;
            r.add(element);
        }
        return r.toArray(new Element[0]);
    }

    protected boolean typeMatches(TypedElement element, JavaClass type) {
        if (element.getType() == null) {
            return false;
        }
        Type typeToCheck = null;
        if (this.isMultiValuedAtTargetEntity()) {
            ParameterizedType pt;
            if (element.getType() instanceof ParameterizedType && (pt = (ParameterizedType)element.getType()).getParameters().size() == 1) {
                typeToCheck = (Type)pt.getParameters().get(0);
            }
        } else {
            typeToCheck = element.getType();
        }
        return typeToCheck != null && typeToCheck.getName().equals(type.getName());
    }

    private static String getFieldNameFromElement(Element e) {
        if (e instanceof NamedElement) {
            String elementName = ((NamedElement)e).getName();
            if (e instanceof Field) {
                return elementName;
            }
            if (e instanceof Method) {
                return PersistenceAPIHelper.getFieldNameFromAccessorName(elementName);
            }
        }
        return null;
    }

    private Annotation[] getRelationAnnotations(AnnotableElement ae) {
        ArrayList<Annotation> r = new ArrayList<Annotation>();
        for (Annotation a : ae.getAnnotations()) {
            if (a.getType() == null || !relationAnnotations.contains(a.getType().getName())) continue;
            r.add(a);
        }
        return r.toArray(new Annotation[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createFieldOrPropertyAtTargetClass(boolean owningSide, JavaClass targetClass, String fieldName) {
        JavaModel.getJavaRepository().beginTrans(true);
        try {
            JavaModel.setClassPath((Resource)targetClass.getResource());
            Annotation annotation = null;
            Field field = targetClass.getField(fieldName, false);
            String fieldType = this.getFieldToBeCreatedTypeName(targetClass);
            if (field == null) {
                field = JMIGenerationUtil.createField((Element)targetClass, (String)fieldName, (int)2, (String)fieldType);
                targetClass.getFeatures().add(0, field);
            }
            if (PersistenceAPIHelper.findBeanAccessType(targetClass) == BeanAccessType.PROPERTY) {
                Method getter = CreateRelationshipAbstractHint.createMethodIfNeeded(targetClass, PersistenceAPIHelper.getAccessorName(fieldName), fieldType, Collections.EMPTY_LIST);
                getter.setBodyText("return " + fieldName + ";");
                annotation = this.createAnnotationAtTargetField((AnnotableElement)getter, targetClass);
                List<Type> setterArg = Collections.singletonList(field.getType());
                String getterName = PersistenceAPIHelper.getMutatorName(fieldName);
                if (targetClass.getMethod(getterName, setterArg, false) == null) {
                    Method setter = CreateRelationshipAbstractHint.createMethodIfNeeded(targetClass, getterName, "void", setterArg);
                    Parameter idParameter = JMIGenerationUtil.createParameter((Element)targetClass, (String)fieldName, (String)fieldType);
                    setter.getParameters().add(idParameter);
                    setter.setBodyText("this." + fieldName + " = " + fieldName + ";");
                }
            } else {
                annotation = this.createAnnotationAtTargetField((AnnotableElement)field, targetClass);
            }
            if (annotation != null && owningSide) {
                this.addMappedByAttribute(annotation, CreateRelationshipAbstractHint.getFieldNameFromElement(this.getProblemContext().getElement()));
            }
        }
        finally {
            JavaModel.getJavaRepository().endTrans(false);
        }
    }

    private Annotation createAnnotationAtTargetField(AnnotableElement element, JavaClass targetClass) {
        Annotation annotation = null;
        for (Annotation existingAnn : element.getAnnotations()) {
            if (!this.complimentaryAnnotationClassName.equals(existingAnn.getType().getName())) continue;
            annotation = existingAnn;
            break;
        }
        if (annotation == null) {
            annotation = JMIGenerationUtil.createAnnotation((Element)targetClass, (String)this.complimentaryAnnotationClassName, (List)Collections.EMPTY_LIST);
            element.getAnnotations().add(annotation);
        }
        return annotation;
    }

    protected String getFieldToBeCreatedTypeName(JavaClass targetClass) {
        String fieldType = this.getProblemContext().getJavaClass().getName();
        JavaClass fieldTypeClass = (JavaClass)JavaModel.getDefaultExtent().getType().resolve(fieldType);
        String simpleTypeName = JavaModelUtil.resolveImportsForType((Element)targetClass, (Type)fieldTypeClass).getName();
        if (this.isMultiValuedAtTargetEntity()) {
            JavaClass listTypeClass = (JavaClass)JavaModel.getDefaultExtent().getType().resolve("java.util.List");
            JavaModelUtil.resolveImportsForType((Element)targetClass, (Type)listTypeClass).getName();
            fieldType = "List<" + simpleTypeName + ">";
        }
        return fieldType;
    }

    private static Method createMethodIfNeeded(JavaClass parentClass, String methodName, String returnType, List args) {
        Method method = parentClass.getMethod(methodName, args, false);
        if (method == null) {
            method = JMIGenerationUtil.createMethod((Element)parentClass, (String)methodName, (int)1, (String)returnType);
            parentClass.getFeatures().add(method);
        }
        return method;
    }

    private void addMappedByAttribute(Annotation ann, String value) {
        AttributeValue av = JMIGenerationUtil.createAttributeValue((Element)this.getProblemContext().getJavaClass(), (String)MAPPED_BY, (String)value);
        ann.getAttributeValues().add(av);
    }

    public String getText() {
        return NbBundle.getMessage(CreateRelationshipAbstractHint.class, (String)"LBL_CreateRelationHint", (Object)this.relationName);
    }

    public int getType() {
        return 2;
    }

    protected boolean isMultiValuedAtTargetEntity() {
        return false;
    }

    protected Element[] filterOutElementsInRelation(Element[] compatibleElements) {
        ArrayList<Element> r = new ArrayList<Element>();
        for (Element e : compatibleElements) {
            if (ProblemFindingUtils.findFirstAnnotationFromGivenSet((AnnotableElement)e, relationAnnotations) != null) continue;
            r.add(e);
        }
        return r.toArray(new Element[0]);
    }

    private Set<String> getExistingFieldNames(JavaClass javaClass) {
        TreeSet<String> r = new TreeSet<String>();
        for (ClassMember m : javaClass.getContents()) {
            if (!(m instanceof Field)) continue;
            r.add(m.getName());
        }
        return r;
    }

    protected boolean isOwningSideByDefault() {
        return true;
    }

    protected CreateRelationshipPanel.AvailableSelection getAvailableRelationTypeSelection() {
        return CreateRelationshipPanel.AvailableSelection.BOTH;
    }

    private static abstract class ElementWrapper {
        private Element element;

        ElementWrapper(Element element) {
            this.element = element;
        }

        Element getElement() {
            return this.element;
        }

        static ElementWrapper create(Element e) {
            if (e instanceof Field) {
                return new FieldWrapper((Field)e);
            }
            if (e instanceof Method) {
                return new GetterWrapper((Method)e);
            }
            return null;
        }

        private static class GetterWrapper
        extends ElementWrapper {
            GetterWrapper(Method getter) {
                super((Element)getter);
            }

            public String toString() {
                return CreateRelationshipAbstractHint.getFieldNameFromElement(this.getElement());
            }
        }

        private static class FieldWrapper
        extends ElementWrapper {
            FieldWrapper(Field field) {
                super((Element)field);
            }

            public String toString() {
                return ((Field)this.getElement()).getName();
            }
        }
    }
}

