/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.server;

import com.sun.xml.ws.server.DocInfo;
import com.sun.xml.ws.server.ServerRtException;
import com.sun.xml.ws.util.ByteArrayBuffer;
import com.sun.xml.ws.wsdl.parser.Service;
import com.sun.xml.ws.wsdl.writer.WSDLOutputResolver;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import javax.xml.ws.Holder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSDLGenResolver
implements WSDLOutputResolver {
    private Map<String, DocInfo> docs;
    private DocInfo abstractWsdl;
    private DocInfo concreteWsdl;
    private Map<String, List<String>> nsMapping;

    public WSDLGenResolver(Map<String, DocInfo> docs) {
        this.docs = docs;
        this.nsMapping = new HashMap<String, List<String>>();
        Set<Map.Entry<String, DocInfo>> docEntries = docs.entrySet();
        for (Map.Entry<String, DocInfo> entry : docEntries) {
            DocInfo docInfo = entry.getValue();
            if (docInfo.isHavingPortType()) {
                this.abstractWsdl = docInfo;
            }
            if (docInfo.getDocType() != DocInfo.DOC_TYPE.SCHEMA) continue;
            List<String> sysIds = this.nsMapping.get(docInfo.getTargetNamespace());
            if (sysIds == null) {
                sysIds = new ArrayList<String>();
                this.nsMapping.put(docInfo.getTargetNamespace(), sysIds);
            }
            sysIds.add(docInfo.getUrl().toString());
        }
    }

    public String getWSDLFile() {
        return this.concreteWsdl.getUrl().toString();
    }

    public Map<String, DocInfo> getDocs() {
        return this.docs;
    }

    public Result getSchemaOutput(String namespaceUri, String suggestedFileName) {
        ByteArrayBuffer bout = new ByteArrayBuffer();
        StreamDocInfo docInfo = new StreamDocInfo(suggestedFileName, bout);
        docInfo.setQueryString("xsd=" + suggestedFileName);
        docInfo.setDocType(DocInfo.DOC_TYPE.SCHEMA);
        this.docs.put(docInfo.getUrl().toString(), docInfo);
        StreamResult result = new StreamResult();
        result.setOutputStream(bout);
        result.setSystemId(docInfo.getUrl().toString());
        return result;
    }

    @Override
    public Result getWSDLOutput(String filename) {
        ByteArrayBuffer bout = new ByteArrayBuffer();
        StreamDocInfo docInfo = new StreamDocInfo(filename, bout);
        docInfo.setDocType(DocInfo.DOC_TYPE.WSDL);
        docInfo.setQueryString("wsdl");
        this.concreteWsdl = docInfo;
        this.docs.put(docInfo.getUrl().toString(), docInfo);
        StreamResult result = new StreamResult();
        result.setOutputStream(bout);
        result.setSystemId(docInfo.getUrl().toString());
        return result;
    }

    @Override
    public Result getAbstractWSDLOutput(Holder<String> filename) {
        if (this.abstractWsdl != null) {
            filename.value = this.abstractWsdl.getUrl().toString();
            return null;
        }
        ByteArrayBuffer bout = new ByteArrayBuffer();
        StreamDocInfo abstractWsdl = new StreamDocInfo((String)filename.value, bout);
        abstractWsdl.setDocType(DocInfo.DOC_TYPE.WSDL);
        this.docs.put(abstractWsdl.getUrl().toString(), abstractWsdl);
        StreamResult result = new StreamResult();
        result.setOutputStream(bout);
        result.setSystemId(abstractWsdl.getUrl().toString());
        return result;
    }

    @Override
    public Result getSchemaOutput(String namespace, Holder<String> filename) {
        List<String> schemas = this.nsMapping.get(namespace);
        if (schemas != null) {
            if (schemas.size() > 1) {
                throw new ServerRtException("server.rt.err", "More than one schema for the target namespace " + namespace);
            }
            filename.value = schemas.get(0);
            return null;
        }
        ByteArrayBuffer bout = new ByteArrayBuffer();
        StreamDocInfo docInfo = new StreamDocInfo((String)filename.value, bout);
        docInfo.setDocType(DocInfo.DOC_TYPE.SCHEMA);
        this.docs.put(docInfo.getUrl().toString(), docInfo);
        StreamResult result = new StreamResult();
        result.setOutputStream(bout);
        result.setSystemId(docInfo.getUrl().toString());
        return result;
    }

    private static class StreamDocInfo
    implements DocInfo {
        private ByteArrayBuffer bout;
        private String resource;
        private String queryString;
        private DocInfo.DOC_TYPE docType;

        public StreamDocInfo(String resource, ByteArrayBuffer bout) {
            this.resource = resource;
            this.bout = bout;
        }

        public InputStream getDoc() {
            this.bout.close();
            return this.bout.newInputStream();
        }

        public String getPath() {
            return this.resource;
        }

        public URL getUrl() {
            try {
                return new URL("file:///" + this.resource);
            }
            catch (Exception exception) {
                return null;
            }
        }

        public String getQueryString() {
            return this.queryString;
        }

        public void setQueryString(String queryString) {
            this.queryString = queryString;
        }

        public void setDocType(DocInfo.DOC_TYPE docType) {
            this.docType = docType;
        }

        public DocInfo.DOC_TYPE getDocType() {
            return this.docType;
        }

        public void setTargetNamespace(String ns) {
        }

        public String getTargetNamespace() {
            return null;
        }

        public void setService(Service service) {
        }

        public Service getService() {
            return null;
        }

        public void setHavingPortType(boolean portType) {
        }

        public boolean isHavingPortType() {
            return false;
        }
    }
}

