/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ddloaders.multiview;

import org.netbeans.jmi.javamodel.Method;
import org.netbeans.modules.j2ee.common.JMIUtils;
import org.netbeans.modules.j2ee.common.ui.nodes.QueryCustomizer;
import org.netbeans.modules.j2ee.dd.api.ejb.Query;
import org.netbeans.modules.j2ee.ddloaders.multiview.EntityHelper;
import org.netbeans.modules.j2ee.ddloaders.multiview.QueryMethodHelper;
import org.netbeans.modules.j2ee.ddloaders.multiview.QueryMethodsTableModel;
import org.netbeans.modules.j2ee.ddloaders.multiview.Utils;

public class FinderMethodsTableModel
extends QueryMethodsTableModel {
    protected static final String[] COLUMN_NAMES = new String[]{Utils.getBundleMessage("LBL_Method"), Utils.getBundleMessage("LBL_ReturnsCollection"), Utils.getBundleMessage("LBL_ResultInterface"), Utils.getBundleMessage("LBL_Query"), Utils.getBundleMessage("LBL_Description")};
    protected static final int[] COLUMN_WIDTHS = new int[]{200, 100, 120, 200, 100};

    public FinderMethodsTableModel(EntityHelper.Queries queries) {
        super(COLUMN_NAMES, COLUMN_WIDTHS, queries);
    }

    public void editRow(int row) {
        QueryMethodHelper helper = this.getQueryMethodHelper(row);
        boolean hasLocal = this.queries.getLocal() != null;
        boolean hasRemote = this.queries.getRemote() != null;
        boolean hasLocalMethod = helper.localMethod != null;
        boolean hasRemoteMethod = helper.remoteMethod != null;
        boolean returnsCollection = helper.returnsCollection();
        QueryCustomizer customizer = new QueryCustomizer();
        Method method = helper.getPrototypeMethod();
        JMIUtils.addException((Method)method, (String)"javax.ejb.FinderException");
        Query aQuery = (Query)this.queries.getFinderMethod(row).clone();
        boolean result = customizer.showFinderCustomizer(method, aQuery, returnsCollection, hasLocal, hasRemote, hasLocalMethod, hasRemoteMethod);
        if (result) {
            helper.updateFinderMethod(method, aQuery, customizer.finderReturnIsSingle(), customizer.publishToLocal(), customizer.publishToRemote());
        }
    }

    public int addRow() {
        this.queries.addFinderMethod();
        return this.getRowCount() - 1;
    }

    public QueryMethodHelper getQueryMethodHelper(int row) {
        return this.queries.getFinderMethodHelper(row);
    }

    public int getRowCount() {
        return this.queries.getFinderMethodCount();
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        QueryMethodHelper queryMethodHelper = this.getQueryMethodHelper(rowIndex);
        switch (columnIndex) {
            case 0: {
                return queryMethodHelper.getQueryMethod().getMethodName();
            }
            case 1: {
                return new Boolean(queryMethodHelper.returnsCollection());
            }
            case 2: {
                return queryMethodHelper.getResultInterface();
            }
            case 3: {
                return queryMethodHelper.getEjbQl();
            }
            case 4: {
                return queryMethodHelper.getDefaultDescription();
            }
        }
        return null;
    }

    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        QueryMethodHelper helper = this.getQueryMethodHelper(rowIndex);
        boolean publishToLocal = helper.localMethod != null;
        boolean publishToRemote = helper.remoteMethod != null;
        boolean returnsCollection = helper.returnsCollection();
        Method method = helper.getPrototypeMethod();
        Query query = (Query)this.queries.getFinderMethod(rowIndex).clone();
        switch (columnIndex) {
            case 1: {
                returnsCollection = Boolean.TRUE.equals(value);
                break;
            }
            case 4: {
                query.setDescription((String)value);
            }
        }
        helper.updateFinderMethod(method, query, !returnsCollection, publishToLocal, publishToRemote);
    }

    public Class getColumnClass(int columnIndex) {
        Class clazz = columnIndex == 1 ? Boolean.class : String.class;
        return clazz;
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (columnIndex == 1 || columnIndex == 4) {
            return true;
        }
        return super.isCellEditable(rowIndex, columnIndex);
    }
}

