/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seproject.ui.customizer;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.DefaultListModel;
import javax.swing.ListSelectionModel;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.modules.java.j2seproject.classpath.ClassPathSupport;
import org.netbeans.modules.java.j2seproject.ui.customizer.AntArtifactChooser;

public class ClassPathUiSupport {
    private ClassPathSupport cps;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static DefaultListModel createListModel(Iterator it) {
        DefaultListModel model = new DefaultListModel();
        while (it.hasNext()) {
            model.addElement(it.next());
        }
        return model;
    }

    public static Iterator getIterator(DefaultListModel model) {
        return ClassPathUiSupport.getList(model).iterator();
    }

    public static List getList(DefaultListModel model) {
        return Collections.list(model.elements());
    }

    public static int[] moveUp(DefaultListModel listModel, int[] indices) {
        int i;
        if (!(indices != null && indices.length != 0 || $assertionsDisabled)) {
            throw new AssertionError((Object)"MoveUp button should be disabled");
        }
        for (i = 0; i < indices.length; ++i) {
            Object item = listModel.get(indices[i]);
            listModel.remove(indices[i]);
            listModel.add(indices[i] - 1, item);
        }
        i = 0;
        while (i < indices.length) {
            int n = i++;
            indices[n] = indices[n] - 1;
        }
        return indices;
    }

    public static boolean canMoveUp(ListSelectionModel selectionModel) {
        return selectionModel.getMinSelectionIndex() > 0;
    }

    public static int[] moveDown(DefaultListModel listModel, int[] indices) {
        int i;
        if (!(indices != null && indices.length != 0 || $assertionsDisabled)) {
            throw new AssertionError((Object)"MoveDown button should be disabled");
        }
        for (i = indices.length - 1; i >= 0; --i) {
            Object item = listModel.get(indices[i]);
            listModel.remove(indices[i]);
            listModel.add(indices[i] + 1, item);
        }
        i = 0;
        while (i < indices.length) {
            int n = i++;
            indices[n] = indices[n] + 1;
        }
        return indices;
    }

    public static boolean canMoveDown(ListSelectionModel selectionModel, int modelSize) {
        int iMax = selectionModel.getMaxSelectionIndex();
        return iMax != -1 && iMax < modelSize - 1;
    }

    public static int[] remove(DefaultListModel listModel, int[] indices) {
        if (!(indices != null && indices.length != 0 || $assertionsDisabled)) {
            throw new AssertionError((Object)"Remove button should be disabled");
        }
        for (int i = indices.length - 1; i >= 0; --i) {
            listModel.remove(indices[i]);
        }
        if (!listModel.isEmpty()) {
            int selectedIndex = indices[indices.length - 1] - indices.length + 1;
            if (selectedIndex > listModel.size() - 1) {
                selectedIndex = listModel.size() - 1;
            }
            return new int[]{selectedIndex};
        }
        return new int[0];
    }

    public static int[] addLibraries(DefaultListModel listModel, int[] indices, Library[] libraries, Set alreadyIncludedLibs) {
        int lastIndex = indices == null || indices.length == 0 ? listModel.getSize() - 1 : indices[indices.length - 1];
        int j = 1;
        for (int i = 0; i < libraries.length; ++i) {
            if (alreadyIncludedLibs.contains(libraries[i])) continue;
            listModel.add(lastIndex + j++, ClassPathSupport.Item.create(libraries[i], null));
        }
        HashSet<Library> addedLibs = new HashSet<Library>(Arrays.asList(libraries));
        int[] indexes = new int[libraries.length];
        int j2 = 0;
        for (int i = 0; i < listModel.getSize(); ++i) {
            ClassPathSupport.Item item = (ClassPathSupport.Item)listModel.get(i);
            if (item.getType() != 1 || item.isBroken() || !addedLibs.contains(item.getLibrary())) continue;
            indexes[j2++] = i;
        }
        return indexes;
    }

    public static int[] addJarFiles(DefaultListModel listModel, int[] indices, File[] files) {
        int lastIndex = indices == null || indices.length == 0 ? listModel.getSize() - 1 : indices[indices.length - 1];
        int[] indexes = new int[files.length];
        int i = 0;
        int delta = 0;
        while (i + delta < files.length) {
            int current = lastIndex + 1 + i;
            ClassPathSupport.Item item = ClassPathSupport.Item.create(files[i + delta], null);
            if (!listModel.contains(item)) {
                listModel.add(current, item);
                indexes[delta + i] = current;
                ++i;
                continue;
            }
            indexes[i + delta] = listModel.indexOf(item);
            ++delta;
        }
        return indexes;
    }

    public static int[] addArtifacts(DefaultListModel listModel, int[] indices, AntArtifactChooser.ArtifactItem[] artifactItems) {
        int lastIndex = indices == null || indices.length == 0 ? listModel.getSize() - 1 : indices[indices.length - 1];
        int[] indexes = new int[artifactItems.length];
        for (int i = 0; i < artifactItems.length; ++i) {
            int current = lastIndex + 1 + i;
            ClassPathSupport.Item item = ClassPathSupport.Item.create(artifactItems[i].getArtifact(), artifactItems[i].getArtifactURI(), null);
            if (!listModel.contains(item)) {
                listModel.add(current, item);
                indexes[i] = current;
                continue;
            }
            indexes[i] = listModel.indexOf(item);
        }
        return indexes;
    }

    static {
        $assertionsDisabled = !ClassPathUiSupport.class.desiredAssertionStatus();
    }
}

