/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seproject;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.metadata.ClassPathSupport;
import org.netbeans.modules.j2ee.persistence.api.PersistenceScope;
import org.netbeans.modules.j2ee.persistence.api.PersistenceScopes;
import org.netbeans.modules.j2ee.persistence.spi.PersistenceClassPathProvider;
import org.netbeans.modules.j2ee.persistence.spi.PersistenceLocationProvider;
import org.netbeans.modules.j2ee.persistence.spi.PersistenceScopeFactory;
import org.netbeans.modules.j2ee.persistence.spi.PersistenceScopeImplementation;
import org.netbeans.modules.j2ee.persistence.spi.PersistenceScopeProvider;
import org.netbeans.modules.j2ee.persistence.spi.PersistenceScopesProvider;
import org.netbeans.modules.j2ee.persistence.spi.support.PersistenceScopesHelper;
import org.netbeans.modules.java.j2seproject.J2SEProject;
import org.netbeans.modules.java.j2seproject.classpath.ClassPathProviderImpl;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class J2SEPersistenceProvider
implements PersistenceLocationProvider,
PersistenceScopeProvider,
PersistenceScopesProvider,
PersistenceClassPathProvider,
PropertyChangeListener {
    private final J2SEProject project;
    private final PersistenceScopeImplementation persistenceScopeImpl = new PersistenceScopeImpl();
    private final PersistenceScope persistenceScope = PersistenceScopeFactory.createPersistenceScope((PersistenceScopeImplementation)this.persistenceScopeImpl);
    private final PersistenceScopesHelper scopesHelper = new PersistenceScopesHelper();
    private ClassPath projectSourcesClassPath;

    public J2SEPersistenceProvider(J2SEProject project) {
        this.project = project;
        project.getSourceRoots().addPropertyChangeListener(this);
        this.sourcesChanged();
    }

    public FileObject getLocation() {
        FileObject root = this.getLocationSourceRoot();
        if (root == null) {
            return null;
        }
        FileObject metaInf = root.getFileObject("META-INF");
        if (metaInf == null || !metaInf.isFolder()) {
            return null;
        }
        return metaInf;
    }

    public FileObject createLocation() throws IOException {
        FileObject root = this.getLocationSourceRoot();
        if (root == null) {
            throw new IOException("There are no source roots in the project or the first source root does not exist.");
        }
        FileObject metaInf = root.getFileObject("META-INF");
        if (metaInf != null) {
            if (!metaInf.isFolder()) {
                throw new IOException("The META-INF directory exists, but is not a folder.");
            }
        } else {
            metaInf = root.createFolder("META-INF");
        }
        return metaInf;
    }

    public PersistenceScope findPersistenceScope(FileObject fo) {
        Project project = FileOwnerQuery.getOwner((FileObject)fo);
        if (project != null) {
            J2SEPersistenceProvider provider = (J2SEPersistenceProvider)project.getLookup().lookup(J2SEPersistenceProvider.class);
            return provider.getPersistenceScope();
        }
        return null;
    }

    public PersistenceScopes getPersistenceScopes() {
        return this.scopesHelper.getPersistenceScopes();
    }

    public ClassPath getClassPath() {
        return this.getProjectSourcesClassPath();
    }

    private File getFirstSourceRoot() {
        URL[] urls = this.project.getSourceRoots().getRootURLs();
        if (urls.length == 0) {
            return null;
        }
        return new File(URI.create(urls[0].toExternalForm()));
    }

    private FileObject getLocationSourceRoot() {
        File sourceRoot = this.getFirstSourceRoot();
        if (sourceRoot != null) {
            return FileUtil.toFileObject((File)sourceRoot);
        }
        return null;
    }

    private PersistenceScope getPersistenceScope() {
        FileObject persistenceXml = this.persistenceScope.getPersistenceXml();
        if (persistenceXml != null && persistenceXml.isValid()) {
            return this.persistenceScope;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassPath getProjectSourcesClassPath() {
        J2SEPersistenceProvider j2SEPersistenceProvider = this;
        synchronized (j2SEPersistenceProvider) {
            if (this.projectSourcesClassPath == null) {
                ClassPathProviderImpl cpProvider = (ClassPathProviderImpl)this.project.getLookup().lookup(ClassPathProviderImpl.class);
                this.projectSourcesClassPath = ClassPathSupport.createWeakProxyClassPath((ClassPath[])new ClassPath[]{cpProvider.getProjectSourcesClassPath("classpath/source"), cpProvider.getProjectSourcesClassPath("classpath/compile")});
            }
            return this.projectSourcesClassPath;
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        this.sourcesChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sourcesChanged() {
        J2SEPersistenceProvider j2SEPersistenceProvider = this;
        synchronized (j2SEPersistenceProvider) {
            File sourceRootFile = this.getFirstSourceRoot();
            if (sourceRootFile != null) {
                File persistenceXmlFile = new File(sourceRootFile, "META-INF/persistence.xml");
                this.scopesHelper.changePersistenceScope(this.persistenceScope, persistenceXmlFile);
            } else {
                this.scopesHelper.changePersistenceScope(null, null);
            }
        }
    }

    private final class PersistenceScopeImpl
    implements PersistenceScopeImplementation {
        private PersistenceScopeImpl() {
        }

        public FileObject getPersistenceXml() {
            FileObject location = J2SEPersistenceProvider.this.getLocation();
            if (location == null) {
                return null;
            }
            return location.getFileObject("persistence.xml");
        }

        public ClassPath getClassPath() {
            return J2SEPersistenceProvider.this.getProjectSourcesClassPath();
        }
    }
}

