/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.common.ui.nodes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.swing.SwingUtilities;
import org.netbeans.api.mdr.events.MDRChangeEvent;
import org.netbeans.api.mdr.events.MDRChangeListener;
import org.netbeans.api.mdr.events.MDRChangeSource;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.modules.j2ee.common.JMIUtils;
import org.netbeans.modules.j2ee.common.ui.nodes.ComponentMethodViewStrategy;
import org.netbeans.modules.j2ee.common.ui.nodes.MethodNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;

public abstract class ComponentMethodModel
extends Children.Keys
implements MDRChangeListener {
    private Collection interfaces;
    private JavaClass implBean;

    public ComponentMethodModel(JavaClass implBean, Collection interfaces) {
        this.implBean = implBean;
        this.interfaces = interfaces;
    }

    public ComponentMethodModel() {
    }

    private void updateKeys() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ArrayList<Method> keys = new ArrayList<Method>();
                for (JavaClass intf : ComponentMethodModel.this.getInterfaces()) {
                    if (intf == null) continue;
                    Method[] methods = JMIUtils.getMethods(intf);
                    for (int i = 0; i < methods.length; ++i) {
                        keys.add(methods[i]);
                    }
                }
                ComponentMethodModel.this.setKeys(keys);
            }
        });
    }

    protected void addNotify() {
        if (this.interfaces == null) {
            this.interfaces = this.getInterfaces();
        }
        assert (this.interfaces != null);
        if (this.implBean == null) {
            this.implBean = this.getImplBean();
        }
        super.addNotify();
        this.registerListeners();
        this.updateKeys();
    }

    private void registerListeners() {
        for (JavaClass intf : this.interfaces) {
            if (intf == null) continue;
            ((MDRChangeSource)intf).addListener((MDRChangeListener)this);
        }
    }

    private void removeListeners() {
        if (this.interfaces == null) {
            return;
        }
        for (JavaClass intf : this.interfaces) {
            ((MDRChangeSource)intf).removeListener((MDRChangeListener)this);
        }
    }

    protected void removeNotify() {
        if (this.interfaces == null) {
            return;
        }
        this.setKeys(Collections.EMPTY_SET);
        this.removeListeners();
        super.removeNotify();
    }

    protected Collection getInterfaces() {
        return null;
    }

    protected JavaClass getImplBean() {
        return null;
    }

    public void change(MDRChangeEvent evt) {
        this.updateKeys();
    }

    public abstract ComponentMethodViewStrategy createViewStrategy();

    protected Node[] createNodes(Object key) {
        if (key instanceof Method) {
            Method method = (Method)key;
            ComponentMethodViewStrategy cmvs = this.createViewStrategy();
            return new Node[]{new MethodNode(method, this.implBean, this.getInterfaces(), cmvs)};
        }
        return new Node[0];
    }
}

