/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.proxy;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.nio.channels.SocketChannel;
import java.util.regex.Pattern;
import javax.net.SocketFactory;
import org.netbeans.modules.proxy.Base64Encoder;
import org.netbeans.modules.proxy.ConnectivitySettings;
import org.netbeans.modules.proxy.InterruptibleInputStream;

public class ClientSocketFactory
extends SocketFactory {
    private static final int CONNECT_TIMEOUT = 20000;
    private static final String AUTH_NONE = "<none>";
    private static final String AUTH_BASIC = "Basic";
    private static final Pattern sConnectionEstablishedPattern = Pattern.compile("HTTP\\/\\d+\\.\\d+\\s+200\\s+");
    private static final Pattern sProxyAuthRequiredPattern = Pattern.compile("HTTP\\/\\d+\\.\\d+\\s+407\\s+");
    private ConnectivitySettings mSettings;

    public ClientSocketFactory(ConnectivitySettings settings) {
        this.mSettings = settings;
    }

    public Socket createSocket() throws IOException {
        return new Socket(){

            public void connect(SocketAddress endpoint, int timeout) throws IOException {
                Socket s = ClientSocketFactory.this.createSocket((InetSocketAddress)endpoint, timeout);
                s.close();
            }

            public void bind(SocketAddress bindpoint) {
                throw new UnsupportedOperationException();
            }

            protected Object clone() {
                throw new UnsupportedOperationException();
            }

            public synchronized void close() {
            }

            public void connect(SocketAddress endpoint) {
                throw new UnsupportedOperationException();
            }

            public SocketChannel getChannel() {
                throw new UnsupportedOperationException();
            }

            public InetAddress getInetAddress() {
                throw new UnsupportedOperationException();
            }

            public InputStream getInputStream() {
                throw new UnsupportedOperationException();
            }

            public boolean getKeepAlive() {
                throw new UnsupportedOperationException();
            }

            public InetAddress getLocalAddress() {
                throw new UnsupportedOperationException();
            }

            public int getLocalPort() {
                throw new UnsupportedOperationException();
            }

            public SocketAddress getLocalSocketAddress() {
                throw new UnsupportedOperationException();
            }

            public boolean getOOBInline() {
                throw new UnsupportedOperationException();
            }

            public OutputStream getOutputStream() {
                throw new UnsupportedOperationException();
            }

            public int getPort() {
                throw new UnsupportedOperationException();
            }

            public synchronized int getReceiveBufferSize() {
                throw new UnsupportedOperationException();
            }

            public SocketAddress getRemoteSocketAddress() {
                throw new UnsupportedOperationException();
            }

            public boolean getReuseAddress() {
                throw new UnsupportedOperationException();
            }

            public synchronized int getSendBufferSize() {
                throw new UnsupportedOperationException();
            }

            public int getSoLinger() {
                throw new UnsupportedOperationException();
            }

            public synchronized int getSoTimeout() {
                throw new UnsupportedOperationException();
            }

            public boolean getTcpNoDelay() {
                throw new UnsupportedOperationException();
            }

            public int getTrafficClass() {
                throw new UnsupportedOperationException();
            }

            public boolean isBound() {
                throw new UnsupportedOperationException();
            }

            public boolean isClosed() {
                throw new UnsupportedOperationException();
            }

            public boolean isConnected() {
                throw new UnsupportedOperationException();
            }

            public boolean isInputShutdown() {
                throw new UnsupportedOperationException();
            }

            public boolean isOutputShutdown() {
                throw new UnsupportedOperationException();
            }

            public void sendUrgentData(int data) {
                throw new UnsupportedOperationException();
            }

            public void setKeepAlive(boolean on) {
                throw new UnsupportedOperationException();
            }

            public void setOOBInline(boolean on) {
                throw new UnsupportedOperationException();
            }

            public synchronized void setReceiveBufferSize(int size) {
                throw new UnsupportedOperationException();
            }

            public void setReuseAddress(boolean on) {
                throw new UnsupportedOperationException();
            }

            public synchronized void setSendBufferSize(int size) {
                throw new UnsupportedOperationException();
            }

            public void setSoLinger(boolean on, int linger) {
                throw new UnsupportedOperationException();
            }

            public synchronized void setSoTimeout(int timeout) {
                throw new UnsupportedOperationException();
            }

            public void setTcpNoDelay(boolean on) {
                throw new UnsupportedOperationException();
            }

            public void setTrafficClass(int tc) {
                throw new UnsupportedOperationException();
            }

            public void shutdownInput() {
                throw new UnsupportedOperationException();
            }

            public void shutdownOutput() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        return this.createSocket(new InetSocketAddress(host, port), 20000);
    }

    public Socket createSocket(InetAddress inetAddress, int port) throws IOException {
        return this.createSocket(new InetSocketAddress(inetAddress, port), 20000);
    }

    public Socket createSocket(String s, int i, InetAddress inetAddress, int i1) throws IOException, UnknownHostException {
        throw new IOException("Unsupported operation");
    }

    public Socket createSocket(InetAddress inetAddress, int i, InetAddress inetAddress1, int i1) throws IOException {
        throw new IOException("Unsupported operation");
    }

    private Socket getHttpsTunnelSocket(InetSocketAddress address, int timeout) throws UnknownHostException, IOException {
        Socket proxy = new Socket();
        proxy.connect(new InetSocketAddress(this.mSettings.getProxyHost(), this.mSettings.getProxyPort()), timeout);
        BufferedReader r = new BufferedReader(new InputStreamReader(new InterruptibleInputStream(proxy.getInputStream())));
        DataOutputStream dos = new DataOutputStream(proxy.getOutputStream());
        dos.writeBytes("CONNECT ");
        dos.writeBytes(address.getHostName() + ":" + address.getPort());
        dos.writeBytes(" HTTP/1.0\r\n");
        dos.writeBytes("Connection: Keep-Alive\r\n\r\n");
        dos.flush();
        String line = r.readLine();
        if (sConnectionEstablishedPattern.matcher(line).find()) {
            while ((line = r.readLine()).length() != 0) {
            }
            return proxy;
        }
        if (sProxyAuthRequiredPattern.matcher(line).find()) {
            boolean authMethodSelected = false;
            String authMethod = AUTH_NONE;
            while ((line = r.readLine()).length() != 0) {
                if (!line.startsWith("Proxy-Authenticate:") || authMethodSelected || !(authMethod = line.substring(19).trim()).equals(AUTH_BASIC)) continue;
                authMethodSelected = true;
            }
            proxy.close();
            if (authMethod.startsWith(AUTH_BASIC)) {
                return this.authenticateBasic(address);
            }
            throw new IOException("Unsupported authentication method: " + authMethod);
        }
        proxy.close();
        throw new IOException("HTTP proxy does not support CONNECT command. Received reply: " + line);
    }

    private Socket authenticateBasic(InetSocketAddress address) throws IOException {
        Socket proxy = new Socket(this.mSettings.getProxyHost(), this.mSettings.getProxyPort());
        BufferedReader r = new BufferedReader(new InputStreamReader(new InterruptibleInputStream(proxy.getInputStream())));
        DataOutputStream dos = new DataOutputStream(proxy.getOutputStream());
        String username = this.mSettings.getProxyUsername() == null ? "" : this.mSettings.getProxyUsername();
        String password = this.mSettings.getProxyPassword() == null ? "" : String.valueOf(this.mSettings.getProxyPassword());
        String credentials = username + ":" + password;
        String basicCookie = Base64Encoder.encode(credentials.getBytes("US-ASCII"));
        dos.writeBytes("CONNECT ");
        dos.writeBytes(address.getHostName() + ":" + address.getPort());
        dos.writeBytes(" HTTP/1.0\r\n");
        dos.writeBytes("Connection: Keep-Alive\r\n");
        dos.writeBytes("Proxy-Authorization: Basic " + basicCookie + "\r\n");
        dos.writeBytes("\r\n");
        dos.flush();
        String line = r.readLine();
        if (sConnectionEstablishedPattern.matcher(line).find()) {
            while ((line = r.readLine()).length() != 0) {
            }
            return proxy;
        }
        throw new IOException("Basic authentication failed: " + line);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Socket getSocks4TunnelSocket(InetSocketAddress address, int timeout) throws IOException {
        boolean success = false;
        Socket proxy = new Socket();
        proxy.connect(new InetSocketAddress(this.mSettings.getProxyHost(), this.mSettings.getProxyPort()), timeout);
        try {
            DataInputStream din = new DataInputStream(new InterruptibleInputStream(proxy.getInputStream()));
            DataOutputStream dos = new DataOutputStream(proxy.getOutputStream());
            dos.writeByte(4);
            dos.writeByte(1);
            dos.writeShort(address.getPort());
            InetAddress addr = address.getAddress();
            if (addr == null) {
                throw new UnknownHostException(address.getHostName());
            }
            byte[] byteAddress = addr.getAddress();
            for (int i = 0; i < byteAddress.length; ++i) {
                dos.writeByte(byteAddress[i]);
            }
            String uname = this.mSettings.getProxyUsername();
            if (uname != null) {
                byte[] unamebytes = uname.getBytes();
                for (int i = 0; i < unamebytes.length; ++i) {
                    dos.writeByte(unamebytes[i]);
                }
            }
            dos.writeByte(0);
            int replyVersion = din.read();
            if (replyVersion != 0) {
                throw new IOException("socks4.not.available." + replyVersion);
            }
            int retCode = din.read();
            if (retCode != 90) {
                throw new IOException("socks4.error." + retCode);
            }
            while (din.available() > 0) {
                din.read();
            }
            success = true;
            Socket socket = proxy;
            return socket;
        }
        finally {
            if (!success) {
                proxy.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Socket getSocks5TunnelSocket(InetSocketAddress address, int timeout) throws IOException {
        boolean success = false;
        Socket proxy = new Socket();
        proxy.connect(new InetSocketAddress(this.mSettings.getProxyHost(), this.mSettings.getProxyPort()), timeout);
        try {
            int tmp;
            DataInputStream din = new DataInputStream(new InterruptibleInputStream(proxy.getInputStream()));
            DataOutputStream dos = new DataOutputStream(proxy.getOutputStream());
            dos.write(new byte[]{5, 2, 0, 2});
            int serverVersion = din.read();
            if (serverVersion != 5) {
                throw new IOException("SOCKS5 protocol error: version: " + serverVersion);
            }
            int authMethod = din.read();
            if (authMethod == 255) {
                throw new IOException("SOCKS5 authentication failure: no supported method acccepted by server");
            }
            if (authMethod == 2) {
                dos.writeByte(1);
                String uname = this.mSettings.getProxyUsername();
                byte[] unamebytes = uname == null ? new byte[]{} : uname.getBytes();
                dos.writeByte(unamebytes.length);
                for (int i = 0; i < unamebytes.length; ++i) {
                    dos.writeByte(unamebytes[i]);
                }
                String pwd = null;
                if (this.mSettings.getProxyPassword() != null) {
                    pwd = new String(this.mSettings.getProxyPassword());
                }
                byte[] pwdbytes = pwd == null ? new byte[]{} : pwd.getBytes();
                dos.writeByte(pwdbytes.length);
                for (int i = 0; i < pwdbytes.length; ++i) {
                    dos.writeByte(pwdbytes[i]);
                }
                tmp = din.read();
                if (tmp != 1) {
                    throw new IOException("socks5.auth.error." + tmp);
                }
                tmp = din.read();
                if (tmp != 0) {
                    throw new IOException("socks5.auth.error." + tmp);
                }
            }
            String hostName = address.getHostName();
            dos.write(new byte[]{5, 1, 0, 3, (byte)hostName.length()});
            dos.writeBytes(hostName);
            dos.writeShort(address.getPort());
            serverVersion = din.read();
            if (serverVersion != 5) {
                throw new IOException("SOCKS5 protocol error: version: " + serverVersion);
            }
            tmp = din.read();
            if (tmp != 0) {
                throw new IOException("SOCKS5 protocol error: " + tmp);
            }
            tmp = din.read();
            if (tmp != 0) {
                throw new IOException("SOCKS5 protocol error: " + tmp);
            }
            int addrType = din.read();
            if (addrType == -1) {
                throw new IOException("SOCKS5 protocol error: " + addrType);
            }
            for (int i = 0; i < 4; ++i) {
                tmp = din.read();
                if (tmp != -1) continue;
                throw new IOException("SOCKS5 error: " + tmp);
            }
            tmp = din.read();
            tmp = din.read();
            success = true;
            Socket socket = proxy;
            return socket;
        }
        finally {
            if (!success) {
                proxy.close();
            }
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Socket createSocket(InetSocketAddress address, int timeout) throws UnknownHostException, IOException {
        String socksProxyHost = System.getProperty("socksProxyHost");
        System.getProperties().remove("socksProxyHost");
        try {
            switch (this.mSettings.getConnectionType()) {
                case 1: {
                    try {
                        Socket socket = this.getSocks5TunnelSocket(address, timeout);
                        return socket;
                    }
                    catch (IOException e) {
                        Socket socket = this.getSocks4TunnelSocket(address, timeout);
                        if (socksProxyHost == null) return socket;
                        System.setProperty("socksProxyHost", socksProxyHost);
                        return socket;
                    }
                }
                case 0: {
                    Socket s = new Socket();
                    s.connect(address, timeout);
                    Socket socket = s;
                    return socket;
                }
                case 2: {
                    Socket socket = this.getHttpsTunnelSocket(address, timeout);
                    return socket;
                }
            }
            throw new IOException("Illegal connection type: " + this.mSettings.getConnectionType());
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (socksProxyHost != null) {
                System.setProperty("socksProxyHost", socksProxyHost);
            }
        }
    }
}

