/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.ui.nodes.editors;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditorSupport;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import javax.jmi.reflect.JmiException;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.MultipartId;
import org.netbeans.jmi.javamodel.NamedElement;
import org.netbeans.jmi.javamodel.PrimitiveType;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.modules.java.ui.nodes.editors.ObjectArrayPanel2;
import org.netbeans.modules.java.ui.nodes.elements.ElementNode;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class IdentifierArrayEditor
extends PropertyEditorSupport
implements ExPropertyEditor {
    public static final String JAVA_LANG_OBJECT = "java.lang.Object";
    IdentifierArrayPanel panel;
    boolean ignoreEditor = false;
    boolean ignorePanel = false;
    PropertyEnv env;
    private JavaModelPackage model;

    public String getAsText() {
        MultipartId[] id = (MultipartId[])this.getValue();
        if (id == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < id.length; ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(IdentifierArrayEditor.multipartIdToName(id[i]));
        }
        return buf.toString();
    }

    public static String multipartIdToName(MultipartId id) {
        LinkedList<String> list = new LinkedList<String>();
        while (id != null) {
            String stringRep;
            if (id.getTypeArguments().size() > 0) {
                JavaModelPackage pkg = (JavaModelPackage)id.refImmediatePackage();
                NamedElement e = id.getElement();
                stringRep = e.getName();
                stringRep = stringRep + '<';
                Iterator tIt = id.getTypeArguments().iterator();
                while (true) {
                    stringRep = stringRep + ((NamedElement)tIt.next()).getName();
                    if (!tIt.hasNext()) break;
                    stringRep = stringRep + ", ";
                }
                stringRep = stringRep + '>';
            } else {
                stringRep = id.getName();
            }
            list.addFirst(stringRep);
            id = id.getParent();
        }
        StringBuffer buf = new StringBuffer();
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            buf.append((String)iter.next());
            if (!iter.hasNext()) continue;
            buf.append('.');
        }
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAsText(String text) throws IllegalArgumentException {
        List list = Collections.EMPTY_LIST;
        try {
            JavaMetamodel.getDefaultRepository().beginTrans(false);
            try {
                list = this.resolveIdentifiers(text);
            }
            finally {
                JavaMetamodel.getDefaultRepository().endTrans();
            }
        }
        catch (JmiException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
        }
        MultipartId[] ret = new MultipartId[list.size()];
        list.toArray(ret);
        this.setValue(ret);
    }

    private List resolveIdentifiers(String txt) {
        StringTokenizer tukac = new StringTokenizer(txt, ", ", false);
        ArrayList<MultipartId> list = new ArrayList<MultipartId>();
        while (tukac.hasMoreTokens()) {
            String id = tukac.nextToken();
            JavaModelPackage jmp = this.model;
            Type t = jmp.getType().resolve(id);
            if (t instanceof PrimitiveType) {
                IllegalArgumentException ex = new IllegalArgumentException();
                String msg = MessageFormat.format(IdentifierArrayEditor.getString("MSG_InvalidIdentifier"), id);
                ErrorManager.getDefault().annotate((Throwable)ex, 256, null, msg, null, null);
                throw ex;
            }
            MultipartId mid = jmp.getMultipartId().createMultipartId(id, null, null);
            list.add(mid);
        }
        return list;
    }

    public void setValue(Object o) {
        this.ignoreEditor = true;
        boolean saveIgnorePanel = this.ignorePanel;
        this.ignorePanel = false;
        super.setValue(o);
        if (this.panel != null & !saveIgnorePanel) {
            this.panel.setIdentifiers((MultipartId[])o);
        }
        this.ignoreEditor = false;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public Component getCustomEditor() {
        if (this.panel == null) {
            this.panel = new IdentifierArrayPanel(this.model);
            this.panel.setIdentifiers((MultipartId[])this.getValue());
            this.panel.setMnemonics(this.env);
            this.panel.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    if (!IdentifierArrayEditor.this.ignoreEditor && "identifiers".equals(evt.getPropertyName())) {
                        IdentifierArrayEditor.this.ignorePanel = true;
                        IdentifierArrayEditor.this.setValue(evt.getNewValue());
                        IdentifierArrayEditor.this.ignorePanel = false;
                    }
                }
            });
        }
        return this.panel;
    }

    public void attachEnv(PropertyEnv env) {
        this.env = env;
        this.model = ElementNode.getModel(env.getFeatureDescriptor());
    }

    private static String getString(String key) {
        return NbBundle.getMessage((Class)IdentifierArrayEditor.class, (String)key);
    }

    static class IdentifierArrayPanel
    extends ObjectArrayPanel2 {
        public static final String PROP_IDENTIFIERS = "identifiers";
        MultipartId[] prevValue;
        private final JavaModelPackage javaModel;

        public IdentifierArrayPanel(JavaModelPackage javaModel) {
            this.javaModel = javaModel;
            this.prevValue = new MultipartId[0];
            this.getListComponent().setCellRenderer(new DefaultListCellRenderer(){

                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    Component comp = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                    if (comp == this) {
                        this.setText(IdentifierArrayEditor.multipartIdToName((MultipartId)value));
                    }
                    return comp;
                }
            });
        }

        public MultipartId[] getIdentifiers() {
            Object[] ret = new MultipartId[this.model.size()];
            this.model.copyInto(ret);
            return ret;
        }

        public void setIdentifiers(MultipartId[] data) {
            this.model = new DefaultListModel();
            if (data != null) {
                for (int i = 0; i < data.length; ++i) {
                    this.model.addElement(data[i]);
                }
            }
            this.getListComponent().setModel(this.model);
            this.modelChanged();
        }

        protected void modelChanged() {
            MultipartId[] newValue = this.getIdentifiers();
            this.firePropertyChange(PROP_IDENTIFIERS, this.prevValue, newValue);
            this.prevValue = newValue;
        }

        protected Object insertNewValue() {
            return this.openInputDialog(null);
        }

        protected Object editValue(Object oldValue) {
            return this.openInputDialog((MultipartId)oldValue);
        }

        protected MultipartId openInputDialog(MultipartId origValue) {
            Object ret;
            NotifyDescriptor.InputLine input = new NotifyDescriptor.InputLine(IdentifierArrayEditor.getString("LAB_NewName"), IdentifierArrayEditor.getString("LAB_NewIdentifier"));
            if (origValue != null) {
                input.setInputText(IdentifierArrayEditor.multipartIdToName(origValue));
            }
            while ((ret = DialogDisplayer.getDefault().notify((NotifyDescriptor)input)) == NotifyDescriptor.OK_OPTION) {
                String retValue = input.getInputText();
                if (!(retValue == null || "".equals(retValue) || retValue.startsWith(".") || retValue.endsWith(".") || retValue.indexOf("..") != -1)) {
                    boolean ok = true;
                    StringTokenizer tokenizer = new StringTokenizer(retValue, ".", false);
                    while (tokenizer.hasMoreTokens()) {
                        String token = tokenizer.nextToken();
                        if (Utilities.isJavaIdentifier((String)token)) continue;
                        ok = false;
                        break;
                    }
                    if (ok) {
                        return this.javaModel.getMultipartId().createMultipartId(retValue, null, null);
                    }
                }
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)IdentifierArrayEditor.getString("MSG_NotValidID")));
            }
            return null;
        }
    }
}

