/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.tools;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.reflect.Modifier;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import javax.jmi.reflect.InvalidObjectException;
import org.netbeans.api.mdr.MDRepository;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.NamedElement;
import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.jmi.javamodel.ParameterizedType;
import org.netbeans.jmi.javamodel.PrimitiveType;
import org.netbeans.jmi.javamodel.PrimitiveTypeKindEnum;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.modules.java.settings.JavaSynchronizationSettings;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.javacore.internalapi.JavaModelUtil;
import org.netbeans.modules.javacore.jmiimpl.javamodel.MethodImpl;
import org.netbeans.modules.javacore.jmiimpl.javamodel.ParameterizedTypeImpl;
import org.openide.ErrorManager;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.SharedClassObject;
import org.openide.util.Task;
import org.openide.util.TaskListener;

public class JMIInheritanceSupport
implements Runnable,
TaskListener {
    public static final String PROP_FINISHED = "JMIInheritanceSupport.finished";
    private ClassDefinition root;
    private JavaModelPackage modelPackage;
    private Resource resource;
    private Set classes;
    private Map methods;
    private Map tree;
    private List classesList;
    private Set finalMethodsKeys;
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private RequestProcessor.Task task = RequestProcessor.getDefault().create((Runnable)this);
    private int nextPosition = -1;
    static final /* synthetic */ boolean $assertionsDisabled;

    private static String getString(String key) {
        return NbBundle.getMessage((Class)JMIInheritanceSupport.class, (String)key);
    }

    public JMIInheritanceSupport(ClassDefinition root) {
        DataObject dobj = JavaMetamodel.getManager().getDataObject(root.getResource());
        if (!$assertionsDisabled && dobj == null) {
            throw new AssertionError();
        }
        this.root = root;
        this.resource = root.getResource();
        this.modelPackage = (JavaModelPackage)root.refOutermostPackage();
        this.task.addTaskListener((TaskListener)this);
    }

    public ClassDefinition getRootClass() {
        return this.root;
    }

    public void setRootClass(ClassDefinition root) {
        this.root = root;
    }

    public Collection getClasses(Collection result, boolean cls, boolean ifc) {
        if (!this.task.isFinished()) {
            this.task.waitFinished();
        }
        Iterator i = this.classesList.iterator();
        while (i.hasNext()) {
            JavaClass jc = (JavaClass)i.next();
            boolean isInterface = jc.isInterface();
            if ((isInterface || !cls) && (!isInterface || !ifc)) continue;
            result.add(jc);
        }
        return result;
    }

    public Collection getAllMethods(Collection result, boolean abstractOnly) {
        if (!this.task.isFinished()) {
            this.task.waitFinished();
        }
        Iterator i = this.methods.values().iterator();
        while (i.hasNext()) {
            Method mte = (Method)i.next();
            if (abstractOnly && (!this.isAbstract(mte) || this.isImplemented(mte))) continue;
            result.add(mte);
        }
        return result;
    }

    public Collection getMethods(Collection result, ClassDefinition cd, boolean abstractOnly) {
        if (!this.task.isFinished()) {
            this.task.waitFinished();
        }
        Set meths = (Set)this.tree.get(cd);
        Iterator i = meths.iterator();
        while (i.hasNext()) {
            MethodKey key = (MethodKey)i.next();
            Method m = (Method)this.methods.get(key);
            if (abstractOnly && (!this.isAbstract(m) || this.isImplemented(m))) continue;
            result.add(m);
        }
        return result;
    }

    public Method overrideMethod(Method m, boolean superCall, boolean javadoc) {
        try {
            String bodyText = "";
            int mods = m.getModifiers() & 0xFFFFFADF;
            if (superCall) {
                bodyText = this.createSuperCall(m, this.isImplementedInSuper(this.root, m, false));
            }
            MethodImpl miOrig = m instanceof MethodImpl ? (MethodImpl)m : (MethodImpl)((ParameterizedTypeImpl.Wrapper)m).getWrappedObject();
            MethodImpl newMethod = (MethodImpl)miOrig.duplicate((JavaModelPackage)this.root.refImmediatePackage());
            newMethod.setJavadocText(javadoc ? miOrig.getJavadocText() : null);
            newMethod.setModifiers(mods);
            newMethod.setBody(null);
            newMethod.fixImports((Element)this.root, (Element)m);
            newMethod.setBodyText(bodyText);
            this.addMethod((Method)newMethod);
            return newMethod;
        }
        catch (InvalidObjectException e) {
            ErrorManager.getDefault().notify((Throwable)e);
            return null;
        }
    }

    private void addMethod(Method m) {
        List contents = this.root.getContents();
        if (this.nextPosition != -1) {
            contents.add(this.nextPosition, m);
            ++this.nextPosition;
            return;
        }
        int index = -1;
        ListIterator<Method> iter = contents.listIterator();
        int x = 0;
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (!(obj instanceof JavaClass)) {
                index = x;
            }
            ++x;
        }
        if (index == -1) {
            contents.add(m);
            this.nextPosition = 1;
            return;
        }
        JavaMetamodel manager = JavaMetamodel.getManager();
        iter = contents.listIterator(index + 1);
        while (iter.hasPrevious()) {
            NamedElement elem = (NamedElement)iter.previous();
            if (manager.isElementGuarded((Element)elem)) continue;
            iter.next();
            iter.add(m);
            this.nextPosition = contents.indexOf(m) + 1;
            return;
        }
        contents.add(0, m);
        this.nextPosition = 1;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(l);
    }

    public boolean isFinished() {
        return this.task.isFinished();
    }

    public void reset() {
        this.classes = null;
        this.classesList = null;
        this.methods = null;
        this.tree = null;
        this.finalMethodsKeys = null;
        this.task.schedule(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.classes = new HashSet();
        this.classesList = new ArrayList();
        this.methods = new HashMap();
        this.tree = new HashMap();
        this.finalMethodsKeys = new HashSet();
        MDRepository repository = JavaMetamodel.getDefaultRepository();
        repository.beginTrans(false);
        try {
            JavaMetamodel model = JavaMetamodel.getManager();
            model.setClassPath(model.getFileObject(this.root.getResource()), true);
            for (JavaClass superClass = this.root.getSuperClass(); superClass != null && this.classes.add(superClass); superClass = superClass.getSuperClass()) {
                this.classesList.add(superClass);
                HashSet meths = new HashSet();
                this.collectMethods(meths, superClass);
                this.tree.put(superClass, meths);
            }
            this.traverseInterfaces(this.classes, this.classesList, this.tree, this.root);
        }
        finally {
            repository.endTrans();
        }
    }

    private void traverseInterfaces(Set classes, List classesList, Map tree, ClassDefinition root) {
        List interfaces = root.getInterfaces();
        Iterator iter = interfaces.iterator();
        while (iter.hasNext()) {
            JavaClass jc = (JavaClass)iter.next();
            if (!classes.add(jc)) continue;
            classesList.add(jc);
            HashSet meths = new HashSet();
            this.collectMethods(meths, jc);
            tree.put(jc, meths);
            this.traverseInterfaces(classes, classesList, tree, (ClassDefinition)jc);
        }
    }

    public void taskFinished(Task task) {
        this.pcs.firePropertyChange(PROP_FINISHED, Boolean.FALSE, Boolean.TRUE);
    }

    private boolean isAbstract(Method mte) {
        ClassDefinition cd = mte.getDeclaringClass();
        return Modifier.isAbstract(mte.getModifiers()) || cd instanceof JavaClass && ((JavaClass)cd).isInterface();
    }

    private boolean isAccessibleMethod(Method m) {
        int modifs;
        ClassDefinition cls = m.getDeclaringClass();
        int n = modifs = cls instanceof JavaClass ? ((JavaClass)cls).getModifiers() : 0;
        if ((modifs & 2) != 0 || (modifs & 7) == 0 && !this.isSamePackage(cls)) {
            return false;
        }
        if (cls instanceof JavaClass && ((JavaClass)cls).isInterface()) {
            return true;
        }
        modifs = m.getModifiers();
        if ((modifs & 2) != 0) {
            return false;
        }
        if ((modifs & 5) != 0) {
            return true;
        }
        return this.isSamePackage(cls);
    }

    private boolean isImplementedInSuper(ClassDefinition rootCl, Method m, boolean includeClass) {
        String name = m.getName();
        List params = m.getParameters();
        ArrayList<Type> paramTypes = new ArrayList<Type>(params.size());
        Iterator iter = params.iterator();
        while (iter.hasNext()) {
            paramTypes.add(((Parameter)iter.next()).getType());
        }
        HashSet<ClassDefinition> visited = new HashSet<ClassDefinition>();
        for (ClassDefinition jc = includeClass ? rootCl : rootCl.getSuperClass(); jc != null && visited.add(jc); jc = jc.getSuperClass()) {
            Method mte = jc.getMethod(name, paramTypes, false);
            if (mte == null || Modifier.isAbstract(mte.getModifiers())) continue;
            return true;
        }
        return false;
    }

    private boolean isImplemented(Method m) {
        String name = m.getName();
        List params = m.getParameters();
        ArrayList<Type> paramTypes = new ArrayList<Type>(params.size());
        Iterator iter = params.iterator();
        while (iter.hasNext()) {
            paramTypes.add(((Parameter)iter.next()).getType());
        }
        ClassDefinition jc = this.root;
        ClassDefinition realJc = jc instanceof ParameterizedType ? ((ParameterizedType)jc).getDefinition() : jc;
        HashSet<ClassDefinition> visited = new HashSet<ClassDefinition>();
        visited.add(m.getDeclaringClass());
        while (jc != null && visited.add(realJc)) {
            Method mte = jc.getMethod(name, paramTypes, false);
            if (mte != null && !Modifier.isAbstract(mte.getModifiers())) {
                return true;
            }
            realJc = (jc = jc.getSuperClass()) instanceof ParameterizedType ? ((ParameterizedType)jc).getDefinition() : jc;
        }
        return false;
    }

    private boolean isOverriden(Method m) {
        List params = m.getParameters();
        String name = m.getName();
        ArrayList<Type> paramTypes = new ArrayList<Type>(params.size());
        Iterator iter = params.iterator();
        while (iter.hasNext()) {
            paramTypes.add(((Parameter)iter.next()).getType());
        }
        HashSet<ClassDefinition> visited = new HashSet<ClassDefinition>();
        for (ClassDefinition cd = this.root; cd != null && visited.add(cd); cd = cd.getSuperClass()) {
            Method meth = this.root.getMethod(name, paramTypes, false);
            if (meth == m) {
                return false;
            }
            if (meth == null) continue;
            return true;
        }
        return false;
    }

    private boolean isSamePackage(ClassDefinition cd) {
        String p1 = this.root.getResource().getPackageName();
        String p2 = cd.getResource().getPackageName();
        return p1 == null ? p2 == null : p1.equals(p2);
    }

    private void collectMethods(Set meths, JavaClass jc) {
        Iterator iter = jc.getContents().iterator();
        while (iter.hasNext()) {
            MethodKey key;
            Object obj = iter.next();
            if (!(obj instanceof Method)) continue;
            Method m = (Method)obj;
            int mods = m.getModifiers();
            boolean modFlag = !Modifier.isStatic(mods) && (Modifier.isPublic(mods) || Modifier.isProtected(mods));
            boolean isFinal = Modifier.isFinal(mods);
            if (modFlag && !isFinal && this.isAccessibleMethod(m) && !this.isOverriden(m)) {
                key = new MethodKey(m);
                if (this.finalMethodsKeys.contains(key) || this.methods.get(key) != null) continue;
                this.methods.put(key, m);
                meths.add(key);
                continue;
            }
            if (!isFinal || !modFlag) continue;
            key = new MethodKey(m);
            this.finalMethodsKeys.add(key);
        }
        iter = jc.getInterfaces().iterator();
        while (iter.hasNext()) {
            this.collectMethods(meths, (JavaClass)iter.next());
        }
    }

    private String createSuperCall(Method target, boolean hasSuper) {
        String body;
        JavaSynchronizationSettings syncSettings = (JavaSynchronizationSettings)SharedClassObject.findObject((Class)JavaSynchronizationSettings.class, (boolean)true);
        if (hasSuper) {
            StringBuffer str = new StringBuffer();
            Iterator iter = target.getParameters().iterator();
            while (iter.hasNext()) {
                Parameter par = (Parameter)iter.next();
                if (str.length() > 0) {
                    str.append(", ");
                }
                str.append(par.getName());
            }
            Type t = target.getType();
            String format = t instanceof PrimitiveType && PrimitiveTypeKindEnum.VOID.equals((Object)((PrimitiveType)t).getKind()) ? NbBundle.getMessage((Class)JMIInheritanceSupport.class, (String)"FMT_CallSuper") : NbBundle.getMessage((Class)JMIInheritanceSupport.class, (String)"FMT_ReturnCallSuper");
            body = MessageFormat.format(format, JavaModelUtil.resolveImportsForType((Element)this.root, (Type)target.getType()).getName(), target.getName(), str);
        } else {
            body = syncSettings.getGenerateReturnAsString(target.getType());
        }
        return body;
    }

    static {
        $assertionsDisabled = !JMIInheritanceSupport.class.desiredAssertionStatus();
    }

    public static class MethodKey {
        private String name;
        private String[] paramTypes;

        public MethodKey(Method m) {
            this.name = m.getName();
            List params = m.getParameters();
            this.paramTypes = new String[params.size()];
            Iterator iter = params.iterator();
            int x = 0;
            while (iter.hasNext()) {
                this.paramTypes[x] = ((Parameter)iter.next()).getType().getName();
                ++x;
            }
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof MethodKey)) {
                return false;
            }
            return this.name.equals(((MethodKey)obj).name) && Arrays.equals(this.paramTypes, ((MethodKey)obj).paramTypes);
        }

        public int hashCode() {
            int length = this.paramTypes.length;
            if (length == 0) {
                return 0;
            }
            if (length == 1) {
                return this.paramTypes[0].hashCode();
            }
            return this.paramTypes[0].hashCode() ^ this.paramTypes[length - 1].hashCode();
        }
    }
}

