/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.modules.java.JavaElementNodeFactory;
import org.netbeans.modules.java.ui.nodes.ExElementNodeFactory;
import org.netbeans.modules.java.ui.nodes.ExFilterFactory;
import org.netbeans.modules.java.ui.nodes.FilterSourceNodeFactory;
import org.netbeans.modules.java.ui.nodes.JavaSourceNodeFactory;
import org.netbeans.modules.java.ui.nodes.SourceNodeFactory;
import org.netbeans.modules.java.ui.nodes.SourceNodes;
import org.openide.ErrorManager;
import org.openide.cookies.InstanceCookie;
import org.openide.loaders.DataFolder;
import org.openide.loaders.FolderInstance;
import org.openide.src.nodes.ElementNodeFactory;
import org.openide.src.nodes.FilterFactory;

final class NodeFactoryPool
extends FolderInstance {
    ElementNodeFactory base;
    LinkedList explicit;
    List factories = Collections.EMPTY_LIST;
    ElementNodeFactory head;
    boolean initialized;

    NodeFactoryPool(DataFolder storage, ElementNodeFactory base) {
        super(storage);
        this.base = base;
        this.head = base;
    }

    final Object sync() {
        return this.base;
    }

    ElementNodeFactory getHead() {
        if (!this.initialized) {
            this.recreate();
            this.waitFinished();
            this.initialized = true;
        }
        return this.head;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object createInstance(InstanceCookie[] cookies) throws IOException, ClassNotFoundException {
        ArrayList<Object> l = new ArrayList<Object>(cookies.length + 1);
        JavaSourceNodeFactory jsnf = new JavaSourceNodeFactory();
        jsnf.setGenerateForTree(((JavaElementNodeFactory)this.base).getGenerateForTree());
        l.add(jsnf);
        for (int i = 0; i < cookies.length; ++i) {
            try {
                Object o = cookies[i].instanceCreate();
                if (o instanceof FilterSourceNodeFactory) {
                    l.add(o);
                    continue;
                }
                if (!(o instanceof FilterFactory)) continue;
                ExFilterFactory eff = new ExFilterFactory((ElementNodeFactory)o);
                l.add(eff);
                continue;
            }
            catch (IOException ex) {
                this.logError(ex);
                continue;
            }
            catch (ClassNotFoundException ex) {
                this.logError(ex);
            }
        }
        Object object = this.sync();
        synchronized (object) {
            ElementNodeFactory f = this.relinkFactories(l);
            this.factories = l;
            this.head = f;
            return this.head;
        }
    }

    private ElementNodeFactory relinkFactories(Collection first) {
        Object obj;
        ExFilterFactory previousFactory = new ExFilterFactory(this.base);
        LinkedList next = this.explicit;
        if (first == null) {
            first = this.factories;
        }
        Iterator it = first.iterator();
        while (it.hasNext()) {
            obj = it.next();
            NodeFactoryPool.attachFactories(obj, previousFactory);
            previousFactory = obj;
        }
        if (next != null) {
            it = next.iterator();
            while (it.hasNext()) {
                obj = it.next();
                ExFilterFactory eff = new ExFilterFactory((ElementNodeFactory)obj);
                NodeFactoryPool.attachFactories(previousFactory, eff);
                previousFactory = obj;
            }
        }
        return previousFactory instanceof ElementNodeFactory ? (ElementNodeFactory)previousFactory : SourceNodes.createElementNodeFactory((FilterSourceNodeFactory)((Object)previousFactory));
    }

    private static void attachFactories(Object f1, Object f2) {
        if (f1 instanceof FilterSourceNodeFactory) {
            FilterSourceNodeFactory f1SNF = (FilterSourceNodeFactory)f1;
            if (f2 instanceof SourceNodeFactory) {
                f1SNF.attach((SourceNodeFactory)f2);
            } else if (f2 instanceof ExElementNodeFactory) {
                f1SNF.attach(SourceNodes.createSourceNodeFactory((ExElementNodeFactory)f2));
            } else {
                ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("Unsupported factory: " + f2));
            }
        } else if (f1 instanceof ExFilterFactory) {
            ExFilterFactory f1EFF = (ExFilterFactory)f1;
            if (f2 instanceof ExElementNodeFactory) {
                f1EFF.attach((ExElementNodeFactory)f2);
            } else if (f2 instanceof SourceNodeFactory) {
                f1EFF.attach(SourceNodes.createElementNodeFactory((SourceNodeFactory)f2));
            } else {
                ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("Unsupported factory: " + f2));
            }
        } else {
            ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("Unsupported factory: " + f1));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addFactory(FilterFactory f) {
        Object object = this.sync();
        synchronized (object) {
            if (this.explicit == null) {
                this.explicit = new LinkedList();
            }
            this.explicit.add(f);
            this.head = this.relinkFactories(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeFactory(FilterFactory f) {
        Object object = this.sync();
        synchronized (object) {
            if (!this.explicit.remove(f)) {
                return;
            }
            this.relinkFactories(null);
        }
    }

    void logError(Exception ex) {
        ErrorManager.getDefault().notify((Throwable)ex);
    }
}

