/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.debugger.jpda;

import org.netbeans.api.debugger.jpda.JPDABreakpoint;

public final class FieldBreakpoint
extends JPDABreakpoint {
    public static final String PROP_FIELD_NAME = "fieldName";
    public static final String PROP_CLASS_NAME = "className";
    public static final String PROP_CONDITION = "condition";
    public static final String PROP_BREAKPOINT_TYPE = "breakpointType";
    public static final int TYPE_ACCESS = 1;
    public static final int TYPE_MODIFICATION = 2;
    private String className = "";
    private String fieldName = "";
    private int type = 2;
    private String condition = "";

    private FieldBreakpoint() {
    }

    public static FieldBreakpoint create(String className, String fieldName, int breakpointType) {
        FieldBreakpoint b = new FieldBreakpoint();
        b.setClassName(className);
        b.setFieldName(fieldName);
        b.setBreakpointType(breakpointType);
        return b;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        if (className == this.className || className != null && this.className != null && this.className.equals(className)) {
            return;
        }
        String old = this.className;
        this.className = className;
        this.firePropertyChange(PROP_CLASS_NAME, old, className);
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String name) {
        if (name != null) {
            name = name.trim();
        }
        if (name == this.fieldName || name != null && this.fieldName != null && this.fieldName.equals(name)) {
            return;
        }
        String old = this.fieldName;
        this.fieldName = name;
        this.firePropertyChange(PROP_FIELD_NAME, old, this.fieldName);
    }

    public int getBreakpointType() {
        return this.type;
    }

    public void setBreakpointType(int type) {
        if (this.type == type) {
            return;
        }
        if (type != 2 && type != 1) {
            throw new IllegalArgumentException();
        }
        int old = this.type;
        this.type = type;
        this.firePropertyChange(PROP_BREAKPOINT_TYPE, new Integer(old), new Integer(type));
    }

    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String cond) {
        if (cond != null) {
            cond = cond.trim();
        }
        String old = this.condition;
        this.condition = cond;
        this.firePropertyChange(PROP_CONDITION, old, cond);
    }

    public String toString() {
        return "FieldBreakpoint " + this.className + "." + this.fieldName;
    }
}

