/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbjarproject.api;

import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Stack;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.netbeans.modules.j2ee.dd.api.ejb.DDProvider;
import org.netbeans.modules.j2ee.deployment.devmodules.api.AntDeploymentHelper;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.j2ee.ejbjarproject.EjbJarProject;
import org.netbeans.modules.j2ee.ejbjarproject.UpdateHelper;
import org.netbeans.modules.j2ee.ejbjarproject.Utils;
import org.netbeans.modules.j2ee.ejbjarproject.ui.customizer.PlatformUiSupport;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.ProjectGenerator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class EjbJarProjectGenerator {
    private static final String DEFAULT_DOC_BASE_FOLDER = "conf";
    private static final String DEFAULT_SRC_FOLDER = "src";
    private static final String DEFAULT_TEST_FOLDER = "test";
    private static final String DEFAULT_RESOURCE_FOLDER = "setup";
    private static final String DEFAULT_JAVA_FOLDER = "java";
    private static final String DEFAULT_BUILD_DIR = "build";
    public static final String MINIMUM_ANT_VERSION = "1.6";

    private EjbJarProjectGenerator() {
    }

    public static AntProjectHelper createProject(File dir, String name, String j2eeLevel, String serverInstanceID) throws IOException {
        FileObject fo = EjbJarProjectGenerator.createProjectDir(dir);
        FileObject srcRoot = fo.createFolder(DEFAULT_SRC_FOLDER);
        srcRoot.createFolder(DEFAULT_JAVA_FOLDER);
        FileObject testRoot = fo.createFolder(DEFAULT_TEST_FOLDER);
        FileObject confRoot = srcRoot.createFolder(DEFAULT_DOC_BASE_FOLDER);
        FileUtil.copyFile((FileObject)Repository.getDefault().getDefaultFileSystem().findResource("org-netbeans-modules-j2ee-ejbjarproject/MANIFEST.MF"), (FileObject)confRoot, (String)"MANIFEST");
        AntProjectHelper h = EjbJarProjectGenerator.setupProject(fo, name, DEFAULT_SRC_FOLDER, DEFAULT_TEST_FOLDER, null, null, null, j2eeLevel, serverInstanceID);
        EditableProperties ep = h.getProperties("nbproject/project.properties");
        ep.put((Object)"source.root", (Object)DEFAULT_SRC_FOLDER);
        ep.setProperty("meta.inf", "${source.root}/conf");
        ep.setProperty("src.dir", "${source.root}/java");
        ep.setProperty("meta.inf.excludes", "sun-cmp-mappings.xml");
        h.putProperties("nbproject/project.properties", ep);
        Project p = ProjectManager.getDefault().findProject(h.getProjectDirectory());
        ProjectManager.getDefault().saveProject(p);
        if (!"1.5".equals(j2eeLevel)) {
            String resource = "org-netbeans-modules-j2ee-ejbjarproject/ejb-jar-2.1.xml";
            FileObject ddFile = FileUtil.copyFile((FileObject)Repository.getDefault().getDefaultFileSystem().findResource(resource), (FileObject)confRoot, (String)"ejb-jar");
            org.netbeans.modules.j2ee.dd.api.ejb.EjbJar ejbJar = DDProvider.getDefault().getMergedDDRoot(EjbJar.getEjbJar((FileObject)ddFile).getMetadataUnit());
            ejbJar.setDisplayName(name);
            ejbJar.write(ddFile);
        }
        return h;
    }

    public static AntProjectHelper importProject(File dir, String name, File[] sourceFolders, File[] testFolders, File configFilesBase, File libFolder, String j2eeLevel, String serverInstanceID, boolean fromJavaSources) throws IOException {
        AntProjectHelper retVal = EjbJarProjectGenerator.importProject(dir, name, sourceFolders, testFolders, configFilesBase, libFolder, j2eeLevel, serverInstanceID);
        EditableProperties subEp = retVal.getProperties("nbproject/project.properties");
        subEp.setProperty("java.source.based", fromJavaSources + "");
        retVal.putProperties("nbproject/project.properties", subEp);
        Project subP = ProjectManager.getDefault().findProject(retVal.getProjectDirectory());
        ProjectManager.getDefault().saveProject(subP);
        return retVal;
    }

    public static AntProjectHelper importProject(final File dir, String name, final File[] sourceFolders, final File[] testFolders, File configFilesBase, File libFolder, String j2eeLevel, String serverInstanceID) throws IOException {
        assert (sourceFolders != null && testFolders != null) : "Package roots can't be null";
        FileObject dirFO = EjbJarProjectGenerator.createProjectDir(dir);
        final AntProjectHelper h = EjbJarProjectGenerator.setupProject(dirFO, name, null, null, configFilesBase, libFolder == null ? null : libFolder, null, j2eeLevel, serverInstanceID);
        final EjbJarProject p = (EjbJarProject)ProjectManager.getDefault().findProject(dirFO);
        final ReferenceHelper refHelper = p.getReferenceHelper();
        try {
            ProjectManager.mutex().writeAccess(new Mutex.ExceptionAction(){

                public Object run() throws Exception {
                    EditableProperties props;
                    Element root;
                    String propName;
                    int i;
                    Element data = h.getPrimaryConfigurationData(true);
                    Document doc = data.getOwnerDocument();
                    NodeList nl = data.getElementsByTagNameNS("http://www.netbeans.org/ns/j2ee-ejbjarproject/3", "source-roots");
                    assert (nl.getLength() == 1);
                    Element sourceRoots = (Element)nl.item(0);
                    nl = data.getElementsByTagNameNS("http://www.netbeans.org/ns/j2ee-ejbjarproject/3", "test-roots");
                    assert (nl.getLength() == 1);
                    Element testRoots = (Element)nl.item(0);
                    for (i = 0; i < sourceFolders.length; ++i) {
                        propName = "src.dir" + (i == 0 ? "" : Integer.toString(i + 1));
                        String srcReference = refHelper.createForeignFileReference(sourceFolders[i], EjbJarProjectGenerator.DEFAULT_JAVA_FOLDER);
                        root = doc.createElementNS("http://www.netbeans.org/ns/j2ee-ejbjarproject/3", "root");
                        root.setAttribute("id", propName);
                        sourceRoots.appendChild(root);
                        props = h.getProperties("nbproject/project.properties");
                        props.put((Object)propName, (Object)srcReference);
                        h.putProperties("nbproject/project.properties", props);
                    }
                    if (testFolders.length == 0) {
                        String testLoc = NbBundle.getMessage(EjbJarProjectGenerator.class, (String)"TXT_DefaultTestFolderName");
                        File f = new File(dir, testLoc);
                        f.mkdirs();
                        String propName2 = "test.src.dir";
                        root = doc.createElementNS("http://www.netbeans.org/ns/j2ee-ejbjarproject/3", "root");
                        root.setAttribute("id", propName2);
                        root.setAttribute("name", NbBundle.getMessage(EjbJarProjectGenerator.class, (String)"NAME_test.src.dir"));
                        testRoots.appendChild(root);
                        props = h.getProperties("nbproject/project.properties");
                        props.put((Object)propName2, (Object)testLoc);
                        h.putProperties("nbproject/project.properties", props);
                    } else {
                        for (i = 0; i < testFolders.length; ++i) {
                            if (!testFolders[i].exists()) {
                                testFolders[i].mkdirs();
                            }
                            propName = "test.src.dir" + (i == 0 ? "" : Integer.toString(i + 1));
                            String testReference = refHelper.createForeignFileReference(testFolders[i], EjbJarProjectGenerator.DEFAULT_JAVA_FOLDER);
                            root = doc.createElementNS("http://www.netbeans.org/ns/j2ee-ejbjarproject/3", "root");
                            root.setAttribute("id", propName);
                            testRoots.appendChild(root);
                            props = h.getProperties("nbproject/project.properties");
                            props.put((Object)propName, (Object)testReference);
                            h.putProperties("nbproject/project.properties", props);
                        }
                    }
                    h.putPrimaryConfigurationData(data, true);
                    ProjectManager.getDefault().saveProject((Project)p);
                    return null;
                }
            });
        }
        catch (MutexException me) {
            ErrorManager.getDefault().notify((Throwable)me);
        }
        FileObject ejbJarXml = FileUtil.toFileObject((File)configFilesBase).getFileObject("ejb-jar.xml");
        if (ejbJarXml != null) {
            try {
                String dispName;
                org.netbeans.modules.j2ee.dd.api.ejb.EjbJar root = DDProvider.getDefault().getMergedDDRoot(EjbJar.getEjbJar((FileObject)ejbJarXml).getMetadataUnit());
                boolean writeDD = false;
                if (new BigDecimal("2.0").equals(root.getVersion()) && j2eeLevel.equals("1.4")) {
                    root.setVersion(new BigDecimal("2.1"));
                    writeDD = true;
                }
                if (null == (dispName = root.getDefaultDisplayName()) || dispName.trim().length() == 0) {
                    root.setDisplayName(name);
                    writeDD = true;
                }
                if (writeDD) {
                    root.write(ejbJarXml);
                }
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
        }
        return h;
    }

    private static String createFileReference(ReferenceHelper refHelper, FileObject projectFO, FileObject referencedFO) {
        if (FileUtil.isParentOf((FileObject)projectFO, (FileObject)referencedFO)) {
            return EjbJarProjectGenerator.relativePath(projectFO, referencedFO);
        }
        return refHelper.createForeignFileReference(FileUtil.toFile((FileObject)referencedFO), null);
    }

    private static String relativePath(FileObject parent, FileObject child) {
        if (child.equals(parent)) {
            return "";
        }
        if (!FileUtil.isParentOf((FileObject)parent, (FileObject)child)) {
            throw new IllegalArgumentException("Cannot find relative path, " + parent + " is not parent of " + child);
        }
        return child.getPath().substring(parent.getPath().length() + 1);
    }

    private static AntProjectHelper setupProject(FileObject dirFO, String name, String srcRoot, String testRoot, File configFiles, File libraries, String resources, String j2eeLevel, String serverInstanceID) throws IOException {
        EditableProperties props;
        String ref;
        AntProjectHelper h = ProjectGenerator.createProject((FileObject)dirFO, (String)"org.netbeans.modules.j2ee.ejbjarproject");
        EjbJarProject prj = (EjbJarProject)ProjectManager.getDefault().findProject(h.getProjectDirectory());
        ReferenceHelper referenceHelper = prj.getReferenceHelper();
        Element data = h.getPrimaryConfigurationData(true);
        Document doc = data.getOwnerDocument();
        Element nameEl = doc.createElementNS("http://www.netbeans.org/ns/j2ee-ejbjarproject/3", "name");
        nameEl.appendChild(doc.createTextNode(name));
        data.appendChild(nameEl);
        Element minant = doc.createElementNS("http://www.netbeans.org/ns/j2ee-ejbjarproject/3", "minimum-ant-version");
        minant.appendChild(doc.createTextNode(MINIMUM_ANT_VERSION));
        data.appendChild(minant);
        EditableProperties ep = h.getProperties("nbproject/project.properties");
        Element sourceRoots = doc.createElementNS("http://www.netbeans.org/ns/j2ee-ejbjarproject/3", "source-roots");
        if (srcRoot != null) {
            Element root = doc.createElementNS("http://www.netbeans.org/ns/j2ee-ejbjarproject/3", "root");
            root.setAttribute("id", "src.dir");
            root.setAttribute("name", NbBundle.getMessage(EjbJarProjectGenerator.class, (String)"NAME_src.dir"));
            sourceRoots.appendChild(root);
            ep.setProperty("src.dir", srcRoot);
        }
        data.appendChild(sourceRoots);
        Element testRoots = doc.createElementNS("http://www.netbeans.org/ns/j2ee-ejbjarproject/3", "test-roots");
        if (testRoot != null) {
            Element root = doc.createElementNS("http://www.netbeans.org/ns/j2ee-ejbjarproject/3", "root");
            root.setAttribute("id", "test.src.dir");
            root.setAttribute("name", NbBundle.getMessage(EjbJarProjectGenerator.class, (String)"NAME_test.src.dir"));
            testRoots.appendChild(root);
            ep.setProperty("test.src.dir", testRoot);
        }
        data.appendChild(testRoots);
        h.putPrimaryConfigurationData(data, true);
        if (resources != null) {
            ep.setProperty("resource.dir", resources);
        } else {
            ep.setProperty("resource.dir", DEFAULT_RESOURCE_FOLDER);
        }
        ep.setProperty("javac.source", "${default.javac.source}");
        ep.setProperty("javac.target", "${default.javac.target}");
        ep.setProperty("javac.classpath", "");
        ep.setProperty("dist.dir", "dist");
        ep.setProperty("dist.jar", "${dist.dir}/${jar.name}");
        ep.setProperty("dist.ear.jar", "${dist.dir}/${jar.name}");
        ep.setProperty("j2ee.platform", j2eeLevel);
        ep.setProperty("jar.name", PropertyUtils.getUsablePropertyName((String)name) + ".jar");
        ep.setProperty("jar.compress", "false");
        Deployment deployment = Deployment.getDefault();
        ep.setProperty("j2ee.server.type", deployment.getServerID(serverInstanceID));
        ep.setProperty("javac.debug", "true");
        ep.setProperty("javac.deprecation", "false");
        ep.setProperty("javac.test.classpath", new String[]{"${javac.classpath}:", "${build.classes.dir}:", "${libs.junit.classpath}"});
        ep.setProperty("run.test.classpath", new String[]{"${javac.test.classpath}:", "${build.test.classes.dir}"});
        ep.setProperty("debug.test.classpath", new String[]{"${run.test.classpath}"});
        ep.setProperty("build.dir", DEFAULT_BUILD_DIR);
        ep.setProperty("build.test.classes.dir", "${build.dir}/test/classes");
        ep.setProperty("build.test.results.dir", "${build.dir}/test/results");
        ep.setProperty("build.generated.dir", "${build.dir}/generated");
        ep.setProperty("build.classes.dir", "${build.dir}/jar");
        ep.setProperty("build.ear.classes.dir", "${build.dir}/ear-module");
        ep.setProperty("build.classes.excludes", "**/*.java,**/*.form,**/.nbattrs");
        ep.setProperty("dist.javadoc.dir", "${dist.dir}/javadoc");
        ep.setProperty("platform.active", "default_platform");
        ep.setProperty("debug.classpath", "${javac.classpath}:${build.classes.dir}");
        ep.setProperty("javadoc.private", "false");
        ep.setProperty("javadoc.notree", "false");
        ep.setProperty("javadoc.use", "true");
        ep.setProperty("javadoc.nonavbar", "false");
        ep.setProperty("javadoc.noindex", "false");
        ep.setProperty("javadoc.splitindex", "true");
        ep.setProperty("javadoc.author", "false");
        ep.setProperty("javadoc.version", "false");
        ep.setProperty("javadoc.windowtitle", "");
        ep.setProperty("javadoc.encoding", "");
        ep.setProperty("javadoc.preview", "true");
        ep.setProperty("javadoc.additionalparam", "");
        h.putProperties("nbproject/project.properties", ep);
        if (configFiles != null) {
            ref = EjbJarProjectGenerator.createFileReference(referenceHelper, dirFO, FileUtil.toFileObject((File)configFiles));
            props = h.getProperties("nbproject/project.properties");
            props.setProperty("meta.inf", ref);
            h.putProperties("nbproject/project.properties", props);
        }
        if (libraries != null) {
            ref = EjbJarProjectGenerator.createFileReference(referenceHelper, dirFO, FileUtil.toFileObject((File)libraries));
            props = h.getProperties("nbproject/project.properties");
            props.setProperty("lib.dir", ref);
            h.putProperties("nbproject/project.properties", props);
        }
        ep = h.getProperties("nbproject/private/private.properties");
        ep.setProperty("j2ee.server.instance", serverInstanceID);
        J2eePlatform j2eePlatform = Deployment.getDefault().getJ2eePlatform(serverInstanceID);
        if (!j2eePlatform.getSupportedSpecVersions(J2eeModule.EJB).contains(j2eeLevel)) {
            ErrorManager.getDefault().log(16, "J2EE level:" + j2eeLevel + " not supported by server " + Deployment.getDefault().getServerInstanceDisplayName(serverInstanceID) + " for module type EJB");
        }
        String classpath = Utils.toClasspathString(j2eePlatform.getClasspathEntries());
        ep.setProperty("j2ee.platform.classpath", classpath);
        if (j2eePlatform.isToolSupported("wscompile")) {
            File[] wsClasspath = j2eePlatform.getToolClasspathEntries("wscompile");
            ep.setProperty("j2ee.platform.wscompile.classpath", Utils.toClasspathString(wsClasspath));
        }
        File projectFolder = FileUtil.toFile((FileObject)dirFO);
        try {
            AntDeploymentHelper.writeDeploymentScript((File)new File(projectFolder, "nbproject/ant-deploy.xml"), (Object)J2eeModule.EJB, (String)serverInstanceID);
        }
        catch (IOException ioe) {
            ErrorManager.getDefault().notify(1, (Throwable)ioe);
        }
        File deployAntPropsFile = AntDeploymentHelper.getDeploymentPropertiesFile((String)serverInstanceID);
        if (deployAntPropsFile != null) {
            ep.setProperty("deploy.ant.properties.file", deployAntPropsFile.getAbsolutePath());
        }
        h.putProperties("nbproject/private/private.properties", ep);
        Project p = ProjectManager.getDefault().findProject(dirFO);
        ProjectManager.getDefault().saveProject(p);
        return h;
    }

    private static FileObject createProjectDir(File dir) throws IOException {
        Stack<String> stack = new Stack<String>();
        while (!dir.exists()) {
            stack.push(dir.getName());
            dir = dir.getParentFile();
        }
        FileObject dirFO = FileUtil.toFileObject((File)dir);
        if (dirFO == null) {
            EjbJarProjectGenerator.refreshFileSystem(dir);
            dirFO = FileUtil.toFileObject((File)dir);
        }
        assert (dirFO != null);
        while (!stack.isEmpty()) {
            dirFO = dirFO.createFolder((String)stack.pop());
        }
        return dirFO;
    }

    private static void refreshFileSystem(File dir) throws FileStateInvalidException {
        File rootF = dir;
        while (rootF.getParentFile() != null) {
            rootF = rootF.getParentFile();
        }
        FileObject dirFO = FileUtil.toFileObject((File)rootF);
        assert (dirFO != null) : "At least disk roots must be mounted! " + rootF;
        dirFO.getFileSystem().refresh(false);
    }

    public static void setPlatform(final AntProjectHelper helper, final String platformName, final String sourceLevel) {
        ProjectManager.mutex().writeAccess(new Runnable(){

            public void run() {
                try {
                    EjbJarProject project = (EjbJarProject)ProjectManager.getDefault().findProject(helper.getProjectDirectory());
                    UpdateHelper updateHelper = project.getUpdateHelper();
                    EditableProperties ep = helper.getProperties("nbproject/project.properties");
                    String finalPlatformName = platformName;
                    if (finalPlatformName == null) {
                        finalPlatformName = JavaPlatformManager.getDefault().getDefaultPlatform().getDisplayName();
                    }
                    PlatformUiSupport.storePlatform(ep, updateHelper, finalPlatformName, sourceLevel != null ? new SpecificationVersion(sourceLevel) : null);
                    helper.putProperties("nbproject/project.properties", ep);
                    ProjectManager.getDefault().saveProject(ProjectManager.getDefault().findProject(helper.getProjectDirectory()));
                }
                catch (IOException e) {
                    ErrorManager.getDefault().notify((Throwable)e);
                }
            }
        });
    }
}

