/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbjarproject;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.j2ee.ejbjarproject.EjbJarProject;
import org.netbeans.modules.websvc.api.jaxws.project.GeneratedFilesHelper;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class UpdateHelper {
    private final Project project;
    private final AntProjectHelper helper;
    private final AuxiliaryConfiguration cfg;
    private final GeneratedFilesHelper genFileHelper;
    private final Notifier notifier;
    private boolean alreadyAskedInWriteAccess;
    private Boolean isCurrent;
    private Element cachedElement;
    private static final String BUILD_NUMBER = System.getProperty("netbeans.buildnumber");
    private static final String INCLUDED_LIBRARY_ELEMENT = "included-library";
    private static final String MINIMUM_ANT_VERSION_ELEMENT = "minimum-ant-version";
    private static final String ATTR_FILES = "files";
    private static final String ATTR_DIRS = "dirs";

    UpdateHelper(Project project, AntProjectHelper helper, AuxiliaryConfiguration cfg, GeneratedFilesHelper genFileHelper, Notifier notifier) {
        assert (project != null && helper != null && cfg != null && genFileHelper != null && notifier != null);
        this.project = project;
        this.helper = helper;
        this.cfg = cfg;
        this.genFileHelper = genFileHelper;
        this.notifier = notifier;
    }

    public EditableProperties getProperties(String path) {
        return this.helper.getProperties(path);
    }

    public void putProperties(final String path, final EditableProperties props) {
        ProjectManager.mutex().writeAccess(new Runnable(){

            public void run() {
                if (UpdateHelper.this.isCurrent() || !"nbproject/project.properties".equals(path)) {
                    UpdateHelper.this.helper.putProperties(path, props);
                } else if (UpdateHelper.this.canUpdate()) {
                    try {
                        UpdateHelper.this.saveUpdate(props);
                        UpdateHelper.this.helper.putProperties(path, props);
                    }
                    catch (IOException ioe) {
                        ErrorManager.getDefault().notify((Throwable)ioe);
                    }
                }
            }
        });
    }

    public Element getPrimaryConfigurationData(final boolean shared) {
        return (Element)ProjectManager.mutex().readAccess(new Mutex.Action(){

            public Object run() {
                if (!shared || UpdateHelper.this.isCurrent()) {
                    return UpdateHelper.this.helper.getPrimaryConfigurationData(shared);
                }
                return UpdateHelper.this.getUpdatedSharedConfigurationData();
            }
        });
    }

    public void putPrimaryConfigurationData(final Element element, final boolean shared) {
        ProjectManager.mutex().writeAccess(new Runnable(){

            public void run() {
                if (!shared || UpdateHelper.this.isCurrent()) {
                    UpdateHelper.this.helper.putPrimaryConfigurationData(element, shared);
                } else if (UpdateHelper.this.canUpdate()) {
                    try {
                        UpdateHelper.this.saveUpdate(null);
                        UpdateHelper.this.helper.putPrimaryConfigurationData(element, shared);
                    }
                    catch (IOException ioe) {
                        ErrorManager.getDefault().notify((Throwable)ioe);
                    }
                }
            }
        });
    }

    public AntProjectHelper getAntProjectHelper() {
        return this.helper;
    }

    public boolean requestSave() throws IOException {
        if (this.isCurrent()) {
            return true;
        }
        if (!this.canUpdate()) {
            return false;
        }
        this.saveUpdate(null);
        return true;
    }

    public synchronized boolean isCurrent() {
        if (this.isCurrent == null) {
            this.isCurrent = this.cfg.getConfigurationFragment("data", "http://www.netbeans.org/ns/j2ee-ejbjarproject/1", true) == null && this.cfg.getConfigurationFragment("data", "http://www.netbeans.org/ns/j2ee-ejbjarproject/2", true) == null ? Boolean.TRUE : Boolean.FALSE;
        }
        return this.isCurrent;
    }

    private boolean canUpdate() {
        if (this.alreadyAskedInWriteAccess) {
            return false;
        }
        boolean canUpdate = this.notifier.canUpdate();
        if (!canUpdate) {
            this.alreadyAskedInWriteAccess = true;
            ProjectManager.mutex().postReadRequest(new Runnable(){

                public void run() {
                    UpdateHelper.this.alreadyAskedInWriteAccess = false;
                }
            });
        }
        return canUpdate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveUpdate(EditableProperties props) throws IOException {
        this.helper.putPrimaryConfigurationData(this.getUpdatedSharedConfigurationData(), true);
        if (this.cfg.getConfigurationFragment("data", "http://www.netbeans.org/ns/j2ee-ejbjarproject/1", true) != null) {
            this.cfg.removeConfigurationFragment("data", "http://www.netbeans.org/ns/j2ee-ejbjarproject/1", true);
        } else {
            this.cfg.removeConfigurationFragment("data", "http://www.netbeans.org/ns/j2ee-ejbjarproject/2", true);
        }
        boolean putProps = false;
        if (props == null) {
            props = this.getProperties("nbproject/project.properties");
            putProps = true;
        }
        if (props != null) {
            props.put((Object)"test.src.dir", (Object)"test");
        }
        if (putProps) {
            this.helper.putProperties("nbproject/project.properties", props);
        }
        ProjectManager.getDefault().saveProject(this.project);
        this.genFileHelper.refreshBuildScript("nbproject/build-impl.xml", UpdateHelper.class.getResource("resources/build-impl.xsl"), ((EjbJarProject)this.project).findJaxWsFileObject(), true);
        UpdateHelper updateHelper = this;
        synchronized (updateHelper) {
            this.isCurrent = Boolean.TRUE;
        }
    }

    private synchronized Element getUpdatedSharedConfigurationData() {
        if (this.cachedElement == null) {
            String ns;
            Element oldRoot = this.cfg.getConfigurationFragment("data", "http://www.netbeans.org/ns/j2ee-ejbjarproject/1", true);
            int version = 1;
            if (oldRoot == null) {
                version = 2;
                oldRoot = this.cfg.getConfigurationFragment("data", "http://www.netbeans.org/ns/j2ee-ejbjarproject/2", true);
            }
            String string = ns = version == 1 ? "http://www.netbeans.org/ns/j2ee-ejbjarproject/1" : "http://www.netbeans.org/ns/j2ee-ejbjarproject/2";
            if (oldRoot != null) {
                Document doc = oldRoot.getOwnerDocument();
                Element newRoot = doc.createElementNS("http://www.netbeans.org/ns/j2ee-ejbjarproject/3", "data");
                UpdateHelper.copyDocument(doc, oldRoot, newRoot);
                if (version == 1) {
                    Element sourceRoots = doc.createElementNS("http://www.netbeans.org/ns/j2ee-ejbjarproject/3", "source-roots");
                    Element root = doc.createElementNS("http://www.netbeans.org/ns/j2ee-ejbjarproject/3", "root");
                    root.setAttribute("id", "src.dir");
                    sourceRoots.appendChild(root);
                    newRoot.appendChild(sourceRoots);
                    Element testRoots = doc.createElementNS("http://www.netbeans.org/ns/j2ee-ejbjarproject/3", "test-roots");
                    root = doc.createElementNS("http://www.netbeans.org/ns/j2ee-ejbjarproject/3", "root");
                    root.setAttribute("id", "test.src.dir");
                    testRoots.appendChild(root);
                    newRoot.appendChild(testRoots);
                }
                if (version == 1 || version == 2) {
                    NodeList libList = newRoot.getElementsByTagNameNS(ns, INCLUDED_LIBRARY_ELEMENT);
                    for (int i = 0; i < libList.getLength(); ++i) {
                        Element library;
                        String fileText;
                        if (libList.item(i).getNodeType() != 1 || !(fileText = UpdateHelper.findText(library = (Element)libList.item(i))).startsWith("libs.")) continue;
                        String libName = fileText.substring(6, fileText.indexOf(".classpath"));
                        List roots = LibraryManager.getDefault().getLibrary(libName).getContent("classpath");
                        ArrayList<FileObject> files = new ArrayList<FileObject>();
                        ArrayList<FileObject> dirs = new ArrayList<FileObject>();
                        for (URL rootUrl : roots) {
                            FileObject root = URLMapper.findFileObject((URL)rootUrl);
                            if ("jar".equals(rootUrl.getProtocol())) {
                                root = FileUtil.getArchiveFile((FileObject)root);
                            }
                            if (root == null) continue;
                            if (root.isData()) {
                                files.add(root);
                                continue;
                            }
                            dirs.add(root);
                        }
                        if (files.size() > 0) {
                            library.setAttribute(ATTR_FILES, "" + files.size());
                        }
                        if (dirs.size() <= 0) continue;
                        library.setAttribute(ATTR_DIRS, "" + dirs.size());
                    }
                }
                this.cachedElement = UpdateHelper.updateMinAntVersion(newRoot, doc);
            }
        }
        return this.cachedElement;
    }

    private static void copyDocument(Document doc, Element from, Element to) {
        NodeList nl = from.getChildNodes();
        int length = nl.getLength();
        for (int i = 0; i < length; ++i) {
            Node node = nl.item(i);
            Node newNode = null;
            switch (node.getNodeType()) {
                case 1: {
                    Element oldElement = (Element)node;
                    newNode = doc.createElementNS("http://www.netbeans.org/ns/j2ee-ejbjarproject/3", oldElement.getTagName());
                    NamedNodeMap m = oldElement.getAttributes();
                    Element newElement = (Element)newNode;
                    for (int index = 0; index < m.getLength(); ++index) {
                        Node attr = m.item(index);
                        newElement.setAttribute(attr.getNodeName(), attr.getNodeValue());
                    }
                    UpdateHelper.copyDocument(doc, oldElement, (Element)newNode);
                    break;
                }
                case 3: {
                    Text oldText = (Text)node;
                    newNode = doc.createTextNode(oldText.getData());
                    break;
                }
                case 8: {
                    Comment oldComment = (Comment)node;
                    newNode = doc.createComment(oldComment.getData());
                }
            }
            if (newNode == null) continue;
            to.appendChild(newNode);
        }
    }

    private static Element updateMinAntVersion(Element root, Document doc) {
        Element me;
        NodeList list = root.getElementsByTagNameNS("http://www.netbeans.org/ns/j2ee-ejbjarproject/3", MINIMUM_ANT_VERSION_ELEMENT);
        if (list.getLength() == 1 && (list = (me = (Element)list.item(0)).getChildNodes()).getLength() == 1) {
            me.replaceChild(doc.createTextNode("1.6"), list.item(0));
            return root;
        }
        assert (false) : "Invalid project file";
        return root;
    }

    public static Notifier createDefaultNotifier() {
        return new Notifier(){

            public boolean canUpdate() {
                return DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(UpdateHelper.class, (String)"TXT_ProjectUpdate", (Object)BUILD_NUMBER), NbBundle.getMessage(UpdateHelper.class, (String)"TXT_ProjectUpdateTitle"), 0)) == NotifyDescriptor.YES_OPTION;
            }
        };
    }

    private static String findText(Node parent) {
        NodeList l = parent.getChildNodes();
        for (int i = 0; i < l.getLength(); ++i) {
            if (l.item(i).getNodeType() != 3) continue;
            Text text = (Text)l.item(i);
            return text.getNodeValue();
        }
        return null;
    }

    public static interface Notifier {
        public boolean canUpdate();
    }
}

