/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.ui.nodes.elements;

import java.awt.Component;
import java.beans.PropertyEditor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import javax.jmi.reflect.JmiException;
import javax.swing.JComponent;
import org.netbeans.api.java.queries.SourceLevelQuery;
import org.netbeans.jmi.javamodel.AnnotationType;
import org.netbeans.jmi.javamodel.Attribute;
import org.netbeans.jmi.javamodel.CallableFeature;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.ClassMember;
import org.netbeans.jmi.javamodel.Constructor;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.EnumConstant;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.Initializer;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaEnum;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.PrimitiveTypeKindEnum;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.modules.java.JavaNode;
import org.netbeans.modules.java.ui.nodes.editors.ModifierEditor;
import org.netbeans.modules.java.ui.nodes.elements.AnnotationTypeCustomizer;
import org.netbeans.modules.java.ui.nodes.elements.AnnotationTypeMethodCustomizer;
import org.netbeans.modules.java.ui.nodes.elements.ClassCustomizer;
import org.netbeans.modules.java.ui.nodes.elements.ElementNode;
import org.netbeans.modules.java.ui.nodes.elements.EnumConstantCustomizer;
import org.netbeans.modules.java.ui.nodes.elements.EnumCustomizer;
import org.netbeans.modules.java.ui.nodes.elements.FieldCustomizer;
import org.netbeans.modules.java.ui.nodes.elements.MethodCustomizer;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.explorer.propertysheet.PropertyPanel;
import org.openide.filesystems.FileObject;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.datatransfer.NewType;

public final class SourceEditSupport {
    static final byte NT_INITIALIZER = 0;
    static final byte NT_FIELD = 1;
    static final byte NT_CONSTRUCTOR = 2;
    static final byte NT_METHOD = 3;
    static final byte NT_INNERCLASS = 4;
    static final byte NT_INNERINTERFACE = 5;
    static final byte NT_INNERENUM = 6;
    static final byte NT_ENUMCONSTANT = 7;
    static final byte NT_CLASS = 8;
    static final byte NT_INTERFACE = 9;
    static final byte NT_ENUM = 10;
    static final byte NT_ANNOTATION_TYPE = 11;
    static final byte NT_INNERANNOTATION_TYPE = 12;
    static final byte NT_ANNOTATION_TYPE_METHOD = 13;
    static final String[] MENU_NAMES = new String[]{SourceEditSupport.getString("MENU_CREATE_BLOCK"), SourceEditSupport.getString("MENU_CREATE_VARIABLE"), SourceEditSupport.getString("MENU_CREATE_CONSTRUCTOR"), SourceEditSupport.getString("MENU_CREATE_METHOD"), SourceEditSupport.getString("MENU_CREATE_INNERCLASS"), SourceEditSupport.getString("MENU_CREATE_INNERINTERFACE"), SourceEditSupport.getString("MENU_CREATE_INNERENUM"), SourceEditSupport.getString("MENU_CREATE_CONSTANT"), SourceEditSupport.getString("MENU_CREATE_CLASS"), SourceEditSupport.getString("MENU_CREATE_INTERFACE"), SourceEditSupport.getString("MENU_CREATE_ENUM"), SourceEditSupport.getString("MENU_CREATE_ANN_TYPE"), SourceEditSupport.getString("MENU_CREATE_INNERANN_TYPE"), SourceEditSupport.getString("MENU_CREATE_ANN_TYPE_METHOD")};
    private static final int ACCESS_MASK = 7;
    private static final int OTHERS_MASK = 3576;

    private static String getString(String key) {
        return NbBundle.getMessage((Class)SourceEditSupport.class, (String)key);
    }

    public static NewType[] createClassNewTypes(JavaClass element, boolean supportJDK15) {
        NewType[] ntypes = supportJDK15 ? new NewType[]{new ElementNewType(element, 0), new ElementNewType(element, 1), new ElementNewType(element, 2), new ElementNewType(element, 3), new ElementNewType(element, 4), new ElementNewType(element, 6), new ElementNewType(element, 5), new ElementNewType(element, 12)} : new NewType[]{new ElementNewType(element, 0), new ElementNewType(element, 1), new ElementNewType(element, 2), new ElementNewType(element, 3), new ElementNewType(element, 4), new ElementNewType(element, 5)};
        return ntypes;
    }

    public static NewType[] createInterfaceNewTypes(JavaClass element, boolean supportJDK15) {
        NewType[] ntypes = supportJDK15 ? new NewType[]{new ElementNewType(element, 1), new ElementNewType(element, 3), new ElementNewType(element, 4), new ElementNewType(element, 6), new ElementNewType(element, 5), new ElementNewType(element, 12)} : new NewType[]{new ElementNewType(element, 1), new ElementNewType(element, 3), new ElementNewType(element, 4), new ElementNewType(element, 5)};
        return ntypes;
    }

    public static NewType[] createEnumNewTypes(JavaEnum element) {
        return new NewType[]{new ElementNewType((JavaClass)element, 7), new ElementNewType((JavaClass)element, 0), new ElementNewType((JavaClass)element, 1), new ElementNewType((JavaClass)element, 2), new ElementNewType((JavaClass)element, 3), new ElementNewType((JavaClass)element, 4), new ElementNewType((JavaClass)element, 6), new ElementNewType((JavaClass)element, 5), new ElementNewType((JavaClass)element, 12)};
    }

    public static NewType[] createInterfaceNewTypes(AnnotationType element) {
        return new NewType[]{new ElementNewType((JavaClass)element, 1), new ElementNewType((JavaClass)element, 13), new ElementNewType((JavaClass)element, 4), new ElementNewType((JavaClass)element, 6), new ElementNewType((JavaClass)element, 5), new ElementNewType((JavaClass)element, 12)};
    }

    public static NewType[] createJavaNodeNewTypes(JavaNode node) {
        NewType[] ntypes = SourceEditSupport.isJDK15Supported(node.getDataObject().getPrimaryFile()) ? new NewType[]{new ElementNewType(node, 8), new ElementNewType(node, 10), new ElementNewType(node, 9), new ElementNewType(node, 11)} : new NewType[]{new ElementNewType(node, 8), new ElementNewType(node, 9)};
        return ntypes;
    }

    public static boolean isJDK15Supported(FileObject source) {
        String version = SourceLevelQuery.getSourceLevel((FileObject)source);
        return version != null && version.startsWith("1.5");
    }

    static Attribute findAttribute(AnnotationType at, String name) throws JmiException {
        if (at == null) {
            throw new NullPointerException("at");
        }
        if (name == null) {
            throw new NullPointerException("name");
        }
        Iterator it = at.getFeatures().iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (!(o instanceof Attribute) || !name.equals(((Attribute)o).getName())) continue;
            return (Attribute)o;
        }
        return null;
    }

    static EnumConstant findConstant(JavaEnum en, String name) throws JmiException {
        if (en == null) {
            throw new NullPointerException("en");
        }
        if (name == null) {
            throw new NullPointerException("name");
        }
        Iterator it = en.getConstants().iterator();
        while (it.hasNext()) {
            EnumConstant ec = (EnumConstant)it.next();
            if (!name.equals(ec.getName())) continue;
            return ec;
        }
        return null;
    }

    static JavaClass findTopLevelClass(Resource res, String name) throws JmiException {
        if (res == null) {
            throw new NullPointerException("res");
        }
        if (name == null) {
            throw new NullPointerException("name");
        }
        Iterator it = res.getClassifiers().iterator();
        while (it.hasNext()) {
            JavaClass jc = (JavaClass)it.next();
            if (!name.equals(jc.getSimpleName())) continue;
            return jc;
        }
        return null;
    }

    static boolean openCustomizer(Component customizer, String titleKey) {
        NotifyDescriptor desriptor = new NotifyDescriptor((Object)customizer, ElementNode.getString(titleKey), 2, -1, null, null);
        Object ret = DialogDisplayer.getDefault().notify(desriptor);
        return ret == NotifyDescriptor.OK_OPTION;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean isWriteable(Element element) {
        JavaModel.getJavaRepository().beginTrans(false);
        try {
            boolean w = element.isValid();
            if (w) {
                FileObject fo = JavaModel.getFileObject((Resource)element.getResource());
                w = fo != null && fo.canWrite();
            }
            boolean bl = w;
            return bl;
        }
        finally {
            JavaModel.getJavaRepository().endTrans();
        }
    }

    public static PropertyPanel createAccessModifiersPanel(ClassMember element, int mask) {
        PropertyPanel pp = SourceEditSupport.createModifiersPanel(element, mask &= 7);
        pp.getProperty().setValue("customEditorType", (Object)ModifierEditor.ACCESS_MODIFIERS_CUSTOM_EDITOR);
        return pp;
    }

    public static PropertyPanel createOtherModifiersPanel(ClassMember element, int mask) {
        PropertyPanel pp = SourceEditSupport.createModifiersPanel(element, mask &= 0xDF8);
        pp.getProperty().setValue("customEditorType", (Object)ModifierEditor.OTHERS_MODIFIERS_CUSTOM_EDITOR);
        return pp;
    }

    public static PropertyPanel createModifiersPanel(ClassMember element) {
        return SourceEditSupport.createModifiersPanel(element, SourceEditSupport.getModifiersMask(element));
    }

    private static PropertyPanel createModifiersPanel(ClassMember element, int mask) {
        PropertyPanel modifPanel = new PropertyPanel(ElementNode.createModifiersProperty(element, true, mask), 2);
        PropertyEditor propEdit = modifPanel.getProperty().getPropertyEditor();
        if (propEdit instanceof ModifierEditor) {
            ((ModifierEditor)((Object)propEdit)).setMask(mask);
        }
        return modifPanel;
    }

    public static int getModifiersMask(ClassMember member) throws JmiException {
        int mask = 0;
        if (member instanceof Field) {
            mask = SourceEditSupport.getModifiersMask((Field)member);
        } else if (member instanceof Method) {
            mask = SourceEditSupport.getModifiersMask((Method)member);
        } else if (member instanceof Constructor) {
            mask = SourceEditSupport.getModifiersMask((Constructor)member);
        } else if (member instanceof Attribute) {
            mask = SourceEditSupport.getAttributeModifiersMask();
        } else if (member instanceof JavaClass) {
            mask = SourceEditSupport.getModifiersMask((JavaClass)member);
        } else {
            ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("SourceNodes.getModifiersMask: unknown member: " + member));
        }
        return mask;
    }

    private static int getModifiersMask(Field member) throws JmiException {
        if (SourceEditSupport.isDeclaredInInterface((ClassMember)member)) {
            return 25;
        }
        return 223;
    }

    private static int getModifiersMask(Method member) throws JmiException {
        if (SourceEditSupport.isDeclaredInInterface((ClassMember)member)) {
            return 1025;
        }
        return 1343;
    }

    private static int getModifiersMask(Constructor member) {
        return 7;
    }

    private static int getAttributeModifiersMask() {
        return 1025;
    }

    private static int getModifiersMask(JavaClass member) throws JmiException {
        int ret = 1025;
        if (!member.isInterface()) {
            ret |= 0x10;
        }
        if (SourceEditSupport.isInner(member)) {
            ret |= 0xE;
        }
        return ret;
    }

    private static boolean isInner(JavaClass jclass) throws JmiException {
        return jclass.getDeclaringClass() != null;
    }

    private static boolean isDeclaredInInterface(ClassMember member) throws JmiException {
        ClassDefinition cdef = member.getDeclaringClass();
        return cdef instanceof JavaClass && ((JavaClass)cdef).isInterface();
    }

    public static List getAllClasses(Resource res) throws JmiException {
        LinkedList l = new LinkedList();
        Iterator it = res.getClassifiers().iterator();
        while (it.hasNext()) {
            SourceEditSupport.addAllClasses((JavaClass)it.next(), l);
        }
        return l;
    }

    private static void addAllClasses(JavaClass jc, List container) throws JmiException {
        container.add(jc);
        Iterator it = jc.getFeatures().iterator();
        while (it.hasNext()) {
            Object feature = it.next();
            if (!(feature instanceof JavaClass)) continue;
            SourceEditSupport.addAllClasses((JavaClass)feature, container);
        }
    }

    static final class ElementNewType
    extends NewType {
        private final JavaClass element;
        private final JavaNode node;
        byte kind;
        private static final String NEW_FIELD_NAME = "newField";
        private static final String NEW_METHOD_NAME = "newMethod";
        private static final String NEW_ANN_TYPE_METHOD_NAME = "newMethod";
        private static final String NEW_INNERCLASS_NAME = "InnerClass";
        private static final String NEW_INNERINTERFACE_NAME = "InnerInterface";
        private static final String NEW_INNERENUM_NAME = "InnerEnum";
        private static final String NEW_INNERANN_TYPE_NAME = "InnerNewAnnotationType";
        private static final String NEW_CLASS_NAME = "NewClass";
        private static final String NEW_INTERFACE_NAME = "NewInterface";
        private static final String NEW_ENUM_NAME = "NewEnum";
        private static final String NEW_ANN_TYPE_NAME = "NewAnnotationType";

        public ElementNewType(JavaClass element, byte kind) {
            this.element = element;
            this.node = null;
            this.kind = kind;
        }

        public ElementNewType(JavaNode node, byte kind) {
            this.element = null;
            this.node = node;
            this.kind = kind;
        }

        public String getName() {
            return MENU_NAMES[this.kind];
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx((class$org$netbeans$modules$java$ui$nodes$elements$SourceEditSupport == null ? (class$org$netbeans$modules$java$ui$nodes$elements$SourceEditSupport = SourceEditSupport.class$("org.netbeans.modules.java.ui.nodes.elements.SourceEditSupport")) : class$org$netbeans$modules$java$ui$nodes$elements$SourceEditSupport).getName() + ".newElement" + this.kind);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void create() throws IOException {
            boolean fail = true;
            try {
                JavaModel.getJavaRepository().beginTrans(true);
                try {
                    this.createImpl();
                    fail = false;
                }
                finally {
                    JavaModel.getJavaRepository().endTrans(fail);
                }
            }
            catch (JmiException ex) {
                IOException ioe = new IOException();
                ioe.initCause(ex);
                throw ioe;
            }
        }

        private void createImpl() throws JmiException {
            JavaModelPackage jmodel = this.getModel();
            switch (this.kind) {
                case 0: {
                    this.createInitializer(jmodel);
                    break;
                }
                case 1: {
                    this.createField(jmodel);
                    break;
                }
                case 2: {
                    this.createConstructor(jmodel);
                    break;
                }
                case 3: {
                    this.createMethod(jmodel);
                    break;
                }
                case 4: {
                    this.createInnerClass(jmodel);
                    break;
                }
                case 5: {
                    this.createInnerInterface(jmodel);
                    break;
                }
                case 6: {
                    this.createInnerEnum(jmodel);
                    break;
                }
                case 7: {
                    this.createConstant(jmodel);
                    break;
                }
                case 8: {
                    this.createClass(jmodel);
                    break;
                }
                case 9: {
                    this.createInterface(jmodel);
                    break;
                }
                case 10: {
                    this.createEnum(jmodel);
                    break;
                }
                case 11: {
                    this.createAnnotationType(jmodel);
                    break;
                }
                case 12: {
                    this.createInnerAnnotationType(jmodel);
                    break;
                }
                case 13: {
                    this.createAnnotationTypeMethod(jmodel);
                    break;
                }
            }
        }

        private void createInnerInterface(JavaModelPackage jmodel) throws JmiException {
            String name = NEW_INNERINTERFACE_NAME;
            int index = 1;
            while (this.element.getInnerClass(name, true) != null) {
                name = "InnerInterface_" + index;
                ++index;
            }
            JavaClass e = jmodel.getJavaClass().createJavaClass(name, null, 1, null, null, null, null, null, null);
            e.setInterface(true);
            ClassCustomizer cust = new ClassCustomizer(this.element, e);
            if (SourceEditSupport.openCustomizer(cust, "TIT_NewInnerInterface") && cust.isOK()) {
                this.addFeature((Feature)e);
            }
        }

        private void createInnerClass(JavaModelPackage jmodel) throws JmiException {
            String name = NEW_INNERCLASS_NAME;
            int index = 1;
            while (this.element.getInnerClass(name, true) != null) {
                name = "InnerClass_" + index;
                ++index;
            }
            JavaClass e = jmodel.getJavaClass().createJavaClass(name, null, 17, null, null, null, null, null, null);
            e.setInterface(false);
            ClassCustomizer cust = new ClassCustomizer(this.element, e);
            if (SourceEditSupport.openCustomizer(cust, "TIT_NewInnerClass") && cust.isOK()) {
                this.addFeature((Feature)e);
            }
        }

        private void createInterface(JavaModelPackage jmodel) throws JmiException {
            String name = NEW_INTERFACE_NAME;
            Resource resource = this.getResource();
            int index = 1;
            while (SourceEditSupport.findTopLevelClass(resource, name) != null) {
                name = "NewInterface_" + index;
                ++index;
            }
            JavaClass e = jmodel.getJavaClass().createJavaClass(name, null, 0, null, null, null, null, null, null);
            e.setInterface(true);
            ClassCustomizer cust = new ClassCustomizer(resource, e);
            HelpCtx.setHelpIDString((JComponent)cust, (String)((class$org$netbeans$modules$java$ui$nodes$elements$SourceEditSupport == null ? (class$org$netbeans$modules$java$ui$nodes$elements$SourceEditSupport = SourceEditSupport.class$("org.netbeans.modules.java.ui.nodes.elements.SourceEditSupport")) : class$org$netbeans$modules$java$ui$nodes$elements$SourceEditSupport).getName() + "$AddNewInterface"));
            if (SourceEditSupport.openCustomizer(cust, "TIT_NewInterface") && cust.isOK()) {
                resource.getClassifiers().add(e);
            }
        }

        private void createClass(JavaModelPackage jmodel) throws JmiException {
            String name = NEW_CLASS_NAME;
            Resource resource = this.getResource();
            int index = 1;
            while (SourceEditSupport.findTopLevelClass(resource, name) != null) {
                name = "NewClass_" + index;
                ++index;
            }
            JavaClass e = jmodel.getJavaClass().createJavaClass(name, null, 16, null, null, null, null, null, null);
            e.setInterface(false);
            ClassCustomizer cust = new ClassCustomizer(resource, e);
            HelpCtx.setHelpIDString((JComponent)cust, (String)((class$org$netbeans$modules$java$ui$nodes$elements$SourceEditSupport == null ? (class$org$netbeans$modules$java$ui$nodes$elements$SourceEditSupport = SourceEditSupport.class$("org.netbeans.modules.java.ui.nodes.elements.SourceEditSupport")) : class$org$netbeans$modules$java$ui$nodes$elements$SourceEditSupport).getName() + "$AddNewClass"));
            if (SourceEditSupport.openCustomizer(cust, "TIT_NewClass") && cust.isOK()) {
                resource.getClassifiers().add(e);
            }
        }

        private void createMethod(JavaModelPackage jmodel) throws JmiException {
            Method e = jmodel.getMethod().createMethod();
            Type voidType = jmodel.getType().resolve(PrimitiveTypeKindEnum.VOID.toString());
            e.setType(voidType);
            String name = "newMethod";
            int index = 1;
            while (this.element.getMethod(name, Collections.EMPTY_LIST, true) != null) {
                name = "newMethod_" + index;
                ++index;
            }
            e.setName(name);
            e.setModifiers(1);
            MethodCustomizer cust = new MethodCustomizer(this.element, (CallableFeature)e);
            boolean isOK = false;
            while ((isOK = SourceEditSupport.openCustomizer(cust, "TIT_NewMethod")) && !cust.isOK()) {
            }
            if (isOK) {
                this.addFeature((Feature)e);
            }
        }

        private void createConstructor(JavaModelPackage jmodel) throws JmiException {
            MethodCustomizer cust;
            Constructor e = jmodel.getConstructor().createConstructor();
            if (!(this.element instanceof JavaEnum)) {
                e.setModifiers(1);
            }
            if (SourceEditSupport.openCustomizer(cust = new MethodCustomizer(this.element, (CallableFeature)e), "TIT_NewConstructor") && cust.isOK()) {
                this.addFeature((Feature)e);
            }
        }

        private void createField(JavaModelPackage jmodel) throws JmiException {
            Field e = jmodel.getField().createField();
            Type type = jmodel.getType().resolve("int");
            e.setType(type);
            String name = NEW_FIELD_NAME;
            int index = 1;
            while (this.element.getField(name, true) != null) {
                name = "newField_" + index;
                ++index;
            }
            e.setName(name);
            boolean outerIsClass = !this.element.isInterface();
            e.setModifiers(outerIsClass ? 2 : 9);
            FieldCustomizer cust = new FieldCustomizer(this.element, e);
            if (SourceEditSupport.openCustomizer(cust, "TIT_NewField") && cust.isOK()) {
                this.addFeature((Feature)e);
            }
        }

        private void createInitializer(JavaModelPackage jmodel) throws JmiException {
            Initializer e = jmodel.getInitializer().createInitializer();
            e.setModifiers(8);
            this.addFeature((Feature)e);
        }

        private void createInnerEnum(JavaModelPackage jmodel) throws JmiException {
            String name = NEW_INNERENUM_NAME;
            int index = 1;
            while (this.element.getInnerClass(name, true) != null) {
                name = "InnerEnum_" + index;
                ++index;
            }
            JavaEnum e = jmodel.getJavaEnum().createJavaEnum(name, null, 1, null, null, null, null, null, null, null);
            EnumCustomizer cust = new EnumCustomizer(this.element, e);
            if (SourceEditSupport.openCustomizer(cust, "TIT_NewInnerEnum") && cust.isOK()) {
                this.addFeature((Feature)e);
            }
        }

        private void createEnum(JavaModelPackage jmodel) throws JmiException {
            String name = NEW_ENUM_NAME;
            Resource resource = this.getResource();
            int index = 1;
            while (SourceEditSupport.findTopLevelClass(resource, name) != null) {
                name = "NewEnum_" + index;
                ++index;
            }
            JavaEnum e = jmodel.getJavaEnum().createJavaEnum(name, null, 0, null, null, null, null, null, null, null);
            EnumCustomizer cust = new EnumCustomizer(resource, e);
            if (SourceEditSupport.openCustomizer(cust, "TIT_NewEnum") && cust.isOK()) {
                resource.getClassifiers().add(e);
            }
        }

        private void createConstant(JavaModelPackage jmodel) throws JmiException {
            String ENUM_NAME;
            JavaEnum en = (JavaEnum)this.element;
            EnumConstant e = jmodel.getEnumConstant().createEnumConstant();
            String name = ENUM_NAME = en.getSimpleName();
            int index = 1;
            while (SourceEditSupport.findConstant(en, name) != null) {
                name = ENUM_NAME + '_' + index;
                ++index;
            }
            e.setName(name);
            EnumConstantCustomizer cust = new EnumConstantCustomizer(en, e);
            if (SourceEditSupport.openCustomizer(cust, "TIT_NewConstant") && cust.isOK()) {
                en.getConstants().add(e);
            }
        }

        private void createInnerAnnotationType(JavaModelPackage jmodel) throws JmiException {
            String name = NEW_INNERANN_TYPE_NAME;
            int index = 1;
            while (this.element.getInnerClass(name, true) != null) {
                name = "InnerNewAnnotationType_" + index;
                ++index;
            }
            AnnotationType at = jmodel.getAnnotationType().createAnnotationType(name, null, 1, null, null, null, null, null, null);
            AnnotationTypeCustomizer cust = new AnnotationTypeCustomizer(this.element, at);
            if (SourceEditSupport.openCustomizer(cust, "TIT_NewInnerAnnType") && cust.isOK()) {
                this.addFeature((Feature)at);
            }
        }

        private void createAnnotationType(JavaModelPackage jmodel) throws JmiException {
            String name = NEW_ANN_TYPE_NAME;
            Resource resource = this.getResource();
            int index = 1;
            while (SourceEditSupport.findTopLevelClass(resource, name) != null) {
                name = "NewAnnotationType_" + index;
                ++index;
            }
            AnnotationType at = jmodel.getAnnotationType().createAnnotationType(name, null, 0, null, null, null, null, null, null);
            AnnotationTypeCustomizer cust = new AnnotationTypeCustomizer(resource, at);
            if (SourceEditSupport.openCustomizer(cust, "TIT_NewAnnType") && cust.isOK()) {
                resource.getClassifiers().add(at);
            }
        }

        private void createAnnotationTypeMethod(JavaModelPackage jmodel) throws JmiException {
            AnnotationType at = (AnnotationType)this.element;
            String name = "newMethod";
            int index = 1;
            while (SourceEditSupport.findAttribute(at, name) != null) {
                name = "newMethod_" + index;
                ++index;
            }
            Type type = jmodel.getType().resolve("java.lang.String");
            Attribute attr = jmodel.getAttribute().createAttribute(name, null, 0, null, null, null, null, null);
            attr.setType(type);
            AnnotationTypeMethodCustomizer cust = new AnnotationTypeMethodCustomizer(at, attr);
            if (SourceEditSupport.openCustomizer(cust, "TIT_NewAnnTypeMethod") && cust.isOK()) {
                this.addFeature((Feature)attr);
            }
        }

        private void addFeature(Feature feature) {
            ArrayList features = new ArrayList(this.element.getFeatures());
            ListIterator<Feature> iter = features.listIterator(features.size());
            ClassMember f = iter.hasPrevious() ? (ClassMember)iter.previous() : null;
            JavaMetamodel manager = JavaMetamodel.getManager();
            if (f == null || !manager.isElementGuarded((Element)f)) {
                this.element.getFeatures().add(feature);
                return;
            }
            while ((f = (ClassMember)iter.previous()) != null && manager.isElementGuarded((Element)f)) {
            }
            iter = this.element.getFeatures().listIterator();
            if (f != null) {
                while (iter.next() != f) {
                }
            }
            iter.add(feature);
        }

        private Resource getResource() {
            return JavaModel.getResource((FileObject)this.node.getDataObject().getPrimaryFile());
        }

        private JavaModelPackage getModel() {
            if (this.element != null) {
                return JavaMetamodel.getManager().getJavaExtent((Element)this.element);
            }
            return JavaMetamodel.getManager().getJavaExtent((Element)this.getResource());
        }
    }
}

