/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.ui.nodes.elements;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.jmi.reflect.JmiException;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import org.netbeans.jmi.javamodel.ClassMember;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaEnum;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.java.ui.nodes.elements.ClassNode;
import org.netbeans.modules.java.ui.nodes.elements.SourceEditSupport;
import org.openide.ErrorManager;
import org.openide.awt.Mnemonics;
import org.openide.explorer.propertysheet.PropertyPanel;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

final class EnumCustomizer
extends JPanel {
    private final JavaEnum element;
    private final JavaClass jclass;
    private final Resource resource;
    private boolean isOK = true;
    private JPanel accessPanel;
    private JPanel interfacesPanel;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel modifierPanel;
    private JTextField nameTextField;

    public EnumCustomizer(JavaClass jclass, JavaEnum element) {
        this(null, jclass, element);
    }

    public EnumCustomizer(Resource resource, JavaEnum element) {
        this(resource, null, element);
    }

    private EnumCustomizer(Resource resource, JavaClass jclass, JavaEnum element) {
        this.resource = resource;
        this.jclass = jclass;
        this.element = element;
        this.initComponents();
        this.interfacesPanel.setBorder(new TitledBorder(NbBundle.getMessage((Class)EnumCustomizer.class, (String)"CTL_Interfaces")));
        int mask = 1024;
        if (resource == null) {
            mask |= 0xF;
        }
        if (!element.isInterface()) {
            mask |= 0x10;
        }
        this.accessPanel.add((Component)SourceEditSupport.createAccessModifiersPanel((ClassMember)element, mask), "Center");
        this.modifierPanel.add((Component)SourceEditSupport.createOtherModifiersPanel((ClassMember)element, mask), "Center");
        this.nameTextField.setText(element.getSimpleName());
        this.interfacesPanel.add((Component)new PropertyPanel(ClassNode.createInterfacesProperty((JavaClass)element, true), 2), "Center");
        HelpCtx.setHelpIDString((JComponent)this, (String)"java.enum.customizer");
        this.jLabel1.setDisplayedMnemonic(NbBundle.getMessage((Class)EnumCustomizer.class, (String)"CTL_Name_Mnemonic").charAt(0));
        this.initAccessibility();
    }

    public void addNotify() {
        super.addNotify();
        int l = this.nameTextField.getText().length();
        this.nameTextField.setCaretPosition(0);
        this.nameTextField.moveCaretPosition(l);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                EnumCustomizer.this.nameTextField.requestFocus();
            }
        });
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.nameTextField = new JTextField();
        this.jLabel2 = new JLabel();
        this.accessPanel = new JPanel();
        this.jLabel3 = new JLabel();
        this.modifierPanel = new JPanel();
        this.interfacesPanel = new JPanel();
        this.setLayout(new GridBagLayout());
        this.setBorder(new EmptyBorder(new Insets(6, 6, 6, 6)));
        this.jLabel1.setLabelFor(this.nameTextField);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage((Class)EnumCustomizer.class, (String)"CTL_Name"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.nameTextField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                EnumCustomizer.this.nameTextFieldFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 8, 0, 0);
        this.add((Component)this.nameTextField, gridBagConstraints);
        this.jLabel2.setLabelFor(this.accessPanel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage((Class)EnumCustomizer.class, (String)"CTL_AccessRights"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.add((Component)this.jLabel2, gridBagConstraints);
        this.accessPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 8, 0, 0);
        this.add((Component)this.accessPanel, gridBagConstraints);
        this.jLabel3.setLabelFor(this.modifierPanel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage((Class)EnumCustomizer.class, (String)"CTL_Modifiers"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.add((Component)this.jLabel3, gridBagConstraints);
        this.modifierPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 8, 0, 0);
        this.add((Component)this.modifierPanel, gridBagConstraints);
        this.interfacesPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.interfacesPanel, gridBagConstraints);
    }

    private void nameTextFieldFocusLost(FocusEvent evt) {
        if (evt != null && (evt.isTemporary() || !this.isAncestorOf(evt.getOppositeComponent()))) {
            return;
        }
        String newName = this.nameTextField.getText().trim();
        String oldName = this.element.getSimpleName();
        boolean ok = false;
        if (!Utilities.isJavaIdentifier((String)newName)) {
            IllegalArgumentException x = new IllegalArgumentException("Invalid name: " + newName);
            ErrorManager.getDefault().annotate((Throwable)x, 256, null, NbBundle.getMessage((Class)EnumCustomizer.class, (String)"MSG_Not_Valid_Identifier"), null, null);
            ErrorManager.getDefault().notify((Throwable)x);
        } else {
            if (oldName.equals(newName)) {
                return;
            }
            if (this.resource == null && this.jclass.getInnerClass(newName, true) != null) {
                IllegalArgumentException x = new IllegalArgumentException("Invalid name: " + newName);
                ErrorManager.getDefault().annotate((Throwable)x, 256, null, NbBundle.getMessage((Class)EnumCustomizer.class, (String)"MSG_Not_Valid_Identifier"), null, null);
                ErrorManager.getDefault().notify((Throwable)x);
            } else if (this.jclass == null && SourceEditSupport.findTopLevelClass(this.resource, newName) != null) {
                IllegalArgumentException x = new IllegalArgumentException("Invalid name: " + newName);
                ErrorManager.getDefault().annotate((Throwable)x, 256, null, NbBundle.getMessage((Class)EnumCustomizer.class, (String)"MSG_Not_Valid_Identifier"), null, null);
                ErrorManager.getDefault().notify((Throwable)x);
            } else {
                try {
                    this.element.setSimpleName(newName);
                    ok = true;
                }
                catch (JmiException e) {
                    ErrorManager.getDefault().notify((Throwable)e);
                }
            }
        }
        this.isOK = ok;
        if (!ok) {
            this.nameTextField.setText(oldName);
        }
    }

    private void initAccessibility() {
        this.nameTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)EnumCustomizer.class, (String)"ACS_EnumNameTextField"));
        this.nameTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)EnumCustomizer.class, (String)"ACS_EnumNameTextField"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)EnumCustomizer.class, (String)"ACSD_EnumCustomizerDialog"));
    }

    public boolean isOK() {
        this.nameTextFieldFocusLost(null);
        return this.isOK;
    }
}

