/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.bridge;

import java.beans.PropertyChangeEvent;
import org.netbeans.api.mdr.events.AttributeEvent;
import org.netbeans.api.mdr.events.MDRChangeEvent;
import org.netbeans.api.mdr.events.MDRChangeListener;
import org.netbeans.jmi.javamodel.CallableFeature;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.PrimitiveType;
import org.netbeans.jmi.javamodel.TypeReference;
import org.netbeans.modules.java.bridge.CallableImpl;
import org.netbeans.modules.java.bridge.DefaultLangModel;
import org.netbeans.modules.java.bridge.ElementImpl;
import org.openide.src.ConstructorElement;
import org.openide.src.Element;
import org.openide.src.MethodElement;
import org.openide.src.SourceException;
import org.openide.src.Type;

class MethodElementImpl
extends CallableImpl
implements MethodElement.Impl {
    private ElementImpl.ElementListener methodListener;
    private static final long serialVersionUID = 8831749368310053231L;

    MethodElementImpl(DefaultLangModel model, Method method) {
        super(model, (CallableFeature)method);
    }

    public void connectListener() {
        this.methodListener = new MethodListener(this);
        this.methodListener.connect();
    }

    protected void createFromModel(Element el) throws SourceException {
        super.createFromModel(el);
        MethodElement m = (MethodElement)el;
        this.setReturn(m.getReturn());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Type getReturn() {
        this.repository.beginTrans(false);
        try {
            if (this.javaElement.isValid()) {
                this.setClassPath();
                this.javaElement.refImmediateComposite();
                org.netbeans.jmi.javamodel.Type t = ((Method)this.javaElement).getType();
                if (t instanceof PrimitiveType) {
                    Type type = this.descrToType(t);
                    return type;
                }
                Type type = this.typeReferenceToType(((Method)this.javaElement).getTypeName());
                return type;
            }
            Type type = Type.VOID;
            return type;
        }
        finally {
            this.repository.endTrans(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReturn(Type newType) throws SourceException {
        this.checkWritable(true);
        this.checkDocument();
        boolean failed = true;
        this.repository.beginTrans(true);
        try {
            if (this.javaElement.isValid()) {
                this.setClassPath();
                Type oldType = this.getReturn();
                newType = this.resolveType(newType);
                if (MethodElementImpl.compareSourceTypes(oldType, newType)) {
                    failed = false;
                    return;
                }
                PropertyChangeEvent evt = new PropertyChangeEvent(this.getElement(), "return", oldType, newType);
                this.checkReturnTypeConstraints(newType);
                this.checkVetoablePropertyChange(evt);
                if (newType.isPrimitive()) {
                    ((Method)this.javaElement).setType(this.typeToDescr(newType));
                } else {
                    ((Method)this.javaElement).setTypeName(this.typeToTypeReference(newType));
                }
                failed = false;
            } else {
                failed = false;
                this.throwIsInvalid();
            }
        }
        finally {
            this.repository.endTrans(failed);
        }
    }

    public void fireReturnChange(Type oldType, Type newType) {
        if (MethodElementImpl.compareSourceTypes(oldType = this.resolveType(oldType), newType = this.resolveType(newType))) {
            return;
        }
        PropertyChangeEvent evt = new PropertyChangeEvent(this.getElement(), "return", oldType, newType);
        this.fireOwnPropertyChange(evt);
        MethodElement elem = (MethodElement)this.cloneSelf();
        try {
            MethodElement.Impl impl = (MethodElement.Impl)elem.getCookie(Element.Impl.class);
            impl.setReturn(oldType);
        }
        catch (SourceException e) {
            e.printStackTrace();
        }
        this.notifyConnectionChange((Element)elem);
    }

    protected final Element createWrapperElement() {
        return new MethodElement((MethodElement.Impl)this, this.getDeclaringClass());
    }

    protected void checkReturnTypeConstraints(Type t) throws SourceException {
    }

    public Object readResolve() {
        return null;
    }

    public String toString() {
        return "MethodElementImpl[" + this.getName().getSourceName() + ", " + this.getParameters().length + " args]";
    }

    protected Element cloneSelf() {
        MethodElement clone = new MethodElement();
        this.copyCallableProperties((ConstructorElement)clone);
        try {
            clone.setReturn(this.getReturn());
        }
        catch (SourceException sourceException) {
            // empty catch block
        }
        return clone;
    }

    static class MethodListener
    extends CallableImpl.CallableListener
    implements MDRChangeListener {
        private Type type;

        MethodListener(MethodElementImpl impl) {
            super(impl);
        }

        public void connect() {
            if (REGISTER_LISTENER) {
                super.connect();
                TypeReference typeRef = ((Method)this.javaElement).getTypeName();
                this.type = typeRef != null ? ((MethodElementImpl)this.getImpl()).typeReferenceToType(typeRef) : null;
            }
        }

        public void doChange(MDRChangeEvent event) {
            super.doChange(event);
            if (event instanceof AttributeEvent) {
                AttributeEvent attrEvent = (AttributeEvent)event;
                String attrName = attrEvent.getAttributeName();
                Object source = event.getSource();
                if (attrName.equals("typeName")) {
                    Type oldType = this.type;
                    TypeReference typeRef = (TypeReference)attrEvent.getNewElement();
                    this.type = typeRef != null ? ((MethodElementImpl)this.getImpl()).typeReferenceToType(typeRef) : null;
                    ((MethodElementImpl)this.impl).fireReturnChange(oldType, this.type);
                }
            }
        }
    }
}

