/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.bridge;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.zip.CRC32;
import javax.jmi.reflect.InvalidObjectException;
import javax.jmi.reflect.RefBaseObject;
import javax.jmi.reflect.RefObject;
import org.netbeans.api.mdr.events.AssociationEvent;
import org.netbeans.api.mdr.events.AttributeEvent;
import org.netbeans.api.mdr.events.MDRChangeEvent;
import org.netbeans.api.mdr.events.MDRChangeListener;
import org.netbeans.api.mdr.events.MDRChangeSource;
import org.netbeans.api.mdr.events.MDRPreChangeListener;
import org.netbeans.jmi.javamodel.CallableFeature;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.jmi.javamodel.IsOfType;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.MultipartId;
import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.jmi.javamodel.ParameterClass;
import org.netbeans.modules.java.bridge.DefaultLangModel;
import org.netbeans.modules.java.bridge.ElementImpl;
import org.netbeans.modules.java.bridge.FlyweightIndexedProperty;
import org.netbeans.modules.java.bridge.IdentifierArrayProperty;
import org.netbeans.modules.java.bridge.JavaDocImpl;
import org.netbeans.modules.java.bridge.MemberElementImpl;
import org.openide.src.ConstructorElement;
import org.openide.src.Element;
import org.openide.src.Identifier;
import org.openide.src.JavaDoc;
import org.openide.src.MethodParameter;
import org.openide.src.MultiPropertyChangeEvent;
import org.openide.src.SourceException;
import org.openide.src.Type;

abstract class CallableImpl
extends MemberElementImpl
implements ConstructorElement.Impl {
    private static final boolean DEBUG = false;
    static final MethodParameter[] NO_PARAMETERS = new MethodParameter[0];
    private static IdentifierArrayProperty exceptionSupport;
    private static MethodParamSupport paramSupport;
    private transient long bodyHash = -1L;
    private static final long serialVersionUID = -357084137587082234L;

    CallableImpl(DefaultLangModel model, CallableFeature javaElement) {
        super(model, (Feature)javaElement);
        this.init();
    }

    private void init() {
        if (paramSupport == null) {
            paramSupport = new MethodParamSupport();
            exceptionSupport = new ExceptionSupport();
        }
        this.javadoc = new JavaDocImpl.Method(null, this);
    }

    public JavaDoc.Method getJavaDoc() {
        this.updateJavadoc();
        return (JavaDoc.Method)this.javadoc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final MethodParameter[] getParameters() {
        MethodParameter[] parameters;
        block7: {
            this.repository.beginTrans(false);
            try {
                if (this.javaElement.isValid()) {
                    this.setClassPath();
                    List list = ((CallableFeature)this.javaElement).getParameters();
                    if (list.size() == 0) {
                        parameters = NO_PARAMETERS;
                    } else {
                        Iterator iter = list.iterator();
                        parameters = new MethodParameter[list.size()];
                        int x = 0;
                        while (iter.hasNext()) {
                            Parameter param = (Parameter)iter.next();
                            parameters[x] = this.createParameter(param);
                            ++x;
                        }
                    }
                    break block7;
                }
                MethodParameter[] methodParameterArray = NO_PARAMETERS;
                return methodParameterArray;
            }
            finally {
                this.repository.endTrans(false);
            }
        }
        return parameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Identifier[] getExceptions() {
        Identifier[] exceptions;
        block7: {
            this.repository.beginTrans(false);
            try {
                if (this.javaElement.isValid()) {
                    this.setClassPath();
                    List list = ((CallableFeature)this.javaElement).getExceptionNames();
                    if (list.size() == 0) {
                        exceptions = IdentifierArrayProperty.EMPTY;
                    } else {
                        Iterator iter = list.iterator();
                        exceptions = new Identifier[list.size()];
                        int x = 0;
                        while (iter.hasNext()) {
                            MultipartId ex = (MultipartId)iter.next();
                            exceptions[x] = this.createClassIdentifier(ex);
                            ++x;
                        }
                    }
                    break block7;
                }
                Identifier[] identifierArray = new Identifier[]{};
                return identifierArray;
            }
            finally {
                this.repository.endTrans(false);
            }
        }
        return exceptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String getBody() {
        this.repository.beginTrans(false);
        try {
            if (this.javaElement.isValid()) {
                this.setClassPath();
                String string = ((CallableFeature)this.javaElement).getBodyText();
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            this.repository.endTrans(false);
        }
    }

    private long computeHash(String bodyContent) {
        CRC32 crc = new CRC32();
        crc.update(bodyContent.getBytes());
        return crc.getValue();
    }

    protected void createFromModel(Element model) throws SourceException {
        super.createFromModel(model);
        ConstructorElement m = (ConstructorElement)model;
        this.setParameters(m.getParameters());
        this.setExceptions(m.getExceptions());
        this.setBody(m.getBody());
        this.setJavaDocText(m.getJavaDoc().getRawText(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setParameters(MethodParameter[] params) throws SourceException {
        this.checkWritable(true);
        this.checkDocument();
        boolean failed = true;
        this.repository.beginTrans(true);
        try {
            if (this.javaElement.isValid()) {
                this.setClassPath();
                params = this.resolveParams(params);
                MultiPropertyChangeEvent evt = paramSupport.createChangeEvent(this.getElement(), params == null ? NO_PARAMETERS : this.getParameters(), params);
                if (evt == null) {
                    failed = false;
                    return;
                }
                this.checkVetoablePropertyChange((PropertyChangeEvent)evt);
                if (params == null) {
                    params = NO_PARAMETERS;
                }
                ParameterClass proxy = this.javaModelPackage.getParameter();
                List pars = ((CallableFeature)this.javaElement).getParameters();
                LinkedList<Parameter> temp = new LinkedList<Parameter>();
                pars.clear();
                for (int x = 0; x < params.length; ++x) {
                    Parameter p = proxy.createParameter(params[x].getName(), null, params[x].isFinal(), null, 0, false);
                    Type t = params[x].getType();
                    if (t.isPrimitive()) {
                        p.setType(this.typeToDescr(t));
                    } else {
                        p.setTypeName(this.typeToTypeReference(t));
                    }
                    temp.add(p);
                }
                pars.addAll(temp);
                failed = false;
            } else {
                failed = false;
                this.throwIsInvalid();
            }
        }
        finally {
            this.repository.endTrans(failed);
        }
    }

    MethodParameter createParameter(Parameter param) {
        try {
            Type type = param.isVarArg() ? this.stringToType("java.lang.Object[]") : this.descrToType(param.getType());
            return new MethodParameter(param.getName(), type, param.isFinal());
        }
        catch (InvalidObjectException e) {
            return new MethodParameter("", null, false);
        }
    }

    MethodParameter createParameterConn(Parameter param) {
        try {
            Type type = null;
            type = param.getType() instanceof ClassDefinition ? Type.createClass((Identifier)Identifier.create((String)param.getType().getName())) : this.descrToType(param.getType());
            return new MethodParameter(param.getName(), type, param.isFinal());
        }
        catch (InvalidObjectException e) {
            return new MethodParameter("", null, false);
        }
    }

    private MethodParameter resolveParameter(MethodParameter par) {
        Type t = this.resolveType(par.getType());
        if (t == par.getType()) {
            return par;
        }
        return new MethodParameter(par.getName(), t, par.isFinal());
    }

    private MethodParameter[] resolveParams(MethodParameter[] params) {
        return params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExceptions(Identifier[] except) throws SourceException {
        this.checkWritable(false);
        this.checkDocument();
        boolean failed = true;
        this.repository.beginTrans(true);
        try {
            if (this.javaElement.isValid()) {
                this.setClassPath();
                except = this.resolveIdentifiers(except);
                MultiPropertyChangeEvent evt = exceptionSupport.createChangeEvent(this.getElement(), this.getExceptions(), except);
                if (evt == null) {
                    failed = false;
                    return;
                }
                this.checkVetoablePropertyChange((PropertyChangeEvent)evt);
                if (except == null) {
                    except = IdentifierArrayProperty.EMPTY;
                }
                List excs = ((CallableFeature)this.javaElement).getExceptionNames();
                LinkedList<MultipartId> temp = new LinkedList<MultipartId>();
                for (int x = 0; x < except.length; ++x) {
                    MultipartId id = this.javaModelPackage.getMultipartId().createMultipartId(except[x].getFullName(), null, null);
                    temp.add(id);
                }
                excs.clear();
                excs.addAll(temp);
                failed = false;
            } else {
                failed = false;
                this.throwIsInvalid();
            }
        }
        finally {
            this.repository.endTrans(failed);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setBody(String body) throws SourceException {
        this.checkWritable(false);
        this.checkDocument();
        this.repository.beginTrans(true);
        boolean rollback = true;
        try {
            if (this.javaElement.isValid()) {
                this.setClassPath();
                String cachedBody = this.getBody();
                if (cachedBody == body || cachedBody != null && body != null && cachedBody.equals(body)) {
                    return;
                }
                PropertyChangeEvent evt = new PropertyChangeEvent(this.getElement(), "body", cachedBody, body);
                this.checkVetoablePropertyChange(evt);
                ((CallableFeature)this.javaElement).setBodyText(body);
                rollback = false;
            } else {
                rollback = false;
                this.throwIsInvalid();
            }
        }
        finally {
            this.repository.endTrans(rollback);
        }
    }

    public void fireChangeParameters(MethodParameter[] oldPars, MethodParameter[] newPars, MethodParameter[] oldParsConn) {
        MultiPropertyChangeEvent evt = paramSupport.createChangeEvent(this.getElement(), oldPars, newPars);
        if (evt == null) {
            return;
        }
        this.fireOwnPropertyChange((PropertyChangeEvent)evt);
        ConstructorElement elem = (ConstructorElement)this.cloneSelf();
        try {
            elem.setParameters(oldParsConn);
        }
        catch (SourceException e) {
            e.printStackTrace();
        }
        this.notifyConnectionChange((Element)elem);
    }

    public void fireChangeExceptions(Identifier[] oldExcs, Identifier[] newExcs) {
        oldExcs = this.resolveIdentifiers(oldExcs);
        newExcs = this.resolveIdentifiers(newExcs);
        MultiPropertyChangeEvent evt = exceptionSupport.createChangeEvent(this.getElement(), oldExcs, newExcs);
        if (evt == null) {
            return;
        }
        this.fireOwnPropertyChange((PropertyChangeEvent)evt);
        ConstructorElement elem = (ConstructorElement)this.cloneSelf();
        try {
            elem.setExceptions(oldExcs);
        }
        catch (SourceException e) {
            e.printStackTrace();
        }
        this.notifyConnectionChange((Element)elem);
    }

    public void fireChangeBody(String oldVal, String newVal) {
        PropertyChangeEvent evt = new PropertyChangeEvent(this.getElement(), "body", oldVal, newVal);
        this.fireOwnPropertyChange(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeListenerSupport() {
        Class clazz;
        if (exceptionSupport == null) {
            clazz = CallableImpl.class;
            synchronized (clazz) {
                if (exceptionSupport == null) {
                    exceptionSupport = new ExceptionSupport();
                }
            }
        }
        if (paramSupport == null) {
            clazz = CallableImpl.class;
            synchronized (clazz) {
                if (paramSupport == null) {
                    paramSupport = new MethodParamSupport();
                }
            }
        }
    }

    protected void copyCallableProperties(ConstructorElement el) {
        try {
            el.setName(this.getName());
            el.setModifiers(this.getModifiers());
            el.setParameters(this.getParameters());
            el.setExceptions(this.getExceptions());
        }
        catch (SourceException sourceException) {
            // empty catch block
        }
    }

    static class ParametersListener
    implements MDRChangeListener {
        private ElementImpl.ElementListener parentListener;
        private CallableFeature javaElement;
        private ArrayList array = new ArrayList();
        private ArrayList arrayConn = new ArrayList();
        private ArrayList params = new ArrayList();

        ParametersListener(ElementImpl.ElementListener parentListener) {
            this.parentListener = parentListener;
            this.javaElement = (CallableFeature)parentListener.javaElement;
        }

        public void initElements() {
            Iterator iter = this.javaElement.getParameters().iterator();
            int x = 0;
            while (iter.hasNext()) {
                Parameter param = (Parameter)iter.next();
                this.array.add(((CallableImpl)this.parentListener.getImpl()).createParameter(param));
                this.arrayConn.add(((CallableImpl)this.parentListener.getImpl()).createParameterConn(param));
                this.params.add(param);
                ((MDRChangeSource)param).addListener((MDRChangeListener)this);
                ++x;
            }
            ((MDRChangeSource)this.javaElement).addListener((MDRChangeListener)this);
        }

        public void removeAll() {
            Iterator iter = this.params.iterator();
            while (iter.hasNext()) {
                MDRChangeSource javaElem = (MDRChangeSource)iter.next();
                javaElem.removeListener((MDRChangeListener)this);
            }
            this.array.clear();
            this.arrayConn.clear();
            this.params.clear();
            try {
                ((MDRChangeSource)this.javaElement).removeListener((MDRChangeListener)this);
            }
            catch (InvalidObjectException invalidObjectException) {
                // empty catch block
            }
        }

        public int findParamIndex(RefBaseObject param) {
            int size = this.params.size();
            Iterator iter = this.params.iterator();
            for (int x = 0; x < size; ++x) {
                RefObject obj = (RefObject)iter.next();
                if (!obj.equals(param)) continue;
                return x;
            }
            return -1;
        }

        public void fireChange(CallableImpl impl, ArrayList oldValues, ArrayList newValues, ArrayList oldValuesConn) {
            MethodParameter[] oldPars = oldValues.toArray(CallableListener.NO_PARAMETERS);
            MethodParameter[] newPars = newValues.toArray(CallableListener.NO_PARAMETERS);
            MethodParameter[] oldParsConn = oldValuesConn.toArray(CallableListener.NO_PARAMETERS);
            impl.fireChangeParameters(oldPars, newPars, oldParsConn);
        }

        public final void change(MDRChangeEvent event) {
            if (!this.parentListener.isValid) {
                return;
            }
            CallableImpl impl = (CallableImpl)this.parentListener.getImpl();
            if (impl == null) {
                this.parentListener.doRemove();
                return;
            }
            RefBaseObject source = (RefBaseObject)event.getSource();
            if (source instanceof IsOfType) {
                RefObject fixed = ((AssociationEvent)event).getFixedElement();
                if (fixed instanceof Parameter) {
                    ArrayList old = (ArrayList)this.array.clone();
                    ArrayList oldConn = (ArrayList)this.arrayConn.clone();
                    int index = this.findParamIndex((RefBaseObject)fixed);
                    if (index != -1) {
                        this.array.set(index, ((CallableImpl)this.parentListener.getImpl()).createParameter((Parameter)fixed));
                        this.arrayConn.set(index, ((CallableImpl)this.parentListener.getImpl()).createParameterConn((Parameter)fixed));
                        this.fireChange(impl, old, this.array, oldConn);
                    }
                }
            } else if (event instanceof AttributeEvent) {
                AttributeEvent attrEvent = (AttributeEvent)event;
                String attrName = attrEvent.getAttributeName();
                if (source instanceof Parameter) {
                    if (attrName.equals("isFinal")) {
                        ArrayList old = (ArrayList)this.array.clone();
                        ArrayList oldConn = (ArrayList)this.arrayConn.clone();
                        int index = this.findParamIndex(source);
                        if (index != -1) {
                            MethodParameter param = (MethodParameter)this.array.get(index);
                            boolean isFinal = !param.isFinal();
                            param.setFinal(isFinal);
                            param = (MethodParameter)this.arrayConn.get(index);
                            param.setFinal(isFinal);
                            this.fireChange(impl, old, this.array, oldConn);
                        }
                    } else if (attrName.equals("name")) {
                        ArrayList old = (ArrayList)this.array.clone();
                        ArrayList oldConn = (ArrayList)this.arrayConn.clone();
                        int index = this.findParamIndex(source);
                        if (index != -1) {
                            MethodParameter param = (MethodParameter)this.array.get(index);
                            String n = (String)attrEvent.getNewElement();
                            param.setName(n);
                            param = (MethodParameter)this.arrayConn.get(index);
                            param.setName(n);
                            this.fireChange(impl, old, this.array, oldConn);
                        }
                    } else if (attrName.equals("isVarArg") || attrName.equals("typeArguments")) {
                        ArrayList old = (ArrayList)this.array.clone();
                        ArrayList oldConn = (ArrayList)this.arrayConn.clone();
                        int index = this.findParamIndex(source);
                        if (index != -1) {
                            MethodParameter param = ((CallableImpl)this.parentListener.getImpl()).createParameter((Parameter)source);
                            this.array.set(index, param);
                            param = ((CallableImpl)this.parentListener.getImpl()).createParameterConn((Parameter)source);
                            this.arrayConn.set(index, param);
                            this.fireChange(impl, old, this.array, oldConn);
                        }
                    }
                } else if (source instanceof CallableFeature && attrName.equals("parameters")) {
                    ArrayList old = (ArrayList)this.array.clone();
                    ArrayList oldConn = (ArrayList)this.arrayConn.clone();
                    int position = attrEvent.getPosition();
                    if (event.isOfType(0x1010004)) {
                        RefObject oldPar = (RefObject)attrEvent.getOldElement();
                        if (position == -1) {
                            position = this.findParamIndex((RefBaseObject)oldPar);
                        }
                        if (position != -1) {
                            this.array.remove(position);
                            this.arrayConn.remove(position);
                            MDRChangeSource cs = (MDRChangeSource)this.params.remove(position);
                            cs.removeListener((MDRChangeListener)this);
                        }
                    } else if (event.isOfType(0x1010001)) {
                        Parameter fps = (Parameter)attrEvent.getNewElement();
                        this.array.set(position, ((CallableImpl)this.parentListener.getImpl()).createParameter(fps));
                        this.arrayConn.set(position, ((CallableImpl)this.parentListener.getImpl()).createParameterConn(fps));
                        MDRChangeSource cs = (MDRChangeSource)this.params.set(position, fps);
                        cs.removeListener((MDRChangeListener)this);
                        ((MDRChangeSource)fps).addListener((MDRChangeListener)this);
                    } else if (event.isOfType(0x1010002)) {
                        Parameter fps = (Parameter)attrEvent.getNewElement();
                        if (position == -1) {
                            position = this.array.size();
                        }
                        this.array.add(position, ((CallableImpl)this.parentListener.getImpl()).createParameter(fps));
                        this.arrayConn.add(position, ((CallableImpl)this.parentListener.getImpl()).createParameterConn(fps));
                        this.params.add(position, fps);
                        ((MDRChangeSource)fps).addListener((MDRChangeListener)this);
                    }
                    this.fireChange(impl, old, this.array, oldConn);
                }
            }
        }
    }

    static class ExceptionsListener
    implements MDRPreChangeListener {
        protected ElementImpl.ElementListener parentListener;
        protected RefObject javaElement;
        private ArrayList exIds = new ArrayList();
        private Map eventsMap = new HashMap();

        ExceptionsListener(ElementImpl.ElementListener parentListener) {
            this.parentListener = parentListener;
            this.javaElement = parentListener.javaElement;
        }

        public List getElements() {
            return ((CallableFeature)this.javaElement).getExceptions();
        }

        public String getEndName() {
            return "exceptions";
        }

        public void fireChange(ElementImpl impl, ArrayList oldValues, ArrayList newValues) {
            Identifier[] oldPars = oldValues.toArray(CallableListener.NO_IDENTIFIERS);
            Identifier[] newPars = newValues.toArray(CallableListener.NO_IDENTIFIERS);
            ((CallableImpl)impl).fireChangeExceptions(oldPars, newPars);
        }

        public void initElements() {
            Iterator iter = this.getElements().iterator();
            while (iter.hasNext()) {
                JavaClass ex = (JavaClass)iter.next();
                this.exIds.add(Identifier.create((String)ex.getName()));
            }
            ((MDRChangeSource)this.javaElement).addListener((MDRChangeListener)this, 67239935);
        }

        public void removeAll() {
            this.exIds.clear();
            try {
                ((MDRChangeSource)this.javaElement).removeListener((MDRChangeListener)this);
            }
            catch (InvalidObjectException invalidObjectException) {
                // empty catch block
            }
        }

        public int findIndex(String name) {
            int size = this.exIds.size();
            Iterator iter = this.exIds.iterator();
            for (int x = 0; x < size; ++x) {
                Identifier id = (Identifier)iter.next();
                if (!id.getName().equals(name)) continue;
                return x;
            }
            return -1;
        }

        public final void change(MDRChangeEvent event) {
            if (!this.parentListener.isValid) {
                return;
            }
            ElementImpl impl = this.parentListener.getImpl();
            if (impl == null) {
                this.parentListener.doRemove();
                return;
            }
            if (event instanceof AssociationEvent) {
                AssociationEvent assocEvent = (AssociationEvent)event;
                String endName = this.getEndName();
                if (this.getEndName().equals(assocEvent.getEndName())) {
                    EventInfo info = (EventInfo)this.eventsMap.remove(event);
                    ArrayList old = (ArrayList)this.exIds.clone();
                    int position = info.index;
                    if (event.isOfType(0x4010001)) {
                        int index;
                        int n = index = position != -1 ? position : this.findIndex(info.oldName);
                        if (index < 0 || index >= this.exIds.size()) {
                            return;
                        }
                        this.exIds.set(index, Identifier.create((String)info.newName));
                    } else if (event.isOfType(0x4010004)) {
                        int index;
                        int n = index = position != -1 ? position : this.findIndex(info.oldName);
                        if (index < 0 || index >= this.exIds.size()) {
                            return;
                        }
                        this.exIds.remove(index);
                    } else {
                        if (position == -1) {
                            position = this.exIds.size();
                        }
                        if (position < 0 || position > this.exIds.size()) {
                            return;
                        }
                        this.exIds.add(position, Identifier.create((String)info.newName));
                    }
                    this.fireChange(impl, old, this.exIds);
                }
            }
        }

        public void changeCancelled(MDRChangeEvent e) {
            if (!this.parentListener.isValid) {
                return;
            }
            this.eventsMap.remove(e);
        }

        public void plannedChange(MDRChangeEvent event) {
            if (!this.parentListener.isValid) {
                return;
            }
            if (event instanceof AssociationEvent) {
                AssociationEvent assocEvent = (AssociationEvent)event;
                String endName = assocEvent.getEndName();
                if (this.getEndName().equals(endName)) {
                    EventInfo info = new EventInfo();
                    JavaClass jc = (JavaClass)assocEvent.getNewElement();
                    JavaClass old = (JavaClass)assocEvent.getOldElement();
                    info.index = assocEvent.getPosition();
                    info.newName = jc != null ? jc.getName() : null;
                    info.oldName = old != null ? old.getName() : null;
                    this.eventsMap.put(event, info);
                }
            }
        }

        class EventInfo {
            String newName;
            String oldName;
            int index;

            EventInfo() {
            }
        }
    }

    static class CallableListener
    extends MemberElementImpl.MemberElementListener {
        private static final MethodParameter[] NO_PARAMETERS = new MethodParameter[0];
        private static final Identifier[] NO_IDENTIFIERS = new Identifier[0];
        ParametersListener params = new ParametersListener(this);
        ExceptionsListener exceptions = new ExceptionsListener(this);

        CallableListener(CallableImpl impl) {
            super(impl);
        }

        public void connect() {
            if (REGISTER_LISTENER) {
                super.connect();
                this.impl = (ElementImpl)this.ref.get();
                if (this.impl != null) {
                    this.params.initElements();
                    this.exceptions.initElements();
                }
                this.impl = null;
            }
        }

        public void remove() {
            super.remove();
            this.params.removeAll();
            this.exceptions.removeAll();
        }

        public void doChange(MDRChangeEvent event) {
            AttributeEvent attrEv;
            super.doChange(event);
            if (event instanceof AttributeEvent && (attrEv = (AttributeEvent)event).getAttributeName().equals("bodyText")) {
                ((CallableImpl)this.impl).fireChangeBody((String)attrEv.getOldElement(), (String)attrEv.getNewElement());
            }
        }
    }

    private static final class ExceptionSupport
    extends IdentifierArrayProperty {
        ExceptionSupport() {
            super("exceptions");
        }

        public Object[] getAsArray(ElementImpl bean) {
            return ((CallableImpl)bean).getExceptions();
        }

        protected final Object[] getValue(ElementImpl impl) {
            return ((CallableImpl)impl).getExceptions();
        }

        public boolean compareValues(Object one, Object two) {
            return MemberElementImpl.compareSourceIdentifiers((Identifier)one, (Identifier)two);
        }
    }

    private static final class MethodParamSupport
    extends FlyweightIndexedProperty {
        MethodParamSupport() {
            super("parameters");
        }

        protected final Object[] createEmpty() {
            return NO_PARAMETERS;
        }

        protected final Object[] createValue(int size) {
            if (size == 0) {
                return this.createEmpty();
            }
            return new MethodParameter[size];
        }

        protected boolean compareValues(Object a, Object b) {
            MethodParameter par1 = (MethodParameter)a;
            MethodParameter par2 = (MethodParameter)b;
            Type t1 = par1.getType();
            Type t2 = par2.getType();
            if (!par1.getName().equals(par2.getName())) {
                return false;
            }
            if (par1.isFinal() != par2.isFinal()) {
                return false;
            }
            return MemberElementImpl.compareSourceTypes(t1, t2);
        }

        protected final Object[] getValue(ElementImpl impl) {
            return ((CallableImpl)impl).getParameters();
        }
    }
}

