/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.java.JavaDataObject;
import org.netbeans.modules.java.JavaEditor;
import org.netbeans.modules.java.settings.JavaSettings;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.openide.ErrorManager;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.src.SourceException;
import org.openide.text.IndentEngine;
import org.openide.text.NbDocument;
import org.openide.util.NbBundle;

public final class Util {
    private static ErrorManager errorManager;
    static final String ATTR_FILE_ENCODING = "Content-Encoding";

    static String getString(String key) {
        return NbBundle.getMessage((Class)Util.class, (String)key);
    }

    static ErrorManager getErrorManager() {
        if (errorManager != null) {
            return errorManager;
        }
        ErrorManager main = ErrorManager.getDefault();
        if (main == null) {
            System.err.println("WARNING: can't lookup error manager");
            return null;
        }
        errorManager = main;
        return errorManager;
    }

    static void annotateThrowable(Throwable t, Throwable nested) {
        Util.getErrorManager().annotate(t, nested);
    }

    static void annotateThrowable(Throwable t, String localizedMessage, boolean user) {
        if (user) {
            Util.getErrorManager().annotate(t, 256, null, localizedMessage, null, null);
        } else {
            Util.getErrorManager().annotate(t, 4096, null, localizedMessage, null, null);
        }
    }

    static FileObject findBrother(FileObject f, String extension) {
        return FileUtil.findBrother((FileObject)f, (String)extension);
    }

    private static FileObject findSibling(FileObject base, String name, Enumeration extlist) {
        while (extlist.hasMoreElements()) {
            FileObject ret;
            String ext = (String)extlist.nextElement();
            if (ext == null || (ret = base.getFileObject(name, ext)) == null) continue;
            return ret;
        }
        return null;
    }

    private static void notifyException(Throwable t, String msg) {
        Util.getErrorManager().notify(t);
    }

    static Writer findIndentWriter(Document doc, int offset, Writer writer) {
        IndentEngine engine = IndentEngine.find((Document)doc);
        return engine.createWriter(doc, offset, writer);
    }

    static void runAtomic(StyledDocument doc, ExceptionRunnable run) throws SourceException {
        RunnableSupport support = new RunnableSupport(run);
        NbDocument.runAtomic((StyledDocument)doc, (Runnable)support);
        support.throwException();
    }

    public static String getFileEncoding0(FileObject someFile) {
        return (String)someFile.getAttribute(ATTR_FILE_ENCODING);
    }

    public static String getFileEncoding(FileObject someFile) {
        String enc = Util.getFileEncoding0(someFile);
        if (enc == null) {
            enc = JavaSettings.getDefault().getDefaultEncoding();
        }
        if ("".equals(enc)) {
            return null;
        }
        return enc;
    }

    public static void setFileEncoding(FileObject someFile, String enc) throws IOException {
        someFile.setAttribute(ATTR_FILE_ENCODING, (Object)enc);
    }

    static void throwException(String desc, String bundleKey) throws SourceException {
        throw (SourceException)Util.getErrorManager().annotate((Throwable)new SourceException(desc), Util.getString(bundleKey));
    }

    static SourceException wrapException(Exception ex) {
        SourceException x = new SourceException("Exception wrapper");
        Util.annotateThrowable((Throwable)x, ex);
        return x;
    }

    public static char[] readContents(Reader r) throws IOException {
        char[] buffer;
        int read = 0;
        int total = 0;
        LinkedList<char[]> buflist = new LinkedList<char[]>();
        do {
            int offset;
            buffer = new char[2048];
            for (offset = 0; offset < buffer.length && (read = r.read(buffer, offset, buffer.length - offset)) != -1; offset += read) {
            }
            if (offset > 0) {
                buflist.add(buffer);
            }
            total += offset;
        } while (read >= 0);
        r.close();
        buffer = new char[total];
        Iterator it = buflist.iterator();
        int offset2 = 0;
        while (it.hasNext()) {
            char[] buf = (char[])it.next();
            int size = it.hasNext() ? buf.length : total - offset2;
            System.arraycopy(buf, 0, buffer, offset2, size);
            offset2 += size;
        }
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getDocumentText(FileObject fo, boolean save) throws IOException {
        StyledDocument doc;
        DataObject obj = DataObject.find((FileObject)fo);
        JavaEditor editor = null;
        if (obj instanceof JavaDataObject) {
            editor = ((JavaDataObject)obj).getJavaEditor();
        }
        if (editor != null && (doc = editor.getDocument()) != null) {
            SaveCookie cookie;
            final String[] str = new String[1];
            Runnable run = new Runnable(){

                public void run() {
                    try {
                        str[0] = doc.getText(0, doc.getLength());
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            };
            if (save && (cookie = (SaveCookie)obj.getCookie(SaveCookie.class)) != null) {
                cookie.save();
            }
            JavaMetamodel.getDefaultRepository().beginTrans(false);
            try {
                doc.render(run);
            }
            finally {
                JavaMetamodel.getDefaultRepository().endTrans();
            }
            return str[0];
        }
        return null;
    }

    public static char[] getContent(FileObject fo, boolean save, boolean filter, String encoding) throws IOException {
        String text = Util.getDocumentText(fo, save);
        if (text == null) {
            BufferedInputStream is = new BufferedInputStream(fo.getInputStream());
            Reader reader = filter ? new JavaEditor.GuardedReader(is, true, encoding) : (encoding == null ? new InputStreamReader(is) : new InputStreamReader((InputStream)is, encoding));
            return Util.readContents(reader);
        }
        return text.toCharArray();
    }

    public static InputStream createInputStream(FileObject fo, boolean save, boolean store) throws IOException {
        return Util.createInputStream(fo, save, store, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputStream createInputStream(FileObject fo, boolean save, boolean store, String encoding) throws IOException {
        String text = Util.getDocumentText(fo, save);
        if (text == null) {
            InputStream is = new BufferedInputStream(fo.getInputStream());
            if (store) {
                ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
                OutputStreamWriter outWriter = new OutputStreamWriter(byteStream);
                JavaEditor.GuardedReader reader = new JavaEditor.GuardedReader(is, true);
                try {
                    int c;
                    while ((c = reader.read()) != -1) {
                        outWriter.write(c);
                    }
                }
                finally {
                    outWriter.close();
                    ((InputStream)is).close();
                }
                is = new ByteArrayInputStream(byteStream.toByteArray());
            }
            return new ParserInputStream(is);
        }
        return new ParserInputStream(text, encoding);
    }

    static class ParserInputStream
    extends InputStream {
        private InputStream stream;
        private String text;
        private StringBuffer buffer;
        private boolean mode;
        private int counter;
        private int[] lines = new int[200];
        int lineCounter = 2;
        int currentLineLength = 0;

        ParserInputStream(String text) {
            this(text, null);
        }

        ParserInputStream(String text, String encoding) {
            this.text = text;
            this.counter = 0;
            this.mode = false;
            ByteArrayOutputStream outstm = new ByteArrayOutputStream(text.length());
            Writer wr = null;
            if (encoding != null) {
                try {
                    wr = new OutputStreamWriter((OutputStream)outstm, encoding);
                }
                catch (UnsupportedEncodingException ex) {
                    // empty catch block
                }
            }
            if (wr == null) {
                wr = new OutputStreamWriter(outstm);
            }
            try {
                wr.write(text);
                wr.close();
            }
            catch (IOException ex) {
                // empty catch block
            }
            this.stream = new ByteArrayInputStream(outstm.toByteArray());
        }

        ParserInputStream(InputStream stream) {
            this.stream = stream;
            this.buffer = new StringBuffer();
            this.mode = true;
        }

        public String getString(int begin, int end) {
            return this.mode ? this.buffer.substring(begin, end) : this.text.substring(begin, end);
        }

        public String getString(int begin) {
            if (this.mode) {
                return this.buffer.substring(begin);
            }
            int end = Math.min(this.counter - 1, this.text.length());
            return this.text.substring(begin, end);
        }

        public int read() throws IOException {
            int x = this.stream.read();
            if (this.mode && x != -1) {
                this.buffer.append((char)x);
                ++this.counter;
            }
            if (x == 10) {
                if (this.lineCounter == this.lines.length - 1) {
                    int[] newLines = new int[this.lineCounter + this.lineCounter];
                    System.arraycopy(this.lines, 0, newLines, 0, this.lines.length);
                    this.lines = newLines;
                }
                this.lines[this.lineCounter] = this.lines[this.lineCounter - 1] + this.currentLineLength + 1;
                ++this.lineCounter;
                this.currentLineLength = 0;
            } else {
                ++this.currentLineLength;
            }
            return x;
        }

        public void close() throws IOException {
            this.stream.close();
        }

        int getOffset(int line, int column) {
            return this.lines[line] + column - 1;
        }
    }

    private static class RunnableSupport
    implements Runnable {
        private Exception e;
        private ExceptionRunnable runnable;

        public RunnableSupport(ExceptionRunnable runnable) {
            this.runnable = runnable;
            this.e = null;
        }

        public boolean hasException() {
            return this.e != null;
        }

        public Exception getException() {
            return this.e;
        }

        public void throwException() throws SourceException {
            if (this.e != null) {
                if (this.e instanceof SourceException) {
                    throw (SourceException)this.e;
                }
                SourceException wrapper = new SourceException(this.e.getMessage());
                if (this.e instanceof BadLocationException) {
                    ErrorManager.getDefault().annotate((Throwable)wrapper, 256, this.e.getMessage(), this.e.getLocalizedMessage(), (Throwable)this.e, null);
                } else {
                    ErrorManager.getDefault().annotate((Throwable)wrapper, (Throwable)this.e);
                }
                throw wrapper;
            }
        }

        public void run() {
            try {
                this.runnable.run();
            }
            catch (Exception e) {
                this.e = e;
            }
        }
    }

    static interface ExceptionRunnable {
        public void run() throws Exception;
    }
}

