/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.catalog;

import java.awt.Image;
import java.beans.IntrospectionException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeSet;
import org.netbeans.modules.xml.catalog.AddCatalogEntryAction;
import org.netbeans.modules.xml.catalog.CatalogEntry;
import org.netbeans.modules.xml.catalog.CatalogEntryNode;
import org.netbeans.modules.xml.catalog.RefreshAction;
import org.netbeans.modules.xml.catalog.Refreshable;
import org.netbeans.modules.xml.catalog.Util;
import org.netbeans.modules.xml.catalog.settings.CatalogSettings;
import org.netbeans.modules.xml.catalog.spi.CatalogDescriptor;
import org.netbeans.modules.xml.catalog.spi.CatalogListener;
import org.netbeans.modules.xml.catalog.spi.CatalogReader;
import org.netbeans.modules.xml.catalog.spi.CatalogWriter;
import org.openide.actions.PropertiesAction;
import org.openide.nodes.BeanNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.WeakListeners;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.SystemAction;

final class CatalogNode
extends BeanNode
implements Refreshable,
PropertyChangeListener,
Node.Cookie {
    private CatalogReader catalog;
    static /* synthetic */ Class class$org$netbeans$modules$xml$catalog$CatalogNode;

    public CatalogNode(CatalogReader catalog) throws IntrospectionException {
        super((Object)catalog, (Children)new CatalogChildren(catalog));
        this.catalog = catalog;
        this.getCookieSet().add((Node.Cookie)this);
        if (catalog instanceof CatalogDescriptor) {
            CatalogDescriptor desc = (CatalogDescriptor)((Object)catalog);
            this.setSynchronizeName(false);
            this.setName(desc.getDisplayName());
            String bundleString = catalog instanceof CatalogWriter ? "LBL_catalogReadWrite" : "LBL_catalogReadOnly";
            this.setDisplayName(Util.THIS.getString(bundleString, desc.getDisplayName()));
            this.setShortDescription(desc.getShortDescription());
            this.fireIconChange();
            desc.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)desc));
        }
    }

    CatalogReader getCatalogReader() {
        return this.catalog;
    }

    protected SystemAction[] createActions() {
        if (this.catalog instanceof CatalogWriter) {
            return new SystemAction[]{SystemAction.get((Class)AddCatalogEntryAction.class), SystemAction.get((Class)RefreshAction.class), SystemAction.get((Class)UnmountAction.class), null, SystemAction.get((Class)PropertiesAction.class)};
        }
        return new SystemAction[]{SystemAction.get((Class)RefreshAction.class), SystemAction.get((Class)UnmountAction.class), null, SystemAction.get((Class)PropertiesAction.class)};
    }

    public Image getIcon(int type) {
        Image icon;
        if (this.catalog instanceof CatalogDescriptor && (icon = ((CatalogDescriptor)((Object)this.catalog)).getIcon(type)) != null) {
            return icon;
        }
        return super.getIcon(type);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public void refresh() {
        this.catalog.refresh();
        ((CatalogChildren)this.getChildren()).reload();
    }

    public boolean canDestroy() {
        return false;
    }

    public boolean canRename() {
        return false;
    }

    public void destroy() throws IOException {
        CatalogSettings mounted = CatalogSettings.getDefault();
        mounted.removeCatalog(this.catalog);
        super.destroy();
    }

    public void propertyChange(PropertyChangeEvent e) {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug(e.toString());
        }
        if ("ca-name".equals(e.getPropertyName())) {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug(" Setting name: " + (String)e.getNewValue());
            }
            this.setName((String)e.getNewValue());
            this.setDisplayName((String)e.getNewValue());
        } else if ("ca-desc".equals(e.getPropertyName())) {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug(" Setting desc: " + (String)e.getNewValue());
            }
            this.setShortDescription((String)e.getNewValue());
        } else if ("ca-icon".equals(e.getPropertyName())) {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug(" Updating icon");
            }
            this.fireIconChange();
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("Reading Catalog node " + this);
        }
        in.defaultReadObject();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("Writing " + this);
        }
        out.defaultWriteObject();
    }

    private static final class UnmountAction
    extends NodeAction {
        private static final long serialVersionUID = 3556006276357785484L;

        public String getName() {
            return Util.THIS.getString("LBL_unmount");
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx(class$org$netbeans$modules$xml$catalog$CatalogNode$UnmountAction == null ? (class$org$netbeans$modules$xml$catalog$CatalogNode$UnmountAction = CatalogNode.class$("org.netbeans.modules.xml.catalog.CatalogNode$UnmountAction")) : class$org$netbeans$modules$xml$catalog$CatalogNode$UnmountAction);
        }

        protected boolean enable(Node[] activatedNodes) {
            if (activatedNodes.length > 0) {
                for (int i = 0; i < activatedNodes.length; ++i) {
                    Node me = activatedNodes[i];
                    Node.Cookie self = me.getCookie(class$org$netbeans$modules$xml$catalog$CatalogNode == null ? CatalogNode.class$("org.netbeans.modules.xml.catalog.CatalogNode") : class$org$netbeans$modules$xml$catalog$CatalogNode);
                    if (!(self instanceof CatalogNode)) continue;
                    CatalogReader reader = (CatalogReader)((CatalogNode)self).getBean();
                    if (!CatalogSettings.getDefault().isRemovable(reader)) continue;
                    return true;
                }
            }
            return false;
        }

        protected void performAction(Node[] activatedNodes) {
            if (!this.enable(activatedNodes)) {
                return;
            }
            for (int i = 0; i < activatedNodes.length; ++i) {
                try {
                    Node me = activatedNodes[i];
                    CatalogNode self = (CatalogNode)me.getCookie(class$org$netbeans$modules$xml$catalog$CatalogNode == null ? CatalogNode.class$("org.netbeans.modules.xml.catalog.CatalogNode") : class$org$netbeans$modules$xml$catalog$CatalogNode);
                    self.destroy();
                    continue;
                }
                catch (IOException ex) {
                    Util.THIS.debug("Cannot unmount XML entity catalog!", ex);
                }
            }
        }

        protected boolean asynchronous() {
            return false;
        }
    }

    public static class CatalogChildren
    extends Children.Keys {
        private CatalogReader peer;
        private CatalogListener catalogListener;
        private final TreeSet keys = new TreeSet();

        public CatalogChildren(CatalogReader catalog) {
            this.peer = catalog;
        }

        public void addNotify() {
            this.catalogListener = new Lis();
            try {
                this.peer.addCatalogListener(this.catalogListener);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            this.reload();
        }

        public void removeNotify() {
            try {
                this.peer.removeCatalogListener(this.catalogListener);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            this.keys.clear();
            this.setKeys(this.keys);
        }

        public Node[] createNodes(Object key) {
            try {
                CatalogEntry catalogEntry = new CatalogEntry((String)key, this.peer);
                return new Node[]{new CatalogEntryNode(catalogEntry)};
            }
            catch (IntrospectionException ex) {
                return null;
            }
        }

        public void reload() {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug(" Reloading kids of " + this.peer + "...");
            }
            HashSet previous = new HashSet(this.keys);
            this.keys.clear();
            Iterator it = this.peer.getPublicIDs();
            if (it != null) {
                while (it.hasNext()) {
                    String publicID = (String)it.next();
                    this.keys.add(publicID);
                    if (!previous.contains(publicID)) continue;
                    this.refreshKey(publicID);
                }
            }
            this.setKeys(this.keys);
        }

        private class Lis
        implements CatalogListener {
            private Lis() {
            }

            public void notifyNew(String publicID) {
                CatalogChildren.this.keys.add(publicID);
                CatalogChildren.this.setKeys(CatalogChildren.this.keys);
            }

            public void notifyRemoved(String publicID) {
                CatalogChildren.this.keys.remove(publicID);
                CatalogChildren.this.setKeys(CatalogChildren.this.keys);
            }

            public void notifyUpdate(String publicID) {
                CatalogChildren.this.refreshKey(publicID);
            }

            public void notifyInvalidate() {
                CatalogChildren.this.reload();
            }
        }
    }
}

