/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.openide.ErrorManager;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.MIMEResolver;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;

final class MIMESupport {
    private static final WeakReference EMPTY = new WeakReference<Object>(null);
    private static WeakReference lastFo = EMPTY;
    private static WeakReference lastCfo = EMPTY;
    private static Object lock = new Object();
    private static ErrorManager ERR = ErrorManager.getDefault().getInstance(MIMESupport.class.getName());
    static /* synthetic */ Class class$org$openide$filesystems$MIMESupport$CachedFileObject;
    static /* synthetic */ Class class$org$openide$filesystems$MIMEResolver;

    private MIMESupport() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String findMIMEType(FileObject fo, String def) {
        if (!fo.isValid() || fo.isFolder()) {
            return null;
        }
        if (def != null && !CachedFileObject.isAnyResolver()) {
            return def;
        }
        CachedFileObject cfo = null;
        try {
            Object object = lock;
            synchronized (object) {
                CachedFileObject lcfo = (CachedFileObject)lastCfo.get();
                cfo = lcfo == null || fo != lastFo.get() || fo.lastModified().getTime() != lcfo.lastModified().getTime() ? new CachedFileObject(fo) : lcfo;
                lastCfo = EMPTY;
            }
            object = cfo.getMIMEType(def);
            return object;
        }
        finally {
            Object object = lock;
            synchronized (object) {
                lastFo = new WeakReference<FileObject>(fo);
                lastCfo = new WeakReference<CachedFileObject>(cfo);
            }
        }
    }

    static MIMEResolver[] getResolvers() {
        return CachedFileObject.getResolvers();
    }

    private static class CachedInputStream
    extends InputStream {
        private InputStream inputStream;
        private byte[] buffer = null;
        private int len = 0;
        private int pos = 0;
        private boolean eof = false;

        CachedInputStream(InputStream is) {
            this.inputStream = is;
        }

        public void close() throws IOException {
        }

        void internalClose() {
            try {
                this.inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        protected void finalize() {
            this.internalClose();
        }

        public int read() throws IOException {
            int c;
            int n;
            if (this.eof) {
                return -1;
            }
            if (this.pos < this.len) {
                int c2;
                c2 = (c2 = this.buffer[this.pos++]) < 0 ? c2 + 256 : c2;
                return c2;
            }
            int buflen = this.len > 0 ? this.len * 2 : 256;
            byte[] buf = new byte[buflen];
            if (this.len > 0) {
                System.arraycopy(this.buffer, 0, buf, 0, this.len);
            }
            if ((n = this.inputStream.read(buf, this.len, buflen - this.len)) <= 0) {
                this.eof = true;
                return -1;
            }
            this.buffer = buf;
            this.len += n;
            c = (c = this.buffer[this.pos++]) < 0 ? c + 256 : c;
            return c;
        }

        void cacheToStart() {
            this.pos = 0;
            this.eof = false;
        }

        public String toString() {
            String retVal = super.toString() + '[' + this.inputStream.toString() + ']' + '\n';
            retVal = retVal + new String(this.buffer);
            return retVal;
        }
    }

    private static class CachedFileObject
    extends FileObject
    implements FileChangeListener {
        static Lookup.Result result;
        private static Object resolvers;
        private static MIMEResolver[] previousResolvers;
        String mimeType;
        Date lastModified;
        CachedInputStream fixIt;
        FileObject fileObj;

        CachedFileObject(FileObject fo) {
            this.fileObj = fo;
            this.lastModified = this.fileObj.lastModified();
            this.fileObj.addFileChangeListener(FileUtil.weakFileChangeListener(this, this.fileObj));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static MIMEResolver[] getResolvers() {
            HashSet<Thread> creators;
            Class clazz = class$org$openide$filesystems$MIMESupport$CachedFileObject == null ? (class$org$openide$filesystems$MIMESupport$CachedFileObject = MIMESupport.class$("org.openide.filesystems.MIMESupport$CachedFileObject")) : class$org$openide$filesystems$MIMESupport$CachedFileObject;
            synchronized (clazz) {
                if (resolvers instanceof MIMEResolver[]) {
                    return (MIMEResolver[])resolvers;
                }
                if (resolvers instanceof Set) {
                    creators = (HashSet<Thread>)resolvers;
                    if (creators.contains(Thread.currentThread())) {
                        ERR.log("Stack Overflow prevention. Returning previousResolvers: " + previousResolvers);
                        MIMEResolver[] toRet = previousResolvers;
                        if (!(toRet instanceof MIMEResolver[])) {
                            toRet = new MIMEResolver[]{};
                        }
                        return toRet;
                    }
                } else {
                    resolvers = creators = new HashSet<Thread>();
                }
                if (result == null) {
                    result = Lookup.getDefault().lookup(new Lookup.Template(class$org$openide$filesystems$MIMEResolver == null ? (class$org$openide$filesystems$MIMEResolver = MIMESupport.class$("org.openide.filesystems.MIMEResolver")) : class$org$openide$filesystems$MIMEResolver));
                    result.addLookupListener(new LookupListener(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void resultChanged(LookupEvent evt) {
                            Class clazz = class$org$openide$filesystems$MIMESupport$CachedFileObject == null ? (class$org$openide$filesystems$MIMESupport$CachedFileObject = MIMESupport.class$("org.openide.filesystems.MIMESupport$CachedFileObject")) : class$org$openide$filesystems$MIMESupport$CachedFileObject;
                            synchronized (clazz) {
                                ERR.log("Clearing cache");
                                Object prev = resolvers;
                                if (prev instanceof MIMEResolver[]) {
                                    CachedFileObject.access$302((MIMEResolver[])prev);
                                }
                                resolvers = null;
                                lastFo = EMPTY;
                                lastCfo = EMPTY;
                            }
                        }
                    });
                }
                creators.add(Thread.currentThread());
            }
            ERR.log("Computing resolvers");
            MIMEResolver[] toRet = result.allInstances().toArray(new MIMEResolver[0]);
            ERR.log("Resolvers computed");
            Class clazz2 = class$org$openide$filesystems$MIMESupport$CachedFileObject == null ? (class$org$openide$filesystems$MIMESupport$CachedFileObject = MIMESupport.class$("org.openide.filesystems.MIMESupport$CachedFileObject")) : class$org$openide$filesystems$MIMESupport$CachedFileObject;
            synchronized (clazz2) {
                if (resolvers == creators) {
                    resolvers = toRet;
                    previousResolvers = null;
                    ERR.log("Resolvers assigned");
                } else {
                    ERR.log("Somebody else computes resolvers: " + resolvers);
                }
                return toRet;
            }
        }

        public static boolean isAnyResolver() {
            return CachedFileObject.getResolvers().length > 0;
        }

        public void freeCaches() {
            this.fixIt = null;
            this.mimeType = null;
            this.lastModified = null;
        }

        public String getMIMEType() {
            return this.getMIMEType(null);
        }

        public String getMIMEType(String def) {
            if (this.mimeType == null) {
                this.mimeType = this.resolveMIME(def);
            }
            return this.mimeType;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String resolveMIME(String def) {
            String retVal = null;
            MIMEResolver[] local = CachedFileObject.getResolvers();
            try {
                for (int i = 0; i < local.length; ++i) {
                    retVal = local[i].findMIMEType(this);
                    if (retVal == null) continue;
                    String string = retVal;
                    return string;
                }
                if (def != null) {
                    String string = def;
                    return string;
                }
                String string = "content/unknown";
                return string;
            }
            finally {
                if (this.fixIt != null) {
                    this.fixIt.internalClose();
                }
                this.fixIt = null;
            }
        }

        public Date lastModified() {
            if (this.lastModified != null) {
                return this.lastModified;
            }
            this.lastModified = this.fileObj.lastModified();
            return this.lastModified;
        }

        public InputStream getInputStream() throws FileNotFoundException {
            if (this.fixIt == null) {
                InputStream is = this.fileObj.getInputStream();
                if (!(is instanceof BufferedInputStream)) {
                    is = new BufferedInputStream(is);
                }
                this.fixIt = new CachedInputStream(is);
            }
            this.fixIt.cacheToStart();
            return this.fixIt;
        }

        public void fileChanged(FileEvent fe) {
            this.freeCaches();
        }

        public void fileDeleted(FileEvent fe) {
            this.freeCaches();
        }

        public void fileRenamed(FileRenameEvent fe) {
            this.freeCaches();
        }

        public FileObject getParent() {
            return this.fileObj.getParent();
        }

        public String getPackageNameExt(char separatorChar, char extSepChar) {
            return this.fileObj.getPackageNameExt(separatorChar, extSepChar);
        }

        public FileObject copy(FileObject target, String name, String ext) throws IOException {
            return this.fileObj.copy(target, name, ext);
        }

        protected void fireFileDeletedEvent(Enumeration en, FileEvent fe) {
            this.fileObj.fireFileDeletedEvent(en, fe);
        }

        protected void fireFileFolderCreatedEvent(Enumeration en, FileEvent fe) {
            this.fileObj.fireFileFolderCreatedEvent(en, fe);
        }

        public void setImportant(boolean b) {
            this.fileObj.setImportant(b);
        }

        public boolean isData() {
            return this.fileObj.isData();
        }

        public Object getAttribute(String attrName) {
            return this.fileObj.getAttribute(attrName);
        }

        public Enumeration getFolders(boolean rec) {
            return this.fileObj.getFolders(rec);
        }

        public void delete(FileLock lock) throws IOException {
            this.fileObj.delete(lock);
        }

        public boolean isRoot() {
            return this.fileObj.isRoot();
        }

        public Enumeration getData(boolean rec) {
            return this.fileObj.getData(rec);
        }

        public FileObject[] getChildren() {
            return this.fileObj.getChildren();
        }

        public String getNameExt() {
            return this.fileObj.getNameExt();
        }

        public boolean isValid() {
            return this.fileObj.isValid();
        }

        public boolean isReadOnly() {
            return this.fileObj.isReadOnly();
        }

        public String getExt() {
            return this.fileObj.getExt();
        }

        public String getName() {
            return this.fileObj.getName();
        }

        public void removeFileChangeListener(FileChangeListener fcl) {
            this.fileObj.removeFileChangeListener(fcl);
        }

        protected void fireFileRenamedEvent(Enumeration en, FileRenameEvent fe) {
            this.fileObj.fireFileRenamedEvent(en, fe);
        }

        public void refresh(boolean expected) {
            this.fileObj.refresh(expected);
        }

        protected void fireFileAttributeChangedEvent(Enumeration en, FileAttributeEvent fe) {
            this.fileObj.fireFileAttributeChangedEvent(en, fe);
        }

        public long getSize() {
            return this.fileObj.getSize();
        }

        public Enumeration getAttributes() {
            return this.fileObj.getAttributes();
        }

        public void rename(FileLock lock, String name, String ext) throws IOException {
            this.fileObj.rename(lock, name, ext);
        }

        protected void fireFileChangedEvent(Enumeration en, FileEvent fe) {
            this.fileObj.fireFileChangedEvent(en, fe);
        }

        public FileObject getFileObject(String name, String ext) {
            return this.fileObj.getFileObject(name, ext);
        }

        public void refresh() {
            this.fileObj.refresh();
        }

        public FileObject createData(String name, String ext) throws IOException {
            return this.fileObj.createData(name, ext);
        }

        public void addFileChangeListener(FileChangeListener fcl) {
            this.fileObj.addFileChangeListener(fcl);
        }

        protected void fireFileDataCreatedEvent(Enumeration en, FileEvent fe) {
            this.fileObj.fireFileDataCreatedEvent(en, fe);
        }

        public boolean isFolder() {
            return this.fileObj.isFolder();
        }

        public FileObject createFolder(String name) throws IOException {
            return this.fileObj.createFolder(name);
        }

        public Enumeration getChildren(boolean rec) {
            return this.fileObj.getChildren(rec);
        }

        public void setAttribute(String attrName, Object value) throws IOException {
            this.fileObj.setAttribute(attrName, value);
        }

        public String getPackageName(char separatorChar) {
            return this.fileObj.getPackageName(separatorChar);
        }

        public FileSystem getFileSystem() throws FileStateInvalidException {
            return this.fileObj.getFileSystem();
        }

        public OutputStream getOutputStream(FileLock lock) throws IOException {
            return this.fileObj.getOutputStream(lock);
        }

        public boolean existsExt(String ext) {
            return this.fileObj.existsExt(ext);
        }

        public FileObject move(FileLock lock, FileObject target, String name, String ext) throws IOException {
            return this.fileObj.move(lock, target, name, ext);
        }

        public FileLock lock() throws IOException {
            return this.fileObj.lock();
        }

        public void fileFolderCreated(FileEvent fe) {
        }

        public void fileDataCreated(FileEvent fe) {
        }

        public void fileAttributeChanged(FileAttributeEvent fe) {
        }

        public int hashCode() {
            return this.fileObj.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof CachedFileObject) {
                return ((CachedFileObject)obj).fileObj.equals(this.fileObj);
            }
            return super.equals(obj);
        }

        static /* synthetic */ MIMEResolver[] access$302(MIMEResolver[] x0) {
            previousResolvers = x0;
            return x0;
        }
    }
}

