/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.actions;

import com.sun.jdi.AbsentInformationException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.Set;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.api.debugger.ActionsManagerListener;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAStep;
import org.netbeans.api.debugger.jpda.LineBreakpoint;
import org.netbeans.api.debugger.jpda.event.JPDABreakpointEvent;
import org.netbeans.api.debugger.jpda.event.JPDABreakpointListener;
import org.netbeans.modules.debugger.jpda.ui.EditorContextBridge;
import org.netbeans.modules.debugger.jpda.ui.SourcePath;
import org.netbeans.modules.debugger.jpda.ui.actions.RunToCursorActionProvider;
import org.netbeans.spi.debugger.ActionsProviderSupport;
import org.netbeans.spi.debugger.ContextProvider;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

public class RunIntoMethodActionProvider
extends ActionsProviderSupport
implements PropertyChangeListener,
ActionsManagerListener {
    private JPDADebugger debugger;
    private Session session;
    private LineBreakpoint breakpoint;
    private ActionsManager lastActionsManager;
    private SourcePath sourcePath;

    public RunIntoMethodActionProvider(ContextProvider lookupProvider) {
        this.debugger = (JPDADebugger)lookupProvider.lookupFirst(null, JPDADebugger.class);
        this.session = (Session)lookupProvider.lookupFirst(null, Session.class);
        this.sourcePath = (SourcePath)lookupProvider.lookupFirst(null, SourcePath.class);
        this.debugger.addPropertyChangeListener("state", (PropertyChangeListener)this);
        EditorContextBridge.addPropertyChangeListener(this);
    }

    private void destroy() {
        this.debugger.removePropertyChangeListener("state", (PropertyChangeListener)this);
        EditorContextBridge.removePropertyChangeListener(this);
    }

    private ActionsManager getActionsManager() {
        ActionsManager current = RunToCursorActionProvider.getCurrentActionsManager();
        if (current != this.lastActionsManager) {
            if (this.lastActionsManager != null) {
                this.lastActionsManager.removeActionsManagerListener("actionStateChanged", (ActionsManagerListener)this);
            }
            current.addActionsManagerListener("actionStateChanged", (ActionsManagerListener)this);
            this.lastActionsManager = current;
        }
        return current;
    }

    /*
     * Unable to fully structure code
     */
    public void propertyChange(PropertyChangeEvent evt) {
        if (!this.getActionsManager().isEnabled(ActionsManager.ACTION_CONTINUE)) ** GOTO lbl-1000
        if (this.debugger.getState() == 3 && EditorContextBridge.getCurrentLineNumber() >= 0 && EditorContextBridge.getCurrentURL().endsWith(".java")) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = false;
        }
        this.setEnabled(ActionsManager.ACTION_RUN_INTO_METHOD, v0);
        if (this.debugger.getState() != 2 && this.breakpoint != null) {
            DebuggerManager.getDebuggerManager().removeBreakpoint((Breakpoint)this.breakpoint);
            this.breakpoint = null;
        }
        if (this.debugger.getState() == 4) {
            this.destroy();
        }
    }

    public Set getActions() {
        return Collections.singleton(ActionsManager.ACTION_RUN_INTO_METHOD);
    }

    public void doAction(Object action) {
        if (this.breakpoint != null) {
            DebuggerManager.getDebuggerManager().removeBreakpoint((Breakpoint)this.breakpoint);
            this.breakpoint = null;
        }
        final String method = EditorContextBridge.getSelectedMethodName();
        final int methodLine = EditorContextBridge.getCurrentLineNumber();
        if (method.length() < 1) {
            NotifyDescriptor.Message descriptor = new NotifyDescriptor.Message((Object)NbBundle.getMessage((Class)RunIntoMethodActionProvider.class, (String)"MSG_Put_cursor_on_some_method_call"));
            DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor);
            return;
        }
        try {
            if (this.debugger.getCurrentThread().getCallStack()[0].getLineNumber(null) == EditorContextBridge.getCurrentLineNumber()) {
                this.traceLineForMethod(method, methodLine);
                this.session.getEngineForLanguage("Java").getActionsManager().doAction(ActionsManager.ACTION_CONTINUE);
                return;
            }
        }
        catch (AbsentInformationException e) {
            e.printStackTrace();
        }
        this.breakpoint = LineBreakpoint.create((String)EditorContextBridge.getCurrentURL(), (int)EditorContextBridge.getCurrentLineNumber());
        this.breakpoint.setHidden(true);
        this.breakpoint.setSuspend(0);
        this.breakpoint.addJPDABreakpointListener(new JPDABreakpointListener(){

            public void breakpointReached(JPDABreakpointEvent event) {
                RunIntoMethodActionProvider.this.traceLineForMethod(method, methodLine);
                DebuggerManager.getDebuggerManager().removeBreakpoint((Breakpoint)RunIntoMethodActionProvider.this.breakpoint);
            }
        });
        DebuggerManager.getDebuggerManager().addBreakpoint((Breakpoint)this.breakpoint);
        this.session.getEngineForLanguage("Java").getActionsManager().doAction(ActionsManager.ACTION_CONTINUE);
    }

    private void traceLineForMethod(final String method, final int methodLine) {
        final int depth = this.debugger.getCurrentThread().getStackDepth();
        final JPDAStep step = this.debugger.createJPDAStep(-2, 1);
        step.addPropertyChangeListener("exec", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if ((RunIntoMethodActionProvider.this.debugger.getCurrentThread().getMethodName().equals(method) || RunIntoMethodActionProvider.this.debugger.getCurrentThread().getStackDepth() == depth && RunIntoMethodActionProvider.this.debugger.getCurrentCallStackFrame().getLineNumber("java") != methodLine) && RunIntoMethodActionProvider.this.sourcePath.sourceAvailable(RunIntoMethodActionProvider.this.debugger.getCurrentThread(), "java", false)) {
                    step.setHidden(false);
                } else {
                    step.setHidden(true);
                    if (step.getDepth() == 1) {
                        step.setDepth(3);
                    } else {
                        step.setDepth(1);
                    }
                    step.addStep(RunIntoMethodActionProvider.this.debugger.getCurrentThread());
                }
            }
        });
        step.addStep(this.debugger.getCurrentThread());
    }

    public void actionPerformed(Object action) {
    }

    /*
     * Unable to fully structure code
     */
    public void actionStateChanged(Object action, boolean enabled) {
        block2: {
            if (ActionsManager.ACTION_CONTINUE != action) break block2;
            if (!enabled) ** GOTO lbl-1000
            if (this.debugger.getState() == 3 && EditorContextBridge.getCurrentLineNumber() >= 0 && EditorContextBridge.getCurrentURL().endsWith(".java")) {
                v0 = true;
            } else lbl-1000:
            // 2 sources

            {
                v0 = false;
            }
            this.setEnabled(ActionsManager.ACTION_RUN_INTO_METHOD, v0);
        }
    }
}

