/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j2ee.blueprints.ui.progressbar;

import com.sun.j2ee.blueprints.ui.progressbar.ProgressBarComponent;
import com.sun.j2ee.blueprints.ui.util.BaseRenderer;
import com.sun.j2ee.blueprints.ui.util.Util;
import java.beans.Beans;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import javax.faces.FactoryFinder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.el.MethodBinding;
import javax.faces.el.ValueBinding;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.faces.render.Renderer;
import org.apache.shale.remoting.Mechanism;
import org.apache.shale.remoting.XhtmlHelper;

public class ProgressBarRenderer
extends BaseRenderer {
    private boolean logging = false;
    private static final String CSS_RESOURCE = "/META-INF/progressbar/styles.css";
    private static final String SCRIPT_RESOURCE = "/META-INF/progressbar/script.js";
    private static final String RENDER_ONCE = "com.sun.j2ee.blueprints.ui.progressbar.RENDER_ONCE";
    private static final String RESPONSE_HANDLER = "/bpui_progressbar_handler/writeAjaxResponse";
    private static XhtmlHelper helper = new XhtmlHelper();
    private Renderer commandButtonRenderer = null;

    public void decode(FacesContext context, UIComponent component) {
        this.getButtonRenderer(context).decode(context, component);
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = component.getClientId(context);
        int interval = 1500;
        int percentage = 0;
        int indeterminateSection = 0;
        int indeterminateInterval = 0;
        int indeterminateIncrement = 0;
        String style = null;
        String styleClass = null;
        String percentageText = null;
        String onComplete = null;
        String onFail = null;
        String onUpdate = null;
        String onPoll = null;
        ValueBinding percentageVb = null;
        ValueBinding percentageTextVb = null;
        Boolean autoStart = null;
        if (Beans.isDesignTime()) {
            percentage = 67;
        }
        ProgressBarComponent pbComponent = null;
        if (component instanceof ProgressBarComponent) {
            String defaultPercentageText;
            pbComponent = (ProgressBarComponent)component;
            style = pbComponent.getStyle();
            styleClass = pbComponent.getStyleClass();
            onComplete = pbComponent.getOnComplete();
            onFail = pbComponent.getOnFail();
            onUpdate = pbComponent.getOnUpdate();
            onPoll = pbComponent.getOnPoll();
            autoStart = pbComponent.isAutoStart();
            indeterminateSection = pbComponent.getIndeterminateSection();
            indeterminateInterval = pbComponent.getIndeterminateInterval();
            indeterminateIncrement = pbComponent.getIndeterminateIncrement();
            interval = pbComponent.getInterval();
            if (interval < 0) {
                interval = 0;
            }
            percentageVb = pbComponent.getValueBinding("percentage");
            if (!Beans.isDesignTime() || percentageVb == null) {
                percentage = pbComponent.getPercentage();
            }
            percentageText = defaultPercentageText = String.valueOf(percentage) + "%";
            percentageTextVb = pbComponent.getValueBinding("percentageText");
            if (Beans.isDesignTime() && percentageTextVb == null || !Beans.isDesignTime() && percentageTextVb != null) {
                percentageText = pbComponent.getPercentageText();
            }
            if (Beans.isDesignTime()) {
                if (percentageText == null || percentageText.length() < 1) {
                    percentageText = defaultPercentageText;
                }
            } else if (percentageText == null) {
                percentageText = "";
            }
        } else {
            ClassLoader cl;
            System.err.println("ProgressBarRenderer.encodeBegin: expected type " + ProgressBarComponent.class + " but found " + component.getClass());
            System.err.println("ProgressBarRenderer.encodeBegin: class loader hierarchy, starting with ProgressBarComponent.class.getClassLoader():");
            for (cl = ProgressBarComponent.class.getClassLoader(); cl != null; cl = cl.getParent()) {
                System.err.println(cl);
            }
            System.err.println();
            System.err.println("ProgressBarRenderer.encodeBegin: class loader hierarchy, starting with component.getClass().getClassLoader():");
            for (cl = component.getClass().getClassLoader(); cl != null; cl = cl.getParent()) {
                System.err.println(cl);
            }
            System.err.println();
        }
        if (Beans.isDesignTime()) {
            URL cssURL = component.getClass().getResource(CSS_RESOURCE);
            writer.startElement("link", component);
            writer.writeAttribute("type", (Object)"text/css", null);
            writer.writeAttribute("rel", (Object)"stylesheet", null);
            writer.writeURIAttribute("href", (Object)cssURL, null);
            writer.endElement("link");
        } else {
            helper.linkStylesheet(context, component, writer, Mechanism.CLASS_RESOURCE, CSS_RESOURCE);
            helper.linkJavascript(context, component, writer, Mechanism.CLASS_RESOURCE, "/META-INF/common/script.js");
            Util.renderDojoLoading(context, component, writer);
            helper.linkJavascript(context, component, writer, Mechanism.CLASS_RESOURCE, SCRIPT_RESOURCE);
        }
        writer.startElement("div", component);
        writer.writeAttribute("id", (Object)clientId, null);
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        if (styleClass != null) {
            writer.writeAttribute("class", (Object)styleClass, "styleClass");
        }
        writer.write("\n");
        writer.startElement("table", component);
        writer.writeAttribute("id", (Object)(clientId + "_barAreaContainer"), null);
        writer.writeAttribute("class", (Object)"bpui_progressbar_barAreaContainer", null);
        writer.writeAttribute("border", (Object)"0", null);
        writer.writeAttribute("cellspacing", (Object)"0", null);
        writer.writeAttribute("cellpadding", (Object)"0", null);
        writer.writeAttribute("width", (Object)"100%", null);
        writer.write("\n");
        writer.startElement("tr", null);
        writer.writeAttribute("id", (Object)(clientId + "_barArea"), null);
        writer.writeAttribute("class", (Object)"bpui_progressbar_barArea", null);
        writer.write("\n");
        int sanePercentage = percentage;
        if (percentage > 100) {
            sanePercentage = 100;
        }
        if (percentage < 0) {
            sanePercentage = 0;
        }
        String portionCompleteStyleClass = "bpui_progressbar_portionComplete";
        String portionRemainingStyleClass = "bpui_progressbar_portionRemaining";
        if (Beans.isDesignTime()) {
            if (sanePercentage == 0) {
                portionCompleteStyleClass = "bpui_progressbar_portionRemaining";
            }
            if (sanePercentage == 100) {
                portionRemainingStyleClass = "bpui_progressbar_portionComplete";
            }
        }
        writer.startElement("td", null);
        writer.writeAttribute("id", (Object)(clientId + "_portionIndeterminate"), null);
        writer.writeAttribute("class", (Object)portionRemainingStyleClass, null);
        writer.writeAttribute("width", (Object)"0%", null);
        writer.endElement("td");
        writer.write("\n");
        writer.startElement("td", null);
        writer.writeAttribute("id", (Object)(clientId + "_portionComplete"), null);
        writer.writeAttribute("class", (Object)portionCompleteStyleClass, null);
        writer.writeAttribute("width", (Object)(String.valueOf(sanePercentage) + "%"), null);
        writer.endElement("td");
        writer.write("\n");
        writer.startElement("td", null);
        writer.writeAttribute("id", (Object)(clientId + "_portionRemaining"), null);
        writer.writeAttribute("class", (Object)portionRemainingStyleClass, null);
        writer.writeAttribute("width", (Object)(String.valueOf(100 - sanePercentage) + "%"), null);
        writer.endElement("td");
        writer.write("\n");
        writer.endElement("tr");
        writer.write("\n");
        writer.endElement("table");
        writer.write("\n");
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)(clientId + "_percentageText"), null);
        writer.writeAttribute("class", (Object)"bpui_progressbar_percentageText", null);
        writer.write(percentageText);
        writer.endElement("div");
        writer.write("\n");
        writer.endElement("div");
        writer.write("\n");
        if (!Beans.isDesignTime()) {
            String percentageBinding;
            writer.startElement("script", component);
            writer.writeAttribute("type", (Object)"text/javascript", null);
            writer.write("\n");
            if (!context.getExternalContext().getRequestMap().containsKey(RENDER_ONCE)) {
                context.getExternalContext().getRequestMap().put(RENDER_ONCE, Boolean.TRUE);
                String callback = helper.mapResourceId(context, Mechanism.DYNAMIC_RESOURCE, RESPONSE_HANDLER);
                writer.write("bpui.progressbar.unparameterizedUrl = \"" + callback + "\";");
                writer.write("\n");
                writer.write("bpui.progressbar.messages[\"bindError\"] = \"" + Util.getMessage("progressbar.bindError") + "\";");
                writer.write("\n");
                writer.write("bpui.progressbar.messages[\"unboundPercentage\"] = \"" + Util.getMessage("progressbar.unboundPercentage") + "\";");
                writer.write("\n");
            }
            String percentageBindingParam = "null";
            if (percentageVb != null && (percentageBinding = percentageVb.getExpressionString()) != null && percentageBinding.length() > 0) {
                percentageBindingParam = "\"" + percentageBinding + "\"";
            }
            writer.write("new bpui.progressbar.Instance(\"" + clientId + "\", " + interval + ", " + percentage + ", " + percentageBindingParam + ");");
            writer.write("\n");
            if (onComplete != null && onComplete.length() > 0) {
                writer.write("bpui.progressbar.state[\"");
                writer.write(clientId);
                writer.write("\"].onComplete = ");
                writer.writeText((Object)onComplete, "onComplete");
                writer.write("\n");
            }
            if (onFail != null && onFail.length() > 0) {
                writer.write("bpui.progressbar.state[\"");
                writer.write(clientId);
                writer.write("\"].onFail = ");
                writer.writeText((Object)onFail, "onFail");
                writer.write("\n");
            }
            if (onUpdate != null && onUpdate.length() > 0) {
                writer.write("bpui.progressbar.state[\"");
                writer.write(clientId);
                writer.write("\"].onUpdate = ");
                writer.writeText((Object)onUpdate, "onUpdate");
                writer.write("\n");
            }
            if (onPoll != null && onPoll.length() > 0) {
                writer.write("bpui.progressbar.state[\"");
                writer.write(clientId);
                writer.write("\"].onPoll = ");
                writer.writeText((Object)onPoll, "onPoll");
                writer.write("\n");
            }
            if (Boolean.TRUE.equals(autoStart)) {
                writer.write("bpui.progressbar.state[\"");
                writer.write(clientId);
                writer.write("\"].autoStart = ");
                writer.writeText((Object)autoStart.toString(), "autoStart");
                writer.write("\n");
            }
            if (indeterminateSection != 10) {
                writer.write("bpui.progressbar.state[\"");
                writer.write(clientId);
                writer.write("\"].indeterminateSection = ");
                writer.writeText((Object)String.valueOf(indeterminateSection), "indeterminateSection");
                writer.write("\n");
            }
            if (indeterminateInterval != 20) {
                writer.write("bpui.progressbar.state[\"");
                writer.write(clientId);
                writer.write("\"].indeterminateInterval = ");
                writer.writeText((Object)String.valueOf(indeterminateInterval), "indeterminateInterval");
                writer.write("\n");
            }
            if (indeterminateIncrement != 1) {
                writer.write("bpui.progressbar.state[\"");
                writer.write(clientId);
                writer.write("\"].indeterminateIncrement = ");
                writer.writeText((Object)String.valueOf(indeterminateIncrement), "indeterminateIncrement");
                writer.write("\n");
            }
            String[] otherBindings = new String[]{"percentageText", "startOperation", "pauseOperation", "resumeOperation", "stopOperation", "failed"};
            boolean[] whichAreMethodBindings = new boolean[]{false, true, true, true, true, false};
            for (int i = 0; pbComponent != null && i < otherBindings.length; ++i) {
                String expressionString = null;
                if (whichAreMethodBindings[i]) {
                    Map attributes = pbComponent.getAttributes();
                    Object propValue = attributes.get(otherBindings[i]);
                    if (propValue instanceof MethodBinding) {
                        MethodBinding mb = (MethodBinding)propValue;
                        expressionString = mb.getExpressionString();
                    }
                } else {
                    ValueBinding binding = pbComponent.getValueBinding(otherBindings[i]);
                    if (binding != null) {
                        expressionString = binding.getExpressionString();
                    }
                }
                if (expressionString == null) continue;
                writer.write("bpui.progressbar.state[\"");
                writer.write(clientId);
                writer.write("\"].bindings[\"");
                writer.write(otherBindings[i]);
                writer.write("\"] = \"");
                writer.writeText((Object)expressionString, null);
                writer.write("\";\n");
            }
            writer.endElement("script");
            writer.write("\n");
        }
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        if (this.logging) {
            this.log("encodeChildren(" + component.getId() + ")");
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        if (this.logging) {
            this.log("encodeEnd(" + component.getId() + ")");
        }
    }

    private void log(String message) {
        if (this.logging) {
            System.out.println(message);
        }
    }

    public Renderer getButtonRenderer(FacesContext context) {
        if (null != this.commandButtonRenderer) {
            return this.commandButtonRenderer;
        }
        RenderKitFactory fact = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
        RenderKit basic = fact.getRenderKit(context, "HTML_BASIC");
        this.commandButtonRenderer = basic.getRenderer("javax.faces.Command", "javax.faces.Button");
        return this.commandButtonRenderer;
    }
}

